import type { Dict } from '@sage/xtrem-shared';
import * as React from 'react';
import type { ReduxResponsive } from '../../../redux/state';
import type { ScreenBaseDefinition } from '../../../service/screen-base-definition';
import type { CustomDialogOptions, DialogDescription, PageDialogOptions } from '../../../types/dialogs';
export interface DialogComponentExternalProps {
    dialogKey: string;
    isFullScreen: boolean;
}
export interface DialogComponentProps extends DialogComponentExternalProps {
    browser: ReduxResponsive;
    closeDialog: (dialogId: number) => Promise<void>;
    dialog: DialogDescription<PageDialogOptions & CustomDialogOptions>;
    screenDefinitions: Dict<ScreenBaseDefinition>;
    setActiveSection: (screenId: string, activeSection: string) => Promise<void>;
    stepOneSection: (screenId: string, direction: 1 | -1) => Promise<void>;
}
interface DialogComponentState {
    activeSection: string | null;
}
export declare class DialogComponent extends React.Component<DialogComponentProps, DialogComponentState> {
    private normalDialogRef;
    constructor(props: DialogComponentProps);
    componentDidUpdate(prevProps: DialogComponentProps): void;
    closeDialog: () => Promise<void>;
    getDialogContentGridSize: () => number;
    getActiveSection: () => string | null;
    /**
     *
     * @description Carbon Dialog focustrap and AgGrid internal state focus handling are incompatible.
     * They compete and overlap each other for the same browser events and imperative effects (.focus()).
     * Therefore, we disable the focus trap when the page dialog includes a table within.
     * For the same reasons we disable the 'Esc' key.
     *
     * `disableFocusTrap: boolean` does not currently work... so we use the hidden `bespokeFocusTrap`
     * callback property with a noop function, which does the same. We should consider a
     * replacement in the future, when `disableFocusTrap` is back in the Carbon library.
     *
     * Giving its current state, disabling by default the FocusTrap in all/most of the dialogs might
     * not be completely discarded. Browsers defaults may be enough for most cases.
     *
     */
    hasTableField: () => boolean;
    setSelectedSection: (selectedSection: string) => void;
    onStepOneSection: (direction: 1 | -1) => void;
    renderDialogContent(defaultFocusRef?: React.RefObject<any>, noHeader?: boolean): React.ReactNode;
    renderSidebarDialog: () => React.ReactNode;
    renderNormalDialog: () => React.ReactNode;
    renderStickerDialog: () => React.ReactNode;
    renderFullScreenStickerDialog: () => React.ReactNode;
    renderFullScreenDialog: () => React.ReactNode;
    render(): React.ReactNode;
}
export declare const ConnectedDialogComponent: import("react-redux").ConnectedComponent<typeof DialogComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<DialogComponent> | undefined;
    dialogKey: string;
    isFullScreen: boolean;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export {};
//# sourceMappingURL=dialog-component.d.ts.map