import Button from 'carbon-react/esm/components/button';
import * as React from 'react';
import { focusFirstElement } from '../../../../utils/layout-utils';
const getButtonType = (button, reverseButtons) => reverseButtons ? (button.isNegative ? 'primary' : 'tertiary') : button.isNegative ? 'tertiary' : 'primary';
export function DialogActionButtons(props) {
    const positiveButtons = Object.keys(props.buttons).filter(b => !!props.buttons[b].isNegative === !!props.pickNegativeButtons && !props.buttons[b].isHidden);
    React.useEffect(() => {
        focusFirstElement('[data-element="form-footer"]', true);
    }, []);
    return (React.createElement(React.Fragment, null, positiveButtons.map((b) => {
        const buttonProps = {
            className: props.buttons[b].className,
            onClick: props.buttons[b].onClick,
            disabled: props.buttons[b].isDisabled,
            buttonType: getButtonType(props.buttons[b], props.reverseButtons),
        };
        return (React.createElement(Button, { key: b, ...buttonProps }, props.buttons[b].text));
    })));
}
//# sourceMappingURL=dialog-action-buttons.js.map