import Form from 'carbon-react/esm/components/form';
import * as React from 'react';
import { connect } from 'react-redux';
import { RenderingRouter } from '../../../../render/rendering-router';
import { ContextType } from '../../../../types';
import { focusFirstElement } from '../../../../utils/layout-utils';
import { ContainerKey } from '../../../types';
import { GridRow } from '@sage/xtrem-ui-components';
import BusinessActions from '../../footer/business-actions';
import { DialogActionButtons } from './dialog-action-buttons';
export function DialogBodyCustomContent(props) {
    let sections = props.content instanceof Array ? props.content : [props.content];
    sections = sections.filter(c => !!c && !c.isHidden);
    const isBlockContent = sections[0]?.componentType === ContainerKey.Block;
    const stickerDefinition = props.dialog.isSticker ? props.screenDefinition : null;
    const businessActions = stickerDefinition && stickerDefinition.sticker.$.businessActions;
    const hasBusinessActions = businessActions && businessActions.length > 0;
    const useTabs = sections.length > 1;
    // We only want to take selectedSection from external prop if is rightAligned because the tabs will be handled by dialog component as is rendered in the SidePanel Header
    const selectedSectionDetails = sections.find(section => section?.id === props.selectedSection);
    React.useEffect(() => {
        focusFirstElement('.e-dialog-custom-content');
    }, []);
    const dialogBody = (React.createElement(React.Fragment, null,
        useTabs && selectedSectionDetails && (React.createElement(RenderingRouter, { contextType: ContextType.dialog, screenId: props.screenId, availableColumns: props.availableColumns, item: selectedSectionDetails.layout })),
        !useTabs &&
            sections
                .filter(section => section?.id)
                .map(section => (React.createElement(RenderingRouter, { contextType: ContextType.dialog, screenId: props.screenId, availableColumns: props.availableColumns, key: section.id, item: section.layout })))));
    return (React.createElement(Form, { stickyFooter: Object.keys(props.dialog.buttons || {}).length > 0, buttonAlignment: "right", height: props.dialog.options.height ? `${props.dialog.options.height}px` : undefined, rightSideButtons: hasBusinessActions ? (React.createElement("div", { className: "e-dialog-footer e-dialog-type-page", "data-testid": "e-dialog-footer" },
            React.createElement(BusinessActions, { businessActions: businessActions, contextType: ContextType.dialog, defaultButtonType: "primary", key: "e-sticker-business-actions", screenId: props.dialog.screenId || '' }))) : (React.createElement(DialogActionButtons, { buttons: props.dialog.buttons, reverseButtons: !!props.dialog.options.reverseButtons, pickNegativeButtons: false })), leftSideButtons: React.createElement(DialogActionButtons, { buttons: props.dialog.buttons, reverseButtons: !!props.dialog.options.reverseButtons, pickNegativeButtons: true }) },
        React.createElement("div", { className: "e-dialog-custom-body" },
            React.createElement("div", { className: "e-dialog-custom-content" },
                !isBlockContent && dialogBody,
                isBlockContent && (React.createElement(GridRow, { className: "e-section-body", margin: 0, gutter: 16, verticalMargin: 0, columns: props.availableColumns }, dialogBody))))));
}
export const ConnectedDialogBodyCustomContent = connect()(DialogBodyCustomContent);
//# sourceMappingURL=custom-content.js.map