/**
 * @packageDocumentation
 * @module root
 * */
import type { PageArticleItem } from '../../../service/layout-service';
import type { ScreenBase } from '../../../service/screen-base';
import type { ValidationResult } from '../../../service/screen-base-definition';
import type { ScreenExtension } from '../../../types';
import type { ContainerProperties } from '../../abstract-container';
import { AbstractContainer } from '../../abstract-container';
import type { PageActionControlObject } from '../../control-objects';
import type { ContainerComponentProps, ContainerControlObjectConstructorProps } from '../../types';
import { ContainerKey } from '../../types';
export declare const detailPanelId = "$detailPanel";
export interface DetailPanelProperties<CT extends ScreenBase = ScreenBase> extends ContainerProperties<CT> {
    /** Whether the helper panel can be extracted into a separate window or not. Defaults to false */
    isExtendable?: boolean;
    /** Which of the helper panel sections is being displayed (element ID of the section) */
    activeSection?: string;
    /** Whether the a cross icon is displayed that enables the user from closing the dialog */
    isCloseButtonHidden?: boolean;
}
export interface IDetailPanelControlObject<CT extends ScreenBase = ScreenBase> extends ContainerControlObjectConstructorProps<ContainerKey.DetailPanel> {
    headerSection: Partial<PageArticleItem>;
    sections: Partial<PageArticleItem>[];
    footerActions?: PageActionControlObject<CT>[];
}
/**
 * [Container]{@link AbstractContainer} that can be used to display additional information outside of the page layout
 */
export declare class DetailPanelControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractContainer<CT, ContainerKey.DetailPanel, ContainerComponentProps<ContainerKey.DetailPanel>> {
    private readonly _headerSection;
    private readonly _sections;
    private readonly _footerActions?;
    static readonly defaultUiProperties: Partial<DetailPanelProperties>;
    constructor(properties: IDetailPanelControlObject<CT>);
    /** Which of the helper panel sections is being displayed */
    get activeSection(): string | undefined;
    /** Which of the helper panel sections is being displayed */
    set activeSection(newValue: string | undefined);
    /** Whether the a cross icon is displayed that enables the user from closing the dialog */
    get isCloseButtonHidden(): boolean | undefined;
    /** Whether the a cross icon is displayed that enables the user from closing the dialog */
    set isCloseButtonHidden(newValue: boolean | undefined);
    /**
     * Whether the helper panel can be extended into a separate window (extendable = true)
     * or not (extendable = false)
     */
    get isExtendable(): boolean;
    /**
     * Whether the helper panel can be extended into a separate window (extendable = true)
     * or not (extendable = false)
     */
    set isExtendable(newValue: boolean);
    /** [Section]{@link SectionControlObject} contained in the helper panel header */
    get headerSection(): Partial<PageArticleItem>;
    /** [Sections]{@link SectionControlObject} contained in the helper panel body */
    get sections(): Partial<PageArticleItem>[];
    /** [Page Actions]{@link PageAction} rendered in the helper panel footer */
    get footerActions(): PageActionControlObject<CT>[] | undefined;
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
     */
    validateWithDetails(partition: true): Promise<{
        allErrors: ValidationResult[];
        blockingErrors: ValidationResult[];
    }>;
    validateWithDetails(partition: false): Promise<ValidationResult[]>;
    validateWithDetails(): Promise<ValidationResult[]>;
}
//# sourceMappingURL=detail-panel-control-object.d.ts.map