/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import type { BlockProperties, SectionControlObject } from '../../control-objects';
import { BlockControlObject } from '../../control-objects';
import type { ExtensionField, HasParent } from '../../field/traits';
export interface BlockDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<BlockProperties<CT>, '_controlObjectType'>, HasParent<CT, SectionControlObject<CT>>, ExtensionField<CT, BlockControlObject<CT>> {
}
/**
 * Initializes the decorated member as a [Block]{@link BlockControlObject} container with the provided properties
 *
 * @param properties The properties that the [Block]{@link BlockControlObject} container will be initialized with
 */
export declare function block<CT extends ScreenExtension<CT>>(properties: BlockDecoratorProperties<Extend<CT>>): (target: CT, name: string) => void;
//# sourceMappingURL=block-decorator.d.ts.map