import type { ClientNode } from '@sage/xtrem-client';
import type { ScreenBase } from '../service/screen-base';
import type { NestedField } from './nested-fields';
import type { FieldKey } from './types';
export interface CommonChartOptions<CT extends ScreenBase, NodeType extends ClientNode = any> {
    enableMouseTracking?: boolean;
    series: NestedField<CT, FieldKey.Numeric>[];
    xAxis: NestedField<CT, FieldKey.Numeric | FieldKey.Text | FieldKey.Date, NodeType>;
}
export declare enum ChartTypes {
    Bar = "bar",
    Line = "line",
    Pie = "pie"
}
export interface ChartDeclaration<CT extends ScreenBase, NodeType extends ClientNode = any> extends CommonChartOptions<CT, NodeType> {
    type: ChartTypes;
}
export declare const line: <CT extends ScreenBase<any, any>, NodeType extends ClientNode = any>(options: CommonChartOptions<CT, NodeType>) => ChartDeclaration<CT, NodeType>;
export declare const bar: <CT extends ScreenBase<any, any>, NodeType extends ClientNode = any>(options: CommonChartOptions<CT, NodeType>) => ChartDeclaration<CT, NodeType>;
export declare const pie: <CT extends ScreenBase<any, any>, NodeType extends ClientNode = any>(options: CommonChartOptions<CT, NodeType>) => ChartDeclaration<CT, NodeType>;
//# sourceMappingURL=chart-types.d.ts.map