import type { ScreenBase } from '../service/screen-base';
import type { ScreenExtension } from '../types';
import type { ValueOrCallbackWithFieldValue } from '../utils/types';
import type { ComponentProperties } from './base-control-object';
import { BaseControlObject } from './base-control-object';
export type ColumnWidth = 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12;
export interface ResponsiveProperties {
    /** Whether the element is hidden or not in mobile devices. Defaults to false */
    isHiddenMobile?: boolean;
    /** Whether the element is hidden or not in desktop devices. Defaults to false */
    isHiddenDesktop?: boolean;
}
export interface UiComponentProperties<CT extends ScreenBase = ScreenBase> extends ComponentProperties<CT>, ResponsiveProperties {
    /** Whether the element title is hidden or not. Defaults to false */
    isTitleHidden?: boolean;
    /** Whether the value is bound to a GraphQL node (transient = false) or not (transient = true). Defaults to false */
    isTransient?: boolean;
    /** Whether the HTML element is hidden or not. Defaults to false */
    isHidden?: ValueOrCallbackWithFieldValue<CT, boolean>;
    /** The title of the HTML element */
    title?: ValueOrCallbackWithFieldValue<CT, string>;
}
/**
 * Any element than can be placed inside a page and can be interacted with (i.e. retrieving
 * and/or setting element's properties values)
 */
export declare abstract class AbstractUiControlObject<CT extends ScreenExtension<CT> = ScreenBase, S extends UiComponentProperties<CT> = {}> extends BaseControlObject<CT, S> {
    static readonly defaultUiProperties: Partial<UiComponentProperties>;
    /** Whether the element title is hidden or not. Defaults to false */
    isTitleHidden?: boolean;
    /** Whether the value is bind to a GraphQL node (transient = false) or not (transient = true). */
    get isTransient(): boolean;
    /** Title of the component */
    title?: string;
    /** Whether the HTML element is visible or not */
    isHidden?: boolean;
}
//# sourceMappingURL=abstract-ui-control-object.d.ts.map