import type { Dict } from '@sage/xtrem-shared';
import type { PageArticleItem } from '../service/layout-service';
import type { ResponsiveProperties } from './abstract-ui-control-object';
import type { ComponentKey, ContainerWidth, DecoratorTarget, FieldWidth, LayoutContent, MetadataProps } from './types';
import type { DataTypeDetails, FormattedNodeDetails } from '../service/metadata-types';
export interface DefaultFieldLayoutProps extends ResponsiveProperties {
    elementId: string;
    containerType: string;
    width?: FieldWidth;
    isFullWidth: boolean;
}
export declare abstract class AbstractLayoutBuilder<T extends ComponentKey> {
    target: DecoratorTarget<T>;
    elementId: string;
    readonly nodeTypes: Dict<FormattedNodeDetails>;
    readonly dataTypes: Dict<DataTypeDetails>;
    readonly metadata: MetadataProps<T>;
    layout: LayoutContent<T>;
    constructor(target: DecoratorTarget<T>, elementId: string, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, metadata: MetadataProps<T>);
    readonly build: () => this;
    protected abstract buildLayout: () => this;
    protected buildContainerLayout(elementId: string, category: string, isHiddenMobile?: boolean, isHiddenDesktop?: boolean, width?: ContainerWidth): Partial<PageArticleItem>;
    protected buildFieldLayout({ elementId, containerType, isHiddenDesktop, isHiddenMobile, width, isFullWidth, }: Partial<DefaultFieldLayoutProps>): PageArticleItem;
}
//# sourceMappingURL=abstract-layout-builder.d.ts.map