import { runAndDispatchFieldValidation } from '../service/dispatch-service';
import { focusField, isFieldDirty, isFieldInFocus, refreshField, setFieldClean, setFieldDirty, } from '../service/field-state-service';
import { getFieldValue, getUiComponentProperties, setFieldValue, setUiComponentProperties, } from '../service/transactions-service';
import { addTitleToProperties } from '../utils/data-type-utils';
import { convertDeepBindToPathNotNull } from '../utils/nested-field-utils';
import { findDeepPropertyType } from '../utils/node-utils';
import { schemaTypeNameFromNodeName } from '../utils/transformers';
import { AbstractDecorator } from './abstract-decorator';
import { GraphQLKind } from '../types';
export class AbstractFieldDecorator extends AbstractDecorator {
    constructor(target, elementId, componentType, nodeTypes, dataTypes, _metadataProps) {
        super(target, elementId, _metadataProps, componentType, nodeTypes, dataTypes, {
            componentKey: componentType,
            getValue: getFieldValue,
            setValue: setFieldValue,
            refresh: refreshField,
            getUiComponentProperties,
            setUiComponentProperties,
            isFieldDirty,
            setFieldDirty,
            setFieldClean,
            isFieldInFocus,
            focus: focusField,
            dispatchValidation: runAndDispatchFieldValidation,
        });
        this.target = target;
        this.elementId = elementId;
        this.componentType = componentType;
        this.nodeTypes = nodeTypes;
        this.dataTypes = dataTypes;
        this._metadataProps = _metadataProps;
        this.setUiComponentProperties = () => {
            const actualPageMetadata = this.getPageMetadata();
            const fieldDecoratorProperties = this._metadataProps.properties;
            const isTransient = !!fieldDecoratorProperties.isTransient;
            const rootNode = actualPageMetadata.rootNode;
            const fieldNode = fieldDecoratorProperties.node;
            if (!isTransient && !actualPageMetadata.isTransient && rootNode) {
                /**
                 * If the page and the field is bound (and not transient), we can compute the default properties based on the
                 * context node's property data type details
                 *  */
                return super.setUiComponentProperties(this.computeDefaultPropertiesForNonTransientField(rootNode));
            }
            if (fieldNode) {
                /**
                 * If the field or the page is transient, but it has a `node` decorator property, try computing defaults from that
                 */
                return super.setUiComponentProperties(this.computeDefaultPropertiesForTransientField(String(fieldNode)));
            }
            return super.setUiComponentProperties();
        };
    }
    parseRawServerValue(value) {
        return value;
    }
    getComponentPropertiesFromDataType(
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    _dataType, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    _propertyDetails) {
        return {};
    }
    computeDefaultPropertiesForNonTransientField(rootNode) {
        let dataTypeProvidedProperties = {};
        const fieldDecoratorProperties = this._metadataProps.properties;
        const bind = fieldDecoratorProperties?.bind
            ? convertDeepBindToPathNotNull(fieldDecoratorProperties?.bind)
            : this.elementId;
        const contextNode = schemaTypeNameFromNodeName(rootNode);
        const propertyDetails = findDeepPropertyType(contextNode, bind, this.nodeTypes);
        if (propertyDetails) {
            const nodeDetails = findDeepPropertyType(contextNode, bind, this.nodeTypes);
            if (nodeDetails) {
                addTitleToProperties({
                    propertyDetails,
                    properties: dataTypeProvidedProperties,
                });
                if (nodeDetails.dataType && this.dataTypes[nodeDetails.dataType]) {
                    const dataType = this.dataTypes[nodeDetails.dataType];
                    dataTypeProvidedProperties = {
                        ...dataTypeProvidedProperties,
                        ...this.getComponentPropertiesFromDataType(dataType, nodeDetails),
                    };
                }
            }
        }
        return dataTypeProvidedProperties;
    }
    /**
     * Compute default decorator properties with fields that have a `node` decorator property
     * @param fieldNode
     * @returns
     */
    computeDefaultPropertiesForTransientField(fieldNode) {
        const schemaTypeName = schemaTypeNameFromNodeName(fieldNode);
        const nodeDetails = this.nodeTypes[schemaTypeName];
        if (!nodeDetails?.defaultDataType) {
            return {};
        }
        const dataType = this.dataTypes[nodeDetails.defaultDataType];
        if (!dataType) {
            return {};
        }
        const propertyDetails = {
            targetNode: fieldNode,
            title: nodeDetails?.title,
            kind: GraphQLKind.Object,
            type: schemaTypeName,
            isMutable: false,
            isCustom: false,
        };
        const dataTypeProvidedProperties = {};
        addTitleToProperties({
            propertyDetails,
            properties: dataTypeProvidedProperties,
        });
        return {
            ...dataTypeProvidedProperties,
            ...this.getComponentPropertiesFromDataType(dataType, propertyDetails),
        };
    }
}
//# sourceMappingURL=abstract-field-decorator.js.map