import type { Dict } from '@sage/xtrem-shared';
import type { DataTypeDetails, FormattedNodeDetails } from '../service/metadata-types';
import { type PageMetadata } from '../service/page-metadata';
import type { ComponentKey, ControlObjectConstructor, ControlObjectConstructorProps, ControlObjectInstance, DecoratorProperties, DecoratorTarget, LayoutBuilder, LayoutContent, MetadataProps } from './types';
export declare class AbstractDecorator<T extends ComponentKey> {
    protected target: DecoratorTarget<T>;
    protected elementId: string;
    protected _metadataProps: MetadataProps<T>;
    protected componentType: T;
    protected nodeTypes: Dict<FormattedNodeDetails>;
    protected dataTypes: Dict<DataTypeDetails>;
    protected _controlObjectConstructorProps: Partial<ControlObjectConstructorProps<T>>;
    protected _layout: new (target: DecoratorTarget<T>, elementId: string, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, props: MetadataProps<T>) => LayoutBuilder<T>;
    protected _controlObjectConstructor: ControlObjectConstructor<T>;
    protected layoutBuilder: LayoutBuilder<T>;
    protected controlObjectInstance: ControlObjectInstance<T>;
    constructor(target: DecoratorTarget<T>, elementId: string, _metadataProps: MetadataProps<T>, componentType: T, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, _controlObjectConstructorProps: Partial<ControlObjectConstructorProps<T>>);
    build: () => this;
    private getScreenId;
    protected readonly buildLayout: () => this;
    protected readonly buildActions: () => this;
    protected readonly buildControlObject: () => this;
    protected readonly buildMetadata: () => this;
    private readonly setTarget;
    protected getPageMetadata(): PageMetadata;
    private readonly setControlObject;
    protected setUiComponentProperties(dataTypeDefaults?: Partial<DecoratorProperties<T>>): this;
    get layout(): LayoutContent<T>;
    get controlObject(): AbstractDecorator<T>['controlObjectInstance'];
}
//# sourceMappingURL=abstract-decorator.d.ts.map