declare module '@sage/xtrem-x3-interop-api-partial' {
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        Operation as Node$Operation,
        decimal,
    } from '@sage/xtrem-client';
    export interface SysApp extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
    }
    export interface SysAppInput extends ClientNodeInput {}
    export interface SysAppBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
    }
    export interface SysApp$Queries {
        getAppInfo: Node$Operation<
            {},
            {
                name: string;
                version: string;
                metadataPackage: string;
            }
        >;
    }
    export interface SysApp$Operations {
        queries: SysApp$Queries;
        getDefaults: GetDefaultsOperation<SysApp>;
    }
    export interface SysSynchronizationSource extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
    }
    export interface SysSynchronizationSourceInput extends ClientNodeInput {}
    export interface SysSynchronizationSourceBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
    }
    export interface SysSynchronizationSource$Queries {
        getSynchronizationFeed: Node$Operation<
            {
                node: string;
                startTick?: decimal | string;
                selector?: string;
                filter?: string;
            },
            {
                nextTick: string;
                feed: string[];
            }
        >;
    }
    export interface SysSynchronizationSource$Operations {
        queries: SysSynchronizationSource$Queries;
        getDefaults: GetDefaultsOperation<SysSynchronizationSource>;
    }
    export interface Package {
        '@sage/xtrem-x3-interop/SysApp': SysApp$Operations;
        '@sage/xtrem-x3-interop/SysSynchronizationSource': SysSynchronizationSource$Operations;
    }
    export interface GraphApi extends Package, SageXtremAppMetadata$Package, SageXtremX3SystemUtils$Package {}
}
declare module '@sage/xtrem-x3-interop-api' {
    export type * from '@sage/xtrem-x3-interop-api-partial';
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/xtrem-x3-interop-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/xtrem-x3-interop-api';
    export interface GraphApi extends GraphApiExtension {}
}
