declare module '@sage/x3-purchasing-finance-api-partial' {
    import type { FinancialCommitment, Package as SageX3Finance$Package } from '@sage/x3-finance-api';
    import type { Package as SageX3FinanceData$Package } from '@sage/x3-finance-data-api';
    import type { Package as SageX3InvoicingData$Package, Tax } from '@sage/x3-invoicing-data-api';
    import type { Package as SageX3ManufacturingData$Package } from '@sage/x3-manufacturing-data-api';
    import type {
        Currency,
        Package as SageX3MasterData$Package,
        Product,
        SiteAddress,
        Supplier,
        SupplierAddress,
        SupplierProduct,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type { Package as SageX3PhysicalFlowsData$Package } from '@sage/x3-physical-flows-data-api';
    import type {
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type {
        Package as SageX3Purchasing$Package,
        PurchaseOrder,
        PurchaseOrderLineInput,
        PurchaseOrderLineProductStatisticalGroups,
        PurchaseOrderLineProductStatisticalGroupsBinding,
        PurchaseOrderLineProductStatisticalGroupsInput,
        PurchaseOrderLineTaxes,
        PurchaseOrderLineTaxesBinding,
        PurchaseOrderLineTaxesInput,
        PurchaseReceipt,
        PurchaseReceiptLine,
    } from '@sage/x3-purchasing-api';
    import type {
        FreightCostStructure,
        MatchingTolerance,
        Package as SageX3PurchasingData$Package,
        PurchasePriceReason,
    } from '@sage/x3-purchasing-data-api';
    import type { MajorVersionStatus, Package as SageX3StockData$Package } from '@sage/x3-stock-data-api';
    import type { Country, Package as SageX3Structure$Package } from '@sage/x3-structure-api';
    import type { Company, Package as SageX3System$Package, Site, User } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type { ClientCollection, QueryOperation, TextStream, decimal, integer } from '@sage/xtrem-client';
    export interface PurchaseOrderLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseOrder: PurchaseOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        orderType: PurchaseOrderType;
        revisionNumber: integer;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: PurchasePriceReason;
        discountOrCharge2Reason: PurchasePriceReason;
        discountOrCharge3Reason: PurchasePriceReason;
        discountOrCharge4Reason: PurchasePriceReason;
        discountOrCharge5Reason: PurchasePriceReason;
        discountOrCharge6Reason: PurchasePriceReason;
        discountOrCharge7Reason: PurchasePriceReason;
        discountOrCharge8Reason: PurchasePriceReason;
        discountOrCharge9Reason: PurchasePriceReason;
        netPrice: string;
        buyer: User;
        receiptSite: Site;
        receiptAddress: SiteAddress;
        project: ProjectLink;
        intrastatIncreaseCoefficient: string;
        countryOfOrigin: Country;
        hasQualityControlManagement: boolean;
        receiptTax: Tax;
        issueTax: Tax;
        otherTax1: Tax;
        otherTax2: Tax;
        matchingTolerance: MatchingTolerance;
        acknowledgementDate: string;
        acknowledgementNumber: string;
        acknowledgementUpdate: integer;
        actualPurchaseCostInCompanyCurrency: string;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        calculatedBasisForTax3: string;
        calculatedTaxBasis1: string;
        calculatedTaxBasis2: string;
        calculationBasisForIssueTax: string;
        calculationBasisForOtherTax1: string;
        calculationBasisForOtherTax2: string;
        calculationBasisForReceiptTax: string;
        commitmentGenerated: integer;
        commitmentType: CommitmentType;
        companyCurrency: Currency;
        costPriceWithoutLandedCost: string;
        costStructure: FreightCostStructure;
        currency: Currency;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        expectedReceiptDate: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        interCompanySalesOrderLineNumber: integer;
        interCompanySalesOrderSequenceNumber: integer;
        isBudgetOverrun: boolean;
        isClosed: boolean;
        isClosedByReceipt: boolean;
        isInOrderUnit: boolean;
        isInvoiced: boolean;
        isPrinted: boolean;
        issueTaxAmount: string;
        issueTaxDeductibleAmount: string;
        landedCostCoefficient: string;
        lastReceiptDate: string;
        lastSalesInvoiceDate: string;
        lineAmountIncludingTax: string;
        lineAndSequenceIndex: string;
        lineOrderAmountIncludingTax: string;
        linePurchaseCostInCompanyCurrency: string;
        lineStatus: LineStatus;
        lineStockCostInCompanyCurrency: string;
        lineType: OrderLineType;
        linkCoefficientForSubcontract: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        numberOfInvoicedReceipts: integer;
        numberOfInvoices: integer;
        numberOfReceipts: integer;
        orderDate: string;
        orderFromSupplier: Supplier;
        orderLineText: TextStream;
        orderUnit: UnitOfMeasure;
        orderUnitToPurchaseUnitConversionFactor: string;
        otherTax1Amount: string;
        otherTax1DeductibleAmount: string;
        otherTax2Amount: string;
        otherTax2DeductibleAmount: string;
        productType: PurchasingProductType;
        purchaseCostInCompanyCurrency: string;
        purchaseReceipt: PurchaseReceipt;
        purchaseReceiptLine: PurchaseReceiptLine;
        purchaseSite: Site;
        purchaseType: PurchaseType;
        purchaseUnit: UnitOfMeasure;
        quantityInOrderUnitOrdered: string;
        quantityInPurchaseUnitInvoiced: string;
        quantityInPurchaseUnitOrdered: string;
        quantityInPurchaseUnitReceived: string;
        quantityInPurchaseUnitRequired: string;
        quantityInPurchaseUnitShippedNotReceived: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitReceived: string;
        quantityInStockUnitRequired: string;
        quantityInStockUnitShippedNotReceived: string;
        rebateOnTax1Amount: string;
        receiptTaxAmount: string;
        receiptTaxDeductibleAmount: string;
        releasedProduct: Product;
        reorderLeadTime: string;
        requestForQuotation: string;
        requestForQuotationResponseLineNumber: integer;
        requestedDeliveryEndDate: string;
        requestedDeliveryEndTime: integer;
        requestedDeliveryStartDate: string;
        requestedDeliveryStartTime: integer;
        requirementDate: string;
        shippingSite: Site;
        sourceDocumentLineNumber: integer;
        sourceDocumentNumber: string;
        sourceDocumentSequenceNumber: integer;
        sourceDocumentType: EntryTypeEnum;
        sourceRequest: RequestSource;
        stockCostInCompanyCurrency: string;
        stockUnit: UnitOfMeasure;
        subcontractAddress: SupplierAddress;
        supplierProduct: SupplierProduct;
        tax1BasisAmount: string;
        tax1DeductibleAmount: string;
        tax1amount: string;
        tax2DeductibleAmount: string;
        tax2amount: string;
        tax3DeductibleAmount: string;
        tax3amount: string;
        taxExcludedLineAmount: string;
        totalPurchaseCostInCompanyCurrency: string;
        totalStockCostInCompanyCurrency: string;
        volume: string;
        volumeUnit: UnitOfMeasure;
        weight: string;
        weightUnit: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workOrderInProgressStatus: StatusInProgress;
        workOrderInProgressType: WorkOrderType;
        productStatisticalGroups: ClientCollection<PurchaseOrderLineProductStatisticalGroups>;
        taxes: ClientCollection<PurchaseOrderLineTaxes>;
        commitment: FinancialCommitment;
    }
    export interface PurchaseOrderLineInputExtension {
        purchaseOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        company?: string;
        orderType?: PurchaseOrderType;
        revisionNumber?: integer | string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInSupplierLanguage?: string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        netPrice?: decimal | string;
        buyer?: string;
        receiptSite?: string;
        receiptAddress?: string;
        project?: string;
        intrastatIncreaseCoefficient?: decimal | string;
        countryOfOrigin?: string;
        hasQualityControlManagement?: boolean | string;
        receiptTax?: string;
        issueTax?: string;
        otherTax1?: string;
        otherTax2?: string;
        matchingTolerance?: string;
        acknowledgementDate?: string;
        acknowledgementNumber?: string;
        acknowledgementUpdate?: integer | string;
        actualPurchaseCostInCompanyCurrency?: decimal | string;
        billBySupplier?: string;
        billBySupplierAddress?: string;
        calculatedBasisForTax3?: decimal | string;
        calculatedTaxBasis1?: decimal | string;
        calculatedTaxBasis2?: decimal | string;
        calculationBasisForIssueTax?: decimal | string;
        calculationBasisForOtherTax1?: decimal | string;
        calculationBasisForOtherTax2?: decimal | string;
        calculationBasisForReceiptTax?: decimal | string;
        commitmentGenerated?: integer | string;
        commitmentType?: CommitmentType;
        companyCurrency?: string;
        costPriceWithoutLandedCost?: decimal | string;
        costStructure?: string;
        currency?: string;
        distributedInvoicingElement1AmountExcludingTax?: decimal | string;
        distributedInvoicingElement2AmountExcludingTax?: decimal | string;
        distributedInvoicingElement3AmountExcludingTax?: decimal | string;
        distributedInvoicingElement4AmountExcludingTax?: decimal | string;
        distributedInvoicingElement5AmountExcludingTax?: decimal | string;
        distributedInvoicingElement6AmountExcludingTax?: decimal | string;
        distributedInvoicingElement7AmountExcludingTax?: decimal | string;
        distributedInvoicingElement8AmountExcludingTax?: decimal | string;
        distributedInvoicingElement9AmountExcludingTax?: decimal | string;
        expectedReceiptDate?: string;
        fixedLandedCostPerUnitInCompanyCurrency?: decimal | string;
        interCompanySalesOrderLineNumber?: integer | string;
        interCompanySalesOrderSequenceNumber?: integer | string;
        isBudgetOverrun?: boolean | string;
        isClosed?: boolean | string;
        isClosedByReceipt?: boolean | string;
        isInOrderUnit?: boolean | string;
        isInvoiced?: boolean | string;
        isPrinted?: boolean | string;
        issueTaxAmount?: decimal | string;
        issueTaxDeductibleAmount?: decimal | string;
        landedCostCoefficient?: decimal | string;
        lastReceiptDate?: string;
        lastSalesInvoiceDate?: string;
        lineAmountIncludingTax?: decimal | string;
        lineAndSequenceIndex?: string;
        lineOrderAmountIncludingTax?: decimal | string;
        linePurchaseCostInCompanyCurrency?: decimal | string;
        lineStatus?: LineStatus;
        lineStockCostInCompanyCurrency?: decimal | string;
        lineType?: OrderLineType;
        linkCoefficientForSubcontract?: decimal | string;
        locationReference?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        numberOfInvoicedReceipts?: integer | string;
        numberOfInvoices?: integer | string;
        numberOfReceipts?: integer | string;
        orderDate?: string;
        orderFromSupplier?: string;
        orderLineText?: TextStream;
        orderUnit?: string;
        orderUnitToPurchaseUnitConversionFactor?: decimal | string;
        otherTax1Amount?: decimal | string;
        otherTax1DeductibleAmount?: decimal | string;
        otherTax2Amount?: decimal | string;
        otherTax2DeductibleAmount?: decimal | string;
        productType?: PurchasingProductType;
        purchaseCostInCompanyCurrency?: decimal | string;
        purchaseReceipt?: string;
        purchaseReceiptLine?: integer | string;
        purchaseSite?: string;
        purchaseType?: PurchaseType;
        purchaseUnit?: string;
        quantityInOrderUnitOrdered?: decimal | string;
        quantityInPurchaseUnitInvoiced?: decimal | string;
        quantityInPurchaseUnitOrdered?: decimal | string;
        quantityInPurchaseUnitReceived?: decimal | string;
        quantityInPurchaseUnitRequired?: decimal | string;
        quantityInPurchaseUnitShippedNotReceived?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        quantityInStockUnitOrdered?: decimal | string;
        quantityInStockUnitReceived?: decimal | string;
        quantityInStockUnitRequired?: decimal | string;
        quantityInStockUnitShippedNotReceived?: decimal | string;
        rebateOnTax1Amount?: decimal | string;
        receiptTaxAmount?: decimal | string;
        receiptTaxDeductibleAmount?: decimal | string;
        releasedProduct?: string;
        reorderLeadTime?: decimal | string;
        requestForQuotation?: string;
        requestForQuotationResponseLineNumber?: integer | string;
        requestedDeliveryEndDate?: string;
        requestedDeliveryEndTime?: integer | string;
        requestedDeliveryStartDate?: string;
        requestedDeliveryStartTime?: integer | string;
        requirementDate?: string;
        shippingSite?: string;
        sourceDocumentLineNumber?: integer | string;
        sourceDocumentNumber?: string;
        sourceDocumentSequenceNumber?: integer | string;
        sourceDocumentType?: EntryTypeEnum;
        sourceRequest?: RequestSource;
        stockCostInCompanyCurrency?: decimal | string;
        stockUnit?: string;
        subcontractAddress?: string;
        supplierProduct?: string;
        tax1BasisAmount?: decimal | string;
        tax1DeductibleAmount?: decimal | string;
        tax1amount?: decimal | string;
        tax2DeductibleAmount?: decimal | string;
        tax2amount?: decimal | string;
        tax3DeductibleAmount?: decimal | string;
        tax3amount?: decimal | string;
        taxExcludedLineAmount?: decimal | string;
        totalPurchaseCostInCompanyCurrency?: decimal | string;
        totalStockCostInCompanyCurrency?: decimal | string;
        volume?: decimal | string;
        volumeUnit?: string;
        weight?: decimal | string;
        weightUnit?: string;
        workInProgressOrderNumber?: string;
        workOrderInProgressStatus?: StatusInProgress;
        workOrderInProgressType?: WorkOrderType;
        productStatisticalGroups?: Partial<PurchaseOrderLineProductStatisticalGroupsInput>[];
        taxes?: Partial<PurchaseOrderLineTaxesInput>[];
        commitment?: string;
    }
    export interface PurchaseOrderLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseOrder: PurchaseOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        orderType: PurchaseOrderType;
        revisionNumber: integer;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: PurchasePriceReason;
        discountOrCharge2Reason: PurchasePriceReason;
        discountOrCharge3Reason: PurchasePriceReason;
        discountOrCharge4Reason: PurchasePriceReason;
        discountOrCharge5Reason: PurchasePriceReason;
        discountOrCharge6Reason: PurchasePriceReason;
        discountOrCharge7Reason: PurchasePriceReason;
        discountOrCharge8Reason: PurchasePriceReason;
        discountOrCharge9Reason: PurchasePriceReason;
        netPrice: string;
        buyer: User;
        receiptSite: Site;
        receiptAddress: SiteAddress;
        project: ProjectLink;
        intrastatIncreaseCoefficient: string;
        countryOfOrigin: Country;
        hasQualityControlManagement: boolean;
        receiptTax: Tax;
        issueTax: Tax;
        otherTax1: Tax;
        otherTax2: Tax;
        matchingTolerance: MatchingTolerance;
        acknowledgementDate: string;
        acknowledgementNumber: string;
        acknowledgementUpdate: integer;
        actualPurchaseCostInCompanyCurrency: string;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        calculatedBasisForTax3: string;
        calculatedTaxBasis1: string;
        calculatedTaxBasis2: string;
        calculationBasisForIssueTax: string;
        calculationBasisForOtherTax1: string;
        calculationBasisForOtherTax2: string;
        calculationBasisForReceiptTax: string;
        commitmentGenerated: integer;
        commitmentType: CommitmentType;
        companyCurrency: Currency;
        costPriceWithoutLandedCost: string;
        costStructure: FreightCostStructure;
        currency: Currency;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        expectedReceiptDate: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        interCompanySalesOrderLineNumber: integer;
        interCompanySalesOrderSequenceNumber: integer;
        isBudgetOverrun: boolean;
        isClosed: boolean;
        isClosedByReceipt: boolean;
        isInOrderUnit: boolean;
        isInvoiced: boolean;
        isPrinted: boolean;
        issueTaxAmount: string;
        issueTaxDeductibleAmount: string;
        landedCostCoefficient: string;
        lastReceiptDate: string;
        lastSalesInvoiceDate: string;
        lineAmountIncludingTax: string;
        lineAndSequenceIndex: string;
        lineOrderAmountIncludingTax: string;
        linePurchaseCostInCompanyCurrency: string;
        lineStatus: LineStatus;
        lineStockCostInCompanyCurrency: string;
        lineType: OrderLineType;
        linkCoefficientForSubcontract: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        numberOfInvoicedReceipts: integer;
        numberOfInvoices: integer;
        numberOfReceipts: integer;
        orderDate: string;
        orderFromSupplier: Supplier;
        orderLineText: TextStream;
        orderUnit: UnitOfMeasure;
        orderUnitToPurchaseUnitConversionFactor: string;
        otherTax1Amount: string;
        otherTax1DeductibleAmount: string;
        otherTax2Amount: string;
        otherTax2DeductibleAmount: string;
        productType: PurchasingProductType;
        purchaseCostInCompanyCurrency: string;
        purchaseReceipt: PurchaseReceipt;
        purchaseReceiptLine: PurchaseReceiptLine;
        purchaseSite: Site;
        purchaseType: PurchaseType;
        purchaseUnit: UnitOfMeasure;
        quantityInOrderUnitOrdered: string;
        quantityInPurchaseUnitInvoiced: string;
        quantityInPurchaseUnitOrdered: string;
        quantityInPurchaseUnitReceived: string;
        quantityInPurchaseUnitRequired: string;
        quantityInPurchaseUnitShippedNotReceived: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitReceived: string;
        quantityInStockUnitRequired: string;
        quantityInStockUnitShippedNotReceived: string;
        rebateOnTax1Amount: string;
        receiptTaxAmount: string;
        receiptTaxDeductibleAmount: string;
        releasedProduct: Product;
        reorderLeadTime: string;
        requestForQuotation: string;
        requestForQuotationResponseLineNumber: integer;
        requestedDeliveryEndDate: string;
        requestedDeliveryEndTime: integer;
        requestedDeliveryStartDate: string;
        requestedDeliveryStartTime: integer;
        requirementDate: string;
        shippingSite: Site;
        sourceDocumentLineNumber: integer;
        sourceDocumentNumber: string;
        sourceDocumentSequenceNumber: integer;
        sourceDocumentType: EntryTypeEnum;
        sourceRequest: RequestSource;
        stockCostInCompanyCurrency: string;
        stockUnit: UnitOfMeasure;
        subcontractAddress: SupplierAddress;
        supplierProduct: SupplierProduct;
        tax1BasisAmount: string;
        tax1DeductibleAmount: string;
        tax1amount: string;
        tax2DeductibleAmount: string;
        tax2amount: string;
        tax3DeductibleAmount: string;
        tax3amount: string;
        taxExcludedLineAmount: string;
        totalPurchaseCostInCompanyCurrency: string;
        totalStockCostInCompanyCurrency: string;
        volume: string;
        volumeUnit: UnitOfMeasure;
        weight: string;
        weightUnit: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workOrderInProgressStatus: StatusInProgress;
        workOrderInProgressType: WorkOrderType;
        productStatisticalGroups: ClientCollection<PurchaseOrderLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<PurchaseOrderLineTaxesBinding>;
        commitment: FinancialCommitment;
    }
    export interface PurchaseOrderLineExtension$Lookups {
        commitment: QueryOperation<FinancialCommitment>;
    }
    export interface PurchaseOrderLineExtension$Operations {
        lookups(dataOrId: string | { data: PurchaseOrderLineInput }): PurchaseOrderLineExtension$Lookups;
    }
    export interface Package {}
    export interface GraphApi
        extends Package,
            SageX3Finance$Package,
            SageX3FinanceData$Package,
            SageX3InvoicingData$Package,
            SageX3ManufacturingData$Package,
            SageX3MasterData$Package,
            SageX3PhysicalFlowsData$Package,
            SageX3ProjectManagementData$Package,
            SageX3Purchasing$Package,
            SageX3PurchasingData$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-purchasing-finance-api' {
    export type * from '@sage/x3-purchasing-finance-api-partial';
}
declare module '@sage/x3-finance-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-finance-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-physical-flows-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-purchasing-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-purchasing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-purchasing-api-partial' {
    import type {
        PurchaseOrderLineBindingExtension,
        PurchaseOrderLineExtension,
        PurchaseOrderLineExtension$Lookups,
        PurchaseOrderLineExtension$Operations,
        PurchaseOrderLineInputExtension,
    } from '@sage/x3-purchasing-finance-api';
    export interface PurchaseOrderLine extends PurchaseOrderLineExtension {}
    export interface PurchaseOrderLineBinding extends PurchaseOrderLineBindingExtension {}
    export interface PurchaseOrderLineInput extends PurchaseOrderLineInputExtension {}
    export interface PurchaseOrderLine$Lookups extends PurchaseOrderLineExtension$Lookups {}
    export interface PurchaseOrderLine$Operations extends PurchaseOrderLineExtension$Operations {}
}
