// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/index.d.ts
declare module '@sage/x3-project-management-data/index' {
	export * from '@sage/x3-project-management-data/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/index.d.ts
declare module '@sage/x3-project-management-data/lib/index' {
	export * as enums from '@sage/x3-project-management-data/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-project-management-data/lib/node-extensions/index';
	export * as nodes from '@sage/x3-project-management-data/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-project-management-data/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/service-options/index.d.ts
declare module '@sage/x3-project-management-data/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/nodes/project-text.d.ts
declare module '@sage/x3-project-management-data/lib/nodes/project-text' {
	import { Node, TextStream } from '@sage/xtrem-core';
	export class ProjectText extends Node {
	    readonly code: Promise<string>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly identifier3: Promise<string>;
	    readonly identifier4: Promise<string>;
	    readonly text: Promise<TextStream>;
	}
	//# sourceMappingURL=project-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/nodes/project-link.d.ts
declare module '@sage/x3-project-management-data/lib/nodes/project-link' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class ProjectLink extends Node {
	    readonly id: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly type: Promise<sageX3MasterData.enums.ProjectAllocationType>;
	    readonly isActive: Promise<boolean>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	}
	//# sourceMappingURL=project-link.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/nodes/index.d.ts
declare module '@sage/x3-project-management-data/lib/nodes/index' {
	export * from '@sage/x3-project-management-data/lib/nodes/cost-type';
	export * from '@sage/x3-project-management-data/lib/nodes/project-link';
	export * from '@sage/x3-project-management-data/lib/nodes/project-text';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/nodes/cost-type.d.ts
declare module '@sage/x3-project-management-data/lib/nodes/cost-type' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class CostType extends Node {
	    readonly code: Promise<string>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=cost-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/node-extensions/product-extension.d.ts
declare module '@sage/x3-project-management-data/lib/node-extensions/product-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data/lib/index';
	export class ProductExtension extends NodeExtension<sageX3MasterData.nodes.Product> {
	    readonly costType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product' {
	    interface Product extends ProductExtension {
	    }
	}
	//# sourceMappingURL=product-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/node-extensions/product-category-extension.d.ts
declare module '@sage/x3-project-management-data/lib/node-extensions/product-category-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data/lib/index';
	export class ProductCategoryExtension extends NodeExtension<sageX3MasterData.nodes.ProductCategory> {
	    readonly costType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product-category' {
	    interface ProductCategory extends ProductCategoryExtension {
	    }
	}
	//# sourceMappingURL=product-category-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-project-management-data/lib/node-extensions/index' {
	export * from '@sage/x3-project-management-data/lib/node-extensions/product-category-extension';
	export * from '@sage/x3-project-management-data/lib/node-extensions/product-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/week-days.d.ts
declare module '@sage/x3-project-management-data/lib/enums/week-days' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WeekDaysEnum {
	    monday = 1,
	    tuesday = 2,
	    wednesday = 3,
	    thursday = 4,
	    friday = 5,
	    saturday = 6,
	    sunday = 7,
	    substituteValue8 = 8
	}
	export interface WeekDays$EnumInterface {
	    monday: 1;
	    tuesday: 2;
	    wednesday: 3;
	    thursday: 4;
	    friday: 5;
	    saturday: 6;
	    sunday: 7;
	    substituteValue8: 8;
	}
	export type WeekDays = keyof WeekDays$EnumInterface;
	export const weekDaysDatatype: X3EnumDataType<keyof WeekDays$EnumInterface, unknown>;
	//# sourceMappingURL=week-days.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/time-entry-status.d.ts
declare module '@sage/x3-project-management-data/lib/enums/time-entry-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TimeEntryStatusEnum {
	    pendingValidation = 1,
	    validated = 2,
	    controlled = 3,
	    approved = 4,
	    postedSimulation = 5,
	    postedActual = 6,
	    rejected = 7
	}
	export interface TimeEntryStatus$EnumInterface {
	    pendingValidation: 1;
	    validated: 2;
	    controlled: 3;
	    approved: 4;
	    postedSimulation: 5;
	    postedActual: 6;
	    rejected: 7;
	}
	export type TimeEntryStatus = keyof TimeEntryStatus$EnumInterface;
	export const timeEntryStatusDatatype: X3EnumDataType<keyof TimeEntryStatus$EnumInterface, unknown>;
	//# sourceMappingURL=time-entry-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/time-entry-report-status.d.ts
declare module '@sage/x3-project-management-data/lib/enums/time-entry-report-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TimeEntryReportStatusEnum {
	    pendingValidation = 1,
	    validated = 2,
	    controlled = 3,
	    approved = 4,
	    rejected = 5
	}
	export interface TimeEntryReportStatus$EnumInterface {
	    pendingValidation: 1;
	    validated: 2;
	    controlled: 3;
	    approved: 4;
	    rejected: 5;
	}
	export type TimeEntryReportStatus = keyof TimeEntryReportStatus$EnumInterface;
	export const timeEntryReportStatusDatatype: X3EnumDataType<keyof TimeEntryReportStatus$EnumInterface, unknown>;
	//# sourceMappingURL=time-entry-report-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/time-entry-origin.d.ts
declare module '@sage/x3-project-management-data/lib/enums/time-entry-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TimeEntryOriginEnum {
	    manual = 1,
	    imported = 2
	}
	export interface TimeEntryOrigin$EnumInterface {
	    manual: 1;
	    imported: 2;
	}
	export type TimeEntryOrigin = keyof TimeEntryOrigin$EnumInterface;
	export const timeEntryOriginDatatype: X3EnumDataType<keyof TimeEntryOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=time-entry-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/time-entry-control-phase.d.ts
declare module '@sage/x3-project-management-data/lib/enums/time-entry-control-phase' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TimeEntryControlPhaseEnum {
	    mandatory = 1,
	    notMandatory = 2
	}
	export interface TimeEntryControlPhase$EnumInterface {
	    mandatory: 1;
	    notMandatory: 2;
	}
	export type TimeEntryControlPhase = keyof TimeEntryControlPhase$EnumInterface;
	export const timeEntryControlPhaseDatatype: X3EnumDataType<keyof TimeEntryControlPhase$EnumInterface, unknown>;
	//# sourceMappingURL=time-entry-control-phase.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/tasks-link-type.d.ts
declare module '@sage/x3-project-management-data/lib/enums/tasks-link-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TasksLinkTypeEnum {
	    endToStart = 1,
	    startToStart = 2,
	    endToEnd = 3,
	    startToEnd = 4
	}
	export interface TasksLinkType$EnumInterface {
	    endToStart: 1;
	    startToStart: 2;
	    endToEnd: 3;
	    startToEnd: 4;
	}
	export type TasksLinkType = keyof TasksLinkType$EnumInterface;
	export const tasksLinkTypeDatatype: X3EnumDataType<keyof TasksLinkType$EnumInterface, unknown>;
	//# sourceMappingURL=tasks-link-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/task-event.d.ts
declare module '@sage/x3-project-management-data/lib/enums/task-event' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaskEventEnum {
	    plan = 1,
	    launch = 2,
	    close = 3,
	    suspend = 4,
	    reactivate = 5
	}
	export interface TaskEvent$EnumInterface {
	    plan: 1;
	    launch: 2;
	    close: 3;
	    suspend: 4;
	    reactivate: 5;
	}
	export type TaskEvent = keyof TaskEvent$EnumInterface;
	export const taskEventDatatype: X3EnumDataType<keyof TaskEvent$EnumInterface, unknown>;
	//# sourceMappingURL=task-event.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/source-of-posted-labor-rate.d.ts
declare module '@sage/x3-project-management-data/lib/enums/source-of-posted-labor-rate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SourceOfPostedLaborRateEnum {
	    employeeLaborRate = 1,
	    projectLaborRate = 2
	}
	export interface SourceOfPostedLaborRate$EnumInterface {
	    employeeLaborRate: 1;
	    projectLaborRate: 2;
	}
	export type SourceOfPostedLaborRate = keyof SourceOfPostedLaborRate$EnumInterface;
	export const sourceOfPostedLaborRateDatatype: X3EnumDataType<keyof SourceOfPostedLaborRate$EnumInterface, unknown>;
	//# sourceMappingURL=source-of-posted-labor-rate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/source-of-posted-labor-acct.d.ts
declare module '@sage/x3-project-management-data/lib/enums/source-of-posted-labor-acct' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SourceOfPostedLaborAcctEnum {
	    employeeCostType = 1,
	    projectCostType = 2
	}
	export interface SourceOfPostedLaborAcct$EnumInterface {
	    employeeCostType: 1;
	    projectCostType: 2;
	}
	export type SourceOfPostedLaborAcct = keyof SourceOfPostedLaborAcct$EnumInterface;
	export const sourceOfPostedLaborAcctDatatype: X3EnumDataType<keyof SourceOfPostedLaborAcct$EnumInterface, unknown>;
	//# sourceMappingURL=source-of-posted-labor-acct.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/sold-products-line-prd-grp-lvl.d.ts
declare module '@sage/x3-project-management-data/lib/enums/sold-products-line-prd-grp-lvl' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SoldProductsLinePrdGrpLvlEnum {
	    notGrouped = 1,
	    project = 2,
	    budgetCode = 3,
	    taskCode = 4
	}
	export interface SoldProductsLinePrdGrpLvl$EnumInterface {
	    notGrouped: 1;
	    project: 2;
	    budgetCode: 3;
	    taskCode: 4;
	}
	export type SoldProductsLinePrdGrpLvl = keyof SoldProductsLinePrdGrpLvl$EnumInterface;
	export const soldProductsLinePrdGrpLvlDatatype: X3EnumDataType<keyof SoldProductsLinePrdGrpLvl$EnumInterface, unknown>;
	//# sourceMappingURL=sold-products-line-prd-grp-lvl.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/sold-products-line-doc-type.d.ts
declare module '@sage/x3-project-management-data/lib/enums/sold-products-line-doc-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SoldProductsLineDocTypeEnum {
	    notSelected = 1,
	    quote = 2,
	    salesOrder = 3,
	    directInvoice = 4
	}
	export interface SoldProductsLineDocType$EnumInterface {
	    notSelected: 1;
	    quote: 2;
	    salesOrder: 3;
	    directInvoice: 4;
	}
	export type SoldProductsLineDocType = keyof SoldProductsLineDocType$EnumInterface;
	export const soldProductsLineDocTypeDatatype: X3EnumDataType<keyof SoldProductsLineDocType$EnumInterface, unknown>;
	//# sourceMappingURL=sold-products-line-doc-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/sold-products-document-type.d.ts
declare module '@sage/x3-project-management-data/lib/enums/sold-products-document-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SoldProductsDocumentTypeEnum {
	    quote = 1,
	    salesOrder = 2,
	    directInvoice = 3
	}
	export interface SoldProductsDocumentType$EnumInterface {
	    quote: 1;
	    salesOrder: 2;
	    directInvoice: 3;
	}
	export type SoldProductsDocumentType = keyof SoldProductsDocumentType$EnumInterface;
	export const soldProductsDocumentTypeDatatype: X3EnumDataType<keyof SoldProductsDocumentType$EnumInterface, unknown>;
	//# sourceMappingURL=sold-products-document-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/saleable-prod-list-automation.d.ts
declare module '@sage/x3-project-management-data/lib/enums/saleable-prod-list-automation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SaleableProdListAutomationEnum {
	    includeAllSubLevels = 1,
	    useBudgetLines = 2,
	    saleableProductsFromTasks = 3,
	    useTaskProducts = 4,
	    useTaskOperations = 5,
	    overwriteExistingAutomatedSaleableProductLines = 6,
	    writeLogFile = 7,
	    deleteAllExistingAutomatedSaleableProductLines = 8
	}
	export interface SaleableProdListAutomation$EnumInterface {
	    includeAllSubLevels: 1;
	    useBudgetLines: 2;
	    saleableProductsFromTasks: 3;
	    useTaskProducts: 4;
	    useTaskOperations: 5;
	    overwriteExistingAutomatedSaleableProductLines: 6;
	    writeLogFile: 7;
	    deleteAllExistingAutomatedSaleableProductLines: 8;
	}
	export type SaleableProdListAutomation = keyof SaleableProdListAutomation$EnumInterface;
	export const saleableProdListAutomationDatatype: X3EnumDataType<keyof SaleableProdListAutomation$EnumInterface, unknown>;
	//# sourceMappingURL=saleable-prod-list-automation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/saleable-prd-line-origin.d.ts
declare module '@sage/x3-project-management-data/lib/enums/saleable-prd-line-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SaleablePrdLineOriginEnum {
	    manual = 1,
	    operations = 2,
	    productRequirements = 3,
	    budgetLines = 4
	}
	export interface SaleablePrdLineOrigin$EnumInterface {
	    manual: 1;
	    operations: 2;
	    productRequirements: 3;
	    budgetLines: 4;
	}
	export type SaleablePrdLineOrigin = keyof SaleablePrdLineOrigin$EnumInterface;
	export const saleablePrdLineOriginDatatype: X3EnumDataType<keyof SaleablePrdLineOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=saleable-prd-line-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/revision-management-options.d.ts
declare module '@sage/x3-project-management-data/lib/enums/revision-management-options' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RevisionManagementOptionsEnum {
	    notManaged = 1,
	    managedOnDemand = 2,
	    managedAutomatically = 3
	}
	export interface RevisionManagementOptions$EnumInterface {
	    notManaged: 1;
	    managedOnDemand: 2;
	    managedAutomatically: 3;
	}
	export type RevisionManagementOptions = keyof RevisionManagementOptions$EnumInterface;
	export const revisionManagementOptionsDatatype: X3EnumDataType<keyof RevisionManagementOptions$EnumInterface, unknown>;
	//# sourceMappingURL=revision-management-options.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/remaining-load-calculation.d.ts
declare module '@sage/x3-project-management-data/lib/enums/remaining-load-calculation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RemainingLoadCalculationEnum {
	    onFullAssignmentPeriod = 1,
	    fromCurrentDate = 2
	}
	export interface RemainingLoadCalculation$EnumInterface {
	    onFullAssignmentPeriod: 1;
	    fromCurrentDate: 2;
	}
	export type RemainingLoadCalculation = keyof RemainingLoadCalculation$EnumInterface;
	export const remainingLoadCalculationDatatype: X3EnumDataType<keyof RemainingLoadCalculation$EnumInterface, unknown>;
	//# sourceMappingURL=remaining-load-calculation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/quantity-amount.d.ts
declare module '@sage/x3-project-management-data/lib/enums/quantity-amount' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QuantityAmountEnum {
	    quantity = 1,
	    amount = 2
	}
	export interface QuantityAmount$EnumInterface {
	    quantity: 1;
	    amount: 2;
	}
	export type QuantityAmount = keyof QuantityAmount$EnumInterface;
	export const quantityAmountDatatype: X3EnumDataType<keyof QuantityAmount$EnumInterface, unknown>;
	//# sourceMappingURL=quantity-amount.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/project-task-type.d.ts
declare module '@sage/x3-project-management-data/lib/enums/project-task-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectTaskTypeEnum {
	    material = 1,
	    labor = 2,
	    mixed = 3,
	    miscellaneous = 4
	}
	export interface ProjectTaskType$EnumInterface {
	    material: 1;
	    labor: 2;
	    mixed: 3;
	    miscellaneous: 4;
	}
	export type ProjectTaskType = keyof ProjectTaskType$EnumInterface;
	export const projectTaskTypeDatatype: X3EnumDataType<keyof ProjectTaskType$EnumInterface, unknown>;
	//# sourceMappingURL=project-task-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/project-task-status.d.ts
declare module '@sage/x3-project-management-data/lib/enums/project-task-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectTaskStatusEnum {
	    new = 1,
	    launched = 2,
	    started = 3,
	    closed = 4,
	    planned = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    suspended = 9
	}
	export interface ProjectTaskStatus$EnumInterface {
	    new: 1;
	    launched: 2;
	    started: 3;
	    closed: 4;
	    planned: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    suspended: 9;
	}
	export type ProjectTaskStatus = keyof ProjectTaskStatus$EnumInterface;
	export const projectTaskStatusDatatype: X3EnumDataType<keyof ProjectTaskStatus$EnumInterface, unknown>;
	//# sourceMappingURL=project-task-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/project-status.d.ts
declare module '@sage/x3-project-management-data/lib/enums/project-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectStatusEnum {
	    new = 1,
	    launched = 2,
	    delivered = 3,
	    closed = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    suspended = 9
	}
	export interface ProjectStatus$EnumInterface {
	    new: 1;
	    launched: 2;
	    delivered: 3;
	    closed: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    suspended: 9;
	}
	export type ProjectStatus = keyof ProjectStatus$EnumInterface;
	export const projectStatusDatatype: X3EnumDataType<keyof ProjectStatus$EnumInterface, unknown>;
	//# sourceMappingURL=project-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/project-status-2278.d.ts
declare module '@sage/x3-project-management-data/lib/enums/project-status-2278' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectStatus2278Enum {
	    allProjects = 1,
	    notOpened = 2,
	    opened = 3,
	    launched = 4,
	    delivered = 5,
	    closed = 6,
	    suspended = 7
	}
	export interface ProjectStatus2278$EnumInterface {
	    allProjects: 1;
	    notOpened: 2;
	    opened: 3;
	    launched: 4;
	    delivered: 5;
	    closed: 6;
	    suspended: 7;
	}
	export type ProjectStatus2278 = keyof ProjectStatus2278$EnumInterface;
	export const projectStatus2278Datatype: X3EnumDataType<keyof ProjectStatus2278$EnumInterface, unknown>;
	//# sourceMappingURL=project-status-2278.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/project-gantt-chart.d.ts
declare module '@sage/x3-project-management-data/lib/enums/project-gantt-chart' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectGanttChartEnum {
	    project = 1,
	    task = 2,
	    product = 3,
	    operation = 4,
	    parentTask = 5
	}
	export interface ProjectGanttChart$EnumInterface {
	    project: 1;
	    task: 2;
	    product: 3;
	    operation: 4;
	    parentTask: 5;
	}
	export type ProjectGanttChart = keyof ProjectGanttChart$EnumInterface;
	export const projectGanttChartDatatype: X3EnumDataType<keyof ProjectGanttChart$EnumInterface, unknown>;
	//# sourceMappingURL=project-gantt-chart.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/project-event.d.ts
declare module '@sage/x3-project-management-data/lib/enums/project-event' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectEventEnum {
	    launch = 1,
	    deliver = 2,
	    close = 3,
	    suspend = 4,
	    reactivate = 5
	}
	export interface ProjectEvent$EnumInterface {
	    launch: 1;
	    deliver: 2;
	    close: 3;
	    suspend: 4;
	    reactivate: 5;
	}
	export type ProjectEvent = keyof ProjectEvent$EnumInterface;
	export const projectEventDatatype: X3EnumDataType<keyof ProjectEvent$EnumInterface, unknown>;
	//# sourceMappingURL=project-event.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/project-default-status.d.ts
declare module '@sage/x3-project-management-data/lib/enums/project-default-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectDefaultStatusEnum {
	    new = 1,
	    launched = 2
	}
	export interface ProjectDefaultStatus$EnumInterface {
	    new: 1;
	    launched: 2;
	}
	export type ProjectDefaultStatus = keyof ProjectDefaultStatus$EnumInterface;
	export const projectDefaultStatusDatatype: X3EnumDataType<keyof ProjectDefaultStatus$EnumInterface, unknown>;
	//# sourceMappingURL=project-default-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/project-budget-status.d.ts
declare module '@sage/x3-project-management-data/lib/enums/project-budget-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectBudgetStatusEnum {
	    new = 1,
	    open = 2,
	    delivered = 3,
	    closed = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    suspended = 9
	}
	export interface ProjectBudgetStatus$EnumInterface {
	    new: 1;
	    open: 2;
	    delivered: 3;
	    closed: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    suspended: 9;
	}
	export type ProjectBudgetStatus = keyof ProjectBudgetStatus$EnumInterface;
	export const projectBudgetStatusDatatype: X3EnumDataType<keyof ProjectBudgetStatus$EnumInterface, unknown>;
	//# sourceMappingURL=project-budget-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/progress-status-selection.d.ts
declare module '@sage/x3-project-management-data/lib/enums/progress-status-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProgressStatusSelectionEnum {
	    notGrouped = 1,
	    byMonthPeriodStart = 2,
	    byMonthInvoiceDate = 3
	}
	export interface ProgressStatusSelection$EnumInterface {
	    notGrouped: 1;
	    byMonthPeriodStart: 2;
	    byMonthInvoiceDate: 3;
	}
	export type ProgressStatusSelection = keyof ProgressStatusSelection$EnumInterface;
	export const progressStatusSelectionDatatype: X3EnumDataType<keyof ProgressStatusSelection$EnumInterface, unknown>;
	//# sourceMappingURL=progress-status-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/progress-billing-selection.d.ts
declare module '@sage/x3-project-management-data/lib/enums/progress-billing-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProgressBillingSelectionEnum {
	    bySalesOrderLine = 1,
	    bySalesOrder = 2,
	    byProjectPhase = 3
	}
	export interface ProgressBillingSelection$EnumInterface {
	    bySalesOrderLine: 1;
	    bySalesOrder: 2;
	    byProjectPhase: 3;
	}
	export type ProgressBillingSelection = keyof ProgressBillingSelection$EnumInterface;
	export const progressBillingSelectionDatatype: X3EnumDataType<keyof ProgressBillingSelection$EnumInterface, unknown>;
	//# sourceMappingURL=progress-billing-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/progress-billing-line-status.d.ts
declare module '@sage/x3-project-management-data/lib/enums/progress-billing-line-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProgressBillingLineStatusEnum {
	    pending = 1,
	    toBeInvoiced = 2,
	    invoiced = 3,
	    creditMemo = 4
	}
	export interface ProgressBillingLineStatus$EnumInterface {
	    pending: 1;
	    toBeInvoiced: 2;
	    invoiced: 3;
	    creditMemo: 4;
	}
	export type ProgressBillingLineStatus = keyof ProgressBillingLineStatus$EnumInterface;
	export const progressBillingLineStatusDatatype: X3EnumDataType<keyof ProgressBillingLineStatus$EnumInterface, unknown>;
	//# sourceMappingURL=progress-billing-line-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/prog-status-percentage-init.d.ts
declare module '@sage/x3-project-management-data/lib/enums/prog-status-percentage-init' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProgStatusPercentageInitEnum {
	    projectProgressOnly = 1,
	    forecastStatusOnlyScheduledInvoices = 2,
	    combinedProjectProgressForecastStatus = 3
	}
	export interface ProgStatusPercentageInit$EnumInterface {
	    projectProgressOnly: 1;
	    forecastStatusOnlyScheduledInvoices: 2;
	    combinedProjectProgressForecastStatus: 3;
	}
	export type ProgStatusPercentageInit = keyof ProgStatusPercentageInit$EnumInterface;
	export const progStatusPercentageInitDatatype: X3EnumDataType<keyof ProgStatusPercentageInit$EnumInterface, unknown>;
	//# sourceMappingURL=prog-status-percentage-init.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/planning-mode.d.ts
declare module '@sage/x3-project-management-data/lib/enums/planning-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PlanningModeEnum {
	    dateOfTasks = 1,
	    manualDate = 2,
	    calculatedDate = 3,
	    noOperation = 4
	}
	export interface PlanningMode$EnumInterface {
	    dateOfTasks: 1;
	    manualDate: 2;
	    calculatedDate: 3;
	    noOperation: 4;
	}
	export type PlanningMode = keyof PlanningMode$EnumInterface;
	export const planningModeDatatype: X3EnumDataType<keyof PlanningMode$EnumInterface, unknown>;
	//# sourceMappingURL=planning-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/pjm-budget-management.d.ts
declare module '@sage/x3-project-management-data/lib/enums/pjm-budget-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PjmBudgetManagementEnum {
	    byCostStructure = 1,
	    byProjectStructure = 2,
	    bothStructures = 3
	}
	export interface PjmBudgetManagement$EnumInterface {
	    byCostStructure: 1;
	    byProjectStructure: 2;
	    bothStructures: 3;
	}
	export type PjmBudgetManagement = keyof PjmBudgetManagement$EnumInterface;
	export const pjmBudgetManagementDatatype: X3EnumDataType<keyof PjmBudgetManagement$EnumInterface, unknown>;
	//# sourceMappingURL=pjm-budget-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/period-to-control.d.ts
declare module '@sage/x3-project-management-data/lib/enums/period-to-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PeriodToControlEnum {
	    day = 1,
	    week = 2,
	    month = 3
	}
	export interface PeriodToControl$EnumInterface {
	    day: 1;
	    week: 2;
	    month: 3;
	}
	export type PeriodToControl = keyof PeriodToControl$EnumInterface;
	export const periodToControlDatatype: X3EnumDataType<keyof PeriodToControl$EnumInterface, unknown>;
	//# sourceMappingURL=period-to-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/origin.d.ts
declare module '@sage/x3-project-management-data/lib/enums/origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OriginEnum {
	    invoice = 1,
	    creditMemo = 2
	}
	export interface Origin$EnumInterface {
	    invoice: 1;
	    creditMemo: 2;
	}
	export type Origin = keyof Origin$EnumInterface;
	export const originDatatype: X3EnumDataType<keyof Origin$EnumInterface, unknown>;
	//# sourceMappingURL=origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/operations-link-type.d.ts
declare module '@sage/x3-project-management-data/lib/enums/operations-link-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperationsLinkTypeEnum {
	    endToStart = 1,
	    startToStart = 2,
	    endToEnd = 3,
	    startToEnd = 4
	}
	export interface OperationsLinkType$EnumInterface {
	    endToStart: 1;
	    startToStart: 2;
	    endToEnd: 3;
	    startToEnd: 4;
	}
	export type OperationsLinkType = keyof OperationsLinkType$EnumInterface;
	export const operationsLinkTypeDatatype: X3EnumDataType<keyof OperationsLinkType$EnumInterface, unknown>;
	//# sourceMappingURL=operations-link-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/operation-labor-rate-priority.d.ts
declare module '@sage/x3-project-management-data/lib/enums/operation-labor-rate-priority' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperationLaborRatePriorityEnum {
	    costingDimension = 1,
	    projectCostType = 2
	}
	export interface OperationLaborRatePriority$EnumInterface {
	    costingDimension: 1;
	    projectCostType: 2;
	}
	export type OperationLaborRatePriority = keyof OperationLaborRatePriority$EnumInterface;
	export const operationLaborRatePriorityDatatype: X3EnumDataType<keyof OperationLaborRatePriority$EnumInterface, unknown>;
	//# sourceMappingURL=operation-labor-rate-priority.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/operation-event.d.ts
declare module '@sage/x3-project-management-data/lib/enums/operation-event' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperationEventEnum {
	    close = 1,
	    suspend = 2,
	    reactivate = 3
	}
	export interface OperationEvent$EnumInterface {
	    close: 1;
	    suspend: 2;
	    reactivate: 3;
	}
	export type OperationEvent = keyof OperationEvent$EnumInterface;
	export const operationEventDatatype: X3EnumDataType<keyof OperationEvent$EnumInterface, unknown>;
	//# sourceMappingURL=operation-event.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/ope-prov-task.d.ts
declare module '@sage/x3-project-management-data/lib/enums/ope-prov-task' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OpeProvTaskEnum {
	    provisional = 1,
	    operational = 2
	}
	export interface OpeProvTask$EnumInterface {
	    provisional: 1;
	    operational: 2;
	}
	export type OpeProvTask = keyof OpeProvTask$EnumInterface;
	export const opeProvTaskDatatype: X3EnumDataType<keyof OpeProvTask$EnumInterface, unknown>;
	//# sourceMappingURL=ope-prov-task.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/objects.d.ts
declare module '@sage/x3-project-management-data/lib/enums/objects' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ObjectsEnum {
	    purchaseOrder = 1,
	    workOrders = 2,
	    subContracts = 3
	}
	export interface Objects$EnumInterface {
	    purchaseOrder: 1;
	    workOrders: 2;
	    subContracts: 3;
	}
	export type Objects = keyof Objects$EnumInterface;
	export const objectsDatatype: X3EnumDataType<keyof Objects$EnumInterface, unknown>;
	//# sourceMappingURL=objects.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/load-analysis.d.ts
declare module '@sage/x3-project-management-data/lib/enums/load-analysis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LoadAnalysisEnum {
	    allTasks = 1,
	    lateTasks = 2,
	    overConsumedTasks = 3,
	    remainingTasks = 4
	}
	export interface LoadAnalysis$EnumInterface {
	    allTasks: 1;
	    lateTasks: 2;
	    overConsumedTasks: 3;
	    remainingTasks: 4;
	}
	export type LoadAnalysis = keyof LoadAnalysis$EnumInterface;
	export const loadAnalysisDatatype: X3EnumDataType<keyof LoadAnalysis$EnumInterface, unknown>;
	//# sourceMappingURL=load-analysis.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/labor-rate-priority.d.ts
declare module '@sage/x3-project-management-data/lib/enums/labor-rate-priority' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LaborRatePriorityEnum {
	    employee = 1,
	    projectCostType = 2
	}
	export interface LaborRatePriority$EnumInterface {
	    employee: 1;
	    projectCostType: 2;
	}
	export type LaborRatePriority = keyof LaborRatePriority$EnumInterface;
	export const laborRatePriorityDatatype: X3EnumDataType<keyof LaborRatePriority$EnumInterface, unknown>;
	//# sourceMappingURL=labor-rate-priority.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/index.d.ts
declare module '@sage/x3-project-management-data/lib/enums/index' {
	export * from '@sage/x3-project-management-data/lib/enums/action-2068';
	export * from '@sage/x3-project-management-data/lib/enums/adjusted-value';
	export * from '@sage/x3-project-management-data/lib/enums/aggregate';
	export * from '@sage/x3-project-management-data/lib/enums/assignment-details';
	export * from '@sage/x3-project-management-data/lib/enums/assignment-split-details';
	export * from '@sage/x3-project-management-data/lib/enums/bdgt-auto-processing-options';
	export * from '@sage/x3-project-management-data/lib/enums/billing-mode';
	export * from '@sage/x3-project-management-data/lib/enums/budget-event';
	export * from '@sage/x3-project-management-data/lib/enums/budget-line-origin';
	export * from '@sage/x3-project-management-data/lib/enums/budget-method';
	export * from '@sage/x3-project-management-data/lib/enums/calculation-method-used';
	export * from '@sage/x3-project-management-data/lib/enums/closing-with-authorized-credit';
	export * from '@sage/x3-project-management-data/lib/enums/constraint-type';
	export * from '@sage/x3-project-management-data/lib/enums/consumption-mode';
	export * from '@sage/x3-project-management-data/lib/enums/copy-budget-status';
	export * from '@sage/x3-project-management-data/lib/enums/copy-task-status';
	export * from '@sage/x3-project-management-data/lib/enums/copy-task-type';
	export * from '@sage/x3-project-management-data/lib/enums/cost-group-type';
	export * from '@sage/x3-project-management-data/lib/enums/dates-adjustment-rules';
	export * from '@sage/x3-project-management-data/lib/enums/delivery-status';
	export * from '@sage/x3-project-management-data/lib/enums/display';
	export * from '@sage/x3-project-management-data/lib/enums/duration-copy-options';
	export * from '@sage/x3-project-management-data/lib/enums/estimation-method-used';
	export * from '@sage/x3-project-management-data/lib/enums/estimation-method';
	export * from '@sage/x3-project-management-data/lib/enums/generation-type-2268';
	export * from '@sage/x3-project-management-data/lib/enums/labor-rate-priority';
	export * from '@sage/x3-project-management-data/lib/enums/load-analysis';
	export * from '@sage/x3-project-management-data/lib/enums/objects';
	export * from '@sage/x3-project-management-data/lib/enums/ope-prov-task';
	export * from '@sage/x3-project-management-data/lib/enums/operation-event';
	export * from '@sage/x3-project-management-data/lib/enums/operation-labor-rate-priority';
	export * from '@sage/x3-project-management-data/lib/enums/operations-link-type';
	export * from '@sage/x3-project-management-data/lib/enums/origin';
	export * from '@sage/x3-project-management-data/lib/enums/period-to-control';
	export * from '@sage/x3-project-management-data/lib/enums/pjm-budget-management';
	export * from '@sage/x3-project-management-data/lib/enums/planning-mode';
	export * from '@sage/x3-project-management-data/lib/enums/prog-status-percentage-init';
	export * from '@sage/x3-project-management-data/lib/enums/progress-billing-line-status';
	export * from '@sage/x3-project-management-data/lib/enums/progress-billing-selection';
	export * from '@sage/x3-project-management-data/lib/enums/progress-status-selection';
	export * from '@sage/x3-project-management-data/lib/enums/project-budget-status';
	export * from '@sage/x3-project-management-data/lib/enums/project-default-status';
	export * from '@sage/x3-project-management-data/lib/enums/project-event';
	export * from '@sage/x3-project-management-data/lib/enums/project-gantt-chart';
	export * from '@sage/x3-project-management-data/lib/enums/project-status-2278';
	export * from '@sage/x3-project-management-data/lib/enums/project-status';
	export * from '@sage/x3-project-management-data/lib/enums/project-task-status';
	export * from '@sage/x3-project-management-data/lib/enums/project-task-type';
	export * from '@sage/x3-project-management-data/lib/enums/quantity-amount';
	export * from '@sage/x3-project-management-data/lib/enums/remaining-load-calculation';
	export * from '@sage/x3-project-management-data/lib/enums/revision-management-options';
	export * from '@sage/x3-project-management-data/lib/enums/saleable-prd-line-origin';
	export * from '@sage/x3-project-management-data/lib/enums/saleable-prod-list-automation';
	export * from '@sage/x3-project-management-data/lib/enums/sold-products-document-type';
	export * from '@sage/x3-project-management-data/lib/enums/sold-products-line-doc-type';
	export * from '@sage/x3-project-management-data/lib/enums/sold-products-line-prd-grp-lvl';
	export * from '@sage/x3-project-management-data/lib/enums/source-of-posted-labor-acct';
	export * from '@sage/x3-project-management-data/lib/enums/source-of-posted-labor-rate';
	export * from '@sage/x3-project-management-data/lib/enums/task-event';
	export * from '@sage/x3-project-management-data/lib/enums/tasks-link-type';
	export * from '@sage/x3-project-management-data/lib/enums/time-entry-control-phase';
	export * from '@sage/x3-project-management-data/lib/enums/time-entry-origin';
	export * from '@sage/x3-project-management-data/lib/enums/time-entry-report-status';
	export * from '@sage/x3-project-management-data/lib/enums/time-entry-status';
	export * from '@sage/x3-project-management-data/lib/enums/week-days';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/generation-type-2268.d.ts
declare module '@sage/x3-project-management-data/lib/enums/generation-type-2268' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GenerationType2268Enum {
	    actual = 1,
	    activeSimulation = 2,
	    inactiveSimulation = 3
	}
	export interface GenerationType2268$EnumInterface {
	    actual: 1;
	    activeSimulation: 2;
	    inactiveSimulation: 3;
	}
	export type GenerationType2268 = keyof GenerationType2268$EnumInterface;
	export const generationType2268Datatype: X3EnumDataType<keyof GenerationType2268$EnumInterface, unknown>;
	//# sourceMappingURL=generation-type-2268.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/estimation-method.d.ts
declare module '@sage/x3-project-management-data/lib/enums/estimation-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EstimationMethodEnum {
	    manualEntry = 1,
	    calculated = 2,
	    manualEntryOrCalculated = 3
	}
	export interface EstimationMethod$EnumInterface {
	    manualEntry: 1;
	    calculated: 2;
	    manualEntryOrCalculated: 3;
	}
	export type EstimationMethod = keyof EstimationMethod$EnumInterface;
	export const estimationMethodDatatype: X3EnumDataType<keyof EstimationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=estimation-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/estimation-method-used.d.ts
declare module '@sage/x3-project-management-data/lib/enums/estimation-method-used' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EstimationMethodUsedEnum {
	    notCalculated = 1,
	    manualEntry = 2,
	    calculated = 3,
	    revRecSnapshot = 4
	}
	export interface EstimationMethodUsed$EnumInterface {
	    notCalculated: 1;
	    manualEntry: 2;
	    calculated: 3;
	    revRecSnapshot: 4;
	}
	export type EstimationMethodUsed = keyof EstimationMethodUsed$EnumInterface;
	export const estimationMethodUsedDatatype: X3EnumDataType<keyof EstimationMethodUsed$EnumInterface, unknown>;
	//# sourceMappingURL=estimation-method-used.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/duration-copy-options.d.ts
declare module '@sage/x3-project-management-data/lib/enums/duration-copy-options' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DurationCopyOptionsEnum {
	    copyFromTheSource = 1,
	    copyFromTheTaskCategory = 2,
	    clearDuration = 3
	}
	export interface DurationCopyOptions$EnumInterface {
	    copyFromTheSource: 1;
	    copyFromTheTaskCategory: 2;
	    clearDuration: 3;
	}
	export type DurationCopyOptions = keyof DurationCopyOptions$EnumInterface;
	export const durationCopyOptionsDatatype: X3EnumDataType<keyof DurationCopyOptions$EnumInterface, unknown>;
	//# sourceMappingURL=duration-copy-options.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/display.d.ts
declare module '@sage/x3-project-management-data/lib/enums/display' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DisplayEnum {
	    displayAll = 1,
	    timeSpentMoreThanCapacity = 2,
	    timeSpentLessThanCapacity = 3
	}
	export interface Display$EnumInterface {
	    displayAll: 1;
	    timeSpentMoreThanCapacity: 2;
	    timeSpentLessThanCapacity: 3;
	}
	export type Display = keyof Display$EnumInterface;
	export const displayDatatype: X3EnumDataType<keyof Display$EnumInterface, unknown>;
	//# sourceMappingURL=display.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/delivery-status.d.ts
declare module '@sage/x3-project-management-data/lib/enums/delivery-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeliveryStatusEnum {
	    notDelivered = 1,
	    partiallyDelivered = 2,
	    delivered = 3,
	    noDeliverable = 4
	}
	export interface DeliveryStatus$EnumInterface {
	    notDelivered: 1;
	    partiallyDelivered: 2;
	    delivered: 3;
	    noDeliverable: 4;
	}
	export type DeliveryStatus = keyof DeliveryStatus$EnumInterface;
	export const deliveryStatusDatatype: X3EnumDataType<keyof DeliveryStatus$EnumInterface, unknown>;
	//# sourceMappingURL=delivery-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/dates-adjustment-rules.d.ts
declare module '@sage/x3-project-management-data/lib/enums/dates-adjustment-rules' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DatesAdjustmentRulesEnum {
	    onDemandUpdate = 1,
	    automaticUpdate = 2
	}
	export interface DatesAdjustmentRules$EnumInterface {
	    onDemandUpdate: 1;
	    automaticUpdate: 2;
	}
	export type DatesAdjustmentRules = keyof DatesAdjustmentRules$EnumInterface;
	export const datesAdjustmentRulesDatatype: X3EnumDataType<keyof DatesAdjustmentRules$EnumInterface, unknown>;
	//# sourceMappingURL=dates-adjustment-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/cost-group-type.d.ts
declare module '@sage/x3-project-management-data/lib/enums/cost-group-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostGroupTypeEnum {
	    material = 1,
	    labor = 2,
	    machine = 3
	}
	export interface CostGroupType$EnumInterface {
	    material: 1;
	    labor: 2;
	    machine: 3;
	}
	export type CostGroupType = keyof CostGroupType$EnumInterface;
	export const costGroupTypeDatatype: X3EnumDataType<keyof CostGroupType$EnumInterface, unknown>;
	//# sourceMappingURL=cost-group-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/copy-task-type.d.ts
declare module '@sage/x3-project-management-data/lib/enums/copy-task-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CopyTaskTypeEnum {
	    allTypes = 1,
	    material = 2,
	    labor = 3,
	    mixed = 4,
	    miscellaneous = 5
	}
	export interface CopyTaskType$EnumInterface {
	    allTypes: 1;
	    material: 2;
	    labor: 3;
	    mixed: 4;
	    miscellaneous: 5;
	}
	export type CopyTaskType = keyof CopyTaskType$EnumInterface;
	export const copyTaskTypeDatatype: X3EnumDataType<keyof CopyTaskType$EnumInterface, unknown>;
	//# sourceMappingURL=copy-task-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/copy-task-status.d.ts
declare module '@sage/x3-project-management-data/lib/enums/copy-task-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CopyTaskStatusEnum {
	    allTasks = 1,
	    notOpened = 2,
	    opened = 3,
	    launched = 4,
	    started = 5,
	    planned = 6,
	    closed = 7,
	    suspended = 8
	}
	export interface CopyTaskStatus$EnumInterface {
	    allTasks: 1;
	    notOpened: 2;
	    opened: 3;
	    launched: 4;
	    started: 5;
	    planned: 6;
	    closed: 7;
	    suspended: 8;
	}
	export type CopyTaskStatus = keyof CopyTaskStatus$EnumInterface;
	export const copyTaskStatusDatatype: X3EnumDataType<keyof CopyTaskStatus$EnumInterface, unknown>;
	//# sourceMappingURL=copy-task-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/copy-budget-status.d.ts
declare module '@sage/x3-project-management-data/lib/enums/copy-budget-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CopyBudgetStatusEnum {
	    allBudgets = 1,
	    notOpened = 2,
	    open = 3,
	    delivered = 4,
	    closed = 5,
	    suspended = 6
	}
	export interface CopyBudgetStatus$EnumInterface {
	    allBudgets: 1;
	    notOpened: 2;
	    open: 3;
	    delivered: 4;
	    closed: 5;
	    suspended: 6;
	}
	export type CopyBudgetStatus = keyof CopyBudgetStatus$EnumInterface;
	export const copyBudgetStatusDatatype: X3EnumDataType<keyof CopyBudgetStatus$EnumInterface, unknown>;
	//# sourceMappingURL=copy-budget-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/consumption-mode.d.ts
declare module '@sage/x3-project-management-data/lib/enums/consumption-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConsumptionModeEnum {
	    directDelivery = 1,
	    salesOrder = 2
	}
	export interface ConsumptionMode$EnumInterface {
	    directDelivery: 1;
	    salesOrder: 2;
	}
	export type ConsumptionMode = keyof ConsumptionMode$EnumInterface;
	export const consumptionModeDatatype: X3EnumDataType<keyof ConsumptionMode$EnumInterface, unknown>;
	//# sourceMappingURL=consumption-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/constraint-type.d.ts
declare module '@sage/x3-project-management-data/lib/enums/constraint-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConstraintTypeEnum {
	    flexible = 1,
	    strict = 2
	}
	export interface ConstraintType$EnumInterface {
	    flexible: 1;
	    strict: 2;
	}
	export type ConstraintType = keyof ConstraintType$EnumInterface;
	export const constraintTypeDatatype: X3EnumDataType<keyof ConstraintType$EnumInterface, unknown>;
	//# sourceMappingURL=constraint-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/closing-with-authorized-credit.d.ts
declare module '@sage/x3-project-management-data/lib/enums/closing-with-authorized-credit' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ClosingWithAuthorizedCreditEnum {
	    notAuthorized = 1,
	    authorized = 2
	}
	export interface ClosingWithAuthorizedCredit$EnumInterface {
	    notAuthorized: 1;
	    authorized: 2;
	}
	export type ClosingWithAuthorizedCredit = keyof ClosingWithAuthorizedCredit$EnumInterface;
	export const closingWithAuthorizedCreditDatatype: X3EnumDataType<keyof ClosingWithAuthorizedCredit$EnumInterface, unknown>;
	//# sourceMappingURL=closing-with-authorized-credit.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/calculation-method-used.d.ts
declare module '@sage/x3-project-management-data/lib/enums/calculation-method-used' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalculationMethodUsedEnum {
	    notCalculated = 1,
	    manual = 2,
	    revRecSnapshot = 3
	}
	export interface CalculationMethodUsed$EnumInterface {
	    notCalculated: 1;
	    manual: 2;
	    revRecSnapshot: 3;
	}
	export type CalculationMethodUsed = keyof CalculationMethodUsed$EnumInterface;
	export const calculationMethodUsedDatatype: X3EnumDataType<keyof CalculationMethodUsed$EnumInterface, unknown>;
	//# sourceMappingURL=calculation-method-used.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/budget-method.d.ts
declare module '@sage/x3-project-management-data/lib/enums/budget-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetMethodEnum {
	    notApplicable = 1,
	    standardCost = 2,
	    revisedStandard = 3,
	    budgetCost = 4,
	    simulatedCost = 5
	}
	export interface BudgetMethod$EnumInterface {
	    notApplicable: 1;
	    standardCost: 2;
	    revisedStandard: 3;
	    budgetCost: 4;
	    simulatedCost: 5;
	}
	export type BudgetMethod = keyof BudgetMethod$EnumInterface;
	export const budgetMethodDatatype: X3EnumDataType<keyof BudgetMethod$EnumInterface, unknown>;
	//# sourceMappingURL=budget-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/budget-line-origin.d.ts
declare module '@sage/x3-project-management-data/lib/enums/budget-line-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetLineOriginEnum {
	    manual = 1,
	    operations = 2,
	    productRequirements = 3,
	    budgetLines = 4,
	    project = 5,
	    operationsAndProductRequirements = 6
	}
	export interface BudgetLineOrigin$EnumInterface {
	    manual: 1;
	    operations: 2;
	    productRequirements: 3;
	    budgetLines: 4;
	    project: 5;
	    operationsAndProductRequirements: 6;
	}
	export type BudgetLineOrigin = keyof BudgetLineOrigin$EnumInterface;
	export const budgetLineOriginDatatype: X3EnumDataType<keyof BudgetLineOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=budget-line-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/budget-event.d.ts
declare module '@sage/x3-project-management-data/lib/enums/budget-event' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetEventEnum {
	    deliver = 1,
	    close = 2,
	    suspend = 3,
	    reactivate = 4
	}
	export interface BudgetEvent$EnumInterface {
	    deliver: 1;
	    close: 2;
	    suspend: 3;
	    reactivate: 4;
	}
	export type BudgetEvent = keyof BudgetEvent$EnumInterface;
	export const budgetEventDatatype: X3EnumDataType<keyof BudgetEvent$EnumInterface, unknown>;
	//# sourceMappingURL=budget-event.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/billing-mode.d.ts
declare module '@sage/x3-project-management-data/lib/enums/billing-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BillingModeEnum {
	    none = 1,
	    progressBilling = 2,
	    timeBilling = 3
	}
	export interface BillingMode$EnumInterface {
	    none: 1;
	    progressBilling: 2;
	    timeBilling: 3;
	}
	export type BillingMode = keyof BillingMode$EnumInterface;
	export const billingModeDatatype: X3EnumDataType<keyof BillingMode$EnumInterface, unknown>;
	//# sourceMappingURL=billing-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/bdgt-auto-processing-options.d.ts
declare module '@sage/x3-project-management-data/lib/enums/bdgt-auto-processing-options' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BdgtAutoProcessingOptionsEnum {
	    includeAllSubBudgets = 1,
	    useTaskProducts = 2,
	    useTaskOperations = 3,
	    overwriteExistingBudgetLines = 4,
	    writeLogFile = 5,
	    deleteAllExistingLines = 6
	}
	export interface BdgtAutoProcessingOptions$EnumInterface {
	    includeAllSubBudgets: 1;
	    useTaskProducts: 2;
	    useTaskOperations: 3;
	    overwriteExistingBudgetLines: 4;
	    writeLogFile: 5;
	    deleteAllExistingLines: 6;
	}
	export type BdgtAutoProcessingOptions = keyof BdgtAutoProcessingOptions$EnumInterface;
	export const bdgtAutoProcessingOptionsDatatype: X3EnumDataType<keyof BdgtAutoProcessingOptions$EnumInterface, unknown>;
	//# sourceMappingURL=bdgt-auto-processing-options.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/assignment-split-details.d.ts
declare module '@sage/x3-project-management-data/lib/enums/assignment-split-details' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssignmentSplitDetailsEnum {
	    notCalculated = 1,
	    limitedToSelectedPeriod = 2,
	    fullAssignmentPeriod = 3
	}
	export interface AssignmentSplitDetails$EnumInterface {
	    notCalculated: 1;
	    limitedToSelectedPeriod: 2;
	    fullAssignmentPeriod: 3;
	}
	export type AssignmentSplitDetails = keyof AssignmentSplitDetails$EnumInterface;
	export const assignmentSplitDetailsDatatype: X3EnumDataType<keyof AssignmentSplitDetails$EnumInterface, unknown>;
	//# sourceMappingURL=assignment-split-details.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/assignment-details.d.ts
declare module '@sage/x3-project-management-data/lib/enums/assignment-details' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssignmentDetailsEnum {
	    notCalculated = 1,
	    calculated = 2
	}
	export interface AssignmentDetails$EnumInterface {
	    notCalculated: 1;
	    calculated: 2;
	}
	export type AssignmentDetails = keyof AssignmentDetails$EnumInterface;
	export const assignmentDetailsDatatype: X3EnumDataType<keyof AssignmentDetails$EnumInterface, unknown>;
	//# sourceMappingURL=assignment-details.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/aggregate.d.ts
declare module '@sage/x3-project-management-data/lib/enums/aggregate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AggregateEnum {
	    company = 1,
	    site = 2,
	    role = 3,
	    employee = 4
	}
	export interface Aggregate$EnumInterface {
	    company: 1;
	    site: 2;
	    role: 3;
	    employee: 4;
	}
	export type Aggregate = keyof Aggregate$EnumInterface;
	export const aggregateDatatype: X3EnumDataType<keyof Aggregate$EnumInterface, unknown>;
	//# sourceMappingURL=aggregate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/adjusted-value.d.ts
declare module '@sage/x3-project-management-data/lib/enums/adjusted-value' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AdjustedValueEnum {
	    none = 1,
	    billedProgress = 2,
	    billedQuantity = 3,
	    billedAmount = 4
	}
	export interface AdjustedValue$EnumInterface {
	    none: 1;
	    billedProgress: 2;
	    billedQuantity: 3;
	    billedAmount: 4;
	}
	export type AdjustedValue = keyof AdjustedValue$EnumInterface;
	export const adjustedValueDatatype: X3EnumDataType<keyof AdjustedValue$EnumInterface, unknown>;
	//# sourceMappingURL=adjusted-value.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-project-management-data/build/lib/enums/action-2068.d.ts
declare module '@sage/x3-project-management-data/lib/enums/action-2068' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Action2068Enum {
	    always = 1,
	    confirmation = 2
	}
	export interface Action2068$EnumInterface {
	    always: 1;
	    confirmation: 2;
	}
	export type Action2068 = keyof Action2068$EnumInterface;
	export const action2068Datatype: X3EnumDataType<keyof Action2068$EnumInterface, unknown>;
	//# sourceMappingURL=action-2068.d.ts.map
}
declare module '@sage/x3-project-management-data' {
	export * from '@sage/x3-project-management-data/index';
}
