"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tree = void 0;
const checkbox_1 = require("carbon-react/esm/components/checkbox");
const icon_1 = __importDefault(require("carbon-react/esm/components/icon"));
const icon_button_1 = __importDefault(require("carbon-react/esm/components/icon-button"));
const React = __importStar(require("react"));
const tokens = __importStar(require("@sage/design-tokens/js/base/common"));
const lodash_1 = require("lodash");
const link_1 = __importDefault(require("carbon-react/esm/components/link"));
const loader_1 = __importDefault(require("carbon-react/esm/components/loader"));
const computeUnderlinedContent = (label, searchText) => {
    if (!searchText) {
        return [label];
    }
    const regex = new RegExp(`(${searchText})`, 'gi');
    const parts = label.split(regex);
    const underlinedLabel = [];
    for (let i = 0; i < parts.length; i += 1) {
        const part = parts[i];
        if (part.toLowerCase() === searchText.toLowerCase()) {
            underlinedLabel.push(React.createElement("span", { key: i, className: "e-tree-view-underlined" }, part));
        }
        else {
            underlinedLabel.push(part);
        }
    }
    return underlinedLabel;
};
exports.Tree = React.memo(({ checkedItems, element, fetchItems, isDisabled, isReadOnly, level, listOpenedItems, localize, onCheckedItemsUpdated, onCloseChild, onOpenChild, selectionMode = 'multiple', searchText = '', isFolderIconHidden = false, onClose, }) => {
    const bodyRef = React.useRef(null);
    const [listItems, setListItems] = React.useState(null);
    const [isOpen, setOpen] = React.useState(() => {
        if (level === 0) {
            return true;
        }
        if (listOpenedItems && element.key in listOpenedItems) {
            return true;
        }
        return false;
    });
    const onTopTreeKeyDown = React.useCallback((ev) => {
        if (ev.key === 'Tab' && onClose) {
            onClose();
            return;
        }
        const bodyElement = bodyRef.current;
        if (!bodyElement) {
            return;
        }
        const activeElement = document.activeElement;
        if (!activeElement) {
            return;
        }
        const buttons = bodyElement.querySelectorAll('button');
        const currentIndex = Array.from(buttons).indexOf(activeElement);
        if (ev.key === 'ArrowDown' && currentIndex !== -1) {
            buttons.item(currentIndex + 1)?.focus();
            ev.preventDefault();
            return;
        }
        if (ev.key === 'ArrowUp' && currentIndex === 0) {
            onClose?.();
            return;
        }
        if (ev.key === 'ArrowUp' && currentIndex !== -1) {
            buttons.item(currentIndex - 1)?.focus();
            ev.preventDefault();
        }
    }, [onClose]);
    const onOpen = React.useCallback((ev) => {
        ev.preventDefault();
        setOpen(!isOpen);
        if (isOpen && onCloseChild) {
            onCloseChild(element.key);
        }
    }, [element.key, isOpen, onCloseChild]);
    const previousListItemsRef = React.useRef(listItems);
    React.useEffect(() => {
        if (isOpen) {
            fetchItems(element).then(elements => {
                const sortedElements = [...elements];
                sortedElements.sort((a, b) => a.label.localeCompare(b.label));
                setListItems(sortedElements);
            });
        }
    }, [isOpen, element, fetchItems]);
    React.useEffect(() => {
        if (level !== 0 && onOpenChild && listItems && listItems !== previousListItemsRef.current) {
            onOpenChild(element.key, listItems.map(item => item.label));
        }
        previousListItemsRef.current = listItems;
    }, [listItems, level, onOpenChild, element.key]);
    function findValuesByPartialPath(obj, partialPath) {
        return (0, lodash_1.flatMap)((0, lodash_1.filter)(obj, (_value, key) => (0, lodash_1.includes)(key, partialPath)));
    }
    const findSearchText = React.useCallback((item) => {
        const result = findValuesByPartialPath(listOpenedItems, item.key);
        return (item.label.toLowerCase().includes(searchText.toLowerCase()) ||
            result.findIndex(ele => ele.toLowerCase().includes(searchText.toLowerCase())) !== -1);
    }, [listOpenedItems, searchText]);
    const renderBody = React.useCallback(() => {
        const ulProps = {
            className: `e-tree-view-element-body e-tree-view-element-body-level-${level}`,
            ref: bodyRef,
        };
        if (level === 0) {
            ulProps.role = 'tree';
            ulProps['aria-multiselectable'] = selectionMode === 'multiple';
            ulProps.onKeyDown = onTopTreeKeyDown;
        }
        return (React.createElement("ul", { ...ulProps }, listItems
            ?.filter(item => findSearchText(item))
            .map(childElement => (React.createElement(exports.Tree, { checkedItems: checkedItems, element: childElement, fetchItems: fetchItems, isDisabled: isDisabled, isReadOnly: isReadOnly, isFolderIconHidden: isFolderIconHidden, key: childElement.key, level: level + 1, listOpenedItems: listOpenedItems, localize: localize, onCheckedItemsUpdated: onCheckedItemsUpdated, onCloseChild: onCloseChild, onOpenChild: onOpenChild, searchText: searchText, selectionMode: selectionMode })))));
    }, [
        level,
        listItems,
        selectionMode,
        onTopTreeKeyDown,
        findSearchText,
        checkedItems,
        fetchItems,
        isDisabled,
        isReadOnly,
        isFolderIconHidden,
        listOpenedItems,
        localize,
        onCheckedItemsUpdated,
        onCloseChild,
        onOpenChild,
        searchText,
    ]);
    const onChecked = React.useCallback((ev) => {
        const newCheckedItems = { ...(checkedItems || {}) };
        if (ev.target.checked) {
            newCheckedItems[element.key] = {
                label: element.label,
                data: element.data,
                id: element.key,
                key: element.key,
                labelKey: element.labelKey,
                labelPath: element.labelPath,
            };
        }
        else {
            delete newCheckedItems[element.key];
        }
        if (onCheckedItemsUpdated) {
            onCheckedItemsUpdated(newCheckedItems);
        }
    }, [checkedItems, element, onCheckedItemsUpdated]);
    const onButtonClick = React.useCallback(() => {
        const newCheckedItems = {};
        newCheckedItems[element.key] = {
            label: element.label,
            data: element.data,
            id: element.key,
            key: element.key,
            labelKey: element.labelKey,
            labelPath: element.labelPath,
        };
        if (onCheckedItemsUpdated) {
            onCheckedItemsUpdated(newCheckedItems);
        }
    }, [element, onCheckedItemsUpdated]);
    if (level === 0) {
        return renderBody();
    }
    const indentations = [];
    for (let i = 1; i < level; i += 1) {
        indentations.push(React.createElement("span", { key: i, className: `e-tree-view-element-tree-branch e-tree-view-element-tree-branch-level-${i}` }));
    }
    const isChecked = !!checkedItems[element.key];
    return (React.createElement("li", { className: `e-tree-view-element e-tree-view-element-level-${level} ${isChecked ? ' checked' : ''}`, role: "treeitem", "aria-selected": isChecked, "aria-expanded": element.canBeExpanded ? (isOpen ? 'true' : 'false') : undefined },
        React.createElement("div", { className: `e-tree-view-element-container e-tree-view-element-container-${selectionMode}` },
            indentations.length > 0 && React.createElement("span", { className: "e-tree-view-indent-container" }, indentations),
            level > 1 && React.createElement("span", { className: "e-tree-view-line" }),
            element.canBeSelected && !isReadOnly && selectionMode !== 'button' && (React.createElement("div", { className: "e-tree-view-checkbox-container" }, selectionMode === 'multiple' && (React.createElement(checkbox_1.Checkbox, { "aria-label": element.label, checked: !!checkedItems[element.key], "data-testid": `e-tree-view-checkbox e-tree-view-checkbox-label-${(0, lodash_1.camelCase)(element.label)}`, disabled: isDisabled, mb: "0px", onChange: onChecked })))),
            element.canBeSelected && isReadOnly && (React.createElement(icon_1.default, { className: "e-tree-view-switcher-icon", type: checkedItems[element.key] ? 'tick' : 'cross', color: tokens.colorsYin090 })),
            element.canBeExpanded && (React.createElement("div", { className: "e-tree-view-element-node-container" },
                React.createElement("span", { className: `e-tree-view-switcher-container${isOpen ? ' e-tree-view-switcher-container-open' : ''}${isFolderIconHidden ? ' e-tree-view-switcher-container-hidden-folder' : ''}` },
                    React.createElement(icon_button_1.default, { "data-testid": `e-tree-view-switcher-icon-container e-tree-view-switcher-label-${(0, lodash_1.camelCase)(element.label)}`, onClick: onOpen, disabled: isDisabled },
                        React.createElement(React.Fragment, null,
                            React.createElement(icon_1.default, { className: "e-tree-view-switcher-icon", type: !isOpen ? 'plus' : 'minus', color: tokens.colorsActionMinor400 }),
                            React.createElement("span", { className: "e-tree-view-switcher-label e-screen-reader-only" }, isOpen
                                ? localize('@sage/xtrem-ui-components/collapse', 'Collapse')
                                : localize('@sage/xtrem-ui-components/expand', 'Expand'))))),
                !isFolderIconHidden && React.createElement(icon_1.default, { type: "folder", className: "e-tree-view-element-icon" }),
                (!element.canBeSelected || selectionMode !== 'button') && (React.createElement("label", null, computeUnderlinedContent(element.label, searchText))),
                selectionMode === 'button' && element.canBeSelected && (React.createElement(link_1.default, { "data-testid": `e-tree-view-checkbox e-tree-view-checkbox-label-${(0, lodash_1.camelCase)(element.label)}`, onClick: onButtonClick, disabled: isDisabled, iconAlign: "left", variant: "neutral" }, computeUnderlinedContent(element.label, searchText))))),
            !element.canBeExpanded && (React.createElement("div", { className: "e-tree-view-icon-container", "data-testid": `e-tree-view-container-label-${(0, lodash_1.camelCase)(element.label)}` },
                selectionMode === 'button' && (React.createElement(link_1.default, { "data-testid": `e-tree-view-checkbox e-tree-view-checkbox-label-${(0, lodash_1.camelCase)(element.label)}`, onClick: onButtonClick, disabled: isDisabled, icon: element.data.iconType || 'file_generic', iconAlign: "left", variant: "neutral" }, computeUnderlinedContent(element.label, searchText))),
                selectionMode !== 'button' && (React.createElement(React.Fragment, null,
                    React.createElement(icon_1.default, { type: element.data.iconType || 'file_generic', className: "e-tree-view-element-icon" }),
                    React.createElement("label", null, computeUnderlinedContent(element.label, searchText))))))),
        isOpen && listItems !== null && renderBody(),
        isOpen && listItems === null && React.createElement(loader_1.default, { size: "small" })));
});
exports.Tree.displayName = 'Tree';
//# sourceMappingURL=tree.js.map