import * as React from 'react';
import type { Order, RowDataType, TableCols } from './sort-condition-editor-types';
import type { LocalizeFunction, TreeElement } from '@sage/xtrem-shared';
import type { FlatTableProps } from '../flat-table/flat-table-types';
export interface OrderCellRendererProps<ListPropertyItem extends TreeElement> {
    localize: LocalizeFunction;
    orderByTranslations: Record<Order, string>;
    onCellChange: <P extends FlatTableProps<TableCols<ListPropertyItem>>['columns'][number]['id']>(args: {
        columnId: P;
        rowId: string;
        value: FlatTableProps<TableCols<ListPropertyItem>>['data'][number][P];
    }) => void;
    rowData: RowDataType<ListPropertyItem>;
}
export declare function OrderCellRenderer<ListPropertyItem extends TreeElement>({ rowData, localize, orderByTranslations, onCellChange, }: OrderCellRendererProps<ListPropertyItem>): React.ReactElement;
//# sourceMappingURL=order-cell-renderer.d.ts.map