"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextValueInput = void 0;
const textbox_1 = __importDefault(require("carbon-react/esm/components/textbox"));
const react_1 = __importDefault(require("react"));
function TextValueInput({ errors, isDisabled, localize, onCellChange, rowData, columnId, 'data-testid': dataTestId = 'e-widget-editor-filter-value', }) {
    return (react_1.default.createElement(textbox_1.default, { error: errors?.[rowData._id]?.[columnId], tooltipPosition: "top", disabled: isDisabled, "data-testid": `${dataTestId}-${rowData._id}`, onChange: ({ target: { value } }) => {
            onCellChange({
                columnId,
                rowId: rowData._id,
                value,
                rowData,
            });
        }, placeholder: localize('@sage/xtrem-ui-components/filter-value', 'Filter value'), size: "small", value: rowData[columnId] ?? '' }));
}
exports.TextValueInput = TextValueInput;
//# sourceMappingURL=text-value-input.js.map