"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnumValueInput = void 0;
const react_1 = __importDefault(require("react"));
const select_1 = require("carbon-react/esm/components/select");
function EnumValueInput({ isDisabled, onCellChange, rowData, localizeEnumMember, localize, columnId, enumType, enumOptions, 'data-testid': dataTestId = 'e-widget-editor-filter-value', }) {
    if (!enumType) {
        return null;
    }
    const localizedOptions = enumOptions.reduce((value, key) => {
        value[key] = localizeEnumMember(enumType, key);
        return value;
    }, {});
    return (react_1.default.createElement(select_1.MultiSelect, { disabled: isDisabled, openOnFocus: true, "data-testid": `${dataTestId}-${rowData._id}`, onChange: ({ target: { value } }) => {
            onCellChange({
                columnId,
                rowId: rowData._id,
                value,
                rowData,
            });
        }, placeholder: localize('@sage/xtrem-ui-components/select-filter-value-enum', 'Select value...'), size: "small", value: rowData[columnId] ?? [] }, Object.keys(localizedOptions).map(option => {
        return react_1.default.createElement(select_1.Option, { key: option, text: localizedOptions[option], value: option });
    })));
}
exports.EnumValueInput = EnumValueInput;
//# sourceMappingURL=enum-value-input.js.map