"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BooleanValueInput = void 0;
const react_1 = __importDefault(require("react"));
const select_1 = require("carbon-react/esm/components/select");
function BooleanValueInput({ isDisabled, localize, onCellChange, rowData, columnId, 'data-testid': dataTestId = 'e-widget-editor-filter-value', }) {
    return (react_1.default.createElement(select_1.FilterableSelect, { disabled: isDisabled, openOnFocus: true, "data-testid": `${dataTestId}-${rowData._id}`, onChange: ({ target: { value } }) => {
            onCellChange({
                columnId,
                rowId: rowData._id,
                value: value,
                rowData,
            });
        }, placeholder: localize('@sage/xtrem-ui-components/select-filter-value-boolean', 'Select value...'), size: "small", value: String(rowData[columnId] ?? '') },
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/true', 'True'), value: "true" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/false', 'False'), value: "false" })));
}
exports.BooleanValueInput = BooleanValueInput;
//# sourceMappingURL=boolean-value-input.js.map