"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SelectionCard = void 0;
const React = __importStar(require("react"));
const icon_1 = __importDefault(require("carbon-react/esm/components/icon"));
exports.SelectionCard = React.memo(React.forwardRef(({ _id, title, description = '', icon, onClick, isSelected = false, isReadOnly = false }, ref) => {
    const onCardClick = React.useCallback((ev) => {
        ev.preventDefault();
        onClick();
    }, [onClick]);
    const baseClassName = isSelected ? 'e-selection-card e-selection-card-selected' : 'e-selection-card';
    const renderImage = () => icon ? React.createElement("img", { "data-testid": "e-selection-card-image", src: icon, alt: title }) : null;
    return (React.createElement("button", { ref: ref, type: "button", "data-testid": `e-selection-card-${_id}`, className: baseClassName, onClick: onCardClick, "aria-label": title, disabled: isReadOnly },
        React.createElement("div", { "data-testid": "e-selection-card-image", className: "e-selection-card-image" }, isSelected ? (React.createElement(icon_1.default, { "data-testid": "e-selection-card-image-selected", fontSize: "large", type: "tick_circle", color: "--colorsSemanticPositive500" })) : (renderImage())),
        React.createElement("div", { "data-testid": "e-selection-card-content", className: "e-selection-card-content" },
            React.createElement("div", { "data-testid": "e-selection-card-title", className: "e-selection-card-title" }, title),
            React.createElement("div", { "data-testid": "e-selection-card-description", className: "e-selection-card-description" }, description))));
}));
exports.SelectionCard.displayName = 'SelectionCard';
//# sourceMappingURL=selection-card.js.map