"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterTableComponent = exports.useFilterTable = void 0;
/* eslint-disable react/no-unstable-nested-components */
const react_1 = __importDefault(require("react"));
const filter_table_utils_1 = require("./filter-table-utils");
const filter_table_property_column_1 = require("./filter-table-property-column");
const filter_table_type_column_1 = require("./filter-table-type-column");
const filter_table_value_column_1 = require("./filter-table-value-column");
const filter_table_parameter_column_1 = require("./filter-table-parameter-column");
const flat_table_1 = require("../flat-table/flat-table");
const lodash_1 = require("lodash");
const use_previous_1 = require("../hooks/use-previous");
const hooks_1 = require("../hooks");
function useFilterTable({ carbonLocale, isDisabled, locale, localize, localizeEnumMember, node, nodeNames, onChange, parameterMode, parameters = [], selectedProperties, value = [], automaticColumnsSpacing = false, }) {
    const previousValue = (0, use_previous_1.usePrevious)(value);
    const filterableProperties = react_1.default.useMemo(() => Object.values(selectedProperties ?? {}).filter(p => p.data?.canFilter), [selectedProperties]);
    const onCellChange = react_1.default.useCallback(changes => {
        dispatch({ type: 'CELL_CHANGED', changes, selectedProperties: selectedProperties ?? {} });
    }, [selectedProperties]);
    const onRowAdded = react_1.default.useCallback(() => {
        dispatch({ type: 'ROW_ADDED' });
    }, []);
    const onRowRemoved = react_1.default.useCallback((row) => {
        dispatch({ type: 'ROW_REMOVED', row });
    }, []);
    const columnProperty = react_1.default.useMemo(() => ({
        id: 'property',
        header: {
            name: localize('@sage/xtrem-ui-components/property', 'Property'),
            width: automaticColumnsSpacing ? undefined : 200,
        },
        cellRenderer: ({ rowData }) => (react_1.default.createElement(filter_table_property_column_1.FilterTablePropertyColumn, { filterableProperties: filterableProperties, isDisabled: isDisabled, localize: localize, node: node, nodeNames: nodeNames, onCellChange: onCellChange, rowData: rowData })),
    }), [filterableProperties, localize, node, nodeNames, onCellChange, isDisabled, automaticColumnsSpacing]);
    const columnFilterType = react_1.default.useMemo(() => ({
        id: 'filterType',
        header: {
            name: localize('@sage/xtrem-ui-components/filter-type', 'Filter type'),
            width: automaticColumnsSpacing ? undefined : 200,
        },
        cellRenderer: ({ rowData }) => (react_1.default.createElement(filter_table_type_column_1.FilterTableTypeColumnMemo, { isDisabled: isDisabled, localize: localize, onCellChange: onCellChange, rowData: rowData })),
    }), [localize, onCellChange, isDisabled, automaticColumnsSpacing]);
    const columnFilterValue = react_1.default.useMemo(() => ({
        id: 'filterValue',
        header: {
            name: localize('@sage/xtrem-ui-components/filter-value', 'Filter value'),
            width: automaticColumnsSpacing ? undefined : 300,
        },
        cellRenderer: ({ rowData, extraData: errors }) => (react_1.default.createElement(filter_table_value_column_1.FilterTableValueColumnMemo, { carbonLocale: carbonLocale, errors: errors, isDisabled: isDisabled, locale: locale, localize: localize, localizeEnumMember: localizeEnumMember, node: node, onCellChange: onCellChange, parameterMode: parameterMode, parameters: parameters, rowData: rowData })),
    }), [
        localize,
        automaticColumnsSpacing,
        node,
        carbonLocale,
        locale,
        onCellChange,
        localizeEnumMember,
        parameters,
        parameterMode,
        isDisabled,
    ]);
    const columnShouldUseParameter = react_1.default.useMemo(() => ({
        id: 'parameter',
        header: {
            name: localize('@sage/xtrem-ui-components/filter-use-parameter', 'Use parameter'),
            width: 125,
        },
        cellRenderer: ({ rowData }) => (react_1.default.createElement(filter_table_parameter_column_1.FilterTableParameterColumnMemo, { isDisabled: isDisabled, rowData: rowData, onCellChange: onCellChange })),
    }), [onCellChange, isDisabled, localize]);
    const columns = react_1.default.useMemo(() => {
        return [
            columnProperty,
            columnFilterType,
            ...(parameterMode === 'creation' || parameterMode === 'usage' || parameters.length > 0
                ? [columnShouldUseParameter]
                : []),
            columnFilterValue,
            { id: 'path', isHidden: true, header: { name: 'Path' } },
            { id: 'labelPath', isHidden: true, header: { name: 'Label path' } },
            { id: 'key', isHidden: true, header: { name: 'Key' } },
            { id: 'labelKey', isHidden: true, header: { name: 'Label key' } },
        ];
    }, [
        columnProperty,
        columnFilterType,
        parameterMode,
        parameters.length,
        columnShouldUseParameter,
        columnFilterValue,
    ]);
    const onRowDrag = react_1.default.useCallback(ids => {
        dispatch({ type: 'ROW_DRAGGED', ids });
    }, []);
    const addButtonText = react_1.default.useMemo(() => localize('@sage/xtrem-ui-components/add-filter', 'Add filter'), [localize]);
    const data = react_1.default.useMemo(() => {
        return (0, filter_table_utils_1.mapFilterToEditorRow)({ value, selectedProperties });
    }, [value, selectedProperties]);
    const [tableDefinition, dispatch] = react_1.default.useReducer((0, filter_table_utils_1.filterTableReducer)()(localize), {
        addButtonText,
        canAddNewLines: true,
        canDrag: false,
        columns,
        counter: value.length,
        data,
        onRowAdded,
        onRowDrag,
        onRowRemoved,
        parameterMode,
        validations: {},
    });
    (0, hooks_1.useDeepCompareEffect)(() => {
        dispatch({ type: 'COLUMNS_CHANGED', columns });
    }, [selectedProperties, dispatch]);
    react_1.default.useEffect(() => {
        onChange(tableDefinition.data
            .filter(row => (0, filter_table_utils_1.isCompleteRow)(row, tableDefinition.validations, parameterMode))
            .map(({ property, filterType, filterValue, path, labelPath, key, labelKey, parameter, ...rest }) => {
            return {
                // spread needed in case columns are extended
                ...rest,
                label: property.label,
                filterType: filterType,
                filterValue,
                data: property.data,
                id: path,
                labelPath: labelPath,
                property,
                key,
                labelKey,
                parameter,
            };
        }));
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [tableDefinition.data, tableDefinition.parameterMode, tableDefinition.validations]);
    react_1.default.useEffect(() => {
        const newValue = (0, filter_table_utils_1.mapFilterToEditorRow)({ value, selectedProperties });
        if (!(0, lodash_1.isEqual)(previousValue, value) && !(0, lodash_1.isEqual)(newValue, tableDefinition.data)) {
            dispatch({ type: 'DATA_RESET', value, selectedProperties });
        }
    }, [value, selectedProperties, tableDefinition.data, previousValue]);
    return {
        ...tableDefinition,
        extraData: tableDefinition.validations,
        canRemoveLines: true,
        emptyStateText: filterableProperties.length === 0
            ? localize('@sage/xtrem-ui-components/widget-editor-no-filterable-properties', 'You cannot filter the current values. You can select different data or continue without filtering.')
            : undefined,
        actionsText: localize('@sage/xtrem-ui-components/actions', 'Actions'),
        isAddButtonHidden: filterableProperties.length === 0,
        onCellChange,
    };
}
exports.useFilterTable = useFilterTable;
function FilterTableComponent(props) {
    const { actionsText, addButtonText, canAddNewLines, canDrag, canRemoveLines, columns, data, emptyStateText, extraData, isAddButtonHidden, onRowAdded, onRowDrag, onRowRemoved, } = useFilterTable(props);
    return (react_1.default.createElement(flat_table_1.FlatTable, { actionsText: actionsText, addButtonText: addButtonText, canAddNewLines: !props.isDisabled && canAddNewLines, canDrag: canDrag, canRemoveLines: canRemoveLines, columns: columns, data: data, emptyStateText: emptyStateText, extraData: extraData, isAddButtonHidden: isAddButtonHidden, onRowAdded: onRowAdded, onRowDrag: onRowDrag, onRowRemoved: onRowRemoved }));
}
exports.FilterTableComponent = FilterTableComponent;
//# sourceMappingURL=filter-table.js.map