"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterTablePropertyColumn = void 0;
const react_1 = __importDefault(require("react"));
const property_table_header_1 = require("../property-template-header/property-table-header");
const select_1 = require("carbon-react/esm/components/select");
const lodash_1 = require("lodash");
const filter_table_utils_1 = require("./filter-table-utils");
const utils_1 = require("../utils");
function FilterTablePropertyColumn({ localize, onCellChange, rowData, filterableProperties, nodeNames, node, isDisabled, }) {
    return (react_1.default.createElement(select_1.FilterableSelect, { multiColumn: true, tableHeader: react_1.default.createElement(property_table_header_1.PropertyTableHeader, { localize: localize }), openOnFocus: true, disabled: isDisabled, "data-testid": `e-widget-editor-filter-property-${rowData._id}`, 
        // @ts-expect-error "onChange" is actually triggered with { target: { value: Property } }
        onChange: ({ target: { value } }) => {
            onCellChange({ columnId: 'property', rowId: rowData._id, value, rowData });
        }, placeholder: localize('@sage/xtrem-ui-components/select-property', 'Select property...'), size: "small", 
        // @ts-expect-error value is of type Property
        value: rowData.property ?? {} }, filterableProperties
        .filter(p => (p.data.type && (0, lodash_1.includes)(utils_1.filterableGraphqlTypes, p.data.type)) ||
        (p.data.kind &&
            (0, lodash_1.includes)(utils_1.filterableGraphqlTypes.map(type => type.toLowerCase()), p.data.kind.toLowerCase())))
        .map(p => {
        return (
        // @ts-expect-error value is of type Property
        react_1.default.createElement(select_1.OptionRow, { text: p.label, value: p, key: p.id },
            react_1.default.createElement("td", { width: "50%", style: {
                    overflow: 'hidden',
                    whiteSpace: 'pre-line',
                    maxWidth: 0,
                } }, p.label),
            react_1.default.createElement("td", { width: "50%", style: {
                    overflow: 'hidden',
                    whiteSpace: 'pre-line',
                    maxWidth: 0,
                    textAlign: 'end',
                } }, (0, filter_table_utils_1.getPropertyParentNode)({ nodeNames, labelPath: p.labelPath, node }))));
    })));
}
exports.FilterTablePropertyColumn = FilterTablePropertyColumn;
//# sourceMappingURL=filter-table-property-column.js.map