import React from 'react';
import type { ColDef, FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { Dict, LocalizeFunction } from '@sage/xtrem-shared';
import type { DefaultContentTableCols, OnCellChange } from './content-table-types';
import { FilterableSelect } from 'carbon-react/esm/components/select';
import type { DefaultPropertyType } from '../types';
export interface ContentTablePropertyColumnProps<Cols extends ColDef[] = [], P extends DefaultPropertyType = DefaultPropertyType, E = unknown> extends Partial<React.ComponentProps<typeof FilterableSelect>> {
    allData: FlatTableProps<UnrestrictedTableCols<DefaultContentTableCols, Cols>, E>['data'];
    isDisabled?: boolean;
    isPropertySelectionDisabled?: boolean;
    localize: LocalizeFunction;
    node?: string;
    nodeNames: Dict<string>;
    onCellChange: OnCellChange<Cols, E>;
    rowData: FlatTableProps<UnrestrictedTableCols<DefaultContentTableCols, Cols>, E>['data'][number];
    selectedProperties?: Dict<P>;
}
export declare function ContentTablePropertyColumn<Cols extends ColDef[] = [], P extends DefaultPropertyType = DefaultPropertyType, E = unknown>({ allData, isDisabled, isPropertySelectionDisabled, localize, node, nodeNames, onCellChange, rowData, selectedProperties, ...rest }: ContentTablePropertyColumnProps<Cols, P, E>): React.ReactElement;
//# sourceMappingURL=content-table-property-column.d.ts.map