"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValueTypeColumn = void 0;
const react_1 = __importDefault(require("react"));
const select_1 = require("carbon-react/esm/components/select");
const box_1 = __importDefault(require("carbon-react/esm/components/box"));
const typography_1 = __importDefault(require("carbon-react/esm/components/typography"));
function ValueTypeColumn({ isDisabled, onCellChange, rowData, localize, columnId, parameters, }) {
    const propertyLiteral = localize('@sage/xtrem-ui-components/condition-value-type-property', 'Property');
    const hasParameters = parameters && parameters.length > 0;
    const hasConstant = columnId === 'valueType2';
    if (!hasParameters && !hasConstant) {
        return (react_1.default.createElement("div", { className: "e-condition-table-value-type-column" },
            react_1.default.createElement("div", { "data-testid": `e-condition-table-${columnId}-column-${rowData._id}` },
                react_1.default.createElement(box_1.default, { display: "flex", alignItems: "center", justifyContent: "flex-start" },
                    react_1.default.createElement(typography_1.default, { variant: "p", m: 0, paddingLeft: "8px" }, propertyLiteral)))));
    }
    return (react_1.default.createElement("div", { className: "e-condition-table-value-type-column" },
        react_1.default.createElement(select_1.Select, { disabled: isDisabled, openOnFocus: true, "data-testid": `e-condition-table-${columnId}-column-${rowData._id}`, onChange: ({ target: { value } }) => {
                onCellChange({
                    columnId,
                    rowId: rowData._id,
                    value: value,
                    rowData,
                });
            }, size: "small", value: rowData[columnId] ?? '' },
            react_1.default.createElement(select_1.Option, { text: propertyLiteral, value: "property", key: "property" }),
            hasParameters && (react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/condition-value-type-parameter', 'Parameter'), value: "parameter", key: "parameter" })),
            hasConstant && (react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/condition-value-type-constant', 'Constant'), value: "constant", key: "constant" })))));
}
exports.ValueTypeColumn = ValueTypeColumn;
//# sourceMappingURL=value-type-column.js.map