import React from 'react';
import type { DefaultConditionEditorCols, OnCellChange } from './condition-editor-table-types';
import type { ColDef, FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { LocalizeFunction, NodeDetails } from '@sage/xtrem-shared';
export interface PropertyColumnProps<Cols extends ColDef[] = [], E = unknown> {
    'data-testid'?: string;
    columnId?: 'value1' | 'value2';
    fetchItems: (element: NodeDetails) => Promise<NodeDetails[]>;
    isDisabled?: boolean;
    localize: LocalizeFunction;
    node?: string;
    onCellChange: OnCellChange<Cols, E>;
    rowData: FlatTableProps<UnrestrictedTableCols<DefaultConditionEditorCols, Cols>, E>['data'][number];
}
export declare function PropertyColumn<Cols extends ColDef[] = [], E = unknown>({ 'data-testid': dataTestId, columnId, fetchItems, isDisabled, localize, node, onCellChange, rowData, }: PropertyColumnProps<Cols, E>): React.ReactElement;
//# sourceMappingURL=property-column.d.ts.map