"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperatorColumn = void 0;
const react_1 = __importDefault(require("react"));
const condition_editor_table_types_1 = require("./condition-editor-table-types");
const xtrem_shared_1 = require("@sage/xtrem-shared");
const select_1 = require("carbon-react/esm/components/select");
const lodash_1 = require("lodash");
const box_1 = __importDefault(require("carbon-react/esm/components/box"));
const typography_1 = __importDefault(require("carbon-react/esm/components/typography"));
function OperatorColumn({ isDisabled, localize, onCellChange, parameters, rowData, }) {
    const isParameter = rowData.valueType1 === 'parameter';
    // If the value is a parameter, the type is the type of the parameter
    const type = isParameter ? parameters?.find(p => p.name === rowData.value1)?.type : rowData.value1?.data?.type;
    // Parameters are always scalar types
    const kind = isParameter ? 'SCALAR' : rowData.value1?.data?.kind;
    let filterableValue = [];
    if (type !== undefined && xtrem_shared_1.filterGraphqlMapping[type] !== undefined) {
        filterableValue = xtrem_shared_1.filterGraphqlMapping[type];
    }
    else if (kind !== undefined) {
        const foundKey = Object.keys(xtrem_shared_1.filterGraphqlMapping).find(key => key.toLowerCase() === kind.toLowerCase());
        if (foundKey !== undefined) {
            filterableValue = xtrem_shared_1.filterGraphqlMapping[foundKey];
        }
    }
    filterableValue = (0, lodash_1.without)([...filterableValue, 'empty', 'notEmpty'], 'inRange');
    if (type &&
        (0, lodash_1.includes)([xtrem_shared_1.GraphQLTypes.Boolean, xtrem_shared_1.GraphQLTypes.ID, xtrem_shared_1.GraphQLTypes.IntOrString, xtrem_shared_1.GraphQLTypes.IntReference], type)) {
        return (react_1.default.createElement("div", { "data-testid": `e-widget-editor-filter-type-${rowData._id}` },
            react_1.default.createElement(box_1.default, { display: "flex", alignItems: "center", justifyContent: "flex-start" },
                react_1.default.createElement(typography_1.default, { variant: "p", m: 0, paddingLeft: "8px" }, localize('@sage/xtrem-ui-components/equals', 'Equals')))));
    }
    return (react_1.default.createElement(select_1.FilterableSelect, { disabled: !rowData.value1 || isDisabled, openOnFocus: true, "data-testid": `e-widget-editor-filter-type-${rowData._id}`, onChange: ({ target: { value } }) => {
            onCellChange({
                columnId: 'operator',
                rowId: rowData._id,
                value: value,
                rowData,
            });
        }, placeholder: localize('@sage/xtrem-ui-components/select-operator', 'Select operator...'), size: "small", value: rowData.operator ?? '' }, filterableValue?.map((filterType) => {
        return (react_1.default.createElement(select_1.Option, { text: (0, condition_editor_table_types_1.filterTranslations)(localize)[filterType] ?? '', value: filterType ?? '', key: filterType ?? '' }));
    })));
}
exports.OperatorColumn = OperatorColumn;
//# sourceMappingURL=operator-column.js.map