/**
 * This file contains types that are shared between the xtrem-ui, xtrem-ui-components and other front-end folder files.
 */
/// <reference types="lodash" />
import type { UnionToIntersection } from 'ts-essentials';
import { LocalizeFunction } from './locale';
export declare enum GraphQLTypes {
    Boolean = "Boolean",
    Date = "Date",
    DateTime = "DateTime",
    Decimal = "Decimal",
    Enum = "Enum",
    ExternalReference = "ExternalReference",// Non-vital references for ADC, same as IntReference
    Float = "Float",
    ID = "Id",// Yes, it is lowercase 'd'
    InputStream = "_InputStream",
    _InputTextStream = "_InputTextStream",
    _OutputTextStream = "_OutputTextStream",
    Int = "Int",
    IntOrString = "IntOrString",
    IntReference = "IntReference",// Non-vital references
    Json = "Json",
    String = "String"
}
export declare const textStreams: ReadonlyArray<GraphQLTypes>;
export type NodeTypeKind = 'LIST' | 'OBJECT' | 'SCALAR' | 'INPUT_OBJECT' | 'INTERFACE' | 'ENUM';
export interface NodeDetails {
    canFilter: boolean;
    canSort: boolean;
    enumValues?: string[];
    isCollection?: boolean;
    kind: NodeTypeKind;
    label: string;
    name: string;
    node?: string;
    isStored: boolean;
    isOnInputType: boolean;
    isOnOutputType: boolean;
    dataType: string;
    targetNode: string;
    enumType: string | null;
    isCustom: boolean;
    isMutable: boolean;
    type: keyof typeof GraphQLTypes | (string & Record<never, never>);
}
export declare const LESS_THAN = "lessThan";
export declare const LESS_THAN_EQUAL = "lessThanOrEqual";
export declare const RANGE = "inRange";
export declare const MULTIPLE_RANGE = "multipleRange";
export declare const GREATER_THAN = "greaterThan";
export declare const GREATER_THAN_EQUAL = "greaterThanOrEqual";
export declare const CONTAINS = "contains";
export declare const STARTS_WITH = "startsWith";
export declare const ENDS_WITH = "endsWith";
export declare const MATCHES = "matches";
export declare const EQUALS = "equals";
export declare const NOT_EQUALS = "notEqual";
export declare const MULTI_NOT_EQUALS = "multiNotEqual";
export declare const SET = "set";
export type UserCustomizableWidget = 'TABLE' | 'INDICATOR_TILE' | 'BAR_CHART' | 'LINE_CHART';
export declare const RANGE_DIVIDER = "~";
export declare const enumFilter: readonly ["set", "multiNotEqual"];
export declare const rangeFilter: readonly ["lessThan", "lessThanOrEqual", "equals", "notEqual", "greaterThan", "greaterThanOrEqual", "inRange"];
export declare const stringFilter: readonly ["contains", "startsWith", "equals", "notEqual", "endsWith", "matches", "set"];
export type StringFilter = (typeof stringFilter)[number];
export type MultipleRangeFilter = typeof MULTIPLE_RANGE;
export type RangeFilter = (typeof rangeFilter)[number];
export type EnumFilter = (typeof enumFilter)[number];
export type SetFilter = typeof SET;
export type BooleanFilter = typeof MATCHES;
export declare class EnumType {
    value: string;
}
export type FiltrableType = string | number | Date | boolean | EnumType;
export type FilterTypeValue = StringFilter | MultipleRangeFilter | BooleanFilter | SetFilter | RangeFilter | EnumFilter;
export type FilterType<T extends FiltrableType> = T extends string ? StringFilter | MultipleRangeFilter : T extends number | Date ? RangeFilter : T extends boolean ? BooleanFilter : T extends EnumType ? EnumFilter : never;
export interface TreeElement<T extends any = NodeDetails> {
    key: string;
    id: string;
    labelKey: string;
    labelPath: string;
    path?: string;
    label: string;
    canBeSelected?: boolean;
    canBeExpanded?: boolean;
    data: T;
    title?: string;
}
export type Property = TreeElement;
export type FilterProperty = Property & {
    filterType: FilterTypeValue | 'timeFrame';
    filterValue: any;
    parameter?: boolean;
};
export interface AggregationOptions {
    group: number;
    operation: Aggregations | 'NONE';
}
export type GroupProperty = Property & AggregationOptions;
export declare const filterGraphqlMapping: Record<keyof typeof GraphQLTypes, Readonly<FilterTypeValue[] | undefined>>;
export declare enum FieldKey {
    Aggregate = "Aggregate",
    Button = "Button",
    Calendar = "Calendar",
    Card = "Card",
    Chart = "Chart",
    Checkbox = "Checkbox",
    ContentTable = "ContentTable",
    Count = "Count",
    Date = "Date",
    DetailList = "DetailList",
    DropdownList = "DropdownList",
    DynamicPod = "DynamicPod",
    File = "File",
    FileDeposit = "FileDeposit",
    FilterEditor = "FilterEditor",
    FilterSelect = "FilterSelect",
    FormDesigner = "FormDesigner",
    Icon = "Icon",
    Image = "Image",
    Label = "Label",
    Link = "Link",
    Message = "Message",
    MultiDropdown = "MultiDropdown",
    MultiFileDeposit = "MultiFileDeposit",
    MultiReference = "MultiReference",
    NestedGrid = "NestedGrid",
    NodeBrowserTree = "NodeBrowserTree",
    Numeric = "Numeric",
    Plugin = "Plugin",
    Pod = "Pod",
    PodCollection = "PodCollection",
    Progress = "Progress",
    Radio = "Radio",
    Reference = "Reference",
    RelativeDate = "RelativeDate",
    RichText = "RichText",
    Select = "Select",
    SelectionCard = "SelectionCard",
    Separator = "Separator",
    StaticContent = "StaticContent",
    StepSequence = "StepSequence",
    Switch = "Switch",
    Table = "Table",
    TableSummary = "TableSummary",
    Technical = "Technical",
    Text = "Text",
    TextArea = "TextArea",
    Time = "Time",
    DatetimeRange = "DatetimeRange",
    Toggle = "ToggleButton",
    Tree = "Tree",
    VisualProcess = "VisualProcess",
    VitalPod = "VitalPod",
    Workflow = "Workflow"
}
export declare const numericFields: ("Boolean" | "Date" | "DateTime" | "Decimal" | "Enum" | "ExternalReference" | "Float" | "_InputTextStream" | "_OutputTextStream" | "Int" | "IntOrString" | "IntReference" | "Json" | "String" | "ID" | "InputStream")[];
export declare const presentationGraphqlMapping: {
    readonly Boolean: readonly [FieldKey.Checkbox];
    readonly Date: readonly [FieldKey.Date];
    readonly DateTime: readonly [FieldKey.Date];
    readonly Decimal: readonly [FieldKey.Numeric, FieldKey.Label, FieldKey.Text, FieldKey.Progress];
    readonly Enum: readonly [FieldKey.Text, FieldKey.Label];
    readonly ExternalReference: readonly [FieldKey.Text];
    readonly Float: readonly [FieldKey.Numeric, FieldKey.Label, FieldKey.Text, FieldKey.Progress];
    readonly ID: readonly [FieldKey.Text];
    readonly InputStream: readonly [FieldKey.Text];
    readonly _InputTextStream: readonly [FieldKey.Text];
    readonly _OutputTextStream: readonly [FieldKey.Text];
    readonly _InputStream: readonly [FieldKey.Text];
    readonly Int: readonly [FieldKey.Numeric, FieldKey.Label, FieldKey.Text, FieldKey.Progress];
    readonly IntOrString: readonly [FieldKey.Text];
    readonly Id: readonly [FieldKey.Text];
    readonly IntReference: readonly [FieldKey.Numeric, FieldKey.Label, FieldKey.Text, FieldKey.Progress];
    readonly Json: readonly [FieldKey.Text];
    readonly String: readonly [FieldKey.Text];
};
export declare const presentationEditorGraphqlMapping: {
    readonly Boolean: readonly [FieldKey.Checkbox];
    readonly Date: readonly [FieldKey.Date];
    readonly DateTime: readonly [FieldKey.Date];
    readonly Decimal: readonly [FieldKey.Numeric];
    readonly Enum: readonly [FieldKey.Text, FieldKey.Label];
    readonly ExternalReference: readonly [FieldKey.Text];
    readonly Float: readonly [FieldKey.Numeric];
    readonly ID: readonly [FieldKey.Text];
    readonly InputStream: readonly [FieldKey.Text];
    readonly _OutputTextStream: readonly [FieldKey.Text];
    readonly _InputTextStream: readonly [FieldKey.Text];
    readonly Int: readonly [FieldKey.Numeric];
    readonly IntOrString: readonly [FieldKey.Text];
    readonly Id: readonly [FieldKey.Text];
    readonly IntReference: readonly [FieldKey.Numeric];
    readonly Json: readonly [FieldKey.Text];
    readonly String: readonly [FieldKey.Text];
};
export type GridNestedFieldTypes = FieldKey.Aggregate | FieldKey.Checkbox | FieldKey.Count | FieldKey.Date | FieldKey.DropdownList | FieldKey.FilterSelect | FieldKey.Icon | FieldKey.Image | FieldKey.Label | FieldKey.Link | FieldKey.Numeric | FieldKey.Progress | FieldKey.Reference | FieldKey.RelativeDate | FieldKey.Select | FieldKey.Switch | FieldKey.Technical | FieldKey.Text;
export declare const ATTR_CONTEXT_OBJECT_TYPE = "data-context-object-type";
export declare const ATTR_CONTEXT_OBJECT_PATH = "data-context-object-path";
export declare const ATTR_CONTEXT_FILTER = "data-context-filter";
export declare const ATTR_CONTEXT_CONDITION = "data-context-condition";
export declare const ATTR_CONTEXT_LIST_ORDER = "data-context-list-order";
export declare const ATTR_PROPERTY_DISPLAY_LABEL = "data-property-display-label";
export declare const ATTR_PROPERTY_NAME = "data-property-name";
export declare const ATTR_PROPERTY_DATA_FORMAT = "data-property-data-format";
export declare const ATTR_PROPERTY_DATA_TYPE = "data-property-data-type";
export declare const ATTR_ALIAS = "data-alias";
export declare const ATTR_FOOTER_GROUP = "data-footer-group";
export declare const ATTR_QUERY_TABLE_HIDDEN_ROW = "data-hidden";
/** Used for ensuring integrity of the context and their children when the properties are dragged or copied */
export declare const ATTR_PROPERTY_PARENT_CONTEXT_TYPE = "data-property-parent-context";
export declare const RECORD_CONTEXT_CLASS = "record-context";
export declare const QUERY_TABLE_CLASS = "query-table";
export declare const PROPERTY_CLASS = "property";
export declare const BLOCK_AGGREGATION_PROPERTY_NAME = "_blockAggregatedData";
export declare const BLOCK_AGGREGATION_ROLLING_PROPERTY_NAME = "_blockAggregatedRollingData";
export declare const ATTR_BREAK_PAGE_AFTER = "data-break-page-after";
export declare const ATTR_CLASS = "class";
export declare enum Aggregations {
    min = "min",
    max = "max",
    sum = "sum",
    avg = "avg",
    distinctCount = "distinctCount"
}
export declare enum Sortings {
    ascending = "ascending",
    descending = "descending"
}
export type SortingOptions = Sortings;
export declare const SORTING_OPTIONS: Sortings[];
export declare const STRING_AGGREGATIONS: Aggregations[];
export declare const NUMBER_AGGREGATIONS: Aggregations[];
export declare const DATE_AGGREGATIONS: Aggregations[];
export declare const OTHER_AGGREGATIONS: Aggregations[];
export declare const aggregationsGraphqlMapping: Record<keyof typeof GraphQLTypes, Aggregations[] | undefined>;
export declare const sortingGraphqlMapping: Record<keyof typeof GraphQLTypes, Sortings[] | undefined>;
export declare const aggregationTranslations: ((localize: LocalizeFunction) => Record<Aggregations, string>) & import("lodash").MemoizedFunction;
export declare const sortingTranslations: ((localize: LocalizeFunction) => Record<Sortings, string>) & import("lodash").MemoizedFunction;
type UnionForAny<T> = T extends never ? 'A' : 'B';
export type IsStrictlyAny<T> = UnionToIntersection<UnionForAny<T>> extends never ? true : false;
export {};
//# sourceMappingURL=ui-shared-types.d.ts.map