"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setSqlRegistryHook = exports.registerSqlFunction = void 0;
/**
 * This file allows us to expose the registerSqlFunction function to client-side code that
 * does not have access to the xtrem-ts-to-sql package.
 *
 * We setup a dummy implementation of the registerSqlFunction function that will be replaced
 * when xtrem-core is imported.
 */
// eslint-disable-next-line @typescript-eslint/no-unused-vars
let sqlRegistryHook = (_fullName, _fn) => { };
/**
 * Registers a function to the TS to SQL converter.
 *
 * @param fullName - The full name of the SQL function.
 * @param fn - The function to be registered.
 * @returns The registered function.
 */
function registerSqlFunction(fullName, fn) {
    sqlRegistryHook(fullName, fn);
}
exports.registerSqlFunction = registerSqlFunction;
/**
 * Replaces the dummy implementation of registerSqlFunction with the real one.
 * @param hook
 */
function setSqlRegistryHook(hook) {
    sqlRegistryHook = hook;
}
exports.setSqlRegistryHook = setSqlRegistryHook;
//# sourceMappingURL=sql-registry-hook.js.map