"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDictionary = exports.createPlainObject = void 0;
/**
 * Creates an empty with a null prototype to prevent from prototype pollutions
 * @returns an empty object
 */
const createPlainObject = (source) => {
    const obj = Object.create(null);
    return source == null ? obj : Object.assign(obj, source);
};
exports.createPlainObject = createPlainObject;
/**
 * Creates a dictionary object safe to prototype pollutions
 * @returns an empty dictionary object
 */
const createDictionary = () => Object.create(null);
exports.createDictionary = createDictionary;
//# sourceMappingURL=secure-coding.js.map