"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.localeFallbacks = exports.supportedLocales = exports.locales = void 0;
exports.locales = [
    'en-US',
    'en-GB',
    'fr-FR',
    'es-ES',
    'pt-PT',
    'pt-BR',
    'ar-SA',
    'de-DE',
    'it-IT',
    'pl-PL',
    'zh-CN',
];
exports.supportedLocales = ['base', ...exports.locales];
const commonFallback = ['en-US', 'en-GB', 'base'];
exports.localeFallbacks = {
    'en-GB': ['en-GB', 'en-US', 'base'],
    'en-US': commonFallback,
    'fr-FR': ['fr-FR', ...commonFallback],
    'es-ES': ['es-ES', ...commonFallback],
    'de-DE': ['de-DE', ...commonFallback],
    'it-IT': ['it-IT', ...commonFallback],
    'ar-SA': ['ar-SA', ...commonFallback],
    'zh-CN': ['zh-CN', ...commonFallback],
    'pl-PL': ['pl-PL', ...commonFallback],
    'pt-PT': ['pt-PT', 'pt-BR', ...commonFallback],
    'pt-BR': ['pt-BR', 'pt-PT', ...commonFallback],
    base: ['base'],
};
//# sourceMappingURL=locale.js.map