// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/index.d.ts
declare module '@sage/x3-finance-data/index' {
	export * from '@sage/x3-finance-data/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/index.d.ts
declare module '@sage/x3-finance-data/lib/index' {
	export * as enums from '@sage/x3-finance-data/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-finance-data/lib/node-extensions/index';
	export * as nodes from '@sage/x3-finance-data/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-finance-data/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/service-options/index.d.ts
declare module '@sage/x3-finance-data/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/supplier-invoice-header-dimensions.d.ts
declare module '@sage/x3-finance-data/lib/nodes/supplier-invoice-header-dimensions' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class SupplierInvoiceHeaderDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=supplier-invoice-header-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/supplier-invoice-header-currency-rates.d.ts
declare module '@sage/x3-finance-data/lib/nodes/supplier-invoice-header-currency-rates' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class SupplierInvoiceHeaderCurrencyRates extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
	    readonly ledger: Reference<sageX3FinanceData.nodes.Ledger | null>;
	    readonly ledgerCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly multiplyingRate: Promise<decimal | null>;
	    readonly dividingRate: Promise<decimal | null>;
	}
	//# sourceMappingURL=supplier-invoice-header-currency-rates.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/stock-journal-import-dimensions.d.ts
declare module '@sage/x3-finance-data/lib/nodes/stock-journal-import-dimensions' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import { Node, integer, date, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class StockJournalImportDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly stockSite: Promise<string>;
	    readonly isUpdated: Promise<boolean>;
	    readonly product: Promise<string>;
	    readonly effectiveDate: Promise<date>;
	    readonly sequence: Promise<integer>;
	    readonly index: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3ManufacturingData.nodes.StockJournalImport>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=stock-journal-import-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/stock-journal-dimensions.d.ts
declare module '@sage/x3-finance-data/lib/nodes/stock-journal-dimensions' {
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, integer, date, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class StockJournalDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly stockSite: Promise<string>;
	    readonly isUpdated: Promise<boolean>;
	    readonly product: Promise<string>;
	    readonly effectiveDate: Promise<date>;
	    readonly sequence: Promise<integer>;
	    readonly index: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3StockData.nodes.StockJournal>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=stock-journal-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/revenue-recognition-rules.d.ts
declare module '@sage/x3-finance-data/lib/nodes/revenue-recognition-rules' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class RevenueRecognitionRules extends Node {
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly code: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
	    readonly localizedDescription: Promise<string>;
	    readonly ledger: Promise<sageX3MasterData.enums.GeneralLedgerTypes>;
	    readonly ledgerType: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly access: Reference<sageX3System.nodes.Access | null>;
	    readonly revenueRecognitionMethod: Promise<sageX3FinanceData.enums.RevenueRecognitionMethod | null>;
	    readonly isActive: Promise<boolean>;
	    readonly revenueType: Promise<sageX3FinanceData.enums.RevenueRecognitonType | null>;
	    readonly dimensionType: Promise<string>;
	    readonly analyticalDimension: Promise<string>;
	}
	//# sourceMappingURL=revenue-recognition-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/reminder-group.d.ts
declare module '@sage/x3-finance-data/lib/nodes/reminder-group' {
	import { Node } from '@sage/xtrem-core';
	export class ReminderGroup extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=reminder-group.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/product-dimensions.d.ts
declare module '@sage/x3-finance-data/lib/nodes/product-dimensions' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class ProductDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Product>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=product-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/product-category-dimensions.d.ts
declare module '@sage/x3-finance-data/lib/nodes/product-category-dimensions' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class ProductCategoryDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly stockSite: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ProductCategory>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=product-category-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/period.d.ts
declare module '@sage/x3-finance-data/lib/nodes/period' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date } from '@sage/xtrem-core';
	export class Period extends Node {
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly ledgerTypeNumber: Promise<sageX3MasterData.enums.GeneralLedgerTypes>;
	    readonly fiscalYear: Promise<integer>;
	    readonly code: Promise<integer>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly status: Promise<sageX3MasterData.enums.PeriodFiscalYearStatus | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly isAutoLedger: Promise<boolean>;
	}
	//# sourceMappingURL=period.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/open-item.d.ts
declare module '@sage/x3-finance-data/lib/nodes/open-item' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class OpenItem extends Node {
	    readonly documentType: Reference<sageX3FinanceData.nodes.EntryType>;
	    readonly documentNumber: Promise<string>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly openItemLineNumber: Promise<integer | null>;
	    readonly journalEntryLineInternalNumber: Promise<integer | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly controlAccount: Promise<string>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly businessPartnerType: Promise<sageX3FinanceData.enums.BusinessPartnerType | null>;
	    readonly payToOrPayByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly dueDate: Promise<date | null>;
	    readonly paymentMethod: Reference<sageX3InvoicingData.nodes.PaymentMethod | null>;
	    readonly paymentType: Promise<sageX3MasterData.enums.OpenItemType | null>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly sign: Promise<integer | null>;
	    readonly amountInCurrency: Promise<decimal | null>;
	    readonly amountInCompanyCurrency: Promise<decimal | null>;
	    readonly paidAmountInCurrency: Promise<decimal | null>;
	    readonly paidAmountInCompanyCurrency: Promise<decimal | null>;
	    readonly provisionalPaidAmountInCurrency: Promise<decimal | null>;
	    readonly provisionalPaidAmountInCompanyCurrency: Promise<decimal | null>;
	    readonly canBeReminded: Promise<boolean>;
	    readonly reminderLevel: Promise<integer | null>;
	    readonly reminderDate: Promise<date | null>;
	    readonly dispute: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly paymentApprovalLevel: Promise<sageX3MasterData.enums.PaymentApprovalType | null>;
	    readonly canBeIncludedInStatement: Promise<boolean>;
	    readonly postedStatus: Promise<integer | null>;
	    readonly deductedPrepaymentAmount: Promise<decimal | null>;
	    readonly prepaymentAmountToDeduct: Promise<decimal | null>;
	    readonly fiscalYear: Promise<integer | null>;
	    readonly period: Promise<integer | null>;
	    readonly prepaymentInvoiceIssueDate: Promise<date | null>;
	    readonly isPrepaymentIssued: Promise<boolean>;
	    readonly closedStatus: Promise<integer | null>;
	    readonly paymentDate: Promise<date | null>;
	    readonly uniqueNumber: Promise<string>;
	}
	//# sourceMappingURL=open-item.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/ledger.d.ts
declare module '@sage/x3-finance-data/lib/nodes/ledger' {
	import { Node } from '@sage/xtrem-core';
	export class Ledger extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=ledger.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/journal.d.ts
declare module '@sage/x3-finance-data/lib/nodes/journal' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class Journal extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=journal.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/journal-entry-transaction.d.ts
declare module '@sage/x3-finance-data/lib/nodes/journal-entry-transaction' {
	import { Node } from '@sage/xtrem-core';
	export class JournalEntryTransaction extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=journal-entry-transaction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/index.d.ts
declare module '@sage/x3-finance-data/lib/nodes/index' {
	export * from '@sage/x3-finance-data/lib/nodes/account-scheme';
	export * from '@sage/x3-finance-data/lib/nodes/account';
	export * from '@sage/x3-finance-data/lib/nodes/accounting-code';
	export * from '@sage/x3-finance-data/lib/nodes/automatic-journal';
	export * from '@sage/x3-finance-data/lib/nodes/bank-account';
	export * from '@sage/x3-finance-data/lib/nodes/bill-of-landing';
	export * from '@sage/x3-finance-data/lib/nodes/chart-of-accounts';
	export * from '@sage/x3-finance-data/lib/nodes/cost-type-dimensions';
	export * from '@sage/x3-finance-data/lib/nodes/customer-dimensions';
	export * from '@sage/x3-finance-data/lib/nodes/customer-invoice-header-currency-rates';
	export * from '@sage/x3-finance-data/lib/nodes/customer-invoice-header-dimensions';
	export * from '@sage/x3-finance-data/lib/nodes/dimension-type';
	export * from '@sage/x3-finance-data/lib/nodes/dimension';
	export * from '@sage/x3-finance-data/lib/nodes/distribution-key';
	export * from '@sage/x3-finance-data/lib/nodes/entry-type';
	export * from '@sage/x3-finance-data/lib/nodes/factor';
	export * from '@sage/x3-finance-data/lib/nodes/fiscal-year';
	export * from '@sage/x3-finance-data/lib/nodes/journal-entry-transaction';
	export * from '@sage/x3-finance-data/lib/nodes/journal';
	export * from '@sage/x3-finance-data/lib/nodes/ledger';
	export * from '@sage/x3-finance-data/lib/nodes/open-item';
	export * from '@sage/x3-finance-data/lib/nodes/period';
	export * from '@sage/x3-finance-data/lib/nodes/product-category-dimensions';
	export * from '@sage/x3-finance-data/lib/nodes/product-dimensions';
	export * from '@sage/x3-finance-data/lib/nodes/reminder-group';
	export * from '@sage/x3-finance-data/lib/nodes/revenue-recognition-rules';
	export * from '@sage/x3-finance-data/lib/nodes/stock-journal-dimensions';
	export * from '@sage/x3-finance-data/lib/nodes/stock-journal-import-dimensions';
	export * from '@sage/x3-finance-data/lib/nodes/supplier-invoice-header-currency-rates';
	export * from '@sage/x3-finance-data/lib/nodes/supplier-invoice-header-dimensions';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/fiscal-year.d.ts
declare module '@sage/x3-finance-data/lib/nodes/fiscal-year' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, Collection } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class FiscalYear extends Node {
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly ledgerTypeNumber: Promise<sageX3MasterData.enums.GeneralLedgerTypes>;
	    readonly code: Promise<integer | null>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly status: Promise<sageX3FinanceData.enums.FiscalYearReport | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly isAutoLedger: Promise<boolean>;
	    readonly periods: Collection<sageX3FinanceData.nodes.Period>;
	}
	//# sourceMappingURL=fiscal-year.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/factor.d.ts
declare module '@sage/x3-finance-data/lib/nodes/factor' {
	import { Node } from '@sage/xtrem-core';
	export class Factor extends Node {
	    readonly code: Promise<string>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=factor.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/entry-type.d.ts
declare module '@sage/x3-finance-data/lib/nodes/entry-type' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class EntryType extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=entry-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/distribution-key.d.ts
declare module '@sage/x3-finance-data/lib/nodes/distribution-key' {
	import { Node, integer } from '@sage/xtrem-core';
	export class DistributionKey extends Node {
	    readonly code: Promise<string>;
	    readonly numberOfLines: Promise<integer | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=distribution-key.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/dimension.d.ts
declare module '@sage/x3-finance-data/lib/nodes/dimension' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class Dimension extends Node {
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType>;
	    readonly dimension: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=dimension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/dimension-type.d.ts
declare module '@sage/x3-finance-data/lib/nodes/dimension-type' {
	import { Node } from '@sage/xtrem-core';
	export class DimensionType extends Node {
	    readonly dimensionType: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=dimension-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/customer-invoice-header-dimensions.d.ts
declare module '@sage/x3-finance-data/lib/nodes/customer-invoice-header-dimensions' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class CustomerInvoiceHeaderDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=customer-invoice-header-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/customer-invoice-header-currency-rates.d.ts
declare module '@sage/x3-finance-data/lib/nodes/customer-invoice-header-currency-rates' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class CustomerInvoiceHeaderCurrencyRates extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader>;
	    readonly ledger: Reference<sageX3FinanceData.nodes.Ledger | null>;
	    readonly ledgerCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly multiplyingRate: Promise<decimal | null>;
	    readonly dividingRate: Promise<decimal | null>;
	}
	//# sourceMappingURL=customer-invoice-header-currency-rates.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/customer-dimensions.d.ts
declare module '@sage/x3-finance-data/lib/nodes/customer-dimensions' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class CustomerDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Customer>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=customer-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/cost-type-dimensions.d.ts
declare module '@sage/x3-finance-data/lib/nodes/cost-type-dimensions' {
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class CostTypeDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3ProjectManagementData.nodes.CostType>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=cost-type-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/chart-of-accounts.d.ts
declare module '@sage/x3-finance-data/lib/nodes/chart-of-accounts' {
	import { Node } from '@sage/xtrem-core';
	export class ChartOfAccounts extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=chart-of-accounts.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/bill-of-landing.d.ts
declare module '@sage/x3-finance-data/lib/nodes/bill-of-landing' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class BillOfLanding extends Node {
	    readonly code: Promise<string>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	}
	//# sourceMappingURL=bill-of-landing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/bank-account.d.ts
declare module '@sage/x3-finance-data/lib/nodes/bank-account' {
	import { Node } from '@sage/xtrem-core';
	export class BankAccount extends Node {
	    readonly bank: Promise<string>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	}
	//# sourceMappingURL=bank-account.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/automatic-journal.d.ts
declare module '@sage/x3-finance-data/lib/nodes/automatic-journal' {
	import { Node } from '@sage/xtrem-core';
	export class AutomaticJournal extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	}
	//# sourceMappingURL=automatic-journal.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/accounting-code.d.ts
declare module '@sage/x3-finance-data/lib/nodes/accounting-code' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class AccountingCode extends Node {
	    readonly type: Promise<sageX3MasterData.enums.AccountingCodeType | null>;
	    readonly accountingCode: Promise<string>;
	    readonly chartOfAccounts: Reference<sageX3FinanceData.nodes.ChartOfAccounts | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=accounting-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/account.d.ts
declare module '@sage/x3-finance-data/lib/nodes/account' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class Account extends Node {
	    readonly chartOfAccounts: Reference<sageX3FinanceData.nodes.ChartOfAccounts>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=account.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/nodes/account-scheme.d.ts
declare module '@sage/x3-finance-data/lib/nodes/account-scheme' {
	import { Node } from '@sage/xtrem-core';
	export class AccountScheme extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=account-scheme.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/supplier-invoice-header-extension.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/supplier-invoice-header-extension' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class SupplierInvoiceHeaderExtension extends NodeExtension<sageX3InvoicingData.nodes.SupplierInvoiceHeader> {
	    readonly entryType: Reference<sageX3FinanceData.nodes.EntryType | null>;
	    readonly journal: Reference<sageX3FinanceData.nodes.Journal | null>;
	    readonly currencyRates: Collection<sageX3FinanceData.nodes.SupplierInvoiceHeaderCurrencyRates>;
	    readonly dimensions: Collection<sageX3FinanceData.nodes.SupplierInvoiceHeaderDimensions>;
	}
	declare module '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header' {
	    interface SupplierInvoiceHeader extends SupplierInvoiceHeaderExtension {
	    }
	}
	//# sourceMappingURL=supplier-invoice-header-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/supplier-extension.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/supplier-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class SupplierExtension extends NodeExtension<sageX3MasterData.nodes.Supplier> {
	    readonly accountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/supplier' {
	    interface Supplier extends SupplierExtension {
	    }
	}
	//# sourceMappingURL=supplier-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/stock-journal-import-extension.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/stock-journal-import-extension' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class StockJournalImportExtension extends NodeExtension<sageX3ManufacturingData.nodes.StockJournalImport> {
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly journalEntryDocumentType: Promise<string>;
	    readonly dimensions: Collection<sageX3FinanceData.nodes.StockJournalImportDimensions>;
	}
	declare module '@sage/x3-manufacturing-data/lib/nodes/stock-journal-import' {
	    interface StockJournalImport extends StockJournalImportExtension {
	    }
	}
	//# sourceMappingURL=stock-journal-import-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/stock-journal-extension.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/stock-journal-extension' {
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class StockJournalExtension extends NodeExtension<sageX3StockData.nodes.StockJournal> {
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly journalEntryDocumentType: Promise<string>;
	    readonly dimensions: Collection<sageX3FinanceData.nodes.StockJournalDimensions>;
	}
	declare module '@sage/x3-stock-data/lib/nodes/stock-journal' {
	    interface StockJournal extends StockJournalExtension {
	    }
	}
	//# sourceMappingURL=stock-journal-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/product-extension.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/product-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class ProductExtension extends NodeExtension<sageX3MasterData.nodes.Product> {
	    readonly accountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
	    readonly dimensions: Collection<sageX3FinanceData.nodes.ProductDimensions>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product' {
	    interface Product extends ProductExtension {
	    }
	}
	//# sourceMappingURL=product-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/product-category-extension.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/product-category-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class ProductCategoryExtension extends NodeExtension<sageX3MasterData.nodes.ProductCategory> {
	    readonly accountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
	    readonly dimensions: Collection<sageX3FinanceData.nodes.ProductCategoryDimensions>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product-category' {
	    interface ProductCategory extends ProductCategoryExtension {
	    }
	}
	//# sourceMappingURL=product-category-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/index' {
	export * from '@sage/x3-finance-data/lib/node-extensions/business-partner-company-exception-extension';
	export * from '@sage/x3-finance-data/lib/node-extensions/business-partner-extension';
	export * from '@sage/x3-finance-data/lib/node-extensions/cost-type-extension';
	export * from '@sage/x3-finance-data/lib/node-extensions/customer-extension';
	export * from '@sage/x3-finance-data/lib/node-extensions/customer-invoice-header-extension';
	export * from '@sage/x3-finance-data/lib/node-extensions/product-category-extension';
	export * from '@sage/x3-finance-data/lib/node-extensions/product-extension';
	export * from '@sage/x3-finance-data/lib/node-extensions/stock-journal-extension';
	export * from '@sage/x3-finance-data/lib/node-extensions/stock-journal-import-extension';
	export * from '@sage/x3-finance-data/lib/node-extensions/supplier-extension';
	export * from '@sage/x3-finance-data/lib/node-extensions/supplier-invoice-header-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/customer-invoice-header-extension.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/customer-invoice-header-extension' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class CustomerInvoiceHeaderExtension extends NodeExtension<sageX3InvoicingData.nodes.CustomerInvoiceHeader> {
	    readonly entryType: Reference<sageX3FinanceData.nodes.EntryType | null>;
	    readonly journal: Reference<sageX3FinanceData.nodes.Journal | null>;
	    readonly paymentBank: Reference<sageX3FinanceData.nodes.BankAccount | null>;
	    readonly currencyRates: Collection<sageX3FinanceData.nodes.CustomerInvoiceHeaderCurrencyRates>;
	    readonly dimensions: Collection<sageX3FinanceData.nodes.CustomerInvoiceHeaderDimensions>;
	}
	declare module '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header' {
	    interface CustomerInvoiceHeader extends CustomerInvoiceHeaderExtension {
	    }
	}
	//# sourceMappingURL=customer-invoice-header-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/customer-extension.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/customer-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class CustomerExtension extends NodeExtension<sageX3MasterData.nodes.Customer> {
	    readonly reminderGroup: Reference<sageX3FinanceData.nodes.ReminderGroup | null>;
	    readonly factor: Reference<sageX3FinanceData.nodes.Factor | null>;
	    readonly paymentBank: Reference<sageX3FinanceData.nodes.BankAccount | null>;
	    readonly accountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
	    readonly accountStructure: Reference<sageX3FinanceData.nodes.AccountScheme | null>;
	    readonly dimensions: Collection<sageX3FinanceData.nodes.CustomerDimensions>;
	}
	declare module '@sage/x3-master-data/lib/nodes/customer' {
	    interface Customer extends CustomerExtension {
	    }
	}
	//# sourceMappingURL=customer-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/cost-type-extension.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/cost-type-extension' {
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import { NodeExtension, Collection } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class CostTypeExtension extends NodeExtension<sageX3ProjectManagementData.nodes.CostType> {
	    readonly dimensions: Collection<sageX3FinanceData.nodes.CostTypeDimensions>;
	}
	declare module '@sage/x3-project-management-data/lib/nodes/cost-type' {
	    interface CostType extends CostTypeExtension {
	    }
	}
	//# sourceMappingURL=cost-type-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/business-partner-extension.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/business-partner-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class BusinessPartnerExtension extends NodeExtension<sageX3MasterData.nodes.BusinessPartner> {
	    readonly accountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
	    readonly expenseEntryType: Reference<sageX3FinanceData.nodes.EntryType | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/business-partner' {
	    interface BusinessPartner extends BusinessPartnerExtension {
	    }
	}
	//# sourceMappingURL=business-partner-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/node-extensions/business-partner-company-exception-extension.d.ts
declare module '@sage/x3-finance-data/lib/node-extensions/business-partner-company-exception-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3FinanceData from '@sage/x3-finance-data/lib/index';
	export class BusinessPartnerCompanyExceptionExtension extends NodeExtension<sageX3MasterData.nodes.BusinessPartnerCompanyException> {
	    readonly customerAccountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
	    readonly supplierAccountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
	    readonly paymentBankIsrQr: Reference<sageX3FinanceData.nodes.BankAccount | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/business-partner-company-exception' {
	    interface BusinessPartnerCompanyException extends BusinessPartnerCompanyExceptionExtension {
	    }
	}
	//# sourceMappingURL=business-partner-company-exception-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/yn-warn.d.ts
declare module '@sage/x3-finance-data/lib/enums/yn-warn' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum YNWarnEnum {
	    no = 1,
	    yes = 2,
	    inform = 3
	}
	export interface YNWarn$EnumInterface {
	    no: 1;
	    yes: 2;
	    inform: 3;
	}
	export type YNWarn = keyof YNWarn$EnumInterface;
	export const ynWarnDatatype: X3EnumDataType<keyof YNWarn$EnumInterface, unknown>;
	//# sourceMappingURL=yn-warn.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/withholding-threshold-base.d.ts
declare module '@sage/x3-finance-data/lib/enums/withholding-threshold-base' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WithholdingThresholdBaseEnum {
	    byDocument = 1,
	    globalPaymentOrder = 2,
	    taxableCorrectedBasis = 3
	}
	export interface WithholdingThresholdBase$EnumInterface {
	    byDocument: 1;
	    globalPaymentOrder: 2;
	    taxableCorrectedBasis: 3;
	}
	export type WithholdingThresholdBase = keyof WithholdingThresholdBase$EnumInterface;
	export const withholdingThresholdBaseDatatype: X3EnumDataType<keyof WithholdingThresholdBase$EnumInterface, unknown>;
	//# sourceMappingURL=withholding-threshold-base.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/withholding-calculation-basis.d.ts
declare module '@sage/x3-finance-data/lib/enums/withholding-calculation-basis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WithholdingCalculationBasisEnum {
	    excludeTaxAmount = 1,
	    taxIncludedAmount = 2,
	    monthlyTotal = 3
	}
	export interface WithholdingCalculationBasis$EnumInterface {
	    excludeTaxAmount: 1;
	    taxIncludedAmount: 2;
	    monthlyTotal: 3;
	}
	export type WithholdingCalculationBasis = keyof WithholdingCalculationBasis$EnumInterface;
	export const withholdingCalculationBasisDatatype: X3EnumDataType<keyof WithholdingCalculationBasis$EnumInterface, unknown>;
	//# sourceMappingURL=withholding-calculation-basis.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/version-status-2669.d.ts
declare module '@sage/x3-finance-data/lib/enums/version-status-2669' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VersionStatus2669Enum {
	    open = 1,
	    closed = 2
	}
	export interface VersionStatus2669$EnumInterface {
	    open: 1;
	    closed: 2;
	}
	export type VersionStatus2669 = keyof VersionStatus2669$EnumInterface;
	export const versionStatus2669Datatype: X3EnumDataType<keyof VersionStatus2669$EnumInterface, unknown>;
	//# sourceMappingURL=version-status-2669.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vatpayfcy-parameter.d.ts
declare module '@sage/x3-finance-data/lib/enums/vatpayfcy-parameter' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatpayfcyParameterEnum {
	    blocking = 1,
	    warning = 2
	}
	export interface VatpayfcyParameter$EnumInterface {
	    blocking: 1;
	    warning: 2;
	}
	export type VatpayfcyParameter = keyof VatpayfcyParameter$EnumInterface;
	export const vatpayfcyParameterDatatype: X3EnumDataType<keyof VatpayfcyParameter$EnumInterface, unknown>;
	//# sourceMappingURL=vatpayfcy-parameter.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-submission-environment.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-submission-environment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatSubmissionEnvironmentEnum {
	    test = 1,
	    preProduction = 2,
	    production = 3,
	    notDefined = 4
	}
	export interface VatSubmissionEnvironment$EnumInterface {
	    test: 1;
	    preProduction: 2;
	    production: 3;
	    notDefined: 4;
	}
	export type VatSubmissionEnvironment = keyof VatSubmissionEnvironment$EnumInterface;
	export const vatSubmissionEnvironmentDatatype: X3EnumDataType<keyof VatSubmissionEnvironment$EnumInterface, unknown>;
	//# sourceMappingURL=vat-submission-environment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-statement-periodicity.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-statement-periodicity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatStatementPeriodicityEnum {
	    month = 1,
	    quarter = 2,
	    year = 3
	}
	export interface VatStatementPeriodicity$EnumInterface {
	    month: 1;
	    quarter: 2;
	    year: 3;
	}
	export type VatStatementPeriodicity = keyof VatStatementPeriodicity$EnumInterface;
	export const vatStatementPeriodicityDatatype: X3EnumDataType<keyof VatStatementPeriodicity$EnumInterface, unknown>;
	//# sourceMappingURL=vat-statement-periodicity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-return-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-return-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatReturnTypeEnum {
	    monthly = 1,
	    quarterly = 2,
	    yearly = 3
	}
	export interface VatReturnType$EnumInterface {
	    monthly: 1;
	    quarterly: 2;
	    yearly: 3;
	}
	export type VatReturnType = keyof VatReturnType$EnumInterface;
	export const vatReturnTypeDatatype: X3EnumDataType<keyof VatReturnType$EnumInterface, unknown>;
	//# sourceMappingURL=vat-return-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-return-reporting.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-return-reporting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatReturnReportingEnum {
	    basis = 1,
	    amount = 2,
	    both = 3
	}
	export interface VatReturnReporting$EnumInterface {
	    basis: 1;
	    amount: 2;
	    both: 3;
	}
	export type VatReturnReporting = keyof VatReturnReporting$EnumInterface;
	export const vatReturnReportingDatatype: X3EnumDataType<keyof VatReturnReporting$EnumInterface, unknown>;
	//# sourceMappingURL=vat-return-reporting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-options-for-shipments.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-options-for-shipments' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatOptionsForShipmentsEnum {
	    vatDebitAllocatedFirst = 1,
	    proRata = 2
	}
	export interface VatOptionsForShipments$EnumInterface {
	    vatDebitAllocatedFirst: 1;
	    proRata: 2;
	}
	export type VatOptionsForShipments = keyof VatOptionsForShipments$EnumInterface;
	export const vatOptionsForShipmentsDatatype: X3EnumDataType<keyof VatOptionsForShipments$EnumInterface, unknown>;
	//# sourceMappingURL=vat-options-for-shipments.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-management.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatManagementEnum {
	    notSubjected = 1,
	    subjected = 2,
	    taxAccount = 3,
	    euTax = 4,
	    prepaymentAccount = 5
	}
	export interface VatManagement$EnumInterface {
	    notSubjected: 1;
	    subjected: 2;
	    taxAccount: 3;
	    euTax: 4;
	    prepaymentAccount: 5;
	}
	export type VatManagement = keyof VatManagement$EnumInterface;
	export const vatManagementDatatype: X3EnumDataType<keyof VatManagement$EnumInterface, unknown>;
	//# sourceMappingURL=vat-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-management-658.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-management-658' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatManagement658Enum {
	    no = 1,
	    prepayment = 2,
	    taxRecovery = 3,
	    taxCharges = 4
	}
	export interface VatManagement658$EnumInterface {
	    no: 1;
	    prepayment: 2;
	    taxRecovery: 3;
	    taxCharges: 4;
	}
	export type VatManagement658 = keyof VatManagement658$EnumInterface;
	export const vatManagement658Datatype: X3EnumDataType<keyof VatManagement658$EnumInterface, unknown>;
	//# sourceMappingURL=vat-management-658.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-entity.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-entity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatEntityEnum {
	    issueOperationCollectedTaxAmount = 1,
	    taxesDueCollectedVat = 2,
	    receiptOperationsDeductibleTaxAmount = 3,
	    deductibleTaxesDeductibleVat = 4
	}
	export interface VatEntity$EnumInterface {
	    issueOperationCollectedTaxAmount: 1;
	    taxesDueCollectedVat: 2;
	    receiptOperationsDeductibleTaxAmount: 3;
	    deductibleTaxesDeductibleVat: 4;
	}
	export type VatEntity = keyof VatEntity$EnumInterface;
	export const vatEntityDatatype: X3EnumDataType<keyof VatEntity$EnumInterface, unknown>;
	//# sourceMappingURL=vat-entity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-declaration-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-declaration-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatDeclarationTypeEnum {
	    periodic = 1,
	    annual = 2,
	    recapitulative = 3,
	    europeanServices = 4
	}
	export interface VatDeclarationType$EnumInterface {
	    periodic: 1;
	    annual: 2;
	    recapitulative: 3;
	    europeanServices: 4;
	}
	export type VatDeclarationType = keyof VatDeclarationType$EnumInterface;
	export const vatDeclarationTypeDatatype: X3EnumDataType<keyof VatDeclarationType$EnumInterface, unknown>;
	//# sourceMappingURL=vat-declaration-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-declaration-record-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-declaration-record-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatDeclarationRecordTypeEnum {
	    normal = 1,
	    unmatching = 2,
	    prepayment = 3
	}
	export interface VatDeclarationRecordType$EnumInterface {
	    normal: 1;
	    unmatching: 2;
	    prepayment: 3;
	}
	export type VatDeclarationRecordType = keyof VatDeclarationRecordType$EnumInterface;
	export const vatDeclarationRecordTypeDatatype: X3EnumDataType<keyof VatDeclarationRecordType$EnumInterface, unknown>;
	//# sourceMappingURL=vat-declaration-record-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-declaration-date.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-declaration-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatDeclarationDateEnum {
	    accountingDate = 1,
	    documentDate = 2
	}
	export interface VatDeclarationDate$EnumInterface {
	    accountingDate: 1;
	    documentDate: 2;
	}
	export type VatDeclarationDate = keyof VatDeclarationDate$EnumInterface;
	export const vatDeclarationDateDatatype: X3EnumDataType<keyof VatDeclarationDate$EnumInterface, unknown>;
	//# sourceMappingURL=vat-declaration-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-box-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-box-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatBoxTypeEnum {
	    title = 1,
	    detail = 2,
	    total = 3,
	    offDeclaration = 4
	}
	export interface VatBoxType$EnumInterface {
	    title: 1;
	    detail: 2;
	    total: 3;
	    offDeclaration: 4;
	}
	export type VatBoxType = keyof VatBoxType$EnumInterface;
	export const vatBoxTypeDatatype: X3EnumDataType<keyof VatBoxType$EnumInterface, unknown>;
	//# sourceMappingURL=vat-box-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/vat-adjustment-level.d.ts
declare module '@sage/x3-finance-data/lib/enums/vat-adjustment-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VatAdjustmentLevelEnum {
	    companyLevel = 1,
	    entityLevel = 2
	}
	export interface VatAdjustmentLevel$EnumInterface {
	    companyLevel: 1;
	    entityLevel: 2;
	}
	export type VatAdjustmentLevel = keyof VatAdjustmentLevel$EnumInterface;
	export const vatAdjustmentLevelDatatype: X3EnumDataType<keyof VatAdjustmentLevel$EnumInterface, unknown>;
	//# sourceMappingURL=vat-adjustment-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/variance-type-611.d.ts
declare module '@sage/x3-finance-data/lib/enums/variance-type-611' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VarianceType611Enum {
	    notManaged = 1,
	    balanceSheet = 2,
	    profitAndLoss = 3
	}
	export interface VarianceType611$EnumInterface {
	    notManaged: 1;
	    balanceSheet: 2;
	    profitAndLoss: 3;
	}
	export type VarianceType611 = keyof VarianceType611$EnumInterface;
	export const varianceType611Datatype: X3EnumDataType<keyof VarianceType611$EnumInterface, unknown>;
	//# sourceMappingURL=variance-type-611.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/type-of-sales-portugal.d.ts
declare module '@sage/x3-finance-data/lib/enums/type-of-sales-portugal' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfSalesPortugalEnum {
	    goods = 1,
	    fixedAssets = 2,
	    services = 3
	}
	export interface TypeOfSalesPortugal$EnumInterface {
	    goods: 1;
	    fixedAssets: 2;
	    services: 3;
	}
	export type TypeOfSalesPortugal = keyof TypeOfSalesPortugal$EnumInterface;
	export const typeOfSalesPortugalDatatype: X3EnumDataType<keyof TypeOfSalesPortugal$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-sales-portugal.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/type-of-rule.d.ts
declare module '@sage/x3-finance-data/lib/enums/type-of-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfRuleEnum {
	    normal = 1,
	    export = 2,
	    taxExempt = 3,
	    eu = 4
	}
	export interface TypeOfRule$EnumInterface {
	    normal: 1;
	    export: 2;
	    taxExempt: 3;
	    eu: 4;
	}
	export type TypeOfRule = keyof TypeOfRule$EnumInterface;
	export const typeOfRuleDatatype: X3EnumDataType<keyof TypeOfRule$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/type-of-extraction.d.ts
declare module '@sage/x3-finance-data/lib/enums/type-of-extraction' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfExtractionEnum {
	    accountRoot = 1,
	    accountList = 2
	}
	export interface TypeOfExtraction$EnumInterface {
	    accountRoot: 1;
	    accountList: 2;
	}
	export type TypeOfExtraction = keyof TypeOfExtraction$EnumInterface;
	export const typeOfExtractionDatatype: X3EnumDataType<keyof TypeOfExtraction$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-extraction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/type-of-economic-reason.d.ts
declare module '@sage/x3-finance-data/lib/enums/type-of-economic-reason' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfEconomicReasonEnum {
	    notUsed = 1,
	    service = 2,
	    capitalFlow = 3,
	    transitTrade = 4
	}
	export interface TypeOfEconomicReason$EnumInterface {
	    notUsed: 1;
	    service: 2;
	    capitalFlow: 3;
	    transitTrade: 4;
	}
	export type TypeOfEconomicReason = keyof TypeOfEconomicReason$EnumInterface;
	export const typeOfEconomicReasonDatatype: X3EnumDataType<keyof TypeOfEconomicReason$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-economic-reason.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/triggering-conditions.d.ts
declare module '@sage/x3-finance-data/lib/enums/triggering-conditions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TriggeringConditionsEnum {
	    no = 1,
	    always = 2,
	    confirmation = 3
	}
	export interface TriggeringConditions$EnumInterface {
	    no: 1;
	    always: 2;
	    confirmation: 3;
	}
	export type TriggeringConditions = keyof TriggeringConditions$EnumInterface;
	export const triggeringConditionsDatatype: X3EnumDataType<keyof TriggeringConditions$EnumInterface, unknown>;
	//# sourceMappingURL=triggering-conditions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/treasury-payments-sfrpt.d.ts
declare module '@sage/x3-finance-data/lib/enums/treasury-payments-sfrpt' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TreasuryPaymentsSfrptEnum {
	    descr = 1,
	    refxrt = 2
	}
	export interface TreasuryPaymentsSfrpt$EnumInterface {
	    descr: 1;
	    refxrt: 2;
	}
	export type TreasuryPaymentsSfrpt = keyof TreasuryPaymentsSfrpt$EnumInterface;
	export const treasuryPaymentsSfrptDatatype: X3EnumDataType<keyof TreasuryPaymentsSfrpt$EnumInterface, unknown>;
	//# sourceMappingURL=treasury-payments-sfrpt.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/treasury-open-items-sfrpt.d.ts
declare module '@sage/x3-finance-data/lib/enums/treasury-open-items-sfrpt' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TreasuryOpenItemsSfrptEnum {
	    descr = 1,
	    dope = 2,
	    refxrt = 3
	}
	export interface TreasuryOpenItemsSfrpt$EnumInterface {
	    descr: 1;
	    dope: 2;
	    refxrt: 3;
	}
	export type TreasuryOpenItemsSfrpt = keyof TreasuryOpenItemsSfrpt$EnumInterface;
	export const treasuryOpenItemsSfrptDatatype: X3EnumDataType<keyof TreasuryOpenItemsSfrpt$EnumInterface, unknown>;
	//# sourceMappingURL=treasury-open-items-sfrpt.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/treas-interface.d.ts
declare module '@sage/x3-finance-data/lib/enums/treas-interface' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TreasInterfaceEnum {
	    cpta = 1,
	    cdc = 2,
	    descr = 3,
	    codrif = 4,
	    dope = 5,
	    nass = 6
	}
	export interface TreasInterface$EnumInterface {
	    cpta: 1;
	    cdc: 2;
	    descr: 3;
	    codrif: 4;
	    dope: 5;
	    nass: 6;
	}
	export type TreasInterface = keyof TreasInterface$EnumInterface;
	export const treasInterfaceDatatype: X3EnumDataType<keyof TreasInterface$EnumInterface, unknown>;
	//# sourceMappingURL=treas-interface.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/treas-interface-2672.d.ts
declare module '@sage/x3-finance-data/lib/enums/treas-interface-2672' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TreasInterface2672Enum {
	    cpta = 1,
	    cdc = 2,
	    descr = 3,
	    codrif = 4,
	    nass = 5
	}
	export interface TreasInterface2672$EnumInterface {
	    cpta: 1;
	    cdc: 2;
	    descr: 3;
	    codrif: 4;
	    nass: 5;
	}
	export type TreasInterface2672 = keyof TreasInterface2672$EnumInterface;
	export const treasInterface2672Datatype: X3EnumDataType<keyof TreasInterface2672$EnumInterface, unknown>;
	//# sourceMappingURL=treas-interface-2672.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/transfer-basis.d.ts
declare module '@sage/x3-finance-data/lib/enums/transfer-basis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransferBasisEnum {
	    inAmountsByPeriods = 1,
	    inAnnualAmounts = 2
	}
	export interface TransferBasis$EnumInterface {
	    inAmountsByPeriods: 1;
	    inAnnualAmounts: 2;
	}
	export type TransferBasis = keyof TransferBasis$EnumInterface;
	export const transferBasisDatatype: X3EnumDataType<keyof TransferBasis$EnumInterface, unknown>;
	//# sourceMappingURL=transfer-basis.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/title-2607.d.ts
declare module '@sage/x3-finance-data/lib/enums/title-2607' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Title2607Enum {
	    mr = 1,
	    mrs = 2,
	    ms = 3
	}
	export interface Title2607$EnumInterface {
	    mr: 1;
	    mrs: 2;
	    ms: 3;
	}
	export type Title2607 = keyof Title2607$EnumInterface;
	export const title2607Datatype: X3EnumDataType<keyof Title2607$EnumInterface, unknown>;
	//# sourceMappingURL=title-2607.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/tds-record-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/tds-record-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TdsRecordTypeEnum {
	    startFlag = 1,
	    companyHeader = 2,
	    siteHeader = 3,
	    feeLines = 4,
	    declarationSiteTotal = 5,
	    companyTotal = 6,
	    endFlag = 7
	}
	export interface TdsRecordType$EnumInterface {
	    startFlag: 1;
	    companyHeader: 2;
	    siteHeader: 3;
	    feeLines: 4;
	    declarationSiteTotal: 5;
	    companyTotal: 6;
	    endFlag: 7;
	}
	export type TdsRecordType = keyof TdsRecordType$EnumInterface;
	export const tdsRecordTypeDatatype: X3EnumDataType<keyof TdsRecordType$EnumInterface, unknown>;
	//# sourceMappingURL=tds-record-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/tds-file-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/tds-file-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TdsFileTypeEnum {
	    tds = 1,
	    tds2 = 2
	}
	export interface TdsFileType$EnumInterface {
	    tds: 1;
	    tds2: 2;
	}
	export type TdsFileType = keyof TdsFileType$EnumInterface;
	export const tdsFileTypeDatatype: X3EnumDataType<keyof TdsFileType$EnumInterface, unknown>;
	//# sourceMappingURL=tds-file-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/tdb-sort.d.ts
declare module '@sage/x3-finance-data/lib/enums/tdb-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TdbSortEnum {
	    none = 1,
	    site = 2,
	    account = 3,
	    bPs = 4,
	    fixedAssets = 5
	}
	export interface TdbSort$EnumInterface {
	    none: 1;
	    site: 2;
	    account: 3;
	    bPs: 4;
	    fixedAssets: 5;
	}
	export type TdbSort = keyof TdbSort$EnumInterface;
	export const tdbSortDatatype: X3EnumDataType<keyof TdbSort$EnumInterface, unknown>;
	//# sourceMappingURL=tdb-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/tdb-sort-2634.d.ts
declare module '@sage/x3-finance-data/lib/enums/tdb-sort-2634' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TdbSort2634Enum {
	    none = 1,
	    site = 2,
	    account = 3,
	    dimension = 4
	}
	export interface TdbSort2634$EnumInterface {
	    none: 1;
	    site: 2;
	    account: 3;
	    dimension: 4;
	}
	export type TdbSort2634 = keyof TdbSort2634$EnumInterface;
	export const tdbSort2634Datatype: X3EnumDataType<keyof TdbSort2634$EnumInterface, unknown>;
	//# sourceMappingURL=tdb-sort-2634.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/taxpayer-number.d.ts
declare module '@sage/x3-finance-data/lib/enums/taxpayer-number' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxpayerNumberEnum {
	    employerIdentificationNumber = 1,
	    socialSecurityNumber = 2
	}
	export interface TaxpayerNumber$EnumInterface {
	    employerIdentificationNumber: 1;
	    socialSecurityNumber: 2;
	}
	export type TaxpayerNumber = keyof TaxpayerNumber$EnumInterface;
	export const taxpayerNumberDatatype: X3EnumDataType<keyof TaxpayerNumber$EnumInterface, unknown>;
	//# sourceMappingURL=taxpayer-number.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/tax-type-selection.d.ts
declare module '@sage/x3-finance-data/lib/enums/tax-type-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxTypeSelectionEnum {
	    collected = 1,
	    deductible = 2,
	    all = 3
	}
	export interface TaxTypeSelection$EnumInterface {
	    collected: 1;
	    deductible: 2;
	    all: 3;
	}
	export type TaxTypeSelection = keyof TaxTypeSelection$EnumInterface;
	export const taxTypeSelectionDatatype: X3EnumDataType<keyof TaxTypeSelection$EnumInterface, unknown>;
	//# sourceMappingURL=tax-type-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/tax-credit-to-recover.d.ts
declare module '@sage/x3-finance-data/lib/enums/tax-credit-to-recover' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxCreditToRecoverEnum {
	    none = 1,
	    requestReimbursement = 2,
	    carryForwardExcess = 3
	}
	export interface TaxCreditToRecover$EnumInterface {
	    none: 1;
	    requestReimbursement: 2;
	    carryForwardExcess: 3;
	}
	export type TaxCreditToRecover = keyof TaxCreditToRecover$EnumInterface;
	export const taxCreditToRecoverDatatype: X3EnumDataType<keyof TaxCreditToRecover$EnumInterface, unknown>;
	//# sourceMappingURL=tax-credit-to-recover.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/tax-code-control-3684.d.ts
declare module '@sage/x3-finance-data/lib/enums/tax-code-control-3684' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxCodeControl3684Enum {
	    inactive = 1,
	    authorization = 2,
	    restriction = 3
	}
	export interface TaxCodeControl3684$EnumInterface {
	    inactive: 1;
	    authorization: 2;
	    restriction: 3;
	}
	export type TaxCodeControl3684 = keyof TaxCodeControl3684$EnumInterface;
	export const taxCodeControl3684Datatype: X3EnumDataType<keyof TaxCodeControl3684$EnumInterface, unknown>;
	//# sourceMappingURL=tax-code-control-3684.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/tax-allocation.d.ts
declare module '@sage/x3-finance-data/lib/enums/tax-allocation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxAllocationEnum {
	    collectedSales = 1,
	    collectedFixedAssets = 2,
	    deductiblePurchases = 3,
	    deductibleFixedAssets = 4,
	    deductibleGS = 5,
	    stateRules = 6,
	    companyRules = 7,
	    collectedGS = 8
	}
	export interface TaxAllocation$EnumInterface {
	    collectedSales: 1;
	    collectedFixedAssets: 2;
	    deductiblePurchases: 3;
	    deductibleFixedAssets: 4;
	    deductibleGS: 5;
	    stateRules: 6;
	    companyRules: 7;
	    collectedGS: 8;
	}
	export type TaxAllocation = keyof TaxAllocation$EnumInterface;
	export const taxAllocationDatatype: X3EnumDataType<keyof TaxAllocation$EnumInterface, unknown>;
	//# sourceMappingURL=tax-allocation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/table-list.d.ts
declare module '@sage/x3-finance-data/lib/enums/table-list' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TableListEnum {
	    accountingEntries = 1,
	    analyticalAccounting = 2,
	    estimations = 3
	}
	export interface TableList$EnumInterface {
	    accountingEntries: 1;
	    analyticalAccounting: 2;
	    estimations: 3;
	}
	export type TableList = keyof TableList$EnumInterface;
	export const tableListDatatype: X3EnumDataType<keyof TableList$EnumInterface, unknown>;
	//# sourceMappingURL=table-list.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/swiss-vat-codes.d.ts
declare module '@sage/x3-finance-data/lib/enums/swiss-vat-codes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SwissVatCodesEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    substituteValue9 = 9,
	    substituteValue10 = 10,
	    substituteValue11 = 11,
	    substituteValue12 = 12,
	    substituteValue13 = 13,
	    substituteValue14 = 14,
	    substituteValue15 = 15,
	    substituteValue16 = 16,
	    substituteValue17 = 17,
	    substituteValue18 = 18,
	    substituteValue19 = 19,
	    substituteValue20 = 20,
	    substituteValue21 = 21,
	    substituteValue22 = 22,
	    substituteValue23 = 23,
	    substituteValue24 = 24,
	    substituteValue25 = 25,
	    substituteValue26 = 26,
	    substituteValue27 = 27
	}
	export interface SwissVatCodes$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    substituteValue9: 9;
	    substituteValue10: 10;
	    substituteValue11: 11;
	    substituteValue12: 12;
	    substituteValue13: 13;
	    substituteValue14: 14;
	    substituteValue15: 15;
	    substituteValue16: 16;
	    substituteValue17: 17;
	    substituteValue18: 18;
	    substituteValue19: 19;
	    substituteValue20: 20;
	    substituteValue21: 21;
	    substituteValue22: 22;
	    substituteValue23: 23;
	    substituteValue24: 24;
	    substituteValue25: 25;
	    substituteValue26: 26;
	    substituteValue27: 27;
	}
	export type SwissVatCodes = keyof SwissVatCodes$EnumInterface;
	export const swissVatCodesDatatype: X3EnumDataType<keyof SwissVatCodes$EnumInterface, unknown>;
	//# sourceMappingURL=swiss-vat-codes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/supplier-customer-document.d.ts
declare module '@sage/x3-finance-data/lib/enums/supplier-customer-document' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierCustomerDocumentEnum {
	    customerInvoices = 1,
	    supplierInvoices = 2
	}
	export interface SupplierCustomerDocument$EnumInterface {
	    customerInvoices: 1;
	    supplierInvoices: 2;
	}
	export type SupplierCustomerDocument = keyof SupplierCustomerDocument$EnumInterface;
	export const supplierCustomerDocumentDatatype: X3EnumDataType<keyof SupplierCustomerDocument$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-customer-document.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/supplier-aged-balance-field.d.ts
declare module '@sage/x3-finance-data/lib/enums/supplier-aged-balance-field' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierAgedBalanceFieldEnum {
	    lastRfq = 1,
	    lastOrder = 2,
	    lastReceipt = 3,
	    lastInvoice = 4,
	    lastPayment = 5
	}
	export interface SupplierAgedBalanceField$EnumInterface {
	    lastRfq: 1;
	    lastOrder: 2;
	    lastReceipt: 3;
	    lastInvoice: 4;
	    lastPayment: 5;
	}
	export type SupplierAgedBalanceField = keyof SupplierAgedBalanceField$EnumInterface;
	export const supplierAgedBalanceFieldDatatype: X3EnumDataType<keyof SupplierAgedBalanceField$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-aged-balance-field.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/submitter-vat-declaration-ger.d.ts
declare module '@sage/x3-finance-data/lib/enums/submitter-vat-declaration-ger' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubmitterVatDeclarationGerEnum {
	    legalEntity = 1
	}
	export interface SubmitterVatDeclarationGer$EnumInterface {
	    legalEntity: 1;
	}
	export type SubmitterVatDeclarationGer = keyof SubmitterVatDeclarationGer$EnumInterface;
	export const submitterVatDeclarationGerDatatype: X3EnumDataType<"legalEntity", unknown>;
	//# sourceMappingURL=submitter-vat-declaration-ger.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/submission-mode-for-recap-st.d.ts
declare module '@sage/x3-finance-data/lib/enums/submission-mode-for-recap-st' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubmissionModeForRecapStEnum {
	    noChangeInSubmissionMode = 1,
	    submissionOfMonthlyReportsAccordingTo18AAbs1UStG = 2,
	    withdrawalOfMonthlyReportsAccordingTo18AAbs1UStG = 3
	}
	export interface SubmissionModeForRecapSt$EnumInterface {
	    noChangeInSubmissionMode: 1;
	    submissionOfMonthlyReportsAccordingTo18AAbs1UStG: 2;
	    withdrawalOfMonthlyReportsAccordingTo18AAbs1UStG: 3;
	}
	export type SubmissionModeForRecapSt = keyof SubmissionModeForRecapSt$EnumInterface;
	export const submissionModeForRecapStDatatype: X3EnumDataType<keyof SubmissionModeForRecapSt$EnumInterface, unknown>;
	//# sourceMappingURL=submission-mode-for-recap-st.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/status-880.d.ts
declare module '@sage/x3-finance-data/lib/enums/status-880' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Status880Enum {
	    inProgress = 1,
	    validated = 2,
	    submitted = 3,
	    rejected = 4,
	    completed = 5
	}
	export interface Status880$EnumInterface {
	    inProgress: 1;
	    validated: 2;
	    submitted: 3;
	    rejected: 4;
	    completed: 5;
	}
	export type Status880 = keyof Status880$EnumInterface;
	export const status880Datatype: X3EnumDataType<keyof Status880$EnumInterface, unknown>;
	//# sourceMappingURL=status-880.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/spanish-setup-values.d.ts
declare module '@sage/x3-finance-data/lib/enums/spanish-setup-values' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SpanishSetupValuesEnum {
	    company = 1,
	    site = 2,
	    date = 3,
	    employee = 4,
	    description = 5,
	    currency = 6,
	    dimension1 = 7,
	    dimension2 = 8,
	    dimension3 = 9,
	    dimension4 = 10,
	    dimension5 = 11
	}
	export interface SpanishSetupValues$EnumInterface {
	    company: 1;
	    site: 2;
	    date: 3;
	    employee: 4;
	    description: 5;
	    currency: 6;
	    dimension1: 7;
	    dimension2: 8;
	    dimension3: 9;
	    dimension4: 10;
	    dimension5: 11;
	}
	export type SpanishSetupValues = keyof SpanishSetupValues$EnumInterface;
	export const spanishSetupValuesDatatype: X3EnumDataType<keyof SpanishSetupValues$EnumInterface, unknown>;
	//# sourceMappingURL=spanish-setup-values.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/source-document-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/source-document-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SourceDocumentTypeEnum {
	    order = 1,
	    deliveryRequest = 2,
	    purchaseRequest = 3,
	    direct = 4
	}
	export interface SourceDocumentType$EnumInterface {
	    order: 1;
	    deliveryRequest: 2;
	    purchaseRequest: 3;
	    direct: 4;
	}
	export type SourceDocumentType = keyof SourceDocumentType$EnumInterface;
	export const sourceDocumentTypeDatatype: X3EnumDataType<keyof SourceDocumentType$EnumInterface, unknown>;
	//# sourceMappingURL=source-document-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sort.d.ts
declare module '@sage/x3-finance-data/lib/enums/sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortEnum {
	    date = 1,
	    account = 2,
	    dimension = 3
	}
	export interface Sort$EnumInterface {
	    date: 1;
	    account: 2;
	    dimension: 3;
	}
	export type Sort = keyof Sort$EnumInterface;
	export const sortDatatype: X3EnumDataType<keyof Sort$EnumInterface, unknown>;
	//# sourceMappingURL=sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sort-sequence.d.ts
declare module '@sage/x3-finance-data/lib/enums/sort-sequence' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortSequenceEnum {
	    ascending = 1,
	    descending = 2
	}
	export interface SortSequence$EnumInterface {
	    ascending: 1;
	    descending: 2;
	}
	export type SortSequence = keyof SortSequence$EnumInterface;
	export const sortSequenceDatatype: X3EnumDataType<keyof SortSequence$EnumInterface, unknown>;
	//# sourceMappingURL=sort-sequence.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sort-order-2608.d.ts
declare module '@sage/x3-finance-data/lib/enums/sort-order-2608' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortOrder2608Enum {
	    date = 1,
	    nature = 2,
	    dimension = 3
	}
	export interface SortOrder2608$EnumInterface {
	    date: 1;
	    nature: 2;
	    dimension: 3;
	}
	export type SortOrder2608 = keyof SortOrder2608$EnumInterface;
	export const sortOrder2608Datatype: X3EnumDataType<keyof SortOrder2608$EnumInterface, unknown>;
	//# sourceMappingURL=sort-order-2608.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sort-open-items-2605.d.ts
declare module '@sage/x3-finance-data/lib/enums/sort-open-items-2605' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortOpenItems2605Enum {
	    dueDate = 1,
	    accountingDocumentDate = 2
	}
	export interface SortOpenItems2605$EnumInterface {
	    dueDate: 1;
	    accountingDocumentDate: 2;
	}
	export type SortOpenItems2605 = keyof SortOpenItems2605$EnumInterface;
	export const sortOpenItems2605Datatype: X3EnumDataType<keyof SortOpenItems2605$EnumInterface, unknown>;
	//# sourceMappingURL=sort-open-items-2605.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sort-engagesec.d.ts
declare module '@sage/x3-finance-data/lib/enums/sort-engagesec' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortEngagesecEnum {
	    date = 1,
	    dim1 = 2,
	    dim2 = 3,
	    dim3 = 4,
	    dim4 = 5,
	    dim5 = 6,
	    dim6 = 7,
	    dim7 = 8,
	    dim8 = 9,
	    dim9 = 10,
	    businessPartner = 11,
	    account = 12
	}
	export interface SortEngagesec$EnumInterface {
	    date: 1;
	    dim1: 2;
	    dim2: 3;
	    dim3: 4;
	    dim4: 5;
	    dim5: 6;
	    dim6: 7;
	    dim7: 8;
	    dim8: 9;
	    dim9: 10;
	    businessPartner: 11;
	    account: 12;
	}
	export type SortEngagesec = keyof SortEngagesec$EnumInterface;
	export const sortEngagesecDatatype: X3EnumDataType<keyof SortEngagesec$EnumInterface, unknown>;
	//# sourceMappingURL=sort-engagesec.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sort-engagenat.d.ts
declare module '@sage/x3-finance-data/lib/enums/sort-engagenat' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortEngagenatEnum {
	    date = 1,
	    dim1 = 2,
	    dim2 = 3,
	    dim3 = 4,
	    dim4 = 5,
	    dim5 = 6,
	    dim6 = 7,
	    dim7 = 8,
	    dim8 = 9,
	    dim9 = 10,
	    businessPartner = 11
	}
	export interface SortEngagenat$EnumInterface {
	    date: 1;
	    dim1: 2;
	    dim2: 3;
	    dim3: 4;
	    dim4: 5;
	    dim5: 6;
	    dim6: 7;
	    dim7: 8;
	    dim8: 9;
	    dim9: 10;
	    businessPartner: 11;
	}
	export type SortEngagenat = keyof SortEngagenat$EnumInterface;
	export const sortEngagenatDatatype: X3EnumDataType<keyof SortEngagenat$EnumInterface, unknown>;
	//# sourceMappingURL=sort-engagenat.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sort-criterion-due-dates.d.ts
declare module '@sage/x3-finance-data/lib/enums/sort-criterion-due-dates' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortCriterionDueDatesEnum {
	    dueDate = 1,
	    businessPartners = 2,
	    bpName = 3,
	    invoiceNumber = 4
	}
	export interface SortCriterionDueDates$EnumInterface {
	    dueDate: 1;
	    businessPartners: 2;
	    bpName: 3;
	    invoiceNumber: 4;
	}
	export type SortCriterionDueDates = keyof SortCriterionDueDates$EnumInterface;
	export const sortCriterionDueDatesDatatype: X3EnumDataType<keyof SortCriterionDueDates$EnumInterface, unknown>;
	//# sourceMappingURL=sort-criterion-due-dates.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sort-criteria.d.ts
declare module '@sage/x3-finance-data/lib/enums/sort-criteria' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortCriteriaEnum {
	    date = 1,
	    match = 2,
	    dueDate = 3
	}
	export interface SortCriteria$EnumInterface {
	    date: 1;
	    match: 2;
	    dueDate: 3;
	}
	export type SortCriteria = keyof SortCriteria$EnumInterface;
	export const sortCriteriaDatatype: X3EnumDataType<keyof SortCriteria$EnumInterface, unknown>;
	//# sourceMappingURL=sort-criteria.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sort-2640.d.ts
declare module '@sage/x3-finance-data/lib/enums/sort-2640' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Sort2640Enum {
	    dimensionsAccounts = 1,
	    accountsDimensions = 2
	}
	export interface Sort2640$EnumInterface {
	    dimensionsAccounts: 1;
	    accountsDimensions: 2;
	}
	export type Sort2640 = keyof Sort2640$EnumInterface;
	export const sort2640Datatype: X3EnumDataType<keyof Sort2640$EnumInterface, unknown>;
	//# sourceMappingURL=sort-2640.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/site-company.d.ts
declare module '@sage/x3-finance-data/lib/enums/site-company' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SiteCompanyEnum {
	    site = 1,
	    company = 2
	}
	export interface SiteCompany$EnumInterface {
	    site: 1;
	    company: 2;
	}
	export type SiteCompany = keyof SiteCompany$EnumInterface;
	export const siteCompanyDatatype: X3EnumDataType<keyof SiteCompany$EnumInterface, unknown>;
	//# sourceMappingURL=site-company.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/single-multi.d.ts
declare module '@sage/x3-finance-data/lib/enums/single-multi' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SingleMultiEnum {
	    mono = 1,
	    multi = 2
	}
	export interface SingleMulti$EnumInterface {
	    mono: 1;
	    multi: 2;
	}
	export type SingleMulti = keyof SingleMulti$EnumInterface;
	export const singleMultiDatatype: X3EnumDataType<keyof SingleMulti$EnumInterface, unknown>;
	//# sourceMappingURL=single-multi.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/simulation-screen-display.d.ts
declare module '@sage/x3-finance-data/lib/enums/simulation-screen-display' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SimulationScreenDisplayEnum {
	    no = 1,
	    yesAlways = 2,
	    yesIfError = 3
	}
	export interface SimulationScreenDisplay$EnumInterface {
	    no: 1;
	    yesAlways: 2;
	    yesIfError: 3;
	}
	export type SimulationScreenDisplay = keyof SimulationScreenDisplay$EnumInterface;
	export const simulationScreenDisplayDatatype: X3EnumDataType<keyof SimulationScreenDisplay$EnumInterface, unknown>;
	//# sourceMappingURL=simulation-screen-display.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sign-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/sign-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SignTypeEnum {
	    debitCredit = 1,
	    negativeAmount = 2
	}
	export interface SignType$EnumInterface {
	    debitCredit: 1;
	    negativeAmount: 2;
	}
	export type SignType = keyof SignType$EnumInterface;
	export const signTypeDatatype: X3EnumDataType<keyof SignType$EnumInterface, unknown>;
	//# sourceMappingURL=sign-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sign-by-default.d.ts
declare module '@sage/x3-finance-data/lib/enums/sign-by-default' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SignByDefaultEnum {
	    debit = 1,
	    credit = 2,
	    unspecified = 3
	}
	export interface SignByDefault$EnumInterface {
	    debit: 1;
	    credit: 2;
	    unspecified: 3;
	}
	export type SignByDefault = keyof SignByDefault$EnumInterface;
	export const signByDefaultDatatype: X3EnumDataType<keyof SignByDefault$EnumInterface, unknown>;
	//# sourceMappingURL=sign-by-default.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sense-of-balance.d.ts
declare module '@sage/x3-finance-data/lib/enums/sense-of-balance' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SenseOfBalanceEnum {
	    debitCredit = 1,
	    creditDebit = 2
	}
	export interface SenseOfBalance$EnumInterface {
	    debitCredit: 1;
	    creditDebit: 2;
	}
	export type SenseOfBalance = keyof SenseOfBalance$EnumInterface;
	export const senseOfBalanceDatatype: X3EnumDataType<keyof SenseOfBalance$EnumInterface, unknown>;
	//# sourceMappingURL=sense-of-balance.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/sage-50-import-transcribe.d.ts
declare module '@sage/x3-finance-data/lib/enums/sage-50-import-transcribe' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Sage50ImportTranscribeEnum {
	    site = 1,
	    account = 2,
	    employeeDimension = 3,
	    costCentreDimension = 4,
	    departmentDimension = 5,
	    aCCodeDimension = 6
	}
	export interface Sage50ImportTranscribe$EnumInterface {
	    site: 1;
	    account: 2;
	    employeeDimension: 3;
	    costCentreDimension: 4;
	    departmentDimension: 5;
	    aCCodeDimension: 6;
	}
	export type Sage50ImportTranscribe = keyof Sage50ImportTranscribe$EnumInterface;
	export const sage50ImportTranscribeDatatype: X3EnumDataType<keyof Sage50ImportTranscribe$EnumInterface, unknown>;
	//# sourceMappingURL=sage-50-import-transcribe.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/review-status.d.ts
declare module '@sage/x3-finance-data/lib/enums/review-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReviewStatusEnum {
	    rejected = 1,
	    requested = 2,
	    approved = 3,
	    cancelled = 4
	}
	export interface ReviewStatus$EnumInterface {
	    rejected: 1;
	    requested: 2;
	    approved: 3;
	    cancelled: 4;
	}
	export type ReviewStatus = keyof ReviewStatus$EnumInterface;
	export const reviewStatusDatatype: X3EnumDataType<keyof ReviewStatus$EnumInterface, unknown>;
	//# sourceMappingURL=review-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/review-processing.d.ts
declare module '@sage/x3-finance-data/lib/enums/review-processing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReviewProcessingEnum {
	    none = 1,
	    review = 2,
	    reject = 3
	}
	export interface ReviewProcessing$EnumInterface {
	    none: 1;
	    review: 2;
	    reject: 3;
	}
	export type ReviewProcessing = keyof ReviewProcessing$EnumInterface;
	export const reviewProcessingDatatype: X3EnumDataType<keyof ReviewProcessing$EnumInterface, unknown>;
	//# sourceMappingURL=review-processing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/reverse-code.d.ts
declare module '@sage/x3-finance-data/lib/enums/reverse-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReverseCodeEnum {
	    no = 1,
	    yes = 2,
	    reversed = 3
	}
	export interface ReverseCode$EnumInterface {
	    no: 1;
	    yes: 2;
	    reversed: 3;
	}
	export type ReverseCode = keyof ReverseCode$EnumInterface;
	export const reverseCodeDatatype: X3EnumDataType<keyof ReverseCode$EnumInterface, unknown>;
	//# sourceMappingURL=reverse-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/revenue-recogniton-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/revenue-recogniton-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RevenueRecognitonTypeEnum {
	    project = 1,
	    dimension = 2
	}
	export interface RevenueRecognitonType$EnumInterface {
	    project: 1;
	    dimension: 2;
	}
	export type RevenueRecognitonType = keyof RevenueRecognitonType$EnumInterface;
	export const revenueRecognitonTypeDatatype: X3EnumDataType<keyof RevenueRecognitonType$EnumInterface, unknown>;
	//# sourceMappingURL=revenue-recogniton-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/revenue-recognition-validation.d.ts
declare module '@sage/x3-finance-data/lib/enums/revenue-recognition-validation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RevenueRecognitionValidationEnum {
	    toBeProcessed = 1,
	    awaitingValidation = 2,
	    validated = 3,
	    posted = 4,
	    postingSimulation = 5
	}
	export interface RevenueRecognitionValidation$EnumInterface {
	    toBeProcessed: 1;
	    awaitingValidation: 2;
	    validated: 3;
	    posted: 4;
	    postingSimulation: 5;
	}
	export type RevenueRecognitionValidation = keyof RevenueRecognitionValidation$EnumInterface;
	export const revenueRecognitionValidationDatatype: X3EnumDataType<keyof RevenueRecognitionValidation$EnumInterface, unknown>;
	//# sourceMappingURL=revenue-recognition-validation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/revenue-recognition-method.d.ts
declare module '@sage/x3-finance-data/lib/enums/revenue-recognition-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RevenueRecognitionMethodEnum {
	    notApplicable = 1,
	    manualPercentageEntry = 2,
	    percentageOfCostsWithEstimatedMarginAtCompletion = 3,
	    percentageOfCostsWithoutEstimatedMarginAtCompletion = 4
	}
	export interface RevenueRecognitionMethod$EnumInterface {
	    notApplicable: 1;
	    manualPercentageEntry: 2;
	    percentageOfCostsWithEstimatedMarginAtCompletion: 3;
	    percentageOfCostsWithoutEstimatedMarginAtCompletion: 4;
	}
	export type RevenueRecognitionMethod = keyof RevenueRecognitionMethod$EnumInterface;
	export const revenueRecognitionMethodDatatype: X3EnumDataType<keyof RevenueRecognitionMethod$EnumInterface, unknown>;
	//# sourceMappingURL=revenue-recognition-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/revenue-recognition-col-types.d.ts
declare module '@sage/x3-finance-data/lib/enums/revenue-recognition-col-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RevenueRecognitionColTypesEnum {
	    estRevenueAtCompletion = 1,
	    actualRevenue = 2,
	    actualCosts = 3,
	    estCostAtCompletion = 4,
	    projectMarginPercentage = 5,
	    percentageOfCompletionInitial = 6,
	    percentageOfCompletion = 7,
	    grossRecognizedRevenue = 8,
	    netRecognizedRevenueInitial = 9,
	    netRecognizedRevenue = 10,
	    grossRecognizedCost = 11,
	    netRecognizedCostInitial = 12,
	    netRecognizedCost = 13,
	    freeColumnType = 14,
	    invoicesToBeIssued = 15,
	    salesAccruals = 16,
	    invoicesToBeReceived = 17,
	    costAccruals = 18
	}
	export interface RevenueRecognitionColTypes$EnumInterface {
	    estRevenueAtCompletion: 1;
	    actualRevenue: 2;
	    actualCosts: 3;
	    estCostAtCompletion: 4;
	    projectMarginPercentage: 5;
	    percentageOfCompletionInitial: 6;
	    percentageOfCompletion: 7;
	    grossRecognizedRevenue: 8;
	    netRecognizedRevenueInitial: 9;
	    netRecognizedRevenue: 10;
	    grossRecognizedCost: 11;
	    netRecognizedCostInitial: 12;
	    netRecognizedCost: 13;
	    freeColumnType: 14;
	    invoicesToBeIssued: 15;
	    salesAccruals: 16;
	    invoicesToBeReceived: 17;
	    costAccruals: 18;
	}
	export type RevenueRecognitionColTypes = keyof RevenueRecognitionColTypes$EnumInterface;
	export const revenueRecognitionColTypesDatatype: X3EnumDataType<keyof RevenueRecognitionColTypes$EnumInterface, unknown>;
	//# sourceMappingURL=revenue-recognition-col-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/resynchronization-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/resynchronization-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ResynchronizationTypeEnum {
	    balanceVerification = 1,
	    glVerification = 2,
	    resynchronization = 3
	}
	export interface ResynchronizationType$EnumInterface {
	    balanceVerification: 1;
	    glVerification: 2;
	    resynchronization: 3;
	}
	export type ResynchronizationType = keyof ResynchronizationType$EnumInterface;
	export const resynchronizationTypeDatatype: X3EnumDataType<keyof ResynchronizationType$EnumInterface, unknown>;
	//# sourceMappingURL=resynchronization-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/restriction-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/restriction-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RestrictionTypeEnum {
	    dimensionDimensionRestriction = 1,
	    accountDimensionRestriction = 2,
	    accountAccountRestriction = 3
	}
	export interface RestrictionType$EnumInterface {
	    dimensionDimensionRestriction: 1;
	    accountDimensionRestriction: 2;
	    accountAccountRestriction: 3;
	}
	export type RestrictionType = keyof RestrictionType$EnumInterface;
	export const restrictionTypeDatatype: X3EnumDataType<keyof RestrictionType$EnumInterface, unknown>;
	//# sourceMappingURL=restriction-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/reporting-status.d.ts
declare module '@sage/x3-finance-data/lib/enums/reporting-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReportingStatusEnum {
	    inReview = 1,
	    validated = 2,
	    closed = 3
	}
	export interface ReportingStatus$EnumInterface {
	    inReview: 1;
	    validated: 2;
	    closed: 3;
	}
	export type ReportingStatus = keyof ReportingStatus$EnumInterface;
	export const reportingStatusDatatype: X3EnumDataType<keyof ReportingStatus$EnumInterface, unknown>;
	//# sourceMappingURL=reporting-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/reporting-period.d.ts
declare module '@sage/x3-finance-data/lib/enums/reporting-period' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReportingPeriodEnum {
	    monthly = 1,
	    quarterly = 2
	}
	export interface ReportingPeriod$EnumInterface {
	    monthly: 1;
	    quarterly: 2;
	}
	export type ReportingPeriod = keyof ReportingPeriod$EnumInterface;
	export const reportingPeriodDatatype: X3EnumDataType<keyof ReportingPeriod$EnumInterface, unknown>;
	//# sourceMappingURL=reporting-period.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/reporting-code-sort.d.ts
declare module '@sage/x3-finance-data/lib/enums/reporting-code-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReportingCodeSortEnum {
	    byAccountRoot = 1,
	    debitCode = 2,
	    creditCode = 3
	}
	export interface ReportingCodeSort$EnumInterface {
	    byAccountRoot: 1;
	    debitCode: 2;
	    creditCode: 3;
	}
	export type ReportingCodeSort = keyof ReportingCodeSort$EnumInterface;
	export const reportingCodeSortDatatype: X3EnumDataType<keyof ReportingCodeSort$EnumInterface, unknown>;
	//# sourceMappingURL=reporting-code-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/report-type-vat-reporting.d.ts
declare module '@sage/x3-finance-data/lib/enums/report-type-vat-reporting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReportTypeVatReportingEnum {
	    vatDeclaration = 1,
	    recapitulativeStatement = 2
	}
	export interface ReportTypeVatReporting$EnumInterface {
	    vatDeclaration: 1;
	    recapitulativeStatement: 2;
	}
	export type ReportTypeVatReporting = keyof ReportTypeVatReporting$EnumInterface;
	export const reportTypeVatReportingDatatype: X3EnumDataType<keyof ReportTypeVatReporting$EnumInterface, unknown>;
	//# sourceMappingURL=report-type-vat-reporting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/renewal-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/renewal-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RenewalTypeEnum {
	    normal = 1,
	    commitmentCarriedForward = 2
	}
	export interface RenewalType$EnumInterface {
	    normal: 1;
	    commitmentCarriedForward: 2;
	}
	export type RenewalType = keyof RenewalType$EnumInterface;
	export const renewalTypeDatatype: X3EnumDataType<keyof RenewalType$EnumInterface, unknown>;
	//# sourceMappingURL=renewal-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/recurring-journal-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/recurring-journal-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecurringJournalTypeEnum {
	    fixed = 1,
	    variable = 2
	}
	export interface RecurringJournalType$EnumInterface {
	    fixed: 1;
	    variable: 2;
	}
	export type RecurringJournalType = keyof RecurringJournalType$EnumInterface;
	export const recurringJournalTypeDatatype: X3EnumDataType<keyof RecurringJournalType$EnumInterface, unknown>;
	//# sourceMappingURL=recurring-journal-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/record-type-2652.d.ts
declare module '@sage/x3-finance-data/lib/enums/record-type-2652' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecordType2652Enum {
	    enteredLine = 1,
	    extractedLine = 2
	}
	export interface RecordType2652$EnumInterface {
	    enteredLine: 1;
	    extractedLine: 2;
	}
	export type RecordType2652 = keyof RecordType2652$EnumInterface;
	export const recordType2652Datatype: X3EnumDataType<keyof RecordType2652$EnumInterface, unknown>;
	//# sourceMappingURL=record-type-2652.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/receipt-status.d.ts
declare module '@sage/x3-finance-data/lib/enums/receipt-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReceiptStatusEnum {
	    normalReceipt = 1,
	    receiptCanceled = 2
	}
	export interface ReceiptStatus$EnumInterface {
	    normalReceipt: 1;
	    receiptCanceled: 2;
	}
	export type ReceiptStatus = keyof ReceiptStatus$EnumInterface;
	export const receiptStatusDatatype: X3EnumDataType<keyof ReceiptStatus$EnumInterface, unknown>;
	//# sourceMappingURL=receipt-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/receipt-communication-status.d.ts
declare module '@sage/x3-finance-data/lib/enums/receipt-communication-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReceiptCommunicationStatusEnum {
	    entered = 1,
	    printed = 2,
	    communicated = 3
	}
	export interface ReceiptCommunicationStatus$EnumInterface {
	    entered: 1;
	    printed: 2;
	    communicated: 3;
	}
	export type ReceiptCommunicationStatus = keyof ReceiptCommunicationStatus$EnumInterface;
	export const receiptCommunicationStatusDatatype: X3EnumDataType<keyof ReceiptCommunicationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=receipt-communication-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/reason-for-action.d.ts
declare module '@sage/x3-finance-data/lib/enums/reason-for-action' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReasonForActionEnum {
	    creation = 1,
	    modification = 2,
	    deletion = 3,
	    closing = 4,
	    reversal = 5,
	    closingCancellation = 6,
	    carryforward = 7,
	    resynchronization = 8
	}
	export interface ReasonForAction$EnumInterface {
	    creation: 1;
	    modification: 2;
	    deletion: 3;
	    closing: 4;
	    reversal: 5;
	    closingCancellation: 6;
	    carryforward: 7;
	    resynchronization: 8;
	}
	export type ReasonForAction = keyof ReasonForAction$EnumInterface;
	export const reasonForActionDatatype: X3EnumDataType<keyof ReasonForAction$EnumInterface, unknown>;
	//# sourceMappingURL=reason-for-action.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/prorata-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/prorata-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProrataTypeEnum {
	    e = 1,
	    g = 2
	}
	export interface ProrataType$EnumInterface {
	    e: 1;
	    g: 2;
	}
	export type ProrataType = keyof ProrataType$EnumInterface;
	export const prorataTypeDatatype: X3EnumDataType<keyof ProrataType$EnumInterface, unknown>;
	//# sourceMappingURL=prorata-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/processed-records-selection.d.ts
declare module '@sage/x3-finance-data/lib/enums/processed-records-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessedRecordsSelectionEnum {
	    process = 1,
	    doNotProcess = 2,
	    all = 3
	}
	export interface ProcessedRecordsSelection$EnumInterface {
	    process: 1;
	    doNotProcess: 2;
	    all: 3;
	}
	export type ProcessedRecordsSelection = keyof ProcessedRecordsSelection$EnumInterface;
	export const processedRecordsSelectionDatatype: X3EnumDataType<keyof ProcessedRecordsSelection$EnumInterface, unknown>;
	//# sourceMappingURL=processed-records-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/process-type-3644.d.ts
declare module '@sage/x3-finance-data/lib/enums/process-type-3644' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessType3644Enum {
	    payments = 1,
	    openItems = 2,
	    both = 3
	}
	export interface ProcessType3644$EnumInterface {
	    payments: 1;
	    openItems: 2;
	    both: 3;
	}
	export type ProcessType3644 = keyof ProcessType3644$EnumInterface;
	export const processType3644Datatype: X3EnumDataType<keyof ProcessType3644$EnumInterface, unknown>;
	//# sourceMappingURL=process-type-3644.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/printing.d.ts
declare module '@sage/x3-finance-data/lib/enums/printing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrintingEnum {
	    printing = 1,
	    inquiry = 2
	}
	export interface Printing$EnumInterface {
	    printing: 1;
	    inquiry: 2;
	}
	export type Printing = keyof Printing$EnumInterface;
	export const printingDatatype: X3EnumDataType<keyof Printing$EnumInterface, unknown>;
	//# sourceMappingURL=printing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/print-format.d.ts
declare module '@sage/x3-finance-data/lib/enums/print-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrintFormatEnum {
	    normal = 1,
	    bold = 2,
	    italic = 3,
	    underlined = 4,
	    boldUnderlined = 5,
	    italicUnderlined = 6
	}
	export interface PrintFormat$EnumInterface {
	    normal: 1;
	    bold: 2;
	    italic: 3;
	    underlined: 4;
	    boldUnderlined: 5;
	    italicUnderlined: 6;
	}
	export type PrintFormat = keyof PrintFormat$EnumInterface;
	export const printFormatDatatype: X3EnumDataType<keyof PrintFormat$EnumInterface, unknown>;
	//# sourceMappingURL=print-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/print-format-872.d.ts
declare module '@sage/x3-finance-data/lib/enums/print-format-872' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrintFormat872Enum {
	    normal = 1,
	    bold = 2,
	    italic = 3,
	    boldItalic = 4
	}
	export interface PrintFormat872$EnumInterface {
	    normal: 1;
	    bold: 2;
	    italic: 3;
	    boldItalic: 4;
	}
	export type PrintFormat872 = keyof PrintFormat872$EnumInterface;
	export const printFormat872Datatype: X3EnumDataType<keyof PrintFormat872$EnumInterface, unknown>;
	//# sourceMappingURL=print-format-872.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/print-effect.d.ts
declare module '@sage/x3-finance-data/lib/enums/print-effect' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrintEffectEnum {
	    normal = 1,
	    strikethrough = 2,
	    underlined = 3
	}
	export interface PrintEffect$EnumInterface {
	    normal: 1;
	    strikethrough: 2;
	    underlined: 3;
	}
	export type PrintEffect = keyof PrintEffect$EnumInterface;
	export const printEffectDatatype: X3EnumDataType<keyof PrintEffect$EnumInterface, unknown>;
	//# sourceMappingURL=print-effect.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/print-currency.d.ts
declare module '@sage/x3-finance-data/lib/enums/print-currency' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrintCurrencyEnum {
	    ledgerCurrency = 1,
	    selectionCurrency = 2
	}
	export interface PrintCurrency$EnumInterface {
	    ledgerCurrency: 1;
	    selectionCurrency: 2;
	}
	export type PrintCurrency = keyof PrintCurrency$EnumInterface;
	export const printCurrencyDatatype: X3EnumDataType<keyof PrintCurrency$EnumInterface, unknown>;
	//# sourceMappingURL=print-currency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/posting-vat-entities.d.ts
declare module '@sage/x3-finance-data/lib/enums/posting-vat-entities' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PostingVatEntitiesEnum {
	    notManaged = 1,
	    toBePosted = 2,
	    withMatching = 3
	}
	export interface PostingVatEntities$EnumInterface {
	    notManaged: 1;
	    toBePosted: 2;
	    withMatching: 3;
	}
	export type PostingVatEntities = keyof PostingVatEntities$EnumInterface;
	export const postingVatEntitiesDatatype: X3EnumDataType<keyof PostingVatEntities$EnumInterface, unknown>;
	//# sourceMappingURL=posting-vat-entities.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/posting-status.d.ts
declare module '@sage/x3-finance-data/lib/enums/posting-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PostingStatusEnum {
	    notManaged = 1,
	    toBePosted = 2,
	    posted = 3
	}
	export interface PostingStatus$EnumInterface {
	    notManaged: 1;
	    toBePosted: 2;
	    posted: 3;
	}
	export type PostingStatus = keyof PostingStatus$EnumInterface;
	export const postingStatusDatatype: X3EnumDataType<keyof PostingStatus$EnumInterface, unknown>;
	//# sourceMappingURL=posting-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/posting-level.d.ts
declare module '@sage/x3-finance-data/lib/enums/posting-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PostingLevelEnum {
	    summary = 1,
	    detail = 2
	}
	export interface PostingLevel$EnumInterface {
	    summary: 1;
	    detail: 2;
	}
	export type PostingLevel = keyof PostingLevel$EnumInterface;
	export const postingLevelDatatype: X3EnumDataType<keyof PostingLevel$EnumInterface, unknown>;
	//# sourceMappingURL=posting-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/periodicity.d.ts
declare module '@sage/x3-finance-data/lib/enums/periodicity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PeriodicityEnum {
	    monthly = 1,
	    quarterly = 2,
	    yearly = 3,
	    biMonthly = 4,
	    notPeriodic = 5
	}
	export interface Periodicity$EnumInterface {
	    monthly: 1;
	    quarterly: 2;
	    yearly: 3;
	    biMonthly: 4;
	    notPeriodic: 5;
	}
	export type Periodicity = keyof Periodicity$EnumInterface;
	export const periodicityDatatype: X3EnumDataType<keyof Periodicity$EnumInterface, unknown>;
	//# sourceMappingURL=periodicity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/period-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/period-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PeriodTypeEnum {
	    normal = 1,
	    opening = 2,
	    closing = 3
	}
	export interface PeriodType$EnumInterface {
	    normal: 1;
	    opening: 2;
	    closing: 3;
	}
	export type PeriodType = keyof PeriodType$EnumInterface;
	export const periodTypeDatatype: X3EnumDataType<keyof PeriodType$EnumInterface, unknown>;
	//# sourceMappingURL=period-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/payment-transaction-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/payment-transaction-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentTransactionTypeEnum {
	    none = 1,
	    lcr = 2,
	    pre = 3,
	    vir = 4,
	    sct = 5,
	    sdd = 6
	}
	export interface PaymentTransactionType$EnumInterface {
	    none: 1;
	    lcr: 2;
	    pre: 3;
	    vir: 4;
	    sct: 5;
	    sdd: 6;
	}
	export type PaymentTransactionType = keyof PaymentTransactionType$EnumInterface;
	export const paymentTransactionTypeDatatype: X3EnumDataType<keyof PaymentTransactionType$EnumInterface, unknown>;
	//# sourceMappingURL=payment-transaction-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/payment-status.d.ts
declare module '@sage/x3-finance-data/lib/enums/payment-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentStatusEnum {
	    entered = 1,
	    accepted = 2,
	    postedNotesPayableReceivable = 3,
	    stage4 = 4,
	    slipEntered = 5,
	    slipOnFile = 6,
	    paymentOrderEntered = 7,
	    onIntermediateAccount = 8,
	    inTheBank = 9,
	    notesPRRiskClosing = 10,
	    unpaid = 11
	}
	export interface PaymentStatus$EnumInterface {
	    entered: 1;
	    accepted: 2;
	    postedNotesPayableReceivable: 3;
	    stage4: 4;
	    slipEntered: 5;
	    slipOnFile: 6;
	    paymentOrderEntered: 7;
	    onIntermediateAccount: 8;
	    inTheBank: 9;
	    notesPRRiskClosing: 10;
	    unpaid: 11;
	}
	export type PaymentStatus = keyof PaymentStatus$EnumInterface;
	export const paymentStatusDatatype: X3EnumDataType<keyof PaymentStatus$EnumInterface, unknown>;
	//# sourceMappingURL=payment-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/payment-mode.d.ts
declare module '@sage/x3-finance-data/lib/enums/payment-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentModeEnum {
	    inCash = 1,
	    debitedFromBankAccount = 2
	}
	export interface PaymentMode$EnumInterface {
	    inCash: 1;
	    debitedFromBankAccount: 2;
	}
	export type PaymentMode = keyof PaymentMode$EnumInterface;
	export const paymentModeDatatype: X3EnumDataType<keyof PaymentMode$EnumInterface, unknown>;
	//# sourceMappingURL=payment-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/payment-balance-line-flag.d.ts
declare module '@sage/x3-finance-data/lib/enums/payment-balance-line-flag' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaymentBalanceLineFlagEnum {
	    create = 1,
	    delete = 2,
	    modify = 3
	}
	export interface PaymentBalanceLineFlag$EnumInterface {
	    create: 1;
	    delete: 2;
	    modify: 3;
	}
	export type PaymentBalanceLineFlag = keyof PaymentBalanceLineFlag$EnumInterface;
	export const paymentBalanceLineFlagDatatype: X3EnumDataType<keyof PaymentBalanceLineFlag$EnumInterface, unknown>;
	//# sourceMappingURL=payment-balance-line-flag.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/partial-payment.d.ts
declare module '@sage/x3-finance-data/lib/enums/partial-payment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PartialPaymentEnum {
	    proportional = 1,
	    onTheFirstPayment = 2
	}
	export interface PartialPayment$EnumInterface {
	    proportional: 1;
	    onTheFirstPayment: 2;
	}
	export type PartialPayment = keyof PartialPayment$EnumInterface;
	export const partialPaymentDatatype: X3EnumDataType<keyof PartialPayment$EnumInterface, unknown>;
	//# sourceMappingURL=partial-payment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/orientation-3645.d.ts
declare module '@sage/x3-finance-data/lib/enums/orientation-3645' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Orientation3645Enum {
	    creditIncomingAndDebitOutgoing = 1,
	    creditOutgoingAndDebitIncoming = 2
	}
	export interface Orientation3645$EnumInterface {
	    creditIncomingAndDebitOutgoing: 1;
	    creditOutgoingAndDebitIncoming: 2;
	}
	export type Orientation3645 = keyof Orientation3645$EnumInterface;
	export const orientation3645Datatype: X3EnumDataType<keyof Orientation3645$EnumInterface, unknown>;
	//# sourceMappingURL=orientation-3645.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/notes-pr-portfolio-update.d.ts
declare module '@sage/x3-finance-data/lib/enums/notes-pr-portfolio-update' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NotesPRPortfolioUpdateEnum {
	    no = 1,
	    notesPR1 = 2,
	    notesPR2 = 3,
	    notesPR3 = 4
	}
	export interface NotesPRPortfolioUpdate$EnumInterface {
	    no: 1;
	    notesPR1: 2;
	    notesPR2: 3;
	    notesPR3: 4;
	}
	export type NotesPRPortfolioUpdate = keyof NotesPRPortfolioUpdate$EnumInterface;
	export const notesPrPortfolioUpdateDatatype: X3EnumDataType<keyof NotesPRPortfolioUpdate$EnumInterface, unknown>;
	//# sourceMappingURL=notes-pr-portfolio-update.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/no-yes-unspecified.d.ts
declare module '@sage/x3-finance-data/lib/enums/no-yes-unspecified' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NoYesUnspecifiedEnum {
	    no = 1,
	    yes = 2,
	    unspecified = 3
	}
	export interface NoYesUnspecified$EnumInterface {
	    no: 1;
	    yes: 2;
	    unspecified: 3;
	}
	export type NoYesUnspecified = keyof NoYesUnspecified$EnumInterface;
	export const noYesUnspecifiedDatatype: X3EnumDataType<keyof NoYesUnspecified$EnumInterface, unknown>;
	//# sourceMappingURL=no-yes-unspecified.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/medium-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/medium-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MediumTypeEnum {
	    telematic = 1,
	    cdR = 2,
	    form = 3
	}
	export interface MediumType$EnumInterface {
	    telematic: 1;
	    cdR: 2;
	    form: 3;
	}
	export type MediumType = keyof MediumType$EnumInterface;
	export const mediumTypeDatatype: X3EnumDataType<keyof MediumType$EnumInterface, unknown>;
	//# sourceMappingURL=medium-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/matching-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/matching-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MatchingTypeEnum {
	    uppercaseLetter = 1,
	    lowercaseLetter = 2,
	    uppercaseAndLowercaseLetter = 3
	}
	export interface MatchingType$EnumInterface {
	    uppercaseLetter: 1;
	    lowercaseLetter: 2;
	    uppercaseAndLowercaseLetter: 3;
	}
	export type MatchingType = keyof MatchingType$EnumInterface;
	export const matchingTypeDatatype: X3EnumDataType<keyof MatchingType$EnumInterface, unknown>;
	//# sourceMappingURL=matching-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/matching-method.d.ts
declare module '@sage/x3-finance-data/lib/enums/matching-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MatchingMethodEnum {
	    byAmount = 1,
	    byAmountInCurrencies = 2,
	    transferToTheBalance = 3,
	    searchForBalance = 4,
	    byReferenceField = 5,
	    byDescriptionField = 6,
	    byFreeReferenceField = 7
	}
	export interface MatchingMethod$EnumInterface {
	    byAmount: 1;
	    byAmountInCurrencies: 2;
	    transferToTheBalance: 3;
	    searchForBalance: 4;
	    byReferenceField: 5;
	    byDescriptionField: 6;
	    byFreeReferenceField: 7;
	}
	export type MatchingMethod = keyof MatchingMethod$EnumInterface;
	export const matchingMethodDatatype: X3EnumDataType<keyof MatchingMethod$EnumInterface, unknown>;
	//# sourceMappingURL=matching-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/mandatory-no.d.ts
declare module '@sage/x3-finance-data/lib/enums/mandatory-no' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MandatoryNoEnum {
	    mandatory = 1,
	    optional = 2,
	    notEntered = 3
	}
	export interface MandatoryNo$EnumInterface {
	    mandatory: 1;
	    optional: 2;
	    notEntered: 3;
	}
	export type MandatoryNo = keyof MandatoryNo$EnumInterface;
	export const mandatoryNoDatatype: X3EnumDataType<keyof MandatoryNo$EnumInterface, unknown>;
	//# sourceMappingURL=mandatory-no.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/local-menu-601.d.ts
declare module '@sage/x3-finance-data/lib/enums/local-menu-601' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LocalMenu601Enum {
	    dummyValue = 0
	}
	export interface LocalMenu601$EnumInterface {
	    dummyValue: 0;
	}
	export type LocalMenu601 = keyof LocalMenu601$EnumInterface;
	export const localMenu601Datatype: X3EnumDataType<"dummyValue", unknown>;
	//# sourceMappingURL=local-menu-601.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/ledger-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/ledger-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LedgerTypeEnum {
	    notApplicable = 1,
	    sncBase = 2,
	    iasIfrsStandards = 3,
	    snsMicroEntities = 4,
	    others = 5
	}
	export interface LedgerType$EnumInterface {
	    notApplicable: 1;
	    sncBase: 2;
	    iasIfrsStandards: 3;
	    snsMicroEntities: 4;
	    others: 5;
	}
	export type LedgerType = keyof LedgerType$EnumInterface;
	export const ledgerTypeDatatype: X3EnumDataType<keyof LedgerType$EnumInterface, unknown>;
	//# sourceMappingURL=ledger-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/ledger-in-currencies.d.ts
declare module '@sage/x3-finance-data/lib/enums/ledger-in-currencies' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LedgerInCurrenciesEnum {
	    currencyCompany = 1,
	    currencyReporting = 2,
	    companyReporting = 3
	}
	export interface LedgerInCurrencies$EnumInterface {
	    currencyCompany: 1;
	    currencyReporting: 2;
	    companyReporting: 3;
	}
	export type LedgerInCurrencies = keyof LedgerInCurrencies$EnumInterface;
	export const ledgerInCurrenciesDatatype: X3EnumDataType<keyof LedgerInCurrencies$EnumInterface, unknown>;
	//# sourceMappingURL=ledger-in-currencies.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/ledger-authorizations.d.ts
declare module '@sage/x3-finance-data/lib/enums/ledger-authorizations' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LedgerAuthorizationsEnum {
	    none = 1,
	    authorized = 2,
	    mandatory = 3
	}
	export interface LedgerAuthorizations$EnumInterface {
	    none: 1;
	    authorized: 2;
	    mandatory: 3;
	}
	export type LedgerAuthorizations = keyof LedgerAuthorizations$EnumInterface;
	export const ledgerAuthorizationsDatatype: X3EnumDataType<keyof LedgerAuthorizations$EnumInterface, unknown>;
	//# sourceMappingURL=ledger-authorizations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/launch-periodicity.d.ts
declare module '@sage/x3-finance-data/lib/enums/launch-periodicity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LaunchPeriodicityEnum {
	    everyDay = 1,
	    everyWeek = 2,
	    everyMonth = 3
	}
	export interface LaunchPeriodicity$EnumInterface {
	    everyDay: 1;
	    everyWeek: 2;
	    everyMonth: 3;
	}
	export type LaunchPeriodicity = keyof LaunchPeriodicity$EnumInterface;
	export const launchPeriodicityDatatype: X3EnumDataType<keyof LaunchPeriodicity$EnumInterface, unknown>;
	//# sourceMappingURL=launch-periodicity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/journal-types.d.ts
declare module '@sage/x3-finance-data/lib/enums/journal-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum JournalTypesEnum {
	    bank = 1,
	    checkToCash = 2,
	    notesPayableToReceive = 3,
	    notesPayableOnPurchases = 4,
	    notesPayableOnFixedAssets = 5,
	    remittanceForCollection = 6,
	    remittanceForDiscount = 7,
	    notesPRRiskClosing = 8,
	    none = 9
	}
	export interface JournalTypes$EnumInterface {
	    bank: 1;
	    checkToCash: 2;
	    notesPayableToReceive: 3;
	    notesPayableOnPurchases: 4;
	    notesPayableOnFixedAssets: 5;
	    remittanceForCollection: 6;
	    remittanceForDiscount: 7;
	    notesPRRiskClosing: 8;
	    none: 9;
	}
	export type JournalTypes = keyof JournalTypes$EnumInterface;
	export const journalTypesDatatype: X3EnumDataType<keyof JournalTypes$EnumInterface, unknown>;
	//# sourceMappingURL=journal-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/journal-type-613.d.ts
declare module '@sage/x3-finance-data/lib/enums/journal-type-613' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum JournalType613Enum {
	    sales = 1,
	    purchasing = 2,
	    treasury = 3,
	    miscOperations1 = 4,
	    miscOperations2 = 5,
	    miscOperations3 = 6,
	    carryforward = 7,
	    miscOperations4 = 8,
	    generalJournal = 9,
	    miscOperations6 = 10
	}
	export interface JournalType613$EnumInterface {
	    sales: 1;
	    purchasing: 2;
	    treasury: 3;
	    miscOperations1: 4;
	    miscOperations2: 5;
	    miscOperations3: 6;
	    carryforward: 7;
	    miscOperations4: 8;
	    generalJournal: 9;
	    miscOperations6: 10;
	}
	export type JournalType613 = keyof JournalType613$EnumInterface;
	export const journalType613Datatype: X3EnumDataType<keyof JournalType613$EnumInterface, unknown>;
	//# sourceMappingURL=journal-type-613.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/journal-generation-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/journal-generation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum JournalGenerationTypeEnum {
	    payment = 1,
	    remittancePaymentOrder = 2,
	    dueDate = 3
	}
	export interface JournalGenerationType$EnumInterface {
	    payment: 1;
	    remittancePaymentOrder: 2;
	    dueDate: 3;
	}
	export type JournalGenerationType = keyof JournalGenerationType$EnumInterface;
	export const journalGenerationTypeDatatype: X3EnumDataType<keyof JournalGenerationType$EnumInterface, unknown>;
	//# sourceMappingURL=journal-generation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/journal-category.d.ts
declare module '@sage/x3-finance-data/lib/enums/journal-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum JournalCategoryEnum {
	    normal = 1,
	    carryforward = 2,
	    closing = 3
	}
	export interface JournalCategory$EnumInterface {
	    normal: 1;
	    carryforward: 2;
	    closing: 3;
	}
	export type JournalCategory = keyof JournalCategory$EnumInterface;
	export const journalCategoryDatatype: X3EnumDataType<keyof JournalCategory$EnumInterface, unknown>;
	//# sourceMappingURL=journal-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/invoice-header-amount-control.d.ts
declare module '@sage/x3-finance-data/lib/enums/invoice-header-amount-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceHeaderAmountControlEnum {
	    exTaxAndTaxInclAmountsOptional = 1,
	    exTaxAndTaxInclAmountsToBeEntered = 2
	}
	export interface InvoiceHeaderAmountControl$EnumInterface {
	    exTaxAndTaxInclAmountsOptional: 1;
	    exTaxAndTaxInclAmountsToBeEntered: 2;
	}
	export type InvoiceHeaderAmountControl = keyof InvoiceHeaderAmountControl$EnumInterface;
	export const invoiceHeaderAmountControlDatatype: X3EnumDataType<keyof InvoiceHeaderAmountControl$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-header-amount-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/instruction-keys-ezag.d.ts
declare module '@sage/x3-finance-data/lib/enums/instruction-keys-ezag' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InstructionKeysEzagEnum {
	    none = 1,
	    personally = 2,
	    urgent = 3
	}
	export interface InstructionKeysEzag$EnumInterface {
	    none: 1;
	    personally: 2;
	    urgent: 3;
	}
	export type InstructionKeysEzag = keyof InstructionKeysEzag$EnumInterface;
	export const instructionKeysEzagDatatype: X3EnumDataType<keyof InstructionKeysEzag$EnumInterface, unknown>;
	//# sourceMappingURL=instruction-keys-ezag.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/instruction-keys-dta.d.ts
declare module '@sage/x3-finance-data/lib/enums/instruction-keys-dta' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InstructionKeysDtaEnum {
	    none = 1,
	    salaryPension = 2
	}
	export interface InstructionKeysDta$EnumInterface {
	    none: 1;
	    salaryPension: 2;
	}
	export type InstructionKeysDta = keyof InstructionKeysDta$EnumInterface;
	export const instructionKeysDtaDatatype: X3EnumDataType<keyof InstructionKeysDta$EnumInterface, unknown>;
	//# sourceMappingURL=instruction-keys-dta.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/indicateur-operations.d.ts
declare module '@sage/x3-finance-data/lib/enums/indicateur-operations' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IndicateurOperationsEnum {
	    create = 1,
	    delete = 2,
	    modify = 3
	}
	export interface IndicateurOperations$EnumInterface {
	    create: 1;
	    delete: 2;
	    modify: 3;
	}
	export type IndicateurOperations = keyof IndicateurOperations$EnumInterface;
	export const indicateurOperationsDatatype: X3EnumDataType<keyof IndicateurOperations$EnumInterface, unknown>;
	//# sourceMappingURL=indicateur-operations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/index.d.ts
declare module '@sage/x3-finance-data/lib/enums/index' {
	export * from '@sage/x3-finance-data/lib/enums/acc-sequence-nos';
	export * from '@sage/x3-finance-data/lib/enums/acceptance-code';
	export * from '@sage/x3-finance-data/lib/enums/account-category-1';
	export * from '@sage/x3-finance-data/lib/enums/account-category-2';
	export * from '@sage/x3-finance-data/lib/enums/account-category';
	export * from '@sage/x3-finance-data/lib/enums/account-dimension-value';
	export * from '@sage/x3-finance-data/lib/enums/account-setup-sort';
	export * from '@sage/x3-finance-data/lib/enums/account-sort-676';
	export * from '@sage/x3-finance-data/lib/enums/account-sort';
	export * from '@sage/x3-finance-data/lib/enums/account-specific-text-853';
	export * from '@sage/x3-finance-data/lib/enums/account-status';
	export * from '@sage/x3-finance-data/lib/enums/account-type-2668';
	export * from '@sage/x3-finance-data/lib/enums/account-type-605';
	export * from '@sage/x3-finance-data/lib/enums/accounting-journal-status';
	export * from '@sage/x3-finance-data/lib/enums/accounting-sign';
	export * from '@sage/x3-finance-data/lib/enums/accounting-types';
	export * from '@sage/x3-finance-data/lib/enums/accruals-generation-type';
	export * from '@sage/x3-finance-data/lib/enums/action-type-8341';
	export * from '@sage/x3-finance-data/lib/enums/activate-deactivate';
	export * from '@sage/x3-finance-data/lib/enums/actual-budgeted';
	export * from '@sage/x3-finance-data/lib/enums/actual-simulation';
	export * from '@sage/x3-finance-data/lib/enums/aligning';
	export * from '@sage/x3-finance-data/lib/enums/allocated-document';
	export * from '@sage/x3-finance-data/lib/enums/allocated-journal';
	export * from '@sage/x3-finance-data/lib/enums/amount-type-686';
	export * from '@sage/x3-finance-data/lib/enums/amounts-quantities';
	export * from '@sage/x3-finance-data/lib/enums/amounts-to-be-displayed-3606';
	export * from '@sage/x3-finance-data/lib/enums/amounts-to-be-displayed';
	export * from '@sage/x3-finance-data/lib/enums/analytical-axis-entry';
	export * from '@sage/x3-finance-data/lib/enums/analytical-balance-sort';
	export * from '@sage/x3-finance-data/lib/enums/analytical-balances';
	export * from '@sage/x3-finance-data/lib/enums/analytical-category';
	export * from '@sage/x3-finance-data/lib/enums/analytical-data-entry';
	export * from '@sage/x3-finance-data/lib/enums/analytical-pyramids';
	export * from '@sage/x3-finance-data/lib/enums/analytical-resync-type';
	export * from '@sage/x3-finance-data/lib/enums/analytical-sense';
	export * from '@sage/x3-finance-data/lib/enums/approval-level';
	export * from '@sage/x3-finance-data/lib/enums/approval-processing';
	export * from '@sage/x3-finance-data/lib/enums/assessment-method';
	export * from '@sage/x3-finance-data/lib/enums/automatic-line-type';
	export * from '@sage/x3-finance-data/lib/enums/auxiliary-account-sort';
	export * from '@sage/x3-finance-data/lib/enums/bad-debt-management-rules';
	export * from '@sage/x3-finance-data/lib/enums/balance-payment-account-type';
	export * from '@sage/x3-finance-data/lib/enums/balance-sort';
	export * from '@sage/x3-finance-data/lib/enums/balance-update';
	export * from '@sage/x3-finance-data/lib/enums/bank-assignment-method';
	export * from '@sage/x3-finance-data/lib/enums/bank-charge-bearer';
	export * from '@sage/x3-finance-data/lib/enums/bank-reconciliation-option';
	export * from '@sage/x3-finance-data/lib/enums/bank-sort';
	export * from '@sage/x3-finance-data/lib/enums/bank-statement-source';
	export * from '@sage/x3-finance-data/lib/enums/batch-field-description';
	export * from '@sage/x3-finance-data/lib/enums/benefit-type';
	export * from '@sage/x3-finance-data/lib/enums/box-type';
	export * from '@sage/x3-finance-data/lib/enums/budget-category-2692';
	export * from '@sage/x3-finance-data/lib/enums/budget-category';
	export * from '@sage/x3-finance-data/lib/enums/budget-control-level';
	export * from '@sage/x3-finance-data/lib/enums/budget-definition-level';
	export * from '@sage/x3-finance-data/lib/enums/budget-document-type';
	export * from '@sage/x3-finance-data/lib/enums/budget-overrun';
	export * from '@sage/x3-finance-data/lib/enums/budget-statistical-group';
	export * from '@sage/x3-finance-data/lib/enums/budgetary-control-type-648';
	export * from '@sage/x3-finance-data/lib/enums/budgetary-control-type';
	export * from '@sage/x3-finance-data/lib/enums/budgetary-gl-management';
	export * from '@sage/x3-finance-data/lib/enums/building-location';
	export * from '@sage/x3-finance-data/lib/enums/business-partner-journal-type';
	export * from '@sage/x3-finance-data/lib/enums/business-partner-type-672';
	export * from '@sage/x3-finance-data/lib/enums/business-partner-type';
	export * from '@sage/x3-finance-data/lib/enums/cash-flow-interface';
	export * from '@sage/x3-finance-data/lib/enums/cash-interface-2675';
	export * from '@sage/x3-finance-data/lib/enums/cash-interface';
	export * from '@sage/x3-finance-data/lib/enums/category-formats';
	export * from '@sage/x3-finance-data/lib/enums/chart-of-accounts-enum';
	export * from '@sage/x3-finance-data/lib/enums/check-type';
	export * from '@sage/x3-finance-data/lib/enums/child-unit-in-declaration';
	export * from '@sage/x3-finance-data/lib/enums/closing-type';
	export * from '@sage/x3-finance-data/lib/enums/column-information';
	export * from '@sage/x3-finance-data/lib/enums/column-type';
	export * from '@sage/x3-finance-data/lib/enums/commitment-type-631';
	export * from '@sage/x3-finance-data/lib/enums/company-activity-type';
	export * from '@sage/x3-finance-data/lib/enums/control-account';
	export * from '@sage/x3-finance-data/lib/enums/control-type-2600';
	export * from '@sage/x3-finance-data/lib/enums/control-type-2625';
	export * from '@sage/x3-finance-data/lib/enums/country-address-code';
	export * from '@sage/x3-finance-data/lib/enums/cre-sending-medium-type-code';
	export * from '@sage/x3-finance-data/lib/enums/crystal-reports-acc-contd';
	export * from '@sage/x3-finance-data/lib/enums/currency-2606';
	export * from '@sage/x3-finance-data/lib/enums/currency-3643';
	export * from '@sage/x3-finance-data/lib/enums/currency-enum';
	export * from '@sage/x3-finance-data/lib/enums/customer-aged-balance-field';
	export * from '@sage/x3-finance-data/lib/enums/date-basis-for-aging';
	export * from '@sage/x3-finance-data/lib/enums/datev-account-modification-3655';
	export * from '@sage/x3-finance-data/lib/enums/datev-account-modification';
	export * from '@sage/x3-finance-data/lib/enums/datev-bp-copy';
	export * from '@sage/x3-finance-data/lib/enums/datev-invoice-fields';
	export * from '@sage/x3-finance-data/lib/enums/debit-credit';
	export * from '@sage/x3-finance-data/lib/enums/declaration-type';
	export * from '@sage/x3-finance-data/lib/enums/definition-level-2696';
	export * from '@sage/x3-finance-data/lib/enums/delay-calculation-date';
	export * from '@sage/x3-finance-data/lib/enums/deposit-type';
	export * from '@sage/x3-finance-data/lib/enums/detail-level';
	export * from '@sage/x3-finance-data/lib/enums/dimension-view-setup-sort';
	export * from '@sage/x3-finance-data/lib/enums/discount-calculation-date';
	export * from '@sage/x3-finance-data/lib/enums/discount-form-type';
	export * from '@sage/x3-finance-data/lib/enums/display-mode';
	export * from '@sage/x3-finance-data/lib/enums/document-reason';
	export * from '@sage/x3-finance-data/lib/enums/due-date-cancellation';
	export * from '@sage/x3-finance-data/lib/enums/due-date-item-type';
	export * from '@sage/x3-finance-data/lib/enums/entered-calculated';
	export * from '@sage/x3-finance-data/lib/enums/entry-origin';
	export * from '@sage/x3-finance-data/lib/enums/entry-type-2646';
	export * from '@sage/x3-finance-data/lib/enums/entry-type-628';
	export * from '@sage/x3-finance-data/lib/enums/entry-type-692';
	export * from '@sage/x3-finance-data/lib/enums/enum-1099-account';
	export * from '@sage/x3-finance-data/lib/enums/enum-1099-declaration-mode';
	export * from '@sage/x3-finance-data/lib/enums/enum-1099-form';
	export * from '@sage/x3-finance-data/lib/enums/enum-1099-record-type';
	export * from '@sage/x3-finance-data/lib/enums/enum-1099-record-usage';
	export * from '@sage/x3-finance-data/lib/enums/enum-2815-category';
	export * from '@sage/x3-finance-data/lib/enums/enum-2815-type-of-declared-amounts';
	export * from '@sage/x3-finance-data/lib/enums/envelope-status';
	export * from '@sage/x3-finance-data/lib/enums/excel-export';
	export * from '@sage/x3-finance-data/lib/enums/expense-revenue-indeterminate';
	export * from '@sage/x3-finance-data/lib/enums/expense-revenue';
	export * from '@sage/x3-finance-data/lib/enums/export-option';
	export * from '@sage/x3-finance-data/lib/enums/extract-das-2-fees';
	export * from '@sage/x3-finance-data/lib/enums/fde-amount-type-2662';
	export * from '@sage/x3-finance-data/lib/enums/fde-amount-type-2663';
	export * from '@sage/x3-finance-data/lib/enums/fde-amount-type-2665';
	export * from '@sage/x3-finance-data/lib/enums/fde-amount-type';
	export * from '@sage/x3-finance-data/lib/enums/fde-extraction-type';
	export * from '@sage/x3-finance-data/lib/enums/fees-declaration';
	export * from '@sage/x3-finance-data/lib/enums/file-type-recapitulative-st';
	export * from '@sage/x3-finance-data/lib/enums/financial-statement-pages';
	export * from '@sage/x3-finance-data/lib/enums/fiscal-year-or-period';
	export * from '@sage/x3-finance-data/lib/enums/fiscal-year-report';
	export * from '@sage/x3-finance-data/lib/enums/flag-auto-manual';
	export * from '@sage/x3-finance-data/lib/enums/flow-management';
	export * from '@sage/x3-finance-data/lib/enums/formula-condition';
	export * from '@sage/x3-finance-data/lib/enums/formula-type-3726';
	export * from '@sage/x3-finance-data/lib/enums/formula-type-874';
	export * from '@sage/x3-finance-data/lib/enums/general-analytical';
	export * from '@sage/x3-finance-data/lib/enums/general-journal-sort';
	export * from '@sage/x3-finance-data/lib/enums/generation-type-2601';
	export * from '@sage/x3-finance-data/lib/enums/generation-type-2678';
	export * from '@sage/x3-finance-data/lib/enums/generation-type-651';
	export * from '@sage/x3-finance-data/lib/enums/indicateur-operations';
	export * from '@sage/x3-finance-data/lib/enums/instruction-keys-dta';
	export * from '@sage/x3-finance-data/lib/enums/instruction-keys-ezag';
	export * from '@sage/x3-finance-data/lib/enums/invoice-header-amount-control';
	export * from '@sage/x3-finance-data/lib/enums/journal-category';
	export * from '@sage/x3-finance-data/lib/enums/journal-generation-type';
	export * from '@sage/x3-finance-data/lib/enums/journal-type-613';
	export * from '@sage/x3-finance-data/lib/enums/journal-types';
	export * from '@sage/x3-finance-data/lib/enums/launch-periodicity';
	export * from '@sage/x3-finance-data/lib/enums/ledger-authorizations';
	export * from '@sage/x3-finance-data/lib/enums/ledger-in-currencies';
	export * from '@sage/x3-finance-data/lib/enums/ledger-type';
	export * from '@sage/x3-finance-data/lib/enums/local-menu-601';
	export * from '@sage/x3-finance-data/lib/enums/mandatory-no';
	export * from '@sage/x3-finance-data/lib/enums/matching-method';
	export * from '@sage/x3-finance-data/lib/enums/matching-type';
	export * from '@sage/x3-finance-data/lib/enums/medium-type';
	export * from '@sage/x3-finance-data/lib/enums/no-yes-unspecified';
	export * from '@sage/x3-finance-data/lib/enums/notes-pr-portfolio-update';
	export * from '@sage/x3-finance-data/lib/enums/orientation-3645';
	export * from '@sage/x3-finance-data/lib/enums/partial-payment';
	export * from '@sage/x3-finance-data/lib/enums/payment-balance-line-flag';
	export * from '@sage/x3-finance-data/lib/enums/payment-mode';
	export * from '@sage/x3-finance-data/lib/enums/payment-status';
	export * from '@sage/x3-finance-data/lib/enums/payment-transaction-type';
	export * from '@sage/x3-finance-data/lib/enums/period-type';
	export * from '@sage/x3-finance-data/lib/enums/periodicity';
	export * from '@sage/x3-finance-data/lib/enums/posting-level';
	export * from '@sage/x3-finance-data/lib/enums/posting-status';
	export * from '@sage/x3-finance-data/lib/enums/posting-vat-entities';
	export * from '@sage/x3-finance-data/lib/enums/print-currency';
	export * from '@sage/x3-finance-data/lib/enums/print-effect';
	export * from '@sage/x3-finance-data/lib/enums/print-format-872';
	export * from '@sage/x3-finance-data/lib/enums/print-format';
	export * from '@sage/x3-finance-data/lib/enums/printing';
	export * from '@sage/x3-finance-data/lib/enums/process-type-3644';
	export * from '@sage/x3-finance-data/lib/enums/processed-records-selection';
	export * from '@sage/x3-finance-data/lib/enums/prorata-type';
	export * from '@sage/x3-finance-data/lib/enums/reason-for-action';
	export * from '@sage/x3-finance-data/lib/enums/receipt-communication-status';
	export * from '@sage/x3-finance-data/lib/enums/receipt-status';
	export * from '@sage/x3-finance-data/lib/enums/record-type-2652';
	export * from '@sage/x3-finance-data/lib/enums/recurring-journal-type';
	export * from '@sage/x3-finance-data/lib/enums/renewal-type';
	export * from '@sage/x3-finance-data/lib/enums/report-type-vat-reporting';
	export * from '@sage/x3-finance-data/lib/enums/reporting-code-sort';
	export * from '@sage/x3-finance-data/lib/enums/reporting-period';
	export * from '@sage/x3-finance-data/lib/enums/reporting-status';
	export * from '@sage/x3-finance-data/lib/enums/restriction-type';
	export * from '@sage/x3-finance-data/lib/enums/resynchronization-type';
	export * from '@sage/x3-finance-data/lib/enums/revenue-recognition-col-types';
	export * from '@sage/x3-finance-data/lib/enums/revenue-recognition-method';
	export * from '@sage/x3-finance-data/lib/enums/revenue-recognition-validation';
	export * from '@sage/x3-finance-data/lib/enums/revenue-recogniton-type';
	export * from '@sage/x3-finance-data/lib/enums/reverse-code';
	export * from '@sage/x3-finance-data/lib/enums/review-processing';
	export * from '@sage/x3-finance-data/lib/enums/review-status';
	export * from '@sage/x3-finance-data/lib/enums/sage-50-import-transcribe';
	export * from '@sage/x3-finance-data/lib/enums/sense-of-balance';
	export * from '@sage/x3-finance-data/lib/enums/sign-by-default';
	export * from '@sage/x3-finance-data/lib/enums/sign-type';
	export * from '@sage/x3-finance-data/lib/enums/simulation-screen-display';
	export * from '@sage/x3-finance-data/lib/enums/single-multi';
	export * from '@sage/x3-finance-data/lib/enums/site-company';
	export * from '@sage/x3-finance-data/lib/enums/sort-2640';
	export * from '@sage/x3-finance-data/lib/enums/sort-criteria';
	export * from '@sage/x3-finance-data/lib/enums/sort-criterion-due-dates';
	export * from '@sage/x3-finance-data/lib/enums/sort-engagenat';
	export * from '@sage/x3-finance-data/lib/enums/sort-engagesec';
	export * from '@sage/x3-finance-data/lib/enums/sort-open-items-2605';
	export * from '@sage/x3-finance-data/lib/enums/sort-order-2608';
	export * from '@sage/x3-finance-data/lib/enums/sort-sequence';
	export * from '@sage/x3-finance-data/lib/enums/sort';
	export * from '@sage/x3-finance-data/lib/enums/source-document-type';
	export * from '@sage/x3-finance-data/lib/enums/spanish-setup-values';
	export * from '@sage/x3-finance-data/lib/enums/status-880';
	export * from '@sage/x3-finance-data/lib/enums/submission-mode-for-recap-st';
	export * from '@sage/x3-finance-data/lib/enums/submitter-vat-declaration-ger';
	export * from '@sage/x3-finance-data/lib/enums/supplier-aged-balance-field';
	export * from '@sage/x3-finance-data/lib/enums/supplier-customer-document';
	export * from '@sage/x3-finance-data/lib/enums/swiss-vat-codes';
	export * from '@sage/x3-finance-data/lib/enums/table-list';
	export * from '@sage/x3-finance-data/lib/enums/tax-allocation';
	export * from '@sage/x3-finance-data/lib/enums/tax-code-control-3684';
	export * from '@sage/x3-finance-data/lib/enums/tax-credit-to-recover';
	export * from '@sage/x3-finance-data/lib/enums/tax-type-selection';
	export * from '@sage/x3-finance-data/lib/enums/taxpayer-number';
	export * from '@sage/x3-finance-data/lib/enums/tdb-sort-2634';
	export * from '@sage/x3-finance-data/lib/enums/tdb-sort';
	export * from '@sage/x3-finance-data/lib/enums/tds-file-type';
	export * from '@sage/x3-finance-data/lib/enums/tds-record-type';
	export * from '@sage/x3-finance-data/lib/enums/title-2607';
	export * from '@sage/x3-finance-data/lib/enums/transfer-basis';
	export * from '@sage/x3-finance-data/lib/enums/treas-interface-2672';
	export * from '@sage/x3-finance-data/lib/enums/treas-interface';
	export * from '@sage/x3-finance-data/lib/enums/treasury-open-items-sfrpt';
	export * from '@sage/x3-finance-data/lib/enums/treasury-payments-sfrpt';
	export * from '@sage/x3-finance-data/lib/enums/triggering-conditions';
	export * from '@sage/x3-finance-data/lib/enums/type-of-economic-reason';
	export * from '@sage/x3-finance-data/lib/enums/type-of-extraction';
	export * from '@sage/x3-finance-data/lib/enums/type-of-rule';
	export * from '@sage/x3-finance-data/lib/enums/type-of-sales-portugal';
	export * from '@sage/x3-finance-data/lib/enums/variance-type-611';
	export * from '@sage/x3-finance-data/lib/enums/vat-adjustment-level';
	export * from '@sage/x3-finance-data/lib/enums/vat-box-type';
	export * from '@sage/x3-finance-data/lib/enums/vat-declaration-date';
	export * from '@sage/x3-finance-data/lib/enums/vat-declaration-record-type';
	export * from '@sage/x3-finance-data/lib/enums/vat-declaration-type';
	export * from '@sage/x3-finance-data/lib/enums/vat-entity';
	export * from '@sage/x3-finance-data/lib/enums/vat-management-658';
	export * from '@sage/x3-finance-data/lib/enums/vat-management';
	export * from '@sage/x3-finance-data/lib/enums/vat-options-for-shipments';
	export * from '@sage/x3-finance-data/lib/enums/vat-return-reporting';
	export * from '@sage/x3-finance-data/lib/enums/vat-return-type';
	export * from '@sage/x3-finance-data/lib/enums/vat-statement-periodicity';
	export * from '@sage/x3-finance-data/lib/enums/vat-submission-environment';
	export * from '@sage/x3-finance-data/lib/enums/vatpayfcy-parameter';
	export * from '@sage/x3-finance-data/lib/enums/version-status-2669';
	export * from '@sage/x3-finance-data/lib/enums/withholding-calculation-basis';
	export * from '@sage/x3-finance-data/lib/enums/withholding-threshold-base';
	export * from '@sage/x3-finance-data/lib/enums/yn-warn';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/generation-type-651.d.ts
declare module '@sage/x3-finance-data/lib/enums/generation-type-651' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GenerationType651Enum {
	    global = 1,
	    byBp = 2
	}
	export interface GenerationType651$EnumInterface {
	    global: 1;
	    byBp: 2;
	}
	export type GenerationType651 = keyof GenerationType651$EnumInterface;
	export const generationType651Datatype: X3EnumDataType<keyof GenerationType651$EnumInterface, unknown>;
	//# sourceMappingURL=generation-type-651.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/generation-type-2678.d.ts
declare module '@sage/x3-finance-data/lib/enums/generation-type-2678' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GenerationType2678Enum {
	    actual = 1,
	    simulation = 2,
	    regeneration = 3
	}
	export interface GenerationType2678$EnumInterface {
	    actual: 1;
	    simulation: 2;
	    regeneration: 3;
	}
	export type GenerationType2678 = keyof GenerationType2678$EnumInterface;
	export const generationType2678Datatype: X3EnumDataType<keyof GenerationType2678$EnumInterface, unknown>;
	//# sourceMappingURL=generation-type-2678.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/generation-type-2601.d.ts
declare module '@sage/x3-finance-data/lib/enums/generation-type-2601' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GenerationType2601Enum {
	    actual = 1,
	    simulation = 2
	}
	export interface GenerationType2601$EnumInterface {
	    actual: 1;
	    simulation: 2;
	}
	export type GenerationType2601 = keyof GenerationType2601$EnumInterface;
	export const generationType2601Datatype: X3EnumDataType<keyof GenerationType2601$EnumInterface, unknown>;
	//# sourceMappingURL=generation-type-2601.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/general-journal-sort.d.ts
declare module '@sage/x3-finance-data/lib/enums/general-journal-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GeneralJournalSortEnum {
	    sitePeriod = 1,
	    periodSite = 2
	}
	export interface GeneralJournalSort$EnumInterface {
	    sitePeriod: 1;
	    periodSite: 2;
	}
	export type GeneralJournalSort = keyof GeneralJournalSort$EnumInterface;
	export const generalJournalSortDatatype: X3EnumDataType<keyof GeneralJournalSort$EnumInterface, unknown>;
	//# sourceMappingURL=general-journal-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/general-analytical.d.ts
declare module '@sage/x3-finance-data/lib/enums/general-analytical' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GeneralAnalyticalEnum {
	    general = 1,
	    analytical = 2
	}
	export interface GeneralAnalytical$EnumInterface {
	    general: 1;
	    analytical: 2;
	}
	export type GeneralAnalytical = keyof GeneralAnalytical$EnumInterface;
	export const generalAnalyticalDatatype: X3EnumDataType<keyof GeneralAnalytical$EnumInterface, unknown>;
	//# sourceMappingURL=general-analytical.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/formula-type-874.d.ts
declare module '@sage/x3-finance-data/lib/enums/formula-type-874' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FormulaType874Enum {
	    budgeted = 1,
	    actual = 2,
	    commited = 3,
	    precommitted = 4
	}
	export interface FormulaType874$EnumInterface {
	    budgeted: 1;
	    actual: 2;
	    commited: 3;
	    precommitted: 4;
	}
	export type FormulaType874 = keyof FormulaType874$EnumInterface;
	export const formulaType874Datatype: X3EnumDataType<keyof FormulaType874$EnumInterface, unknown>;
	//# sourceMappingURL=formula-type-874.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/formula-type-3726.d.ts
declare module '@sage/x3-finance-data/lib/enums/formula-type-3726' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FormulaType3726Enum {
	    tableExtraction = 1,
	    expression = 2,
	    operation = 3
	}
	export interface FormulaType3726$EnumInterface {
	    tableExtraction: 1;
	    expression: 2;
	    operation: 3;
	}
	export type FormulaType3726 = keyof FormulaType3726$EnumInterface;
	export const formulaType3726Datatype: X3EnumDataType<keyof FormulaType3726$EnumInterface, unknown>;
	//# sourceMappingURL=formula-type-3726.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/formula-condition.d.ts
declare module '@sage/x3-finance-data/lib/enums/formula-condition' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FormulaConditionEnum {
	    none = 1,
	    positiveBalance = 2,
	    negativeBalance = 3
	}
	export interface FormulaCondition$EnumInterface {
	    none: 1;
	    positiveBalance: 2;
	    negativeBalance: 3;
	}
	export type FormulaCondition = keyof FormulaCondition$EnumInterface;
	export const formulaConditionDatatype: X3EnumDataType<keyof FormulaCondition$EnumInterface, unknown>;
	//# sourceMappingURL=formula-condition.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/flow-management.d.ts
declare module '@sage/x3-finance-data/lib/enums/flow-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FlowManagementEnum {
	    notEntered = 1,
	    optional = 2,
	    mandatory = 3
	}
	export interface FlowManagement$EnumInterface {
	    notEntered: 1;
	    optional: 2;
	    mandatory: 3;
	}
	export type FlowManagement = keyof FlowManagement$EnumInterface;
	export const flowManagementDatatype: X3EnumDataType<keyof FlowManagement$EnumInterface, unknown>;
	//# sourceMappingURL=flow-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/flag-auto-manual.d.ts
declare module '@sage/x3-finance-data/lib/enums/flag-auto-manual' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FlagAutoManualEnum {
	    manual = 1,
	    auto = 2
	}
	export interface FlagAutoManual$EnumInterface {
	    manual: 1;
	    auto: 2;
	}
	export type FlagAutoManual = keyof FlagAutoManual$EnumInterface;
	export const flagAutoManualDatatype: X3EnumDataType<keyof FlagAutoManual$EnumInterface, unknown>;
	//# sourceMappingURL=flag-auto-manual.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/fiscal-year-report.d.ts
declare module '@sage/x3-finance-data/lib/enums/fiscal-year-report' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FiscalYearReportEnum {
	    notOpen = 1,
	    open = 2,
	    closed = 3
	}
	export interface FiscalYearReport$EnumInterface {
	    notOpen: 1;
	    open: 2;
	    closed: 3;
	}
	export type FiscalYearReport = keyof FiscalYearReport$EnumInterface;
	export const fiscalYearReportDatatype: X3EnumDataType<keyof FiscalYearReport$EnumInterface, unknown>;
	//# sourceMappingURL=fiscal-year-report.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/fiscal-year-or-period.d.ts
declare module '@sage/x3-finance-data/lib/enums/fiscal-year-or-period' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FiscalYearOrPeriodEnum {
	    fullFiscalYear = 1,
	    period = 2
	}
	export interface FiscalYearOrPeriod$EnumInterface {
	    fullFiscalYear: 1;
	    period: 2;
	}
	export type FiscalYearOrPeriod = keyof FiscalYearOrPeriod$EnumInterface;
	export const fiscalYearOrPeriodDatatype: X3EnumDataType<keyof FiscalYearOrPeriod$EnumInterface, unknown>;
	//# sourceMappingURL=fiscal-year-or-period.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/financial-statement-pages.d.ts
declare module '@sage/x3-finance-data/lib/enums/financial-statement-pages' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FinancialStatementPagesEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    substituteValue9 = 9,
	    substituteValue10 = 10,
	    substituteValue11 = 11,
	    substituteValue12 = 12,
	    substituteValue13 = 13,
	    substituteValue14 = 14,
	    substituteValue15 = 15,
	    substituteValue16 = 16,
	    substituteValue17 = 17,
	    dgi2059F18 = 18,
	    dgi2059G19 = 19,
	    dgi206520 = 20,
	    dgi2065Bis21 = 21,
	    dgi2065Ter22 = 22,
	    dgi206723 = 23,
	    ediDgi24 = 24,
	    otherTable25 = 25,
	    dgiCa18Chapay26 = 26,
	    ediDgi27 = 27,
	    otherTable28 = 28,
	    dgiCa20Chaava29 = 29,
	    dgiCa21Proava30 = 30,
	    ediDgi31 = 31,
	    otherTable32 = 32,
	    dgi2057 = 33,
	    dgi2058A = 34,
	    dgi2058B = 35,
	    dgi2058C = 36,
	    dgi2058Is = 37,
	    dgi2059A = 38,
	    dgi2059B = 39,
	    dgi2059C = 40,
	    dgi2059D = 41,
	    dgi2059E = 42,
	    dgi2059F = 43,
	    dgi2059G = 44,
	    dgi2059H = 45,
	    dgi2059I = 46,
	    dgi2065 = 47,
	    dgi2065Bis = 48,
	    dgi2065Ter = 49,
	    dgi2066 = 50,
	    dgi2067 = 51,
	    dgiAnnexlib02 = 52,
	    dgiAnnexlib03 = 53,
	    dgiCa17Prorec = 54,
	    dgiCa18Chapay = 55,
	    dgiCa19Charep = 56,
	    dgiCa20Chaava = 57,
	    dgiCa21Proava = 58,
	    ediDgi = 59,
	    otherTable = 60
	}
	export interface FinancialStatementPages$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    substituteValue9: 9;
	    substituteValue10: 10;
	    substituteValue11: 11;
	    substituteValue12: 12;
	    substituteValue13: 13;
	    substituteValue14: 14;
	    substituteValue15: 15;
	    substituteValue16: 16;
	    substituteValue17: 17;
	    dgi2059F18: 18;
	    dgi2059G19: 19;
	    dgi206520: 20;
	    dgi2065Bis21: 21;
	    dgi2065Ter22: 22;
	    dgi206723: 23;
	    ediDgi24: 24;
	    otherTable25: 25;
	    dgiCa18Chapay26: 26;
	    ediDgi27: 27;
	    otherTable28: 28;
	    dgiCa20Chaava29: 29;
	    dgiCa21Proava30: 30;
	    ediDgi31: 31;
	    otherTable32: 32;
	    dgi2057: 33;
	    dgi2058A: 34;
	    dgi2058B: 35;
	    dgi2058C: 36;
	    dgi2058Is: 37;
	    dgi2059A: 38;
	    dgi2059B: 39;
	    dgi2059C: 40;
	    dgi2059D: 41;
	    dgi2059E: 42;
	    dgi2059F: 43;
	    dgi2059G: 44;
	    dgi2059H: 45;
	    dgi2059I: 46;
	    dgi2065: 47;
	    dgi2065Bis: 48;
	    dgi2065Ter: 49;
	    dgi2066: 50;
	    dgi2067: 51;
	    dgiAnnexlib02: 52;
	    dgiAnnexlib03: 53;
	    dgiCa17Prorec: 54;
	    dgiCa18Chapay: 55;
	    dgiCa19Charep: 56;
	    dgiCa20Chaava: 57;
	    dgiCa21Proava: 58;
	    ediDgi: 59;
	    otherTable: 60;
	}
	export type FinancialStatementPages = keyof FinancialStatementPages$EnumInterface;
	export const financialStatementPagesDatatype: X3EnumDataType<keyof FinancialStatementPages$EnumInterface, unknown>;
	//# sourceMappingURL=financial-statement-pages.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/file-type-recapitulative-st.d.ts
declare module '@sage/x3-finance-data/lib/enums/file-type-recapitulative-st' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FileTypeRecapitulativeStEnum {
	    csvForSageElsterClient = 1,
	    csvForElsterOnline = 2
	}
	export interface FileTypeRecapitulativeSt$EnumInterface {
	    csvForSageElsterClient: 1;
	    csvForElsterOnline: 2;
	}
	export type FileTypeRecapitulativeSt = keyof FileTypeRecapitulativeSt$EnumInterface;
	export const fileTypeRecapitulativeStDatatype: X3EnumDataType<keyof FileTypeRecapitulativeSt$EnumInterface, unknown>;
	//# sourceMappingURL=file-type-recapitulative-st.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/fees-declaration.d.ts
declare module '@sage/x3-finance-data/lib/enums/fees-declaration' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FeesDeclarationEnum {
	    none = 1,
	    das2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4
	}
	export interface FeesDeclaration$EnumInterface {
	    none: 1;
	    das2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	}
	export type FeesDeclaration = keyof FeesDeclaration$EnumInterface;
	export const feesDeclarationDatatype: X3EnumDataType<keyof FeesDeclaration$EnumInterface, unknown>;
	//# sourceMappingURL=fees-declaration.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/fde-extraction-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/fde-extraction-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FdeExtractionTypeEnum {
	    accountRoot = 1,
	    controlAccount = 2,
	    reportingCode = 3,
	    pyramid = 4
	}
	export interface FdeExtractionType$EnumInterface {
	    accountRoot: 1;
	    controlAccount: 2;
	    reportingCode: 3;
	    pyramid: 4;
	}
	export type FdeExtractionType = keyof FdeExtractionType$EnumInterface;
	export const fdeExtractionTypeDatatype: X3EnumDataType<keyof FdeExtractionType$EnumInterface, unknown>;
	//# sourceMappingURL=fde-extraction-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/fde-amount-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/fde-amount-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FdeAmountTypeEnum {
	    generalAccounting = 1,
	    analyticalAccounting = 2,
	    budgetAccounting = 3,
	    sumOfCells = 4,
	    expression = 5,
	    variable = 6
	}
	export interface FdeAmountType$EnumInterface {
	    generalAccounting: 1;
	    analyticalAccounting: 2;
	    budgetAccounting: 3;
	    sumOfCells: 4;
	    expression: 5;
	    variable: 6;
	}
	export type FdeAmountType = keyof FdeAmountType$EnumInterface;
	export const fdeAmountTypeDatatype: X3EnumDataType<keyof FdeAmountType$EnumInterface, unknown>;
	//# sourceMappingURL=fde-amount-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/fde-amount-type-2665.d.ts
declare module '@sage/x3-finance-data/lib/enums/fde-amount-type-2665' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FdeAmountType2665Enum {
	    movementsCFwdClosing = 1,
	    movementsCFwd = 2,
	    movementsClosing = 3,
	    movementsOnly = 4,
	    cFwdOnly = 5,
	    closingOnly = 6
	}
	export interface FdeAmountType2665$EnumInterface {
	    movementsCFwdClosing: 1;
	    movementsCFwd: 2;
	    movementsClosing: 3;
	    movementsOnly: 4;
	    cFwdOnly: 5;
	    closingOnly: 6;
	}
	export type FdeAmountType2665 = keyof FdeAmountType2665$EnumInterface;
	export const fdeAmountType2665Datatype: X3EnumDataType<keyof FdeAmountType2665$EnumInterface, unknown>;
	//# sourceMappingURL=fde-amount-type-2665.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/fde-amount-type-2663.d.ts
declare module '@sage/x3-finance-data/lib/enums/fde-amount-type-2663' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FdeAmountType2663Enum {
	    balances = 1,
	    debtorBalances = 2,
	    creditorBalances = 3,
	    debtorAmounts = 4,
	    creditorAmounts = 5
	}
	export interface FdeAmountType2663$EnumInterface {
	    balances: 1;
	    debtorBalances: 2;
	    creditorBalances: 3;
	    debtorAmounts: 4;
	    creditorAmounts: 5;
	}
	export type FdeAmountType2663 = keyof FdeAmountType2663$EnumInterface;
	export const fdeAmountType2663Datatype: X3EnumDataType<keyof FdeAmountType2663$EnumInterface, unknown>;
	//# sourceMappingURL=fde-amount-type-2663.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/fde-amount-type-2662.d.ts
declare module '@sage/x3-finance-data/lib/enums/fde-amount-type-2662' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FdeAmountType2662Enum {
	    achieved = 1,
	    committed = 2,
	    precommitted = 3
	}
	export interface FdeAmountType2662$EnumInterface {
	    achieved: 1;
	    committed: 2;
	    precommitted: 3;
	}
	export type FdeAmountType2662 = keyof FdeAmountType2662$EnumInterface;
	export const fdeAmountType2662Datatype: X3EnumDataType<keyof FdeAmountType2662$EnumInterface, unknown>;
	//# sourceMappingURL=fde-amount-type-2662.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/extract-das-2-fees.d.ts
declare module '@sage/x3-finance-data/lib/enums/extract-das-2-fees' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExtractDas2FeesEnum {
	    das2FlagAssociatedWithJournalType = 1,
	    das2FlagAssociatedWithInvoiceJournal = 2
	}
	export interface ExtractDas2Fees$EnumInterface {
	    das2FlagAssociatedWithJournalType: 1;
	    das2FlagAssociatedWithInvoiceJournal: 2;
	}
	export type ExtractDas2Fees = keyof ExtractDas2Fees$EnumInterface;
	export const extractDas2FeesDatatype: X3EnumDataType<keyof ExtractDas2Fees$EnumInterface, unknown>;
	//# sourceMappingURL=extract-das-2-fees.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/export-option.d.ts
declare module '@sage/x3-finance-data/lib/enums/export-option' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExportOptionEnum {
	    balanceOfControlAccounts = 1,
	    sumOfIndividualBalances = 2
	}
	export interface ExportOption$EnumInterface {
	    balanceOfControlAccounts: 1;
	    sumOfIndividualBalances: 2;
	}
	export type ExportOption = keyof ExportOption$EnumInterface;
	export const exportOptionDatatype: X3EnumDataType<keyof ExportOption$EnumInterface, unknown>;
	//# sourceMappingURL=export-option.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/expense-revenue.d.ts
declare module '@sage/x3-finance-data/lib/enums/expense-revenue' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExpenseRevenueEnum {
	    expense = 1,
	    revenue = 2
	}
	export interface ExpenseRevenue$EnumInterface {
	    expense: 1;
	    revenue: 2;
	}
	export type ExpenseRevenue = keyof ExpenseRevenue$EnumInterface;
	export const expenseRevenueDatatype: X3EnumDataType<keyof ExpenseRevenue$EnumInterface, unknown>;
	//# sourceMappingURL=expense-revenue.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/expense-revenue-indeterminate.d.ts
declare module '@sage/x3-finance-data/lib/enums/expense-revenue-indeterminate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExpenseRevenueIndeterminateEnum {
	    expense = 1,
	    revenue = 2,
	    unspecified = 3
	}
	export interface ExpenseRevenueIndeterminate$EnumInterface {
	    expense: 1;
	    revenue: 2;
	    unspecified: 3;
	}
	export type ExpenseRevenueIndeterminate = keyof ExpenseRevenueIndeterminate$EnumInterface;
	export const expenseRevenueIndeterminateDatatype: X3EnumDataType<keyof ExpenseRevenueIndeterminate$EnumInterface, unknown>;
	//# sourceMappingURL=expense-revenue-indeterminate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/excel-export.d.ts
declare module '@sage/x3-finance-data/lib/enums/excel-export' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExcelExportEnum {
	    saveOnClientWorkstation = 1,
	    activateExcel = 2
	}
	export interface ExcelExport$EnumInterface {
	    saveOnClientWorkstation: 1;
	    activateExcel: 2;
	}
	export type ExcelExport = keyof ExcelExport$EnumInterface;
	export const excelExportDatatype: X3EnumDataType<keyof ExcelExport$EnumInterface, unknown>;
	//# sourceMappingURL=excel-export.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/envelope-status.d.ts
declare module '@sage/x3-finance-data/lib/enums/envelope-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EnvelopeStatusEnum {
	    entered = 1,
	    toBeApproved = 2,
	    approved = 3,
	    closed = 4,
	    commitmentsCarriedForward = 5
	}
	export interface EnvelopeStatus$EnumInterface {
	    entered: 1;
	    toBeApproved: 2;
	    approved: 3;
	    closed: 4;
	    commitmentsCarriedForward: 5;
	}
	export type EnvelopeStatus = keyof EnvelopeStatus$EnumInterface;
	export const envelopeStatusDatatype: X3EnumDataType<keyof EnvelopeStatus$EnumInterface, unknown>;
	//# sourceMappingURL=envelope-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/enum-2815-type-of-declared-amounts.d.ts
declare module '@sage/x3-finance-data/lib/enums/enum-2815-type-of-declared-amounts' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Enum2815TypeOfDeclaredAmountsEnum {
	    invoicedAmounts = 1,
	    paidAmounts = 2
	}
	export interface Enum2815TypeOfDeclaredAmounts$EnumInterface {
	    invoicedAmounts: 1;
	    paidAmounts: 2;
	}
	export type Enum2815TypeOfDeclaredAmounts = keyof Enum2815TypeOfDeclaredAmounts$EnumInterface;
	export const enum2815TypeOfDeclaredAmountsDatatype: X3EnumDataType<keyof Enum2815TypeOfDeclaredAmounts$EnumInterface, unknown>;
	//# sourceMappingURL=enum-2815-type-of-declared-amounts.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/enum-2815-category.d.ts
declare module '@sage/x3-finance-data/lib/enums/enum-2815-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Enum2815CategoryEnum {
	    commissionBrokerageRebate = 1,
	    feesOrSessionalPayments = 2,
	    benefitsInKind = 3,
	    expensesIncurredOnBehalfOfTheBeneficiary = 4
	}
	export interface Enum2815Category$EnumInterface {
	    commissionBrokerageRebate: 1;
	    feesOrSessionalPayments: 2;
	    benefitsInKind: 3;
	    expensesIncurredOnBehalfOfTheBeneficiary: 4;
	}
	export type Enum2815Category = keyof Enum2815Category$EnumInterface;
	export const enum2815CategoryDatatype: X3EnumDataType<keyof Enum2815Category$EnumInterface, unknown>;
	//# sourceMappingURL=enum-2815-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/enum-1099-record-usage.d.ts
declare module '@sage/x3-finance-data/lib/enums/enum-1099-record-usage' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Enum1099RecordUsageEnum {
	    mandatory = 1,
	    conditional = 2,
	    optional = 3
	}
	export interface Enum1099RecordUsage$EnumInterface {
	    mandatory: 1;
	    conditional: 2;
	    optional: 3;
	}
	export type Enum1099RecordUsage = keyof Enum1099RecordUsage$EnumInterface;
	export const enum1099RecordUsageDatatype: X3EnumDataType<keyof Enum1099RecordUsage$EnumInterface, unknown>;
	//# sourceMappingURL=enum-1099-record-usage.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/enum-1099-record-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/enum-1099-record-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Enum1099RecordTypeEnum {
	    alphanumeric = 1,
	    numeric = 2,
	    date = 3
	}
	export interface Enum1099RecordType$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	    date: 3;
	}
	export type Enum1099RecordType = keyof Enum1099RecordType$EnumInterface;
	export const enum1099RecordTypeDatatype: X3EnumDataType<keyof Enum1099RecordType$EnumInterface, unknown>;
	//# sourceMappingURL=enum-1099-record-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/enum-1099-form.d.ts
declare module '@sage/x3-finance-data/lib/enums/enum-1099-form' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Enum1099FormEnum {
	    none = 1,
	    misc = 2,
	    int = 3,
	    div = 4,
	    nec = 5
	}
	export interface Enum1099Form$EnumInterface {
	    none: 1;
	    misc: 2;
	    int: 3;
	    div: 4;
	    nec: 5;
	}
	export type Enum1099Form = keyof Enum1099Form$EnumInterface;
	export const enum1099FormDatatype: X3EnumDataType<keyof Enum1099Form$EnumInterface, unknown>;
	//# sourceMappingURL=enum-1099-form.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/enum-1099-declaration-mode.d.ts
declare module '@sage/x3-finance-data/lib/enums/enum-1099-declaration-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Enum1099DeclarationModeEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2
	}
	export interface Enum1099DeclarationMode$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	}
	export type Enum1099DeclarationMode = keyof Enum1099DeclarationMode$EnumInterface;
	export const enum1099DeclarationModeDatatype: X3EnumDataType<keyof Enum1099DeclarationMode$EnumInterface, unknown>;
	//# sourceMappingURL=enum-1099-declaration-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/enum-1099-account.d.ts
declare module '@sage/x3-finance-data/lib/enums/enum-1099-account' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Enum1099AccountEnum {
	    feesAndVacations = 1,
	    commissions = 2,
	    brokerages = 3,
	    rebates = 4,
	    attendanceTokens = 5,
	    royalties = 6,
	    inventorRights = 7,
	    otherPayments = 8,
	    indemnitiesAndReimbursements = 9,
	    perquisites = 10,
	    withholdingTaxOnIncome = 11,
	    netTaxOnRoyalties = 12
	}
	export interface Enum1099Account$EnumInterface {
	    feesAndVacations: 1;
	    commissions: 2;
	    brokerages: 3;
	    rebates: 4;
	    attendanceTokens: 5;
	    royalties: 6;
	    inventorRights: 7;
	    otherPayments: 8;
	    indemnitiesAndReimbursements: 9;
	    perquisites: 10;
	    withholdingTaxOnIncome: 11;
	    netTaxOnRoyalties: 12;
	}
	export type Enum1099Account = keyof Enum1099Account$EnumInterface;
	export const enum1099AccountDatatype: X3EnumDataType<keyof Enum1099Account$EnumInterface, unknown>;
	//# sourceMappingURL=enum-1099-account.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/entry-type-692.d.ts
declare module '@sage/x3-finance-data/lib/enums/entry-type-692' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryType692Enum {
	    selected = 1,
	    notSelected = 2,
	    all = 3
	}
	export interface EntryType692$EnumInterface {
	    selected: 1;
	    notSelected: 2;
	    all: 3;
	}
	export type EntryType692 = keyof EntryType692$EnumInterface;
	export const entryType692Datatype: X3EnumDataType<keyof EntryType692$EnumInterface, unknown>;
	//# sourceMappingURL=entry-type-692.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/entry-type-628.d.ts
declare module '@sage/x3-finance-data/lib/enums/entry-type-628' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryType628Enum {
	    all = 1,
	    matched = 2,
	    notMatched = 3
	}
	export interface EntryType628$EnumInterface {
	    all: 1;
	    matched: 2;
	    notMatched: 3;
	}
	export type EntryType628 = keyof EntryType628$EnumInterface;
	export const entryType628Datatype: X3EnumDataType<keyof EntryType628$EnumInterface, unknown>;
	//# sourceMappingURL=entry-type-628.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/entry-type-2646.d.ts
declare module '@sage/x3-finance-data/lib/enums/entry-type-2646' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryType2646Enum {
	    column = 1,
	    row = 2,
	    tab = 3
	}
	export interface EntryType2646$EnumInterface {
	    column: 1;
	    row: 2;
	    tab: 3;
	}
	export type EntryType2646 = keyof EntryType2646$EnumInterface;
	export const entryType2646Datatype: X3EnumDataType<keyof EntryType2646$EnumInterface, unknown>;
	//# sourceMappingURL=entry-type-2646.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/entry-origin.d.ts
declare module '@sage/x3-finance-data/lib/enums/entry-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryOriginEnum {
	    directEntry = 1,
	    automaticGeneration = 2,
	    import = 3
	}
	export interface EntryOrigin$EnumInterface {
	    directEntry: 1;
	    automaticGeneration: 2;
	    import: 3;
	}
	export type EntryOrigin = keyof EntryOrigin$EnumInterface;
	export const entryOriginDatatype: X3EnumDataType<keyof EntryOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=entry-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/entered-calculated.d.ts
declare module '@sage/x3-finance-data/lib/enums/entered-calculated' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EnteredCalculatedEnum {
	    entry = 1,
	    calculatedAmount = 2,
	    calculatedQuantity = 3
	}
	export interface EnteredCalculated$EnumInterface {
	    entry: 1;
	    calculatedAmount: 2;
	    calculatedQuantity: 3;
	}
	export type EnteredCalculated = keyof EnteredCalculated$EnumInterface;
	export const enteredCalculatedDatatype: X3EnumDataType<keyof EnteredCalculated$EnumInterface, unknown>;
	//# sourceMappingURL=entered-calculated.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/due-date-item-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/due-date-item-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DueDateItemTypeEnum {
	    order = 1,
	    invoice = 2,
	    payment = 3,
	    others = 4
	}
	export interface DueDateItemType$EnumInterface {
	    order: 1;
	    invoice: 2;
	    payment: 3;
	    others: 4;
	}
	export type DueDateItemType = keyof DueDateItemType$EnumInterface;
	export const dueDateItemTypeDatatype: X3EnumDataType<keyof DueDateItemType$EnumInterface, unknown>;
	//# sourceMappingURL=due-date-item-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/due-date-cancellation.d.ts
declare module '@sage/x3-finance-data/lib/enums/due-date-cancellation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DueDateCancellationEnum {
	    notToPlaceOnAnotherStatement = 1,
	    toPlaceOnAnotherStatement = 2
	}
	export interface DueDateCancellation$EnumInterface {
	    notToPlaceOnAnotherStatement: 1;
	    toPlaceOnAnotherStatement: 2;
	}
	export type DueDateCancellation = keyof DueDateCancellation$EnumInterface;
	export const dueDateCancellationDatatype: X3EnumDataType<keyof DueDateCancellation$EnumInterface, unknown>;
	//# sourceMappingURL=due-date-cancellation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/document-reason.d.ts
declare module '@sage/x3-finance-data/lib/enums/document-reason' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentReasonEnum {
	    purchaseRequest = 1,
	    order = 2,
	    invoice = 3,
	    grniGoodsReceivedNotInvoiced = 4,
	    receivableCreditMemos = 5,
	    carryforward = 6,
	    creditMemo = 7,
	    accountingDocument = 8
	}
	export interface DocumentReason$EnumInterface {
	    purchaseRequest: 1;
	    order: 2;
	    invoice: 3;
	    grniGoodsReceivedNotInvoiced: 4;
	    receivableCreditMemos: 5;
	    carryforward: 6;
	    creditMemo: 7;
	    accountingDocument: 8;
	}
	export type DocumentReason = keyof DocumentReason$EnumInterface;
	export const documentReasonDatatype: X3EnumDataType<keyof DocumentReason$EnumInterface, unknown>;
	//# sourceMappingURL=document-reason.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/display-mode.d.ts
declare module '@sage/x3-finance-data/lib/enums/display-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DisplayModeEnum {
	    value = 1,
	    title = 2,
	    formula = 3
	}
	export interface DisplayMode$EnumInterface {
	    value: 1;
	    title: 2;
	    formula: 3;
	}
	export type DisplayMode = keyof DisplayMode$EnumInterface;
	export const displayModeDatatype: X3EnumDataType<keyof DisplayMode$EnumInterface, unknown>;
	//# sourceMappingURL=display-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/discount-form-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/discount-form-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DiscountFormTypeEnum {
	    bankDeposits = 1,
	    paymentOrder = 2,
	    payment = 3
	}
	export interface DiscountFormType$EnumInterface {
	    bankDeposits: 1;
	    paymentOrder: 2;
	    payment: 3;
	}
	export type DiscountFormType = keyof DiscountFormType$EnumInterface;
	export const discountFormTypeDatatype: X3EnumDataType<keyof DiscountFormType$EnumInterface, unknown>;
	//# sourceMappingURL=discount-form-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/discount-calculation-date.d.ts
declare module '@sage/x3-finance-data/lib/enums/discount-calculation-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DiscountCalculationDateEnum {
	    openItemDueDate = 1,
	    invoiceDate = 2
	}
	export interface DiscountCalculationDate$EnumInterface {
	    openItemDueDate: 1;
	    invoiceDate: 2;
	}
	export type DiscountCalculationDate = keyof DiscountCalculationDate$EnumInterface;
	export const discountCalculationDateDatatype: X3EnumDataType<keyof DiscountCalculationDate$EnumInterface, unknown>;
	//# sourceMappingURL=discount-calculation-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/dimension-view-setup-sort.d.ts
declare module '@sage/x3-finance-data/lib/enums/dimension-view-setup-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DimensionViewSetupSortEnum {
	    byAccountRoot = 1,
	    byDimensionType = 2
	}
	export interface DimensionViewSetupSort$EnumInterface {
	    byAccountRoot: 1;
	    byDimensionType: 2;
	}
	export type DimensionViewSetupSort = keyof DimensionViewSetupSort$EnumInterface;
	export const dimensionViewSetupSortDatatype: X3EnumDataType<keyof DimensionViewSetupSort$EnumInterface, unknown>;
	//# sourceMappingURL=dimension-view-setup-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/detail-level.d.ts
declare module '@sage/x3-finance-data/lib/enums/detail-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DetailLevelEnum {
	    project = 1,
	    envelope = 2,
	    budget = 3,
	    line = 4
	}
	export interface DetailLevel$EnumInterface {
	    project: 1;
	    envelope: 2;
	    budget: 3;
	    line: 4;
	}
	export type DetailLevel = keyof DetailLevel$EnumInterface;
	export const detailLevelDatatype: X3EnumDataType<keyof DetailLevel$EnumInterface, unknown>;
	//# sourceMappingURL=detail-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/deposit-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/deposit-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DepositTypeEnum {
	    receipt = 1,
	    discount = 2,
	    receiptInValue = 3,
	    discountInValue = 4
	}
	export interface DepositType$EnumInterface {
	    receipt: 1;
	    discount: 2;
	    receiptInValue: 3;
	    discountInValue: 4;
	}
	export type DepositType = keyof DepositType$EnumInterface;
	export const depositTypeDatatype: X3EnumDataType<keyof DepositType$EnumInterface, unknown>;
	//# sourceMappingURL=deposit-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/delay-calculation-date.d.ts
declare module '@sage/x3-finance-data/lib/enums/delay-calculation-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DelayCalculationDateEnum {
	    valueDate = 1,
	    accountingDate = 2
	}
	export interface DelayCalculationDate$EnumInterface {
	    valueDate: 1;
	    accountingDate: 2;
	}
	export type DelayCalculationDate = keyof DelayCalculationDate$EnumInterface;
	export const delayCalculationDateDatatype: X3EnumDataType<keyof DelayCalculationDate$EnumInterface, unknown>;
	//# sourceMappingURL=delay-calculation-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/definition-level-2696.d.ts
declare module '@sage/x3-finance-data/lib/enums/definition-level-2696' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefinitionLevel2696Enum {
	    groupOfCompanies = 1,
	    groupOfSites = 2,
	    company = 3,
	    site = 4
	}
	export interface DefinitionLevel2696$EnumInterface {
	    groupOfCompanies: 1;
	    groupOfSites: 2;
	    company: 3;
	    site: 4;
	}
	export type DefinitionLevel2696 = keyof DefinitionLevel2696$EnumInterface;
	export const definitionLevel2696Datatype: X3EnumDataType<keyof DefinitionLevel2696$EnumInterface, unknown>;
	//# sourceMappingURL=definition-level-2696.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/declaration-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/declaration-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeclarationTypeEnum {
	    normal1099 = 1,
	    additionalDeclaration = 2
	}
	export interface DeclarationType$EnumInterface {
	    normal1099: 1;
	    additionalDeclaration: 2;
	}
	export type DeclarationType = keyof DeclarationType$EnumInterface;
	export const declarationTypeDatatype: X3EnumDataType<keyof DeclarationType$EnumInterface, unknown>;
	//# sourceMappingURL=declaration-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/debit-credit.d.ts
declare module '@sage/x3-finance-data/lib/enums/debit-credit' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DebitCreditEnum {
	    debit = 1,
	    credit = 2
	}
	export interface DebitCredit$EnumInterface {
	    debit: 1;
	    credit: 2;
	}
	export type DebitCredit = keyof DebitCredit$EnumInterface;
	export const debitCreditDatatype: X3EnumDataType<keyof DebitCredit$EnumInterface, unknown>;
	//# sourceMappingURL=debit-credit.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/datev-invoice-fields.d.ts
declare module '@sage/x3-finance-data/lib/enums/datev-invoice-fields' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DatevInvoiceFieldsEnum {
	    documentNo = 1,
	    sourceDocumentNo = 2,
	    notUsed = 3
	}
	export interface DatevInvoiceFields$EnumInterface {
	    documentNo: 1;
	    sourceDocumentNo: 2;
	    notUsed: 3;
	}
	export type DatevInvoiceFields = keyof DatevInvoiceFields$EnumInterface;
	export const datevInvoiceFieldsDatatype: X3EnumDataType<keyof DatevInvoiceFields$EnumInterface, unknown>;
	//# sourceMappingURL=datev-invoice-fields.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/datev-bp-copy.d.ts
declare module '@sage/x3-finance-data/lib/enums/datev-bp-copy' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DatevBpCopyEnum {
	    allBPs = 1,
	    customer = 2,
	    supplier = 3
	}
	export interface DatevBpCopy$EnumInterface {
	    allBPs: 1;
	    customer: 2;
	    supplier: 3;
	}
	export type DatevBpCopy = keyof DatevBpCopy$EnumInterface;
	export const datevBpCopyDatatype: X3EnumDataType<keyof DatevBpCopy$EnumInterface, unknown>;
	//# sourceMappingURL=datev-bp-copy.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/datev-account-modification.d.ts
declare module '@sage/x3-finance-data/lib/enums/datev-account-modification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DatevAccountModificationEnum {
	    shorten = 1,
	    lengthen = 2
	}
	export interface DatevAccountModification$EnumInterface {
	    shorten: 1;
	    lengthen: 2;
	}
	export type DatevAccountModification = keyof DatevAccountModification$EnumInterface;
	export const datevAccountModificationDatatype: X3EnumDataType<keyof DatevAccountModification$EnumInterface, unknown>;
	//# sourceMappingURL=datev-account-modification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/datev-account-modification-3655.d.ts
declare module '@sage/x3-finance-data/lib/enums/datev-account-modification-3655' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DatevAccountModification3655Enum {
	    right = 1,
	    left = 2
	}
	export interface DatevAccountModification3655$EnumInterface {
	    right: 1;
	    left: 2;
	}
	export type DatevAccountModification3655 = keyof DatevAccountModification3655$EnumInterface;
	export const datevAccountModification3655Datatype: X3EnumDataType<keyof DatevAccountModification3655$EnumInterface, unknown>;
	//# sourceMappingURL=datev-account-modification-3655.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/date-basis-for-aging.d.ts
declare module '@sage/x3-finance-data/lib/enums/date-basis-for-aging' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DateBasisForAgingEnum {
	    ageByInvoiceDate = 1,
	    ageByDueDate = 2
	}
	export interface DateBasisForAging$EnumInterface {
	    ageByInvoiceDate: 1;
	    ageByDueDate: 2;
	}
	export type DateBasisForAging = keyof DateBasisForAging$EnumInterface;
	export const dateBasisForAgingDatatype: X3EnumDataType<keyof DateBasisForAging$EnumInterface, unknown>;
	//# sourceMappingURL=date-basis-for-aging.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/customer-aged-balance-field.d.ts
declare module '@sage/x3-finance-data/lib/enums/customer-aged-balance-field' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomerAgedBalanceFieldEnum {
	    customerSince = 1,
	    lastQuote = 2,
	    lastOrder = 3,
	    lastShipment = 4,
	    lastInvoice = 5,
	    lastPayment = 6,
	    lastLatePayment = 7,
	    lastReminder = 8
	}
	export interface CustomerAgedBalanceField$EnumInterface {
	    customerSince: 1;
	    lastQuote: 2;
	    lastOrder: 3;
	    lastShipment: 4;
	    lastInvoice: 5;
	    lastPayment: 6;
	    lastLatePayment: 7;
	    lastReminder: 8;
	}
	export type CustomerAgedBalanceField = keyof CustomerAgedBalanceField$EnumInterface;
	export const customerAgedBalanceFieldDatatype: X3EnumDataType<keyof CustomerAgedBalanceField$EnumInterface, unknown>;
	//# sourceMappingURL=customer-aged-balance-field.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/currency-enum.d.ts
declare module '@sage/x3-finance-data/lib/enums/currency-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CurrencyEnumEnum {
	    company = 1,
	    reporting = 2
	}
	export interface CurrencyEnum$EnumInterface {
	    company: 1;
	    reporting: 2;
	}
	export type CurrencyEnum = keyof CurrencyEnum$EnumInterface;
	export const currencyEnumDatatype: X3EnumDataType<keyof CurrencyEnum$EnumInterface, unknown>;
	//# sourceMappingURL=currency-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/currency-3643.d.ts
declare module '@sage/x3-finance-data/lib/enums/currency-3643' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Currency3643Enum {
	    originalTransactionCurrency = 1,
	    ledgerCurrency = 2
	}
	export interface Currency3643$EnumInterface {
	    originalTransactionCurrency: 1;
	    ledgerCurrency: 2;
	}
	export type Currency3643 = keyof Currency3643$EnumInterface;
	export const currency3643Datatype: X3EnumDataType<keyof Currency3643$EnumInterface, unknown>;
	//# sourceMappingURL=currency-3643.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/currency-2606.d.ts
declare module '@sage/x3-finance-data/lib/enums/currency-2606' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Currency2606Enum {
	    transaction = 1,
	    company = 2
	}
	export interface Currency2606$EnumInterface {
	    transaction: 1;
	    company: 2;
	}
	export type Currency2606 = keyof Currency2606$EnumInterface;
	export const currency2606Datatype: X3EnumDataType<keyof Currency2606$EnumInterface, unknown>;
	//# sourceMappingURL=currency-2606.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/crystal-reports-acc-contd.d.ts
declare module '@sage/x3-finance-data/lib/enums/crystal-reports-acc-contd' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrystalReportsAccContdEnum {
	    days1 = 1,
	    weeks = 2,
	    substituteValue3 = 3,
	    fortnights = 4,
	    months = 5,
	    fixed = 6,
	    file = 7,
	    criteria = 8,
	    empty = 9,
	    s = 10,
	    p = 11,
	    d = 12,
	    rBVariance13 = 13,
	    rEBVariance14 = 14,
	    rEPBVariance15 = 15,
	    rBQtyVariance16 = 16,
	    rEBQtyVariance17 = 17,
	    rEPBQtyVariance18 = 18,
	    rBVariance = 19,
	    rEBVariance = 20,
	    rEPBVariance = 21,
	    rBQtyVariance = 22,
	    rEBQtyVariance = 23,
	    rEPBQtyVariance = 24,
	    balanceChgRev = 25,
	    balancePdtRev = 26,
	    achievedQty = 27,
	    days28 = 28,
	    notDue = 29,
	    dueDate = 30,
	    telephone = 31,
	    days = 32,
	    byBpCode = 33,
	    typeDocumentNumber = 34,
	    tradeName = 35,
	    preparatoryReportForTheTaxDeclarationOnPayments = 36,
	    reprintPreparatoryReportForTheTaxDeclarationOnPayments = 37,
	    txsOn = 38,
	    debitTotal = 39,
	    creditTotal = 40,
	    generalTotal = 41,
	    siteTotal = 42,
	    reportInPreparationToTheEuropeanServicesDeclaration = 43,
	    reprintingTheReportInPreparationToTheEuropeanServicesDeclaration = 44,
	    ledgerTotal = 45,
	    total = 46
	}
	export interface CrystalReportsAccContd$EnumInterface {
	    days1: 1;
	    weeks: 2;
	    substituteValue3: 3;
	    fortnights: 4;
	    months: 5;
	    fixed: 6;
	    file: 7;
	    criteria: 8;
	    empty: 9;
	    s: 10;
	    p: 11;
	    d: 12;
	    rBVariance13: 13;
	    rEBVariance14: 14;
	    rEPBVariance15: 15;
	    rBQtyVariance16: 16;
	    rEBQtyVariance17: 17;
	    rEPBQtyVariance18: 18;
	    rBVariance: 19;
	    rEBVariance: 20;
	    rEPBVariance: 21;
	    rBQtyVariance: 22;
	    rEBQtyVariance: 23;
	    rEPBQtyVariance: 24;
	    balanceChgRev: 25;
	    balancePdtRev: 26;
	    achievedQty: 27;
	    days28: 28;
	    notDue: 29;
	    dueDate: 30;
	    telephone: 31;
	    days: 32;
	    byBpCode: 33;
	    typeDocumentNumber: 34;
	    tradeName: 35;
	    preparatoryReportForTheTaxDeclarationOnPayments: 36;
	    reprintPreparatoryReportForTheTaxDeclarationOnPayments: 37;
	    txsOn: 38;
	    debitTotal: 39;
	    creditTotal: 40;
	    generalTotal: 41;
	    siteTotal: 42;
	    reportInPreparationToTheEuropeanServicesDeclaration: 43;
	    reprintingTheReportInPreparationToTheEuropeanServicesDeclaration: 44;
	    ledgerTotal: 45;
	    total: 46;
	}
	export type CrystalReportsAccContd = keyof CrystalReportsAccContd$EnumInterface;
	export const crystalReportsAccContdDatatype: X3EnumDataType<keyof CrystalReportsAccContd$EnumInterface, unknown>;
	//# sourceMappingURL=crystal-reports-acc-contd.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/cre-sending-medium-type-code.d.ts
declare module '@sage/x3-finance-data/lib/enums/cre-sending-medium-type-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CreSendingMediumTypeCodeEnum {
	    email = 1,
	    paperMaterialByPostalMail = 2
	}
	export interface CreSendingMediumTypeCode$EnumInterface {
	    email: 1;
	    paperMaterialByPostalMail: 2;
	}
	export type CreSendingMediumTypeCode = keyof CreSendingMediumTypeCode$EnumInterface;
	export const creSendingMediumTypeCodeDatatype: X3EnumDataType<keyof CreSendingMediumTypeCode$EnumInterface, unknown>;
	//# sourceMappingURL=cre-sending-medium-type-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/country-address-code.d.ts
declare module '@sage/x3-finance-data/lib/enums/country-address-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CountryAddressCodeEnum {
	    bpAddress = 1,
	    paymentAddress = 2
	}
	export interface CountryAddressCode$EnumInterface {
	    bpAddress: 1;
	    paymentAddress: 2;
	}
	export type CountryAddressCode = keyof CountryAddressCode$EnumInterface;
	export const countryAddressCodeDatatype: X3EnumDataType<keyof CountryAddressCode$EnumInterface, unknown>;
	//# sourceMappingURL=country-address-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/control-type-2625.d.ts
declare module '@sage/x3-finance-data/lib/enums/control-type-2625' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlType2625Enum {
	    blocking = 1,
	    notBlocking = 2
	}
	export interface ControlType2625$EnumInterface {
	    blocking: 1;
	    notBlocking: 2;
	}
	export type ControlType2625 = keyof ControlType2625$EnumInterface;
	export const controlType2625Datatype: X3EnumDataType<keyof ControlType2625$EnumInterface, unknown>;
	//# sourceMappingURL=control-type-2625.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/control-type-2600.d.ts
declare module '@sage/x3-finance-data/lib/enums/control-type-2600' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlType2600Enum {
	    none = 1,
	    annual = 2,
	    period = 3,
	    sliding = 4,
	    accumulated = 5
	}
	export interface ControlType2600$EnumInterface {
	    none: 1;
	    annual: 2;
	    period: 3;
	    sliding: 4;
	    accumulated: 5;
	}
	export type ControlType2600 = keyof ControlType2600$EnumInterface;
	export const controlType2600Datatype: X3EnumDataType<keyof ControlType2600$EnumInterface, unknown>;
	//# sourceMappingURL=control-type-2600.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/control-account.d.ts
declare module '@sage/x3-finance-data/lib/enums/control-account' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlAccountEnum {
	    supplier = 1,
	    customer = 2,
	    indifferent = 3
	}
	export interface ControlAccount$EnumInterface {
	    supplier: 1;
	    customer: 2;
	    indifferent: 3;
	}
	export type ControlAccount = keyof ControlAccount$EnumInterface;
	export const controlAccountDatatype: X3EnumDataType<keyof ControlAccount$EnumInterface, unknown>;
	//# sourceMappingURL=control-account.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/company-activity-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/company-activity-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CompanyActivityTypeEnum {
	    other = 1,
	    retail = 2
	}
	export interface CompanyActivityType$EnumInterface {
	    other: 1;
	    retail: 2;
	}
	export type CompanyActivityType = keyof CompanyActivityType$EnumInterface;
	export const companyActivityTypeDatatype: X3EnumDataType<keyof CompanyActivityType$EnumInterface, unknown>;
	//# sourceMappingURL=company-activity-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/commitment-type-631.d.ts
declare module '@sage/x3-finance-data/lib/enums/commitment-type-631' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CommitmentType631Enum {
	    precommitment = 1,
	    commitment = 2
	}
	export interface CommitmentType631$EnumInterface {
	    precommitment: 1;
	    commitment: 2;
	}
	export type CommitmentType631 = keyof CommitmentType631$EnumInterface;
	export const commitmentType631Datatype: X3EnumDataType<keyof CommitmentType631$EnumInterface, unknown>;
	//# sourceMappingURL=commitment-type-631.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/column-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/column-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ColumnTypeEnum {
	    debitCredit1 = 1,
	    debitCredit = 2,
	    creditDebit = 3
	}
	export interface ColumnType$EnumInterface {
	    debitCredit1: 1;
	    debitCredit: 2;
	    creditDebit: 3;
	}
	export type ColumnType = keyof ColumnType$EnumInterface;
	export const columnTypeDatatype: X3EnumDataType<keyof ColumnType$EnumInterface, unknown>;
	//# sourceMappingURL=column-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/column-information.d.ts
declare module '@sage/x3-finance-data/lib/enums/column-information' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ColumnInformationEnum {
	    quantity = 1,
	    amount = 2,
	    actualQuantity = 3,
	    actualAmount = 4,
	    quantityCommitted = 5,
	    amountCommitted = 6,
	    quantityPrecommitted = 7,
	    amountPrecommitted = 8,
	    formula = 9,
	    text = 10
	}
	export interface ColumnInformation$EnumInterface {
	    quantity: 1;
	    amount: 2;
	    actualQuantity: 3;
	    actualAmount: 4;
	    quantityCommitted: 5;
	    amountCommitted: 6;
	    quantityPrecommitted: 7;
	    amountPrecommitted: 8;
	    formula: 9;
	    text: 10;
	}
	export type ColumnInformation = keyof ColumnInformation$EnumInterface;
	export const columnInformationDatatype: X3EnumDataType<keyof ColumnInformation$EnumInterface, unknown>;
	//# sourceMappingURL=column-information.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/closing-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/closing-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ClosingTypeEnum {
	    generalAccounting = 1,
	    dimensional = 2,
	    complete = 3
	}
	export interface ClosingType$EnumInterface {
	    generalAccounting: 1;
	    dimensional: 2;
	    complete: 3;
	}
	export type ClosingType = keyof ClosingType$EnumInterface;
	export const closingTypeDatatype: X3EnumDataType<keyof ClosingType$EnumInterface, unknown>;
	//# sourceMappingURL=closing-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/child-unit-in-declaration.d.ts
declare module '@sage/x3-finance-data/lib/enums/child-unit-in-declaration' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ChildUnitInDeclarationEnum {
	    no = 1,
	    wholeUnit = 2,
	    halfUnit = 3
	}
	export interface ChildUnitInDeclaration$EnumInterface {
	    no: 1;
	    wholeUnit: 2;
	    halfUnit: 3;
	}
	export type ChildUnitInDeclaration = keyof ChildUnitInDeclaration$EnumInterface;
	export const childUnitInDeclarationDatatype: X3EnumDataType<keyof ChildUnitInDeclaration$EnumInterface, unknown>;
	//# sourceMappingURL=child-unit-in-declaration.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/check-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/check-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CheckTypeEnum {
	    localCheck = 1,
	    outstationCheck = 2,
	    foreign = 3,
	    euro = 4
	}
	export interface CheckType$EnumInterface {
	    localCheck: 1;
	    outstationCheck: 2;
	    foreign: 3;
	    euro: 4;
	}
	export type CheckType = keyof CheckType$EnumInterface;
	export const checkTypeDatatype: X3EnumDataType<keyof CheckType$EnumInterface, unknown>;
	//# sourceMappingURL=check-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/chart-of-accounts-enum.d.ts
declare module '@sage/x3-finance-data/lib/enums/chart-of-accounts-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ChartOfAccountsEnumEnum {
	    masterChart = 1,
	    localChart = 2,
	    consolidatedChart = 3
	}
	export interface ChartOfAccountsEnum$EnumInterface {
	    masterChart: 1;
	    localChart: 2;
	    consolidatedChart: 3;
	}
	export type ChartOfAccountsEnum = keyof ChartOfAccountsEnum$EnumInterface;
	export const chartOfAccountsEnumDatatype: X3EnumDataType<keyof ChartOfAccountsEnum$EnumInterface, unknown>;
	//# sourceMappingURL=chart-of-accounts-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/category-formats.d.ts
declare module '@sage/x3-finance-data/lib/enums/category-formats' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CategoryFormatsEnum {
	    general = 1,
	    analytical = 2,
	    byLot = 3
	}
	export interface CategoryFormats$EnumInterface {
	    general: 1;
	    analytical: 2;
	    byLot: 3;
	}
	export type CategoryFormats = keyof CategoryFormats$EnumInterface;
	export const categoryFormatsDatatype: X3EnumDataType<keyof CategoryFormats$EnumInterface, unknown>;
	//# sourceMappingURL=category-formats.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/cash-interface.d.ts
declare module '@sage/x3-finance-data/lib/enums/cash-interface' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CashInterfaceEnum {
	    none = 1,
	    notesPayableReceivablePosting = 2,
	    intermediatePosting = 3,
	    bankPosting = 4
	}
	export interface CashInterface$EnumInterface {
	    none: 1;
	    notesPayableReceivablePosting: 2;
	    intermediatePosting: 3;
	    bankPosting: 4;
	}
	export type CashInterface = keyof CashInterface$EnumInterface;
	export const cashInterfaceDatatype: X3EnumDataType<keyof CashInterface$EnumInterface, unknown>;
	//# sourceMappingURL=cash-interface.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/cash-interface-2675.d.ts
declare module '@sage/x3-finance-data/lib/enums/cash-interface-2675' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CashInterface2675Enum {
	    descr = 1,
	    trans = 2,
	    budg = 3
	}
	export interface CashInterface2675$EnumInterface {
	    descr: 1;
	    trans: 2;
	    budg: 3;
	}
	export type CashInterface2675 = keyof CashInterface2675$EnumInterface;
	export const cashInterface2675Datatype: X3EnumDataType<keyof CashInterface2675$EnumInterface, unknown>;
	//# sourceMappingURL=cash-interface-2675.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/cash-flow-interface.d.ts
declare module '@sage/x3-finance-data/lib/enums/cash-flow-interface' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CashFlowInterfaceEnum {
	    dope = 1,
	    trans = 2,
	    budg = 3,
	    lcr = 4,
	    ref = 5
	}
	export interface CashFlowInterface$EnumInterface {
	    dope: 1;
	    trans: 2;
	    budg: 3;
	    lcr: 4;
	    ref: 5;
	}
	export type CashFlowInterface = keyof CashFlowInterface$EnumInterface;
	export const cashFlowInterfaceDatatype: X3EnumDataType<keyof CashFlowInterface$EnumInterface, unknown>;
	//# sourceMappingURL=cash-flow-interface.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/business-partner-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/business-partner-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BusinessPartnerTypeEnum {
	    customer = 1,
	    supplier = 2
	}
	export interface BusinessPartnerType$EnumInterface {
	    customer: 1;
	    supplier: 2;
	}
	export type BusinessPartnerType = keyof BusinessPartnerType$EnumInterface;
	export const businessPartnerTypeDatatype: X3EnumDataType<keyof BusinessPartnerType$EnumInterface, unknown>;
	//# sourceMappingURL=business-partner-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/business-partner-type-672.d.ts
declare module '@sage/x3-finance-data/lib/enums/business-partner-type-672' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BusinessPartnerType672Enum {
	    payByBp = 1,
	    billToBp = 2
	}
	export interface BusinessPartnerType672$EnumInterface {
	    payByBp: 1;
	    billToBp: 2;
	}
	export type BusinessPartnerType672 = keyof BusinessPartnerType672$EnumInterface;
	export const businessPartnerType672Datatype: X3EnumDataType<keyof BusinessPartnerType672$EnumInterface, unknown>;
	//# sourceMappingURL=business-partner-type-672.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/business-partner-journal-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/business-partner-journal-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BusinessPartnerJournalTypeEnum {
	    unique = 1,
	    byDiscountType = 2
	}
	export interface BusinessPartnerJournalType$EnumInterface {
	    unique: 1;
	    byDiscountType: 2;
	}
	export type BusinessPartnerJournalType = keyof BusinessPartnerJournalType$EnumInterface;
	export const businessPartnerJournalTypeDatatype: X3EnumDataType<keyof BusinessPartnerJournalType$EnumInterface, unknown>;
	//# sourceMappingURL=business-partner-journal-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/building-location.d.ts
declare module '@sage/x3-finance-data/lib/enums/building-location' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BuildingLocationEnum {
	    locatedOnNationalTerritory = 1,
	    locatedInBasqueCountryOrNavarre = 2,
	    withoutCadastreReference = 3,
	    locatedAbroad = 4
	}
	export interface BuildingLocation$EnumInterface {
	    locatedOnNationalTerritory: 1;
	    locatedInBasqueCountryOrNavarre: 2;
	    withoutCadastreReference: 3;
	    locatedAbroad: 4;
	}
	export type BuildingLocation = keyof BuildingLocation$EnumInterface;
	export const buildingLocationDatatype: X3EnumDataType<keyof BuildingLocation$EnumInterface, unknown>;
	//# sourceMappingURL=building-location.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/budgetary-gl-management.d.ts
declare module '@sage/x3-finance-data/lib/enums/budgetary-gl-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetaryGlManagementEnum {
	    none = 1,
	    manual = 2,
	    complete = 3
	}
	export interface BudgetaryGlManagement$EnumInterface {
	    none: 1;
	    manual: 2;
	    complete: 3;
	}
	export type BudgetaryGlManagement = keyof BudgetaryGlManagement$EnumInterface;
	export const budgetaryGlManagementDatatype: X3EnumDataType<keyof BudgetaryGlManagement$EnumInterface, unknown>;
	//# sourceMappingURL=budgetary-gl-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/budgetary-control-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/budgetary-control-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetaryControlTypeEnum {
	    none = 1,
	    holding = 2,
	    notHolding = 3,
	    accordingToOperator = 4
	}
	export interface BudgetaryControlType$EnumInterface {
	    none: 1;
	    holding: 2;
	    notHolding: 3;
	    accordingToOperator: 4;
	}
	export type BudgetaryControlType = keyof BudgetaryControlType$EnumInterface;
	export const budgetaryControlTypeDatatype: X3EnumDataType<keyof BudgetaryControlType$EnumInterface, unknown>;
	//# sourceMappingURL=budgetary-control-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/budgetary-control-type-648.d.ts
declare module '@sage/x3-finance-data/lib/enums/budgetary-control-type-648' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetaryControlType648Enum {
	    none = 1,
	    blocking = 2,
	    notBlocking = 3
	}
	export interface BudgetaryControlType648$EnumInterface {
	    none: 1;
	    blocking: 2;
	    notBlocking: 3;
	}
	export type BudgetaryControlType648 = keyof BudgetaryControlType648$EnumInterface;
	export const budgetaryControlType648Datatype: X3EnumDataType<keyof BudgetaryControlType648$EnumInterface, unknown>;
	//# sourceMappingURL=budgetary-control-type-648.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/budget-statistical-group.d.ts
declare module '@sage/x3-finance-data/lib/enums/budget-statistical-group' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetStatisticalGroupEnum {
	    mcl1A = 1,
	    mcl2B = 2,
	    mcl3C = 3,
	    mcl4D = 4,
	    notUsed = 5
	}
	export interface BudgetStatisticalGroup$EnumInterface {
	    mcl1A: 1;
	    mcl2B: 2;
	    mcl3C: 3;
	    mcl4D: 4;
	    notUsed: 5;
	}
	export type BudgetStatisticalGroup = keyof BudgetStatisticalGroup$EnumInterface;
	export const budgetStatisticalGroupDatatype: X3EnumDataType<keyof BudgetStatisticalGroup$EnumInterface, unknown>;
	//# sourceMappingURL=budget-statistical-group.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/budget-overrun.d.ts
declare module '@sage/x3-finance-data/lib/enums/budget-overrun' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetOverrunEnum {
	    noOverrun = 1,
	    withinTheLimitsOfTheBudgetRemainingToBeAllocated = 2,
	    withinTheLimitsOfTheBudgetReserve = 3,
	    withinTheLimitsOfTheEnvelopeRemainingToBeAllocated = 4,
	    withinTheLimitsOfTheEnvelopeReserve = 5,
	    envelopeOverrun = 6
	}
	export interface BudgetOverrun$EnumInterface {
	    noOverrun: 1;
	    withinTheLimitsOfTheBudgetRemainingToBeAllocated: 2;
	    withinTheLimitsOfTheBudgetReserve: 3;
	    withinTheLimitsOfTheEnvelopeRemainingToBeAllocated: 4;
	    withinTheLimitsOfTheEnvelopeReserve: 5;
	    envelopeOverrun: 6;
	}
	export type BudgetOverrun = keyof BudgetOverrun$EnumInterface;
	export const budgetOverrunDatatype: X3EnumDataType<keyof BudgetOverrun$EnumInterface, unknown>;
	//# sourceMappingURL=budget-overrun.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/budget-document-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/budget-document-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetDocumentTypeEnum {
	    all = 1,
	    purchaseRequests = 2,
	    orders = 3
	}
	export interface BudgetDocumentType$EnumInterface {
	    all: 1;
	    purchaseRequests: 2;
	    orders: 3;
	}
	export type BudgetDocumentType = keyof BudgetDocumentType$EnumInterface;
	export const budgetDocumentTypeDatatype: X3EnumDataType<keyof BudgetDocumentType$EnumInterface, unknown>;
	//# sourceMappingURL=budget-document-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/budget-definition-level.d.ts
declare module '@sage/x3-finance-data/lib/enums/budget-definition-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetDefinitionLevelEnum {
	    company = 1,
	    site = 2
	}
	export interface BudgetDefinitionLevel$EnumInterface {
	    company: 1;
	    site: 2;
	}
	export type BudgetDefinitionLevel = keyof BudgetDefinitionLevel$EnumInterface;
	export const budgetDefinitionLevelDatatype: X3EnumDataType<keyof BudgetDefinitionLevel$EnumInterface, unknown>;
	//# sourceMappingURL=budget-definition-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/budget-control-level.d.ts
declare module '@sage/x3-finance-data/lib/enums/budget-control-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetControlLevelEnum {
	    line = 1,
	    fiscalYear = 2,
	    envelope = 3
	}
	export interface BudgetControlLevel$EnumInterface {
	    line: 1;
	    fiscalYear: 2;
	    envelope: 3;
	}
	export type BudgetControlLevel = keyof BudgetControlLevel$EnumInterface;
	export const budgetControlLevelDatatype: X3EnumDataType<keyof BudgetControlLevel$EnumInterface, unknown>;
	//# sourceMappingURL=budget-control-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/budget-category.d.ts
declare module '@sage/x3-finance-data/lib/enums/budget-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetCategoryEnum {
	    period = 1,
	    account = 2,
	    dimension = 3
	}
	export interface BudgetCategory$EnumInterface {
	    period: 1;
	    account: 2;
	    dimension: 3;
	}
	export type BudgetCategory = keyof BudgetCategory$EnumInterface;
	export const budgetCategoryDatatype: X3EnumDataType<keyof BudgetCategory$EnumInterface, unknown>;
	//# sourceMappingURL=budget-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/budget-category-2692.d.ts
declare module '@sage/x3-finance-data/lib/enums/budget-category-2692' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BudgetCategory2692Enum {
	    annual = 1,
	    multiannual = 2
	}
	export interface BudgetCategory2692$EnumInterface {
	    annual: 1;
	    multiannual: 2;
	}
	export type BudgetCategory2692 = keyof BudgetCategory2692$EnumInterface;
	export const budgetCategory2692Datatype: X3EnumDataType<keyof BudgetCategory2692$EnumInterface, unknown>;
	//# sourceMappingURL=budget-category-2692.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/box-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/box-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BoxTypeEnum {
	    amount = 1,
	    text = 2,
	    checkbox = 3
	}
	export interface BoxType$EnumInterface {
	    amount: 1;
	    text: 2;
	    checkbox: 3;
	}
	export type BoxType = keyof BoxType$EnumInterface;
	export const boxTypeDatatype: X3EnumDataType<keyof BoxType$EnumInterface, unknown>;
	//# sourceMappingURL=box-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/benefit-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/benefit-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BenefitTypeEnum {
	    expenseAccruals = 1,
	    revenueAccruals = 2
	}
	export interface BenefitType$EnumInterface {
	    expenseAccruals: 1;
	    revenueAccruals: 2;
	}
	export type BenefitType = keyof BenefitType$EnumInterface;
	export const benefitTypeDatatype: X3EnumDataType<keyof BenefitType$EnumInterface, unknown>;
	//# sourceMappingURL=benefit-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/batch-field-description.d.ts
declare module '@sage/x3-finance-data/lib/enums/batch-field-description' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BatchFieldDescriptionEnum {
	    numeric = 1,
	    total = 2,
	    alphabetical = 3,
	    valueN1 = 4,
	    formula = 5
	}
	export interface BatchFieldDescription$EnumInterface {
	    numeric: 1;
	    total: 2;
	    alphabetical: 3;
	    valueN1: 4;
	    formula: 5;
	}
	export type BatchFieldDescription = keyof BatchFieldDescription$EnumInterface;
	export const batchFieldDescriptionDatatype: X3EnumDataType<keyof BatchFieldDescription$EnumInterface, unknown>;
	//# sourceMappingURL=batch-field-description.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/bank-statement-source.d.ts
declare module '@sage/x3-finance-data/lib/enums/bank-statement-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BankStatementSourceEnum {
	    imported = 1,
	    entered = 2
	}
	export interface BankStatementSource$EnumInterface {
	    imported: 1;
	    entered: 2;
	}
	export type BankStatementSource = keyof BankStatementSource$EnumInterface;
	export const bankStatementSourceDatatype: X3EnumDataType<keyof BankStatementSource$EnumInterface, unknown>;
	//# sourceMappingURL=bank-statement-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/bank-sort.d.ts
declare module '@sage/x3-finance-data/lib/enums/bank-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BankSortEnum {
	    accountingDate = 1,
	    valueDate = 2
	}
	export interface BankSort$EnumInterface {
	    accountingDate: 1;
	    valueDate: 2;
	}
	export type BankSort = keyof BankSort$EnumInterface;
	export const bankSortDatatype: X3EnumDataType<keyof BankSort$EnumInterface, unknown>;
	//# sourceMappingURL=bank-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/bank-reconciliation-option.d.ts
declare module '@sage/x3-finance-data/lib/enums/bank-reconciliation-option' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BankReconciliationOptionEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2
	}
	export interface BankReconciliationOption$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	}
	export type BankReconciliationOption = keyof BankReconciliationOption$EnumInterface;
	export const bankReconciliationOptionDatatype: X3EnumDataType<keyof BankReconciliationOption$EnumInterface, unknown>;
	//# sourceMappingURL=bank-reconciliation-option.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/bank-charge-bearer.d.ts
declare module '@sage/x3-finance-data/lib/enums/bank-charge-bearer' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BankChargeBearerEnum {
	    shared = 1,
	    beneficiary = 2,
	    applicant = 3
	}
	export interface BankChargeBearer$EnumInterface {
	    shared: 1;
	    beneficiary: 2;
	    applicant: 3;
	}
	export type BankChargeBearer = keyof BankChargeBearer$EnumInterface;
	export const bankChargeBearerDatatype: X3EnumDataType<keyof BankChargeBearer$EnumInterface, unknown>;
	//# sourceMappingURL=bank-charge-bearer.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/bank-assignment-method.d.ts
declare module '@sage/x3-finance-data/lib/enums/bank-assignment-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BankAssignmentMethodEnum {
	    closestDueDate = 1,
	    highestAmount = 2
	}
	export interface BankAssignmentMethod$EnumInterface {
	    closestDueDate: 1;
	    highestAmount: 2;
	}
	export type BankAssignmentMethod = keyof BankAssignmentMethod$EnumInterface;
	export const bankAssignmentMethodDatatype: X3EnumDataType<keyof BankAssignmentMethod$EnumInterface, unknown>;
	//# sourceMappingURL=bank-assignment-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/balance-update.d.ts
declare module '@sage/x3-finance-data/lib/enums/balance-update' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BalanceUpdateEnum {
	    no = 1,
	    customer = 2,
	    supplier = 3
	}
	export interface BalanceUpdate$EnumInterface {
	    no: 1;
	    customer: 2;
	    supplier: 3;
	}
	export type BalanceUpdate = keyof BalanceUpdate$EnumInterface;
	export const balanceUpdateDatatype: X3EnumDataType<keyof BalanceUpdate$EnumInterface, unknown>;
	//# sourceMappingURL=balance-update.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/balance-sort.d.ts
declare module '@sage/x3-finance-data/lib/enums/balance-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BalanceSortEnum {
	    code = 1,
	    companyName = 2,
	    shortTitle = 3,
	    siteRegistrationNumber = 4,
	    groupCode = 5
	}
	export interface BalanceSort$EnumInterface {
	    code: 1;
	    companyName: 2;
	    shortTitle: 3;
	    siteRegistrationNumber: 4;
	    groupCode: 5;
	}
	export type BalanceSort = keyof BalanceSort$EnumInterface;
	export const balanceSortDatatype: X3EnumDataType<keyof BalanceSort$EnumInterface, unknown>;
	//# sourceMappingURL=balance-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/balance-payment-account-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/balance-payment-account-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BalancePaymentAccountTypeEnum {
	    internalBankAccount = 1,
	    externalBankAccount = 2,
	    otherExternalAccount = 3,
	    compensationAccount = 4,
	    withoutAccountTransactions = 5
	}
	export interface BalancePaymentAccountType$EnumInterface {
	    internalBankAccount: 1;
	    externalBankAccount: 2;
	    otherExternalAccount: 3;
	    compensationAccount: 4;
	    withoutAccountTransactions: 5;
	}
	export type BalancePaymentAccountType = keyof BalancePaymentAccountType$EnumInterface;
	export const balancePaymentAccountTypeDatatype: X3EnumDataType<keyof BalancePaymentAccountType$EnumInterface, unknown>;
	//# sourceMappingURL=balance-payment-account-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/bad-debt-management-rules.d.ts
declare module '@sage/x3-finance-data/lib/enums/bad-debt-management-rules' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BadDebtManagementRulesEnum {
	    doubtfulDebts = 1,
	    impairment = 2,
	    writeOffs = 3,
	    all = 4
	}
	export interface BadDebtManagementRules$EnumInterface {
	    doubtfulDebts: 1;
	    impairment: 2;
	    writeOffs: 3;
	    all: 4;
	}
	export type BadDebtManagementRules = keyof BadDebtManagementRules$EnumInterface;
	export const badDebtManagementRulesDatatype: X3EnumDataType<keyof BadDebtManagementRules$EnumInterface, unknown>;
	//# sourceMappingURL=bad-debt-management-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/auxiliary-account-sort.d.ts
declare module '@sage/x3-finance-data/lib/enums/auxiliary-account-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AuxiliaryAccountSortEnum {
	    accountingDate = 1,
	    dueDate = 2,
	    valueDate = 3
	}
	export interface AuxiliaryAccountSort$EnumInterface {
	    accountingDate: 1;
	    dueDate: 2;
	    valueDate: 3;
	}
	export type AuxiliaryAccountSort = keyof AuxiliaryAccountSort$EnumInterface;
	export const auxiliaryAccountSortDatatype: X3EnumDataType<keyof AuxiliaryAccountSort$EnumInterface, unknown>;
	//# sourceMappingURL=auxiliary-account-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/automatic-line-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/automatic-line-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AutomaticLineTypeEnum {
	    unique = 1,
	    repetitive = 2,
	    linkedTable = 3
	}
	export interface AutomaticLineType$EnumInterface {
	    unique: 1;
	    repetitive: 2;
	    linkedTable: 3;
	}
	export type AutomaticLineType = keyof AutomaticLineType$EnumInterface;
	export const automaticLineTypeDatatype: X3EnumDataType<keyof AutomaticLineType$EnumInterface, unknown>;
	//# sourceMappingURL=automatic-line-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/assessment-method.d.ts
declare module '@sage/x3-finance-data/lib/enums/assessment-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssessmentMethodEnum {
	    none = 1,
	    byJournalEntry = 2,
	    byAccountBalance = 3
	}
	export interface AssessmentMethod$EnumInterface {
	    none: 1;
	    byJournalEntry: 2;
	    byAccountBalance: 3;
	}
	export type AssessmentMethod = keyof AssessmentMethod$EnumInterface;
	export const assessmentMethodDatatype: X3EnumDataType<keyof AssessmentMethod$EnumInterface, unknown>;
	//# sourceMappingURL=assessment-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/approval-processing.d.ts
declare module '@sage/x3-finance-data/lib/enums/approval-processing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ApprovalProcessingEnum {
	    none = 1,
	    approve = 2,
	    reject = 3
	}
	export interface ApprovalProcessing$EnumInterface {
	    none: 1;
	    approve: 2;
	    reject: 3;
	}
	export type ApprovalProcessing = keyof ApprovalProcessing$EnumInterface;
	export const approvalProcessingDatatype: X3EnumDataType<keyof ApprovalProcessing$EnumInterface, unknown>;
	//# sourceMappingURL=approval-processing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/approval-level.d.ts
declare module '@sage/x3-finance-data/lib/enums/approval-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ApprovalLevelEnum {
	    envelope = 1,
	    fiscalYearBudget = 2,
	    budgetLine = 3,
	    multiple = 4
	}
	export interface ApprovalLevel$EnumInterface {
	    envelope: 1;
	    fiscalYearBudget: 2;
	    budgetLine: 3;
	    multiple: 4;
	}
	export type ApprovalLevel = keyof ApprovalLevel$EnumInterface;
	export const approvalLevelDatatype: X3EnumDataType<keyof ApprovalLevel$EnumInterface, unknown>;
	//# sourceMappingURL=approval-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/analytical-sense.d.ts
declare module '@sage/x3-finance-data/lib/enums/analytical-sense' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnalyticalSenseEnum {
	    expense = 1,
	    revenue = 2
	}
	export interface AnalyticalSense$EnumInterface {
	    expense: 1;
	    revenue: 2;
	}
	export type AnalyticalSense = keyof AnalyticalSense$EnumInterface;
	export const analyticalSenseDatatype: X3EnumDataType<keyof AnalyticalSense$EnumInterface, unknown>;
	//# sourceMappingURL=analytical-sense.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/analytical-resync-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/analytical-resync-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnalyticalResyncTypeEnum {
	    balanceComparison = 1,
	    resynchronization = 2
	}
	export interface AnalyticalResyncType$EnumInterface {
	    balanceComparison: 1;
	    resynchronization: 2;
	}
	export type AnalyticalResyncType = keyof AnalyticalResyncType$EnumInterface;
	export const analyticalResyncTypeDatatype: X3EnumDataType<keyof AnalyticalResyncType$EnumInterface, unknown>;
	//# sourceMappingURL=analytical-resync-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/analytical-pyramids.d.ts
declare module '@sage/x3-finance-data/lib/enums/analytical-pyramids' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnalyticalPyramidsEnum {
	    unused = 1,
	    loads = 2,
	    products = 3,
	    balance = 4,
	    commitments = 5,
	    precommitments = 6,
	    realCommitments = 7,
	    realCommitmentsPrecommitments = 8,
	    budget = 9,
	    quantity = 10,
	    committedQuantity = 11,
	    qtyPrecommitments = 12,
	    qtyCommitments = 13,
	    qtyCommitmentsPrecommitments = 14,
	    budgetQuantity = 15,
	    bRAmt = 16,
	    bRCAmt = 17,
	    bRCPAmt = 18,
	    bRQty19 = 19,
	    bRCQty20 = 20,
	    bRCPQty21 = 21,
	    bR = 22,
	    bRC = 23,
	    bRCP = 24,
	    bRQty = 25,
	    bRCQty = 26,
	    bRCPQty = 27,
	    unit = 28
	}
	export interface AnalyticalPyramids$EnumInterface {
	    unused: 1;
	    loads: 2;
	    products: 3;
	    balance: 4;
	    commitments: 5;
	    precommitments: 6;
	    realCommitments: 7;
	    realCommitmentsPrecommitments: 8;
	    budget: 9;
	    quantity: 10;
	    committedQuantity: 11;
	    qtyPrecommitments: 12;
	    qtyCommitments: 13;
	    qtyCommitmentsPrecommitments: 14;
	    budgetQuantity: 15;
	    bRAmt: 16;
	    bRCAmt: 17;
	    bRCPAmt: 18;
	    bRQty19: 19;
	    bRCQty20: 20;
	    bRCPQty21: 21;
	    bR: 22;
	    bRC: 23;
	    bRCP: 24;
	    bRQty: 25;
	    bRCQty: 26;
	    bRCPQty: 27;
	    unit: 28;
	}
	export type AnalyticalPyramids = keyof AnalyticalPyramids$EnumInterface;
	export const analyticalPyramidsDatatype: X3EnumDataType<keyof AnalyticalPyramids$EnumInterface, unknown>;
	//# sourceMappingURL=analytical-pyramids.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/analytical-data-entry.d.ts
declare module '@sage/x3-finance-data/lib/enums/analytical-data-entry' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnalyticalDataEntryEnum {
	    allJournalEntries = 1,
	    noDimensionTypeValue = 2,
	    oneDimensionTypeWithNoValue = 3,
	    noValueOnDimensionType = 4
	}
	export interface AnalyticalDataEntry$EnumInterface {
	    allJournalEntries: 1;
	    noDimensionTypeValue: 2;
	    oneDimensionTypeWithNoValue: 3;
	    noValueOnDimensionType: 4;
	}
	export type AnalyticalDataEntry = keyof AnalyticalDataEntry$EnumInterface;
	export const analyticalDataEntryDatatype: X3EnumDataType<keyof AnalyticalDataEntry$EnumInterface, unknown>;
	//# sourceMappingURL=analytical-data-entry.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/analytical-category.d.ts
declare module '@sage/x3-finance-data/lib/enums/analytical-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnalyticalCategoryEnum {
	    general = 1,
	    analytical = 2
	}
	export interface AnalyticalCategory$EnumInterface {
	    general: 1;
	    analytical: 2;
	}
	export type AnalyticalCategory = keyof AnalyticalCategory$EnumInterface;
	export const analyticalCategoryDatatype: X3EnumDataType<keyof AnalyticalCategory$EnumInterface, unknown>;
	//# sourceMappingURL=analytical-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/analytical-balances.d.ts
declare module '@sage/x3-finance-data/lib/enums/analytical-balances' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnalyticalBalancesEnum {
	    unused = 1,
	    debits = 2,
	    credits = 3,
	    balanceDrCr = 4,
	    balanceCrDr = 5,
	    commitments = 6,
	    precommitments = 7,
	    actualCommitted = 8,
	    actualCommittedPrecommitted = 9,
	    budget = 10,
	    quantity = 11,
	    committedQuantity = 12,
	    precommittedQuantity = 13,
	    quantityCommitted = 14,
	    quantityCommittedPrecommitted = 15,
	    budgetQuantity = 16,
	    bAAmt = 17,
	    bACAmt = 18,
	    bACPAmt = 19,
	    bAQty20 = 20,
	    bACQty21 = 21,
	    bACPQty22 = 22,
	    bA = 23,
	    bAC = 24,
	    bACP = 25,
	    bAQty = 26,
	    bACQty = 27,
	    bACPQty = 28,
	    aBAmt = 29,
	    aCBAmt = 30,
	    aCPBAmt = 31,
	    aBQty32 = 32,
	    aCBQty33 = 33,
	    aCPBQty34 = 34,
	    aB = 35,
	    aCB = 36,
	    aCPB = 37,
	    aBQty = 38,
	    aCBQty = 39,
	    aCPBQty = 40,
	    unit = 41
	}
	export interface AnalyticalBalances$EnumInterface {
	    unused: 1;
	    debits: 2;
	    credits: 3;
	    balanceDrCr: 4;
	    balanceCrDr: 5;
	    commitments: 6;
	    precommitments: 7;
	    actualCommitted: 8;
	    actualCommittedPrecommitted: 9;
	    budget: 10;
	    quantity: 11;
	    committedQuantity: 12;
	    precommittedQuantity: 13;
	    quantityCommitted: 14;
	    quantityCommittedPrecommitted: 15;
	    budgetQuantity: 16;
	    bAAmt: 17;
	    bACAmt: 18;
	    bACPAmt: 19;
	    bAQty20: 20;
	    bACQty21: 21;
	    bACPQty22: 22;
	    bA: 23;
	    bAC: 24;
	    bACP: 25;
	    bAQty: 26;
	    bACQty: 27;
	    bACPQty: 28;
	    aBAmt: 29;
	    aCBAmt: 30;
	    aCPBAmt: 31;
	    aBQty32: 32;
	    aCBQty33: 33;
	    aCPBQty34: 34;
	    aB: 35;
	    aCB: 36;
	    aCPB: 37;
	    aBQty: 38;
	    aCBQty: 39;
	    aCPBQty: 40;
	    unit: 41;
	}
	export type AnalyticalBalances = keyof AnalyticalBalances$EnumInterface;
	export const analyticalBalancesDatatype: X3EnumDataType<keyof AnalyticalBalances$EnumInterface, unknown>;
	//# sourceMappingURL=analytical-balances.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/analytical-balance-sort.d.ts
declare module '@sage/x3-finance-data/lib/enums/analytical-balance-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnalyticalBalanceSortEnum {
	    dimensionsAccounts = 1,
	    accountsDimensions = 2
	}
	export interface AnalyticalBalanceSort$EnumInterface {
	    dimensionsAccounts: 1;
	    accountsDimensions: 2;
	}
	export type AnalyticalBalanceSort = keyof AnalyticalBalanceSort$EnumInterface;
	export const analyticalBalanceSortDatatype: X3EnumDataType<keyof AnalyticalBalanceSort$EnumInterface, unknown>;
	//# sourceMappingURL=analytical-balance-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/analytical-axis-entry.d.ts
declare module '@sage/x3-finance-data/lib/enums/analytical-axis-entry' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnalyticalAxisEntryEnum {
	    entered = 1,
	    mandatory = 2,
	    notEntered = 3
	}
	export interface AnalyticalAxisEntry$EnumInterface {
	    entered: 1;
	    mandatory: 2;
	    notEntered: 3;
	}
	export type AnalyticalAxisEntry = keyof AnalyticalAxisEntry$EnumInterface;
	export const analyticalAxisEntryDatatype: X3EnumDataType<keyof AnalyticalAxisEntry$EnumInterface, unknown>;
	//# sourceMappingURL=analytical-axis-entry.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/amounts-to-be-displayed.d.ts
declare module '@sage/x3-finance-data/lib/enums/amounts-to-be-displayed' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AmountsToBeDisplayedEnum {
	    balancesInLedgerCurrency = 1,
	    movementsAndBalancesInLedgerCurrency = 2,
	    balancesInTransactionCurrency = 3,
	    movementsAndBalancesInTransactionCurrency = 4
	}
	export interface AmountsToBeDisplayed$EnumInterface {
	    balancesInLedgerCurrency: 1;
	    movementsAndBalancesInLedgerCurrency: 2;
	    balancesInTransactionCurrency: 3;
	    movementsAndBalancesInTransactionCurrency: 4;
	}
	export type AmountsToBeDisplayed = keyof AmountsToBeDisplayed$EnumInterface;
	export const amountsToBeDisplayedDatatype: X3EnumDataType<keyof AmountsToBeDisplayed$EnumInterface, unknown>;
	//# sourceMappingURL=amounts-to-be-displayed.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/amounts-to-be-displayed-3606.d.ts
declare module '@sage/x3-finance-data/lib/enums/amounts-to-be-displayed-3606' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AmountsToBeDisplayed3606Enum {
	    balances = 1,
	    movementsAndBalances = 2
	}
	export interface AmountsToBeDisplayed3606$EnumInterface {
	    balances: 1;
	    movementsAndBalances: 2;
	}
	export type AmountsToBeDisplayed3606 = keyof AmountsToBeDisplayed3606$EnumInterface;
	export const amountsToBeDisplayed3606Datatype: X3EnumDataType<keyof AmountsToBeDisplayed3606$EnumInterface, unknown>;
	//# sourceMappingURL=amounts-to-be-displayed-3606.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/amounts-quantities.d.ts
declare module '@sage/x3-finance-data/lib/enums/amounts-quantities' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AmountsQuantitiesEnum {
	    amounts = 1,
	    quantities = 2
	}
	export interface AmountsQuantities$EnumInterface {
	    amounts: 1;
	    quantities: 2;
	}
	export type AmountsQuantities = keyof AmountsQuantities$EnumInterface;
	export const amountsQuantitiesDatatype: X3EnumDataType<keyof AmountsQuantities$EnumInterface, unknown>;
	//# sourceMappingURL=amounts-quantities.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/amount-type-686.d.ts
declare module '@sage/x3-finance-data/lib/enums/amount-type-686' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AmountType686Enum {
	    base = 1,
	    amount = 2
	}
	export interface AmountType686$EnumInterface {
	    base: 1;
	    amount: 2;
	}
	export type AmountType686 = keyof AmountType686$EnumInterface;
	export const amountType686Datatype: X3EnumDataType<keyof AmountType686$EnumInterface, unknown>;
	//# sourceMappingURL=amount-type-686.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/allocated-journal.d.ts
declare module '@sage/x3-finance-data/lib/enums/allocated-journal' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocatedJournalEnum {
	    customerOrder = 1,
	    supplierOrder = 2,
	    accountingJournal = 3,
	    supplierProforma = 4
	}
	export interface AllocatedJournal$EnumInterface {
	    customerOrder: 1;
	    supplierOrder: 2;
	    accountingJournal: 3;
	    supplierProforma: 4;
	}
	export type AllocatedJournal = keyof AllocatedJournal$EnumInterface;
	export const allocatedJournalDatatype: X3EnumDataType<keyof AllocatedJournal$EnumInterface, unknown>;
	//# sourceMappingURL=allocated-journal.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/allocated-document.d.ts
declare module '@sage/x3-finance-data/lib/enums/allocated-document' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocatedDocumentEnum {
	    customerOrder = 1,
	    supplierOrder = 2,
	    accountingJournal = 3,
	    supplierProforma = 4,
	    unallocated = 5
	}
	export interface AllocatedDocument$EnumInterface {
	    customerOrder: 1;
	    supplierOrder: 2;
	    accountingJournal: 3;
	    supplierProforma: 4;
	    unallocated: 5;
	}
	export type AllocatedDocument = keyof AllocatedDocument$EnumInterface;
	export const allocatedDocumentDatatype: X3EnumDataType<keyof AllocatedDocument$EnumInterface, unknown>;
	//# sourceMappingURL=allocated-document.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/aligning.d.ts
declare module '@sage/x3-finance-data/lib/enums/aligning' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AligningEnum {
	    accounts = 1,
	    dimension = 2
	}
	export interface Aligning$EnumInterface {
	    accounts: 1;
	    dimension: 2;
	}
	export type Aligning = keyof Aligning$EnumInterface;
	export const aligningDatatype: X3EnumDataType<keyof Aligning$EnumInterface, unknown>;
	//# sourceMappingURL=aligning.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/actual-simulation.d.ts
declare module '@sage/x3-finance-data/lib/enums/actual-simulation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActualSimulationEnum {
	    actual = 1,
	    activeSimulation = 2,
	    inactiveSimulation = 3
	}
	export interface ActualSimulation$EnumInterface {
	    actual: 1;
	    activeSimulation: 2;
	    inactiveSimulation: 3;
	}
	export type ActualSimulation = keyof ActualSimulation$EnumInterface;
	export const actualSimulationDatatype: X3EnumDataType<keyof ActualSimulation$EnumInterface, unknown>;
	//# sourceMappingURL=actual-simulation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/actual-budgeted.d.ts
declare module '@sage/x3-finance-data/lib/enums/actual-budgeted' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActualBudgetedEnum {
	    actual = 1,
	    budgeted = 2
	}
	export interface ActualBudgeted$EnumInterface {
	    actual: 1;
	    budgeted: 2;
	}
	export type ActualBudgeted = keyof ActualBudgeted$EnumInterface;
	export const actualBudgetedDatatype: X3EnumDataType<keyof ActualBudgeted$EnumInterface, unknown>;
	//# sourceMappingURL=actual-budgeted.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/activate-deactivate.d.ts
declare module '@sage/x3-finance-data/lib/enums/activate-deactivate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActivateDeactivateEnum {
	    activate = 1,
	    deactivate = 2
	}
	export interface ActivateDeactivate$EnumInterface {
	    activate: 1;
	    deactivate: 2;
	}
	export type ActivateDeactivate = keyof ActivateDeactivate$EnumInterface;
	export const activateDeactivateDatatype: X3EnumDataType<keyof ActivateDeactivate$EnumInterface, unknown>;
	//# sourceMappingURL=activate-deactivate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/action-type-8341.d.ts
declare module '@sage/x3-finance-data/lib/enums/action-type-8341' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionType8341Enum {
	    post = 1,
	    reverse = 2
	}
	export interface ActionType8341$EnumInterface {
	    post: 1;
	    reverse: 2;
	}
	export type ActionType8341 = keyof ActionType8341$EnumInterface;
	export const actionType8341Datatype: X3EnumDataType<keyof ActionType8341$EnumInterface, unknown>;
	//# sourceMappingURL=action-type-8341.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/accruals-generation-type.d.ts
declare module '@sage/x3-finance-data/lib/enums/accruals-generation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccrualsGenerationTypeEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2
	}
	export interface AccrualsGenerationType$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	}
	export type AccrualsGenerationType = keyof AccrualsGenerationType$EnumInterface;
	export const accrualsGenerationTypeDatatype: X3EnumDataType<keyof AccrualsGenerationType$EnumInterface, unknown>;
	//# sourceMappingURL=accruals-generation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/accounting-types.d.ts
declare module '@sage/x3-finance-data/lib/enums/accounting-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountingTypesEnum {
	    niCsN = 1,
	    ncrFsS = 2,
	    ncrfPeS = 3,
	    ncMeM = 4
	}
	export interface AccountingTypes$EnumInterface {
	    niCsN: 1;
	    ncrFsS: 2;
	    ncrfPeS: 3;
	    ncMeM: 4;
	}
	export type AccountingTypes = keyof AccountingTypes$EnumInterface;
	export const accountingTypesDatatype: X3EnumDataType<keyof AccountingTypes$EnumInterface, unknown>;
	//# sourceMappingURL=accounting-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/accounting-sign.d.ts
declare module '@sage/x3-finance-data/lib/enums/accounting-sign' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountingSignEnum {
	    paymentSign = 1,
	    expense = 2,
	    revenue = 3
	}
	export interface AccountingSign$EnumInterface {
	    paymentSign: 1;
	    expense: 2;
	    revenue: 3;
	}
	export type AccountingSign = keyof AccountingSign$EnumInterface;
	export const accountingSignDatatype: X3EnumDataType<keyof AccountingSign$EnumInterface, unknown>;
	//# sourceMappingURL=accounting-sign.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/accounting-journal-status.d.ts
declare module '@sage/x3-finance-data/lib/enums/accounting-journal-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountingJournalStatusEnum {
	    temporary = 1,
	    final = 2
	}
	export interface AccountingJournalStatus$EnumInterface {
	    temporary: 1;
	    final: 2;
	}
	export type AccountingJournalStatus = keyof AccountingJournalStatus$EnumInterface;
	export const accountingJournalStatusDatatype: X3EnumDataType<keyof AccountingJournalStatus$EnumInterface, unknown>;
	//# sourceMappingURL=accounting-journal-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/account-type-605.d.ts
declare module '@sage/x3-finance-data/lib/enums/account-type-605' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountType605Enum {
	    expense = 1,
	    revenue = 2,
	    investment = 3
	}
	export interface AccountType605$EnumInterface {
	    expense: 1;
	    revenue: 2;
	    investment: 3;
	}
	export type AccountType605 = keyof AccountType605$EnumInterface;
	export const accountType605Datatype: X3EnumDataType<keyof AccountType605$EnumInterface, unknown>;
	//# sourceMappingURL=account-type-605.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/account-type-2668.d.ts
declare module '@sage/x3-finance-data/lib/enums/account-type-2668' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountType2668Enum {
	    account = 1,
	    dimension = 2,
	    bp = 3
	}
	export interface AccountType2668$EnumInterface {
	    account: 1;
	    dimension: 2;
	    bp: 3;
	}
	export type AccountType2668 = keyof AccountType2668$EnumInterface;
	export const accountType2668Datatype: X3EnumDataType<keyof AccountType2668$EnumInterface, unknown>;
	//# sourceMappingURL=account-type-2668.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/account-status.d.ts
declare module '@sage/x3-finance-data/lib/enums/account-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountStatusEnum {
	    active = 1,
	    inactive = 2
	}
	export interface AccountStatus$EnumInterface {
	    active: 1;
	    inactive: 2;
	}
	export type AccountStatus = keyof AccountStatus$EnumInterface;
	export const accountStatusDatatype: X3EnumDataType<keyof AccountStatus$EnumInterface, unknown>;
	//# sourceMappingURL=account-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/account-specific-text-853.d.ts
declare module '@sage/x3-finance-data/lib/enums/account-specific-text-853' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountSpecificText853Enum {
	    test = 1,
	    additionalLineToUseForAutoJournalFasvatreg = 2
	}
	export interface AccountSpecificText853$EnumInterface {
	    test: 1;
	    additionalLineToUseForAutoJournalFasvatreg: 2;
	}
	export type AccountSpecificText853 = keyof AccountSpecificText853$EnumInterface;
	export const accountSpecificText853Datatype: X3EnumDataType<keyof AccountSpecificText853$EnumInterface, unknown>;
	//# sourceMappingURL=account-specific-text-853.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/account-sort.d.ts
declare module '@sage/x3-finance-data/lib/enums/account-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountSortEnum {
	    number = 1,
	    title = 2,
	    shortTitle = 3,
	    classification = 4,
	    reporting1Debit = 5,
	    reporting1Credit = 6,
	    reporting2Debit = 7,
	    reporting2Credit = 8,
	    consolidationCode = 9
	}
	export interface AccountSort$EnumInterface {
	    number: 1;
	    title: 2;
	    shortTitle: 3;
	    classification: 4;
	    reporting1Debit: 5;
	    reporting1Credit: 6;
	    reporting2Debit: 7;
	    reporting2Credit: 8;
	    consolidationCode: 9;
	}
	export type AccountSort = keyof AccountSort$EnumInterface;
	export const accountSortDatatype: X3EnumDataType<keyof AccountSort$EnumInterface, unknown>;
	//# sourceMappingURL=account-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/account-sort-676.d.ts
declare module '@sage/x3-finance-data/lib/enums/account-sort-676' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountSort676Enum {
	    number = 1,
	    title = 2,
	    shortTitle = 3
	}
	export interface AccountSort676$EnumInterface {
	    number: 1;
	    title: 2;
	    shortTitle: 3;
	}
	export type AccountSort676 = keyof AccountSort676$EnumInterface;
	export const accountSort676Datatype: X3EnumDataType<keyof AccountSort676$EnumInterface, unknown>;
	//# sourceMappingURL=account-sort-676.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/account-setup-sort.d.ts
declare module '@sage/x3-finance-data/lib/enums/account-setup-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountSetupSortEnum {
	    byAccountRoot = 1,
	    byAccount = 2
	}
	export interface AccountSetupSort$EnumInterface {
	    byAccountRoot: 1;
	    byAccount: 2;
	}
	export type AccountSetupSort = keyof AccountSetupSort$EnumInterface;
	export const accountSetupSortDatatype: X3EnumDataType<keyof AccountSetupSort$EnumInterface, unknown>;
	//# sourceMappingURL=account-setup-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/account-dimension-value.d.ts
declare module '@sage/x3-finance-data/lib/enums/account-dimension-value' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountDimensionValueEnum {
	    accountsDimensions = 1,
	    dimensionsAccounts = 2
	}
	export interface AccountDimensionValue$EnumInterface {
	    accountsDimensions: 1;
	    dimensionsAccounts: 2;
	}
	export type AccountDimensionValue = keyof AccountDimensionValue$EnumInterface;
	export const accountDimensionValueDatatype: X3EnumDataType<keyof AccountDimensionValue$EnumInterface, unknown>;
	//# sourceMappingURL=account-dimension-value.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/account-category.d.ts
declare module '@sage/x3-finance-data/lib/enums/account-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountCategoryEnum {
	    normal = 1,
	    offBalanceSheet = 2,
	    unused = 3
	}
	export interface AccountCategory$EnumInterface {
	    normal: 1;
	    offBalanceSheet: 2;
	    unused: 3;
	}
	export type AccountCategory = keyof AccountCategory$EnumInterface;
	export const accountCategoryDatatype: X3EnumDataType<keyof AccountCategory$EnumInterface, unknown>;
	//# sourceMappingURL=account-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/account-category-2.d.ts
declare module '@sage/x3-finance-data/lib/enums/account-category-2' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountCategory2Enum {
	    unspecified = 1,
	    direct = 2,
	    indirect = 3
	}
	export interface AccountCategory2$EnumInterface {
	    unspecified: 1;
	    direct: 2;
	    indirect: 3;
	}
	export type AccountCategory2 = keyof AccountCategory2$EnumInterface;
	export const accountCategory2Datatype: X3EnumDataType<keyof AccountCategory2$EnumInterface, unknown>;
	//# sourceMappingURL=account-category-2.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/account-category-1.d.ts
declare module '@sage/x3-finance-data/lib/enums/account-category-1' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccountCategory1Enum {
	    unspecified = 1,
	    fixed = 2,
	    variable = 3
	}
	export interface AccountCategory1$EnumInterface {
	    unspecified: 1;
	    fixed: 2;
	    variable: 3;
	}
	export type AccountCategory1 = keyof AccountCategory1$EnumInterface;
	export const accountCategory1Datatype: X3EnumDataType<keyof AccountCategory1$EnumInterface, unknown>;
	//# sourceMappingURL=account-category-1.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/acceptance-code.d.ts
declare module '@sage/x3-finance-data/lib/enums/acceptance-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AcceptanceCodeEnum {
	    billOfExchangeNotAccepted = 1,
	    billOfExchangeAccepted = 2,
	    promissoryNote = 3,
	    billOfExchangeToAccept = 4
	}
	export interface AcceptanceCode$EnumInterface {
	    billOfExchangeNotAccepted: 1;
	    billOfExchangeAccepted: 2;
	    promissoryNote: 3;
	    billOfExchangeToAccept: 4;
	}
	export type AcceptanceCode = keyof AcceptanceCode$EnumInterface;
	export const acceptanceCodeDatatype: X3EnumDataType<keyof AcceptanceCode$EnumInterface, unknown>;
	//# sourceMappingURL=acceptance-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-finance-data/build/lib/enums/acc-sequence-nos.d.ts
declare module '@sage/x3-finance-data/lib/enums/acc-sequence-nos' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AccSequenceNosEnum {
	    accountingSequenceNumber = 1,
	    commitments = 2,
	    lots = 3,
	    noVatDeclarationQueryDebits = 4,
	    noVatDeclarationQueryPayments = 5,
	    precommitments = 6,
	    budgetMOs = 7,
	    financialDataExtraction = 8,
	    projects = 9,
	    budgetApproval = 10,
	    reviewApproval = 11,
	    intercompanyDocumentNumber = 12,
	    annualVat = 13,
	    periodicVat = 14,
	    europeanServicesVat = 15,
	    finalNumber = 16,
	    annualCustomerListing = 17,
	    euVatStatement = 18,
	    auGstTaxReport = 19,
	    auWthTaxReport = 20,
	    fifoConversionsRecords = 21,
	    vatDeclarationNumber = 22
	}
	export interface AccSequenceNos$EnumInterface {
	    accountingSequenceNumber: 1;
	    commitments: 2;
	    lots: 3;
	    noVatDeclarationQueryDebits: 4;
	    noVatDeclarationQueryPayments: 5;
	    precommitments: 6;
	    budgetMOs: 7;
	    financialDataExtraction: 8;
	    projects: 9;
	    budgetApproval: 10;
	    reviewApproval: 11;
	    intercompanyDocumentNumber: 12;
	    annualVat: 13;
	    periodicVat: 14;
	    europeanServicesVat: 15;
	    finalNumber: 16;
	    annualCustomerListing: 17;
	    euVatStatement: 18;
	    auGstTaxReport: 19;
	    auWthTaxReport: 20;
	    fifoConversionsRecords: 21;
	    vatDeclarationNumber: 22;
	}
	export type AccSequenceNos = keyof AccSequenceNos$EnumInterface;
	export const accSequenceNosDatatype: X3EnumDataType<keyof AccSequenceNos$EnumInterface, unknown>;
	//# sourceMappingURL=acc-sequence-nos.d.ts.map
}
declare module '@sage/x3-finance-data' {
	export * from '@sage/x3-finance-data/index';
}
