"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenItem = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3FinanceData = require("..");
const joins = {
    referenceJoins: {
        documentType: {
            code: 'documentType',
            async legislation() {
                return (await (await (await this.site).legalCompany).legislation)?.code;
            },
        },
        company: {
            code: 'company',
        },
        site: {
            code: 'site',
        },
        currency: {
            code: 'currency',
        },
        businessPartner: {
            code: 'businessPartner',
        },
        payToOrPayByBusinessPartner: {
            code: 'payToOrPayByBusinessPartner',
        },
        paymentMethod: {
            code: 'paymentMethod',
            async legislation() {
                return (await (await (await this.site).legalCompany).legislation)?.code;
            },
        },
        earlyDiscountOrLateCharge: {
            code: 'earlyDiscountOrLateCharge',
            async legislation() {
                return (await (await (await this.site).legalCompany).legislation)?.code;
            },
        },
        dispute: {
            glossaryId() {
                return 315;
            },
            code: 'dispute',
        },
    },
};
let OpenItem = class OpenItem extends xtrem_core_1.Node {
};
exports.OpenItem = OpenItem;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TYP',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.EntryType,
    })
], OpenItem.prototype, "documentType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'NUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], OpenItem.prototype, "documentNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LIG',
    })
], OpenItem.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DUDLIG',
    })
], OpenItem.prototype, "openItemLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCNUM',
    })
], OpenItem.prototype, "journalEntryLineInternalNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], OpenItem.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], OpenItem.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], OpenItem.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], OpenItem.prototype, "controlAccount", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], OpenItem.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRTYP',
        dataType: () => sageX3FinanceData.enums.businessPartnerTypeDatatype,
    })
], OpenItem.prototype, "businessPartnerType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRPAY',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], OpenItem.prototype, "payToOrPayByBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DUDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], OpenItem.prototype, "dueDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAM',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.PaymentMethod,
    })
], OpenItem.prototype, "paymentMethod", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAMTYP',
        dataType: () => sageX3MasterData.enums.openItemTypeDatatype,
    })
], OpenItem.prototype, "paymentType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.EarlyDiscountLateCharge,
    })
], OpenItem.prototype, "earlyDiscountOrLateCharge", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SNS',
    })
], OpenItem.prototype, "sign", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTCUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OpenItem.prototype, "amountInCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTLOC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OpenItem.prototype, "amountInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAYCUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OpenItem.prototype, "paidAmountInCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAYLOC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OpenItem.prototype, "paidAmountInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TMPCUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OpenItem.prototype, "provisionalPaidAmountInCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TMPLOC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OpenItem.prototype, "provisionalPaidAmountInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGFUP',
    })
], OpenItem.prototype, "canBeReminded", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LEVFUP',
    })
], OpenItem.prototype, "reminderLevel", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DATFUP',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], OpenItem.prototype, "reminderDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DPTCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 315,
            },
            control: {
                glossaryId: 315,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], OpenItem.prototype, "dispute", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLGPAZ',
        dataType: () => sageX3MasterData.enums.paymentApprovalTypeDatatype,
    })
], OpenItem.prototype, "paymentApprovalLevel", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOI',
    })
], OpenItem.prototype, "canBeIncludedInStatement", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DUDSTA',
    })
], OpenItem.prototype, "postedStatus", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DINAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OpenItem.prototype, "deductedPrepaymentAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IBDAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OpenItem.prototype, "prepaymentAmountToDeduct", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIY',
    })
], OpenItem.prototype, "fiscalYear", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PER',
    })
], OpenItem.prototype, "period", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SENDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], OpenItem.prototype, "prepaymentInvoiceIssueDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SENINS',
    })
], OpenItem.prototype, "isPrepaymentIssued", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLGCLE',
    })
], OpenItem.prototype, "closedStatus", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAYDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], OpenItem.prototype, "paymentDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUMDUD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], OpenItem.prototype, "uniqueNumber", void 0);
exports.OpenItem = OpenItem = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'GACCDUDATE',
        keyPropertyNames: ['documentType', 'documentNumber', 'lineNumber', 'openItemLineNumber'],
        indexes: [
            {
                orderBy: {
                    documentType: 1,
                    documentNumber: 1,
                    lineNumber: 1,
                    openItemLineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['lineNumber', 'openItemLineNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], OpenItem);
//# sourceMappingURL=open-item.js.map