import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
import * as sageX3FinanceData from '..';
export declare class OpenItem extends Node {
    readonly documentType: Reference<sageX3FinanceData.nodes.EntryType>;
    readonly documentNumber: Promise<string>;
    readonly lineNumber: Promise<integer | null>;
    readonly openItemLineNumber: Promise<integer | null>;
    readonly journalEntryLineInternalNumber: Promise<integer | null>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly controlAccount: Promise<string>;
    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly businessPartnerType: Promise<sageX3FinanceData.enums.BusinessPartnerType | null>;
    readonly payToOrPayByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly dueDate: Promise<date | null>;
    readonly paymentMethod: Reference<sageX3InvoicingData.nodes.PaymentMethod | null>;
    readonly paymentType: Promise<sageX3MasterData.enums.OpenItemType | null>;
    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
    readonly sign: Promise<integer | null>;
    readonly amountInCurrency: Promise<decimal | null>;
    readonly amountInCompanyCurrency: Promise<decimal | null>;
    readonly paidAmountInCurrency: Promise<decimal | null>;
    readonly paidAmountInCompanyCurrency: Promise<decimal | null>;
    readonly provisionalPaidAmountInCurrency: Promise<decimal | null>;
    readonly provisionalPaidAmountInCompanyCurrency: Promise<decimal | null>;
    readonly canBeReminded: Promise<boolean>;
    readonly reminderLevel: Promise<integer | null>;
    readonly reminderDate: Promise<date | null>;
    readonly dispute: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly paymentApprovalLevel: Promise<sageX3MasterData.enums.PaymentApprovalType | null>;
    readonly canBeIncludedInStatement: Promise<boolean>;
    readonly postedStatus: Promise<integer | null>;
    readonly deductedPrepaymentAmount: Promise<decimal | null>;
    readonly prepaymentAmountToDeduct: Promise<decimal | null>;
    readonly fiscalYear: Promise<integer | null>;
    readonly period: Promise<integer | null>;
    readonly prepaymentInvoiceIssueDate: Promise<date | null>;
    readonly isPrepaymentIssued: Promise<boolean>;
    readonly closedStatus: Promise<integer | null>;
    readonly paymentDate: Promise<date | null>;
    readonly uniqueNumber: Promise<string>;
}
//# sourceMappingURL=open-item.d.ts.map