"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DistributionKey = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'CADSP';
            },
            columnName() {
                return 'DESTRA';
            },
            key1: ['code'],
        },
        localizedShortDescription: {
            tableName() {
                return 'CADSP';
            },
            columnName() {
                return 'SHOTRA';
            },
            key1: ['code'],
        },
    },
};
let DistributionKey = class DistributionKey extends xtrem_core_1.Node {
};
exports.DistributionKey = DistributionKey;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], DistributionKey.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBRDSP',
    })
], DistributionKey.prototype, "numberOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESTRA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], DistributionKey.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHOTRA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], DistributionKey.prototype, "localizedShortDescription", void 0);
exports.DistributionKey = DistributionKey = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CADSP',
        keyPropertyNames: ['code', 'numberOfLines'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                    numberOfLines: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['code', 'numberOfLines'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], DistributionKey);
//# sourceMappingURL=distribution-key.js.map