import { WorkOrderOperationLine } from '@sage/x3-manufacturing-api';
import { ExtractEdges, extractEdges } from '@sage/xtrem-client';
import * as ui from '@sage/xtrem-ui';

/** Function gets operations for a given work order number of a given page ( i.e. passing the 'this' keyword ) -
 *      Returns list of operations */
export async function getWorkOrderOperationsList(
    woNumber: string,
    page: ui.Page,
): Promise<ExtractEdges<WorkOrderOperationLine>[]> {
    try {
        const operationsList = extractEdges<WorkOrderOperationLine>(
            await page.$.graph
                .node('@sage/x3-manufacturing/WorkOrderOperationLine')
                .query(
                    ui.queryUtils.edgesSelector(
                        {
                            operationNumber: true,
                            operationDescription: true,
                            expectedWorkCenter: {
                                code: true,
                            },
                            operationUnit: {
                                code: true,
                            },
                            expectedQuantity: true,
                            completedQuantity: true,
                            timeUnit: true,
                            setupTime: true,
                            runTime: true,
                            operationStatus: true,
                        },
                        {
                            filter: {
                                workOrder: {
                                    number: woNumber,
                                },
                            },
                            first: 1000,
                        },
                    ),
                )
                .execute(),
        );
        return operationsList;
    } catch (err) {
        page.$.showToast(
            ui.localize(
                '@sage/x3-manufacturing/pages__adc_time_tracking___cannot_retrieve_operations',
                'Cannot retrieve operations.',
            ),
            { type: 'error', timeout: 5000 },
        );
        return [];
    }
}
