import * as ui from '@sage/xtrem-ui';

//TODO: not a fan of passing "this" in argument as the execution context. Class constructor, bind?
export async function validateWithDetails(pageInstance: ui.Page): Promise<boolean> {
    await pageInstance.$.commitValueAndPropertyChanges(); // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field
    const errors: ui.ValidationResult[] = await pageInstance.$.page.validateWithDetails();
    if (errors.length === 0) {
        return true;
    }

    pageInstance.$.removeToasts();
    pageInstance.$.showToast(
        ui.localize(
            '@sage/x3-manufacturing/pages__utils__notification__invalid_inputs_error',
            `Please check your inputs for {{#each fieldNames}}\n - {{this}}{{/each}}`,
            {
                fieldNames: errors.map(
                    (error: ui.ValidationResult) =>
                        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type
                        `${(pageInstance as any)[error.elementId]?.title ?? error.elementId}`,
                ),
            },
        ),
        { type: 'error', timeout: 5000 },
    );

    return false;
}
