import { GraphApi } from '@sage/x3-manufacturing-api';
import { integer } from '@sage/xtrem-shared';
import * as ui from '@sage/xtrem-ui';

// Get Unit of measure decimal places

export async function GetUOMNumberOfDecimalPlaces(pageInstance: ui.Page<GraphApi>, uom: string): Promise<integer> {
    try {
        const NumberofDecimals = await pageInstance.$.graph
            .node('@sage/x3-master-data/UnitOfMeasure')
            .read(
                {
                    code: true,
                    numberOfDecimals: true,
                },
                `${uom}`,
            )
            .execute();

        return NumberofDecimals.numberOfDecimals;
    } catch (e) {
        pageInstance.$.dialog.message(
            'error',
            ui.localize('@sage/x3-manufacturing/pages__utils__get_unit_decimal_places_error', 'Error loading unit'),
            String(e),
        );
        return 0;
    }
}
