/// <reference path="../../../../../../shared/x3-manufacturing-data/api/api.d.ts" />
import { StandardOperations, WorkOrder } from '@sage/x3-manufacturing-api';
import { WorkCenter } from '@sage/x3-manufacturing-data-api';
import { UnitOfMeasure } from '@sage/x3-master-data-api';
export interface ProductLine {
    product: Product;
    workOrder: WorkOrder;
    stockUnit: UnitOfMeasure;
    remainingQuantity: number;
    productCategory: string;
    lot: string;
}
export interface OperationLine {
    operationNumber: number;
    operationDescription: string;
    workOrder: WorkOrder;
    expectedWorkCenter: WorkCenter;
    runTime: number;
    setupTime: number;
    timeUnit: string;
    expectedQuantity: number;
    completedQuantity: number;
    rejectQuantity: number;
    operationUnit: UnitOfMeasure;
}
export interface Product {
    _id: string;
    code: string;
    localizedDescription1: string;
    lotManagementMode: string;
    lotSequenceNumber: string;
    serialNumberManagementMode: string;
    serialSequenceNumber: string;
}
export interface TrackingLineTable {
    _id: string;
    title: string;
    description: string;
    product: string;
    quantityAndStockUnit: string;
    actualQuantity: number;
    unit: string;
}
export interface TrackingLine {
    productionSite: string;
    orderNo: string;
    orderLineNumber: number;
    product: string;
    actualQuantity: number;
    postingDate: string;
    releaseUnit: UnitOfMeasure;
    stkConversion: number;
    transactionCode: string;
    balance: string;
    rejectedQty: string;
    project: string;
    serialNumber: string;
    destinationCode: string;
    licensePlateNumber: string;
    description: string;
    quantityInStockUnit: number;
    stockJournal: Partial<StockJournalInput>[];
}
export interface DefaultTrackingLine {
    productionSite: string;
    orderNo: string;
    postingDate: string;
    transaction: string;
}
export interface TimeTrackingLine extends DefaultTrackingLine {
    operation: number;
    employeeId: any;
    workOrderNumber: any;
    routing: string;
    routingCode: number;
    operationUnit: string;
    actualWorkCenter: string;
    actualQuantity: number;
    totalCompletedQuantity: number;
    actualRejectedQuantity: number;
    actualSetupTime: number;
    actualRunTime: number;
    workCenter: string;
    description: string;
    operationConversion: number;
    balance: number;
    rejection: number;
    bom: string;
    bomCode: number;
    operationSplit: number;
    alternativeIndex: number;
    project: string;
    standardOperation: number;
    timeUnit: string;
    operationNumber: number;
}
export interface MaterialTrackingLine {
    workOrder: string;
    productionSite: string;
    lineNumber: number;
    bomSequence: number;
    product: string;
    bomNumber: string;
    bomAlternative: number;
    consumedQuantity: number;
    postingDate: string;
    transaction: string;
    balance: string;
    mfgTrackingNumber: string;
    preferredLot: string;
    project: string;
    stockJournal: Partial<StockJournalInputMaterial>[];
}
export interface keyMaterialTrackingLine {
    workOrder: string;
    productionSite: string;
    lineNumber: number;
    bomSequence: number;
    product: string;
    bomNumber: string;
    bomAlternative: number;
    mfgTrackingNumber: string;
    preferredLot: string;
    project: string;
}
export interface StockJournalInput {
    stockSite: string;
    packingUnit: string;
    quantityInPackingUnit: number;
    packingUnitToStockUnitConversionFactor: number;
    status: string;
    lot: string;
    sublot: string;
    location: string;
    identifier1: string;
    identifier2: string;
    expirationDate: string;
}
export interface StockJournalInputMaterial {
    lot: string;
    sublot: string;
    location: string;
    packingUnit: string;
    quantityInPackingUnit: number;
    status: string;
    serialNumber: string;
    licensePlateNumber: string;
}
export interface StorageObject {
    transaction: string;
    trackingDate: string;
    workOrderNumber: any;
    productLine: Partial<ProductLine>;
    quantityTracking: {
        workOrderProductionReportingLines?: TrackingLine[];
    };
}
export interface DefaultStorageObject {
    transaction: string | null;
    trackingDate: string | null;
    workOrderNumber: any;
}
export interface TimeTrackingStorageObject extends DefaultStorageObject {
    stockSite: any;
    employeeId: any;
    operationLine: Partial<OperationLine> | null;
    standardOperations: Partial<StandardOperations> | null;
    operationMethod: SelectedOperationMethod;
    timeTracking: {
        workOrderOperationTrackingLines?: TimeTrackingLine[] | null | undefined;
    };
    userDefinedOperationNumber: number | null;
    userDefinedOperationDescription?: string | null;
    releaseTimeUnit: string | null;
    releaseUOM: string | null;
}
export interface StorageObjectMaterial {
    materialTracking: {
        productionSite: string;
        workOrderMaterialTrackingLines?: MaterialTrackingLine[];
    };
}
export interface X3Response {
    diagnoses?: DiagnosesEntity[] | null;
    x3Manufacturing?: x3Manufacturing;
    message?: string;
}
export interface DiagnosesEntity {
    severity: number;
    path?: null[] | null;
    message: string;
}
export interface x3Manufacturing {
    workOrderProductionReporting: WorkOrderProductionReporting;
    workOrderOperationTracking: WorkOrderOperationTracking;
    workOrderMaterialTracking: WorkOrderMaterialTrackingResult;
}
export interface WorkOrderProductionReporting {
    create?: Create;
}
export interface WorkOrderOperationTracking {
    create?: Create;
}
export interface WorkOrderMaterialTrackingResult {
    create?: Create;
}
export interface Create {
    trackingNumber: string | null;
}
export declare enum SelectedOperationMethod {
    RouterOperation = 0,// 0
    StandardOperationWithData = 1,// 1
    UserDefinedOperation = 2
}
export type PackingUnit = {
    node: {
        packingUnit: {
            code: string;
            numberOfDecimals: number;
            _id: string;
        };
        packingUnitToStockUnitConversionFactor: string;
        isPackingFactorEntryAllowed: boolean;
        _id: string;
    };
};
//# sourceMappingURL=types.d.ts.map