/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/get-unit-decimal-places.ts":
/*!*********************************************************!*\
  !*** ./lib/client-functions/get-unit-decimal-places.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.GetUOMNumberOfDecimalPlaces = void 0;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n// Get Unit of measure decimal places\nasync function GetUOMNumberOfDecimalPlaces(pageInstance, uom) {\n    try {\n        const NumberofDecimals = await pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .read({\n            code: true,\n            numberOfDecimals: true,\n        }, `${uom}`)\n            .execute();\n        return NumberofDecimals.numberOfDecimals;\n    }\n    catch (e) {\n        pageInstance.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__utils__get_unit_decimal_places_error', 'Error loading unit'), String(e));\n        return 0;\n    }\n}\nexports.GetUOMNumberOfDecimalPlaces = GetUOMNumberOfDecimalPlaces;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/get-unit-decimal-places.ts\n");

/***/ }),

/***/ "./lib/client-functions/validation.ts":
/*!********************************************!*\
  !*** ./lib/client-functions/validation.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.validateWithDetails = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n//TODO: not a fan of passing \"this\" in argument as the execution context. Class constructor, bind?\nasync function validateWithDetails(pageInstance) {\n    await pageInstance.$.commitValueAndPropertyChanges(); // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n    const errors = await pageInstance.$.page.validateWithDetails();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-manufacturing/pages__utils__notification__invalid_inputs_error', `Please check your inputs for {{#each fieldNames}}\\n - {{this}}{{/each}}`, {\n        fieldNames: errors.map((error) => \n        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type\n        `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n    }), { type: 'error', timeout: 5000 });\n    return false;\n}\nexports.validateWithDetails = validateWithDetails;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9saWIvY2xpZW50LWZ1bmN0aW9ucy92YWxpZGF0aW9uLnRzIiwibWFwcGluZ3MiOiI7Ozs7QUFBQSx1RUFBcUM7QUFFckMsa0dBQWtHO0FBQzNGLEtBQUssVUFBVSxtQkFBbUIsQ0FBQyxZQUFxQjtJQUMzRCxNQUFNLFlBQVksQ0FBQyxDQUFDLENBQUMsNkJBQTZCLEVBQUUsQ0FBQyxDQUFDLHNJQUFzSTtJQUM1TCxNQUFNLE1BQU0sR0FBMEIsTUFBTSxZQUFZLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO0lBQ3RGLHNCQUFJLE1BQU0sQ0FBQyxNQUFNLEVBQUssQ0FBQyxHQUFFLENBQUM7UUFDdEIsT0FBTyxJQUFJLENBQUM7SUFDaEIsQ0FBQztJQUVELFlBQVksQ0FBQyxDQUFDLENBQUMsWUFBWSxFQUFFLENBQUM7SUFDOUIsWUFBWSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQ3BCLEVBQUUsQ0FBQyxRQUFRLENBQ1AseUVBQXlFLEVBQ3pFLHlFQUF5RSxFQUN6RTtRQUNJLFVBQVUsRUFBRSxNQUFNLENBQUMsR0FBRyxDQUNsQixDQUFDLEtBQTBCLEVBQUUsRUFBRTtRQUMzQixtSUFBbUk7UUFDbkksR0FBSSxZQUFvQixDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsRUFBRSxLQUFLLElBQUksS0FBSyxDQUFDLFNBQVMsRUFBRSxDQUM1RTtLQUNKLENBQ0osRUFDRCxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxDQUNuQyxDQUFDO0lBRUYsT0FBTyxLQUFLLENBQUM7QUFDakIsQ0FBQztBQXhCRCxrREF3QkMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly94dHJlbUFydGlmYWN0Ly4vbGliL2NsaWVudC1mdW5jdGlvbnMvdmFsaWRhdGlvbi50cz9jZmI1Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcblxuLy9UT0RPOiBub3QgYSBmYW4gb2YgcGFzc2luZyBcInRoaXNcIiBpbiBhcmd1bWVudCBhcyB0aGUgZXhlY3V0aW9uIGNvbnRleHQuIENsYXNzIGNvbnN0cnVjdG9yLCBiaW5kP1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIHZhbGlkYXRlV2l0aERldGFpbHMocGFnZUluc3RhbmNlOiB1aS5QYWdlKTogUHJvbWlzZTxib29sZWFuPiB7XG4gICAgYXdhaXQgcGFnZUluc3RhbmNlLiQuY29tbWl0VmFsdWVBbmRQcm9wZXJ0eUNoYW5nZXMoKTsgLy8gdG8gaGFuZGxlIHN1Y2ggZWRneSBjYXNlcyBhcyB1c2VyIGNsZWFyaW5nIGFuIGlucHV0IGZyb20gYSBmaWVsZCBhbmQgdGhlbiBkaXJlY3RseSBjbGlja2luZyBvbiBhIGJ1dHRvbiB3aXRob3V0IGJsdXJyaW5nIHRoYXQgZmllbGRcbiAgICBjb25zdCBlcnJvcnM6IHVpLlZhbGlkYXRpb25SZXN1bHRbXSA9IGF3YWl0IHBhZ2VJbnN0YW5jZS4kLnBhZ2UudmFsaWRhdGVXaXRoRGV0YWlscygpO1xuICAgIGlmIChlcnJvcnMubGVuZ3RoID09PSAwKSB7XG4gICAgICAgIHJldHVybiB0cnVlO1xuICAgIH1cblxuICAgIHBhZ2VJbnN0YW5jZS4kLnJlbW92ZVRvYXN0cygpO1xuICAgIHBhZ2VJbnN0YW5jZS4kLnNob3dUb2FzdChcbiAgICAgICAgdWkubG9jYWxpemUoXG4gICAgICAgICAgICAnQHNhZ2UveDMtbWFudWZhY3R1cmluZy9wYWdlc19fdXRpbHNfX25vdGlmaWNhdGlvbl9faW52YWxpZF9pbnB1dHNfZXJyb3InLFxuICAgICAgICAgICAgYFBsZWFzZSBjaGVjayB5b3VyIGlucHV0cyBmb3Ige3sjZWFjaCBmaWVsZE5hbWVzfX1cXG4gLSB7e3RoaXN9fXt7L2VhY2h9fWAsXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgZmllbGROYW1lczogZXJyb3JzLm1hcChcbiAgICAgICAgICAgICAgICAgICAgKGVycm9yOiB1aS5WYWxpZGF0aW9uUmVzdWx0KSA9PlxuICAgICAgICAgICAgICAgICAgICAgICAgLy8gVE9ETzogSXNzdWU6IFBlcmhhcHMgYSBiZXR0ZXIgd2F5IGluIFR5cGVzY3JpcHQgdG8gZHluYW1pY2FsbHkgcmV0cmlldmUgYSBwYWdlJ3MgY29tcG9uZW50cyByYXRoZXIgdGhhbiB0byBjYXN0IGl0IHRvICdhbnknIHR5cGVcbiAgICAgICAgICAgICAgICAgICAgICAgIGAkeyhwYWdlSW5zdGFuY2UgYXMgYW55KVtlcnJvci5lbGVtZW50SWRdPy50aXRsZSA/PyBlcnJvci5lbGVtZW50SWR9YCxcbiAgICAgICAgICAgICAgICApLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgKSxcbiAgICAgICAgeyB0eXBlOiAnZXJyb3InLCB0aW1lb3V0OiA1MDAwIH0sXG4gICAgKTtcblxuICAgIHJldHVybiBmYWxzZTtcbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./lib/client-functions/validation.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-time-tracking-details.ts":
/*!***************************************************!*\
  !*** ./lib/pages/mobile-time-tracking-details.ts ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileTimeTrackingDetails = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst get_unit_decimal_places_1 = __webpack_require__(/*! ../client-functions/get-unit-decimal-places */ \"./lib/client-functions/get-unit-decimal-places.ts\");\nconst validation_1 = __webpack_require__(/*! ../client-functions/validation */ \"./lib/client-functions/validation.ts\");\nlet MobileTimeTrackingDetails = class MobileTimeTrackingDetails extends ui.Page {\n    // - For Information only the SelectedOperationMethod are\n    //   RouterOperation is 0\n    //   StandardOperationWithData is 1\n    //   StandardOperationNoData is 2\n    //   UserDefinedOperation is 3\n    async initPage() {\n        //const stockSite: string = this.getStockSite();\n        const { userDefinedOperationNumber, userDefinedOperationDescription, operationMethod, standardOperations, operationLine, workOrderNumber, releaseTimeUnit, releaseUOM, } = this.getStorageObject();\n        this.setHeaderFields(userDefinedOperationNumber, operationLine, workOrderNumber, operationMethod, userDefinedOperationDescription);\n        this.setDefaultValues(operationLine, standardOperations, operationMethod, releaseUOM, releaseTimeUnit);\n        this.workOrderNumber.value = workOrderNumber.number;\n        this.releasedRouting.value = workOrderNumber.releasedRouting.routing.code;\n    }\n    // Set header field values\n    setHeaderFields(userDefinedOperationNumber, operationLine, workOrder, operationMethod, userDefinedOperationDescription) {\n        this.workOrderNumber.value = workOrder.number;\n        this.routingCode.value = workOrder.routingCode.code.toString();\n        if (typesLib.strictNe(operationMethod, 0)) {\n            this.operationNumber.value = userDefinedOperationNumber;\n            this.operationDescription.value = userDefinedOperationDescription;\n        }\n        if (typesLib.strictEq(operationMethod, 0)) {\n            this.operationNumber.value = operationLine?.operationNumber;\n            this.operationDescription.value = operationLine?.operationDescription;\n        }\n    }\n    /** function Set initial page field values */\n    async setDefaultValues(operationLine, standardOperations, operationMethod, releaseUOM, releaseTimeUnit) {\n        // item independant of operation method - generic\n        this.rejectedQuantity.value = 0;\n        this.enteredSetupTimeMinutes.value = 0;\n        this.enteredSetupTimeHours.value = 0;\n        this.enteredRunTimeMinutes.value = 0;\n        this.enteredRunTimeHours.value = 0;\n        // 0 = Routing Operation Method\n        if (typesLib.strictNe(operationMethod, 0)) {\n            // 1 = Standard Operation with data Method\n            if (typesLib.strictEq(operationMethod, 1)) {\n                try {\n                    this.stockUnit.value = standardOperations.operationUom.code;\n                }\n                catch (error) {\n                    this.stockUnit.value = releaseUOM;\n                }\n                await this.setWorkCenter(standardOperations.mainWorkCenter.code);\n            }\n            if (typesLib.strictEq(operationMethod, 2)) {\n                this.stockUnit.value = releaseUOM;\n                this.timeUnit.value = releaseTimeUnit;\n                this.remainingQuantity.value = 1;\n                this.setScaleForNumericFields(this.stockUnit.value);\n            }\n            this.close.value = true;\n            this.close.isDisabled = true;\n            this.setupTime.value = Number(standardOperations.setupTime);\n            this.runTime.value = Number(standardOperations.runTime);\n            this.remainingQuantity.value = 1;\n            this.timeUnit.value = releaseTimeUnit;\n        }\n        // 0 = Routing Operation Method\n        if (typesLib.strictEq(operationMethod, 0)) {\n            const bomValues = await this.getBomCode();\n            this.bomCode.value = bomValues.bomCode.code.toString();\n            this.bom.value = bomValues.product.code;\n            this.stockUnit.value = operationLine.operationUnit.code;\n            this.runTime.value = operationLine.runTime;\n            this.setupTime.value = operationLine.setupTime;\n            this.timeUnit.value = operationLine.timeUnit;\n            await this.setRemainingQuantity();\n            await this.setWorkCenter(operationLine.expectedWorkCenter.code);\n            this.setCloseField();\n        }\n        this.setScaleForNumericFields(this.stockUnit.value);\n    }\n    /** Set the scale for numeric field based on their unit of measure */\n    async setScaleForNumericFields(stockUnit) {\n        const numberOfDecimalPlaces = await (0, get_unit_decimal_places_1.GetUOMNumberOfDecimalPlaces)(this, stockUnit);\n        this.remainingQuantity.scale = numberOfDecimalPlaces;\n        this.rejectedQuantity.scale = numberOfDecimalPlaces;\n    }\n    /** set the remaining quantity value. Expected qty minus the completed qty\n     *  if completed exceeds expected then set qty to zero */\n    async setRemainingQuantity() {\n        const lines = this.getTrackingLines();\n        const { operationLine } = this.getStorageObject();\n        const qtyTrackedOnDeviceOnly = this.calculateLineQuantity(lines, operationLine);\n        const remainingQtyInX3Database = typesLib.sub((operationLine?.expectedQuantity ?? 0), (operationLine?.completedQuantity ?? 0));\n        this.remainingQuantity.value = typesLib.sub(remainingQtyInX3Database, qtyTrackedOnDeviceOnly);\n        if (typesLib.lt(this.remainingQuantity.value, 0)) {\n            this.remainingQuantity.value = 0;\n        }\n    }\n    getStockSite() {\n        try {\n            return this.$.storage.get('mobile-selected-stock-site');\n        }\n        catch (err) {\n            this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_completed_quantity___stock_site_error', 'The stock site is not defined'), { type: 'error', timeout: 5000 });\n            return '';\n        }\n    }\n    getStorageObject() {\n        try {\n            const storageObject = this.$.storage.get('time_tracking');\n            return storageObject;\n        }\n        catch (err) {\n            this.showStorageError();\n            return undefined;\n        }\n    }\n    getTrackingLines() {\n        try {\n            const { timeTracking } = this.getStorageObject() || {};\n            return timeTracking.workOrderOperationTrackingLines;\n        }\n        catch (err) {\n            this.showStorageError();\n            return;\n        }\n    }\n    showStorageError() {\n        this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_completed_quantity_details___empty_storage_object_error', 'Storage object is empty'), { type: 'error', timeout: 5000 });\n        this.$.router.goTo('@sage/x3-manufacturing/MobileCompletedQuantity');\n    }\n    initTrackingLines(storageObject) {\n        const { employeeId, transaction, trackingDate, timeTracking, standardOperations } = storageObject;\n        const stockSite = this.getStockSite();\n        const trackingLine = timeTracking.workOrderOperationTrackingLines;\n        let employee = 0;\n        let lineCounter = 0;\n        let standardOperation = 0;\n        let close = 1;\n        if (typesLib.strictEq(this.close.value, true)) {\n            close = 2;\n        }\n        const YYYYMMDDdate = (date) => {\n            const year = date.slice(0, 4);\n            const month = date.slice(5, 7);\n            const day = date.slice(8, 10);\n            return `${year}-${month}-${day}`;\n        };\n        typesLib.strictNe(trackingLine.length, 0) && (lineCounter = trackingLine.length);\n        if (typesLib.strictNe(employeeId, null)) {\n            employee = employeeId.teamId;\n        }\n        if (typesLib.strictNe(standardOperations, null)) {\n            standardOperation = standardOperations.code;\n        }\n        trackingLine[lineCounter] = {\n            ...trackingLine[lineCounter],\n            productionSite: stockSite,\n            workOrderNumber: this.workOrderNumber.value,\n            routing: this.releasedRouting.value,\n            routingCode: this.routingCode.value,\n            operationNumber: this.operationNumber.value,\n            description: this.operationDescription.value,\n            postingDate: YYYYMMDDdate(trackingDate),\n            transaction: transaction,\n            employeeId: employee,\n            operationUnit: this.stockUnit.value,\n            operationConversion: 1,\n            actualWorkCenter: this.expectedWorkCenter.value.code,\n            totalCompletedQuantity: this.remainingQuantity.value,\n            actualRejectedQuantity: this.rejectedQuantity.value,\n            actualSetupTime: this.setupTime.value,\n            actualRunTime: this.runTime.value,\n            balance: close,\n            rejections: [],\n            bom: this.bom.value,\n            bomCode: this.bomCode.value,\n            operationSplit: 0,\n            alternativeIndex: 0,\n            project: '',\n            standardOperation: standardOperation,\n            timeUnit: this.timeUnit.value,\n        };\n        return trackingLine;\n    }\n    saveTimeTracking(storageObject) {\n        const { timeTracking } = storageObject;\n        timeTracking.workOrderOperationTrackingLines = this.initTrackingLines(storageObject);\n        this.$.storage.set('time_tracking', storageObject);\n    }\n    async buttonsLogic(displayMsg) {\n        const storageObject = this.getStorageObject();\n        this.saveTimeTracking(storageObject);\n        if (typesLib.strictEq(displayMsg, true)) {\n            this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_completed_quantity_details___quantity_added', 'Quantity added.'), { type: 'success', timeout: 3000 });\n        }\n        this.$.setPageClean();\n    }\n    /** Function coverts the setup time entered by the user to operation time unit\n     *  updates runtime page field with new value return: true | false was calculation successfully\n     */\n    async setActualRunTime() {\n        if (typesLib.strictEq(typesLib.add(this.enteredRunTimeHours.value, this.enteredRunTimeMinutes.value), 0)) {\n            this.runTime.value = 0;\n            return true;\n        }\n        try {\n            if (typesLib.strictEq(this.timeUnit.value, 'hours')) {\n                const time = typesLib.floor(typesLib.mul(this.enteredRunTimeHours.value, 60));\n                this.runTime.value = typesLib.div((typesLib.add(this.enteredRunTimeMinutes.value, time)), 60);\n            }\n            if (typesLib.strictEq(this.timeUnit.value, 'minutes')) {\n                const time = typesLib.floor(typesLib.mul(this.enteredRunTimeHours.value, 60));\n                this.runTime.value = typesLib.add(this.enteredRunTimeMinutes.value, time);\n            }\n            return true;\n        }\n        catch (error) {\n            this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_time_tracking_details___update__runtime__error', 'The actual run time calculation failed.'), { type: 'error', timeout: 5000 });\n            return false;\n        }\n    }\n    /** Function coverts the setup time entered by the user to operation time unit\n     *  updates setuptime page field with new value return: true | fales was calculation succefully\n     */\n    async setActualSetupTime() {\n        if (typesLib.strictEq(typesLib.add(this.enteredSetupTimeHours.value, this.enteredSetupTimeMinutes.value), 0)) {\n            this.setupTime.value = 0;\n            return true;\n        }\n        try {\n            if (typesLib.strictEq(this.timeUnit.value, 'hours')) {\n                const time = typesLib.floor(typesLib.mul(this.enteredSetupTimeHours.value, 60));\n                this.setupTime.value = typesLib.div((typesLib.add(this.enteredSetupTimeMinutes.value, time)), 60);\n            }\n            if (typesLib.strictEq(this.timeUnit.value, 'minutes')) {\n                const time = typesLib.floor(typesLib.mul(this.enteredSetupTimeHours.value, 60));\n                this.setupTime.value = typesLib.add(this.enteredSetupTimeMinutes.value, time);\n            }\n            return true;\n        }\n        catch (error) {\n            this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_time_tracking_details___update__setup__time__error', 'The actual setup time calculation failed.'), { type: 'error', timeout: 5000 });\n            return false;\n        }\n    }\n    async setWorkCenter(workCenter) {\n        try {\n            this.expectedWorkCenter.value = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-manufacturing-data/WorkCenter')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n            }, {\n                filter: {\n                    code: workCenter,\n                },\n            }))\n                .execute());\n            if (this.expectedWorkCenter.value) {\n                this.expectedWorkCenter.value.code = workCenter;\n            }\n            else {\n                this.expectedWorkCenter.value.code = '';\n            }\n        }\n        catch (error) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_completed_quantity_details___loading_work_centre_error', 'Error loading work center.'), String(error));\n        }\n    }\n    /** function verify if the time and quantity values enter are permitted - True | False */\n    async isTimeAndQuantityValid() {\n        let result = true;\n        const totaltime = typesLib.add(this.runTime.value, this.setupTime.value);\n        const totalQuantity = typesLib.sub(this.remainingQuantity.value, this.rejectedQuantity.value);\n        if (typesLib.lt(totalQuantity, 0)) {\n            this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_time_tracking_details___rejected_qty_error', 'Rejected quantity greater than the quantity value.'), { type: 'error', timeout: 5000 });\n            result = false;\n        }\n        if (typesLib.strictEq(typesLib.add(this.remainingQuantity.value, totaltime), 0)) {\n            this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_time_tracking_details___invalid__quantity__time___values__error', 'Check your entry for quantity and time.'), { type: 'error', timeout: 5000 });\n            result = false;\n        }\n        if (typesLib.strictEq(totaltime, 0) && typesLib.gt(totalQuantity, 0)) {\n            this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_time_tracking_details___no__time__entered__warning', 'No time entered.'), { type: 'warning', timeout: 5000 });\n            result = true;\n        }\n        return result;\n    }\n    /** function to set the Close field - yes/no based on the quantity being tracked */\n    async setCloseField() {\n        const lines = this.getTrackingLines();\n        const { operationLine } = this.getStorageObject();\n        let automaticClosingPercentage = 100;\n        let completedQuantityPercentage = 0;\n        // Total quantity = quantity of tracked lines + quantity to track + completed quantity\n        const totalQuantity = typesLib.add(typesLib.add(this.calculateLineQuantity(lines, operationLine), this.remainingQuantity.value), operationLine.completedQuantity);\n        if (typesLib.gt(totalQuantity, 0) && typesLib.gt(operationLine.expectedQuantity, 0)) {\n            completedQuantityPercentage = typesLib.mul((typesLib.div(totalQuantity, operationLine.expectedQuantity)), 100);\n        }\n        automaticClosingPercentage = await this.getAutomaticClosingPercent(this.expectedWorkCenter.value.code);\n        if (typesLib.ne(automaticClosingPercentage, 0)) {\n            if (typesLib.gte(completedQuantityPercentage, automaticClosingPercentage)) {\n                this.close.value = true;\n            }\n            else {\n                this.close.value = false;\n            }\n        }\n        else {\n            this.close.value = false;\n        }\n    }\n    /** for the current work order and operation set the total tracked quantity\n     *  return = qty already tracked in X3 + qty tracked on device */\n    getQtyAvailableToTrack() {\n        const lines = this.getTrackingLines();\n        const { operationLine } = this.getStorageObject();\n        const qtyTrackedOnDeviceOnly = this.calculateLineQuantity(lines, operationLine);\n        const remainingQtyInX3Database = typesLib.sub(operationLine.expectedQuantity, operationLine.completedQuantity);\n        const remainingQty = typesLib.sub(remainingQtyInX3Database, qtyTrackedOnDeviceOnly);\n        if (remainingQty) {\n            return remainingQty;\n        }\n        return 0;\n    }\n    /**\n     * Calculate the total quantity - lines tracked for a given work order and operation\n     * @param lines\n     * @param operationLine\n     * @returns\n     */\n    calculateLineQuantity(lines, operationLine) {\n        const { workOrder, operationNumber } = operationLine;\n        const currentOperation = lines.filter((line) => typesLib.strictEq(line.workOrderNumber, workOrder?.number) && typesLib.strictEq(line.operationNumber, operationNumber));\n        const totalLineQuantity = currentOperation.reduce((sum, operation) => {\n            return typesLib.add(sum, operation.totalCompletedQuantity);\n        }, 0);\n        return totalLineQuantity;\n    }\n    /**\n     * Automatic closing percentage for expected work center & site\n     * @param workCenter\n     * @returns\n     */\n    async getAutomaticClosingPercent(workCenter) {\n        try {\n            const result = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-manufacturing-data/WorkCenter')\n                .query(ui.queryUtils.edgesSelector({\n                automaticClosingPercentage: true,\n            }, {\n                filter: {\n                    code: workCenter,\n                    manufacturingSite: { code: this.getStockSite() },\n                },\n            }))\n                .execute());\n            return parseFloat(result[0].automaticClosingPercentage);\n        }\n        catch (err) {\n            return 0;\n        }\n    }\n    /**\n     * get BOM code required for operation tracking/creation of lines\n     * @returns\n     */\n    async getBomCode() {\n        try {\n            const result = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-manufacturing/WorkOrderProductLine')\n                .query(ui.queryUtils.edgesSelector({\n                bomCode: {\n                    code: true,\n                },\n                product: {\n                    code: true,\n                },\n            }, {\n                filter: {\n                    workOrder: this.workOrderNumber.value,\n                },\n            }))\n                .execute());\n            return result[0];\n        }\n        catch (err) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_completed_time_tracking___loading_BOM_code_error', 'Error loading BOM code'), String(err));\n            return;\n        }\n    }\n    /**\n     * Set the rejected qnatity field to zero\n     */\n    async setRejectedQuantityToZero() {\n        this.rejectedQuantity.value = 0;\n    }\n    /**\n     * Set all runtime and setup time fields to zero\n     */\n    async SetAllTimeFieldsToZero() {\n        this.setupTime.value = 0;\n        this.runTime.value = 0;\n        this.enteredRunTimeHours.value = 0;\n        this.enteredRunTimeMinutes.value = 0;\n        this.enteredSetupTimeHours.value = 0;\n        this.enteredSetupTimeMinutes.value = 0;\n        const { operationMethod } = this.getStorageObject();\n        if (typesLib.strictNe(operationMethod, 0)) {\n            this.remainingQuantity.value = 1;\n        }\n    }\n};\nexports.MobileTimeTrackingDetails = MobileTimeTrackingDetails;\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileTimeTrackingDetails.prototype, \"section\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.section;\n        },\n        isTitleHidden: true,\n    })\n], MobileTimeTrackingDetails.prototype, \"block\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__expectedWorkCenter____title\", \"Actual work center\"),\n        valueField: 'code',\n        node: '@sage/x3-manufacturing-data/WorkCenter',\n        isTransientInput: false,\n        isTransient: false,\n        placeholder: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__expectedWorkCenter____placeholder\", \"Scan or select...\"),\n        isAutoSelectEnabled: true,\n        isMandatory: true,\n        filter() {\n            return {\n                manufacturingSite: { code: this.getStockSite() },\n                type: { _ne: 3 },\n            };\n        },\n        onChange() {\n            this.remainingQuantity.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'description',\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-manufacturing/WorkCenterGroup',\n                bind: 'workCenterGroup',\n                valueField: 'code',\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileTimeTrackingDetails.prototype, \"expectedWorkCenter\", void 0);\n__decorate([\n    ui.decorators.separatorField({\n        parent() {\n            return this.block;\n        },\n    })\n], MobileTimeTrackingDetails.prototype, \"blank\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__timeUnit____title\", \"Time unit\"),\n        isDisabled: true,\n    })\n], MobileTimeTrackingDetails.prototype, \"timeUnit\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__stockUnit____title\", \"Unit\"),\n        isDisabled: true,\n    })\n], MobileTimeTrackingDetails.prototype, \"stockUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__remainingQuantity____title\", \"Quantity\"),\n        isMandatory: true,\n        validation: /^\\d*[0-9](|.\\d*[0-9]|,\\d*[0-9])?$/,\n        onChange() {\n            if (typesLib.strictEq(this.remainingQuantity.value, undefined) || typesLib.strictEq(this.remainingQuantity.value, null)) {\n                this.remainingQuantity.value = 0;\n                (0, validation_1.validateWithDetails)(this);\n            }\n            const { operationMethod } = this.getStorageObject();\n            if (typesLib.strictEq(operationMethod, 0)) {\n                this.setCloseField();\n                if (typesLib.gt(this.remainingQuantity.value, this.getQtyAvailableToTrack())) {\n                    this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_time_tracking_details___quantity__larger__expected__warning', 'The quantity is larger than expected.'), { type: 'warning', timeout: 5000 });\n                }\n            }\n        },\n    })\n], MobileTimeTrackingDetails.prototype, \"remainingQuantity\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__rejectedQuantity____title\", \"Rejected qty.\"),\n        validation: /^\\d*[0-9](|.\\d*[0-9]|,\\d*[0-9])?$/,\n        onChange() {\n            // if user blanks out value set to zero and re-run screen validation\n            if (typesLib.strictEq(this.rejectedQuantity.value, undefined) || typesLib.strictEq(this.rejectedQuantity.value, null)) {\n                this.rejectedQuantity.value = 0;\n                (0, validation_1.validateWithDetails)(this);\n            }\n            if (typesLib.strictEq(this.remainingQuantity.value, undefined) || typesLib.strictEq(this.remainingQuantity.value, null)) {\n                this.remainingQuantity.value = 0;\n            }\n            if (typesLib.gt(this.rejectedQuantity.value, this.remainingQuantity.value)) {\n                this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_time_tracking_details___rejected_qty_error', 'Rejected quantity greater than the quantity value.'), { type: 'error', timeout: 5000 });\n            }\n        },\n    })\n], MobileTimeTrackingDetails.prototype, \"rejectedQuantity\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__setupTime____title\", \"Actual setup time\"),\n        isHidden: true,\n        isDisabled: true,\n        scale: 4,\n    })\n], MobileTimeTrackingDetails.prototype, \"setupTime\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__runTime____title\", \"Actual run time\"),\n        isHidden: true,\n        isDisabled: true,\n        scale: 4,\n    })\n], MobileTimeTrackingDetails.prototype, \"runTime\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__enteredSetupTimeHours____title\", \"Setup time hours\"),\n        scale: 4,\n        validation: /^\\d*[0-9](|.\\d*[0-9]|,\\d*[0-9])?$/,\n        onChange() {\n            // if user blanks out value set to zero and re-run screen validation\n            if (typesLib.strictEq(this.enteredSetupTimeHours.value, undefined) || typesLib.strictEq(this.enteredSetupTimeHours.value, null)) {\n                this.enteredSetupTimeHours.value = 0;\n                (0, validation_1.validateWithDetails)(this);\n            }\n        },\n    })\n], MobileTimeTrackingDetails.prototype, \"enteredSetupTimeHours\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__enteredSetupTimeMinutes____title\", \"Setup time minutes\"),\n        scale: 0,\n        validation: /^\\d*[0-9](|.\\d*[0-9]|,\\d*[0-9])?$/,\n        onChange() {\n            if (typesLib.strictEq(this.enteredSetupTimeMinutes.value, undefined) || typesLib.strictEq(this.enteredSetupTimeMinutes.value, null)) {\n                this.enteredSetupTimeMinutes.value = 0;\n                (0, validation_1.validateWithDetails)(this);\n            }\n            if (typesLib.gte(this.enteredSetupTimeMinutes.value, 60)) {\n                this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_time_tracking_details___minutes__entered__warning', 'Minutes are equal to or greater than 60.'), { type: 'warning', timeout: 5000 });\n            }\n        },\n    })\n], MobileTimeTrackingDetails.prototype, \"enteredSetupTimeMinutes\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__enteredRunTimeHours____title\", \"Run time hours\"),\n        scale: 4,\n        validation: /^\\d*[0-9](|.\\d*[0-9]|,\\d*[0-9])?$/,\n        onChange() {\n            if (typesLib.strictEq(this.enteredRunTimeHours.value, undefined) || typesLib.strictEq(this.enteredRunTimeHours.value, null)) {\n                this.enteredRunTimeHours.value = 0;\n                (0, validation_1.validateWithDetails)(this);\n            }\n        },\n    })\n], MobileTimeTrackingDetails.prototype, \"enteredRunTimeHours\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__enteredRunTimeMinutes____title\", \"Run time minutes\"),\n        isMandatory: false,\n        validation: /^\\d*[0-9](|.\\d*[0-9]|,\\d*[0-9])?$/,\n        scale: 0,\n        onChange() {\n            if (typesLib.strictEq(this.enteredRunTimeMinutes.value, undefined) || typesLib.strictEq(this.enteredRunTimeMinutes.value, null)) {\n                this.enteredRunTimeMinutes.value = 0;\n                (0, validation_1.validateWithDetails)(this);\n            }\n            if (typesLib.gte(this.enteredRunTimeMinutes.value, 60)) {\n                this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_time_tracking_details___minutes__entered__warning', 'Minutes are equal to or greater than 60.'), { type: 'warning', timeout: 5000 });\n            }\n        },\n    })\n], MobileTimeTrackingDetails.prototype, \"enteredRunTimeMinutes\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__close____title\", \"Close\"),\n        onChange() {\n            if (typesLib.strictEq(this.close.value, null) || typesLib.strictEq(this.close.value, undefined)) {\n                this.setCloseField();\n            }\n        },\n    })\n], MobileTimeTrackingDetails.prototype, \"close\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__addQuantity____title\", \"Add quantity\"),\n        buttonType: 'secondary',\n        shortcut: ['f2'],\n        async onClick() {\n            if (!(await (0, validation_1.validateWithDetails)(this)))\n                return;\n            await this.setActualRunTime();\n            await this.setActualSetupTime();\n            if (typesLib.strictEq((await this.isTimeAndQuantityValid()), false)) {\n                return;\n            }\n            else {\n                await this.buttonsLogic(true);\n                const { operationMethod } = this.getStorageObject();\n                //const { operationMethod, operationLine }: TimeTrackingStorageObject = this.getStorageObject();\n                if (typesLib.strictEq(operationMethod, 0)) {\n                    await this.setRemainingQuantity();\n                }\n                await this.SetAllTimeFieldsToZero();\n                await this.setRejectedQuantityToZero();\n                this.expectedWorkCenter.focus();\n            }\n        },\n    })\n], MobileTimeTrackingDetails.prototype, \"addQuantity\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details__nextPage____title\", \"Next\"),\n        buttonType: 'primary',\n        shortcut: ['f3'],\n        async onClick() {\n            if (!(await (0, validation_1.validateWithDetails)(this)))\n                return;\n            await this.setActualRunTime();\n            await this.setActualSetupTime();\n            if (typesLib.strictEq((await this.isTimeAndQuantityValid()), false)) {\n                return;\n            }\n            else {\n                await this.buttonsLogic(false);\n                this.$.router.goTo('@sage/x3-manufacturing/MobileTimeTracking', {\n                    gotLines: 'true',\n                });\n            }\n        },\n    })\n], MobileTimeTrackingDetails.prototype, \"nextPage\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n    })\n], MobileTimeTrackingDetails.prototype, \"workOrderNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isHidden: true,\n    })\n], MobileTimeTrackingDetails.prototype, \"releasedRouting\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n    })\n], MobileTimeTrackingDetails.prototype, \"routingCode\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isDisabled: true,\n    })\n], MobileTimeTrackingDetails.prototype, \"operationNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n    })\n], MobileTimeTrackingDetails.prototype, \"operationDescription\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isHidden: true,\n    })\n], MobileTimeTrackingDetails.prototype, \"bom\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n    })\n], MobileTimeTrackingDetails.prototype, \"bomCode\", void 0);\nexports.MobileTimeTrackingDetails = MobileTimeTrackingDetails = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_time_tracking_details____title\", \"Time tracking details\"),\n        isTransient: false,\n        isTitleHidden: true,\n        module: 'x3-manufacturing',\n        mode: 'default',\n        headerCard() {\n            return {\n                title: this.workOrderNumber,\n                line2: this.routingCode,\n                titleRight: this.operationNumber,\n                line2Right: this.operationDescription,\n            };\n        },\n        businessActions() {\n            return [this.addQuantity, this.nextPage];\n        },\n        async onLoad() {\n            await this.initPage();\n        },\n    })\n], MobileTimeTrackingDetails);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9saWIvcGFnZXMvbW9iaWxlLXRpbWUtdHJhY2tpbmctZGV0YWlscy50cyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBR0EsMkZBQTJEO0FBQzNELHVFQUFxQztBQUNyQyw4SkFBMEY7QUFDMUYsdUhBQXFFO0FBd0I5RCxJQUFNLHlCQUF5QixHQUEvQixNQUFNLHlCQUEwQixTQUFRLEVBQUUsQ0FBQyxJQUFJO0lBeVZsRCx5REFBeUQ7SUFDekQseUJBQXlCO0lBQ3pCLG1DQUFtQztJQUNuQyxpQ0FBaUM7SUFDakMsOEJBQThCO0lBRTlCLEtBQUssQ0FBQyxRQUFRO1FBQ1YsZ0RBQWdEO1FBQ2hELE1BQU0sRUFDRiwwQkFBMEIsRUFDMUIsK0JBQStCLEVBQy9CLGVBQWUsRUFDZixrQkFBa0IsRUFDbEIsYUFBYSxFQUNiLGVBQWUsRUFDZixlQUFlLEVBQ2YsVUFBVSxHQUNiLEdBQThCLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1FBQ3ZELElBQUksQ0FBQyxlQUFlLENBQ2hCLDBCQUEwQixFQUMxQixhQUFhLEVBQ2IsZUFBZSxFQUNmLGVBQWUsRUFDZiwrQkFBK0IsQ0FDbEMsQ0FBQztRQUNGLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLEVBQUUsa0JBQWtCLEVBQUUsZUFBZSxFQUFFLFVBQVUsRUFBRSxlQUFlLENBQUMsQ0FBQztRQUN2RyxJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssR0FBRyxlQUFlLENBQUMsTUFBTSxDQUFDO1FBQ3BELElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxHQUFHLGVBQWUsQ0FBQyxlQUFlLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQztJQUM5RSxDQUFDO0lBRUQsMEJBQTBCO0lBQzFCLGVBQWUsQ0FDWCwwQkFBeUMsRUFDekMsYUFBNEMsRUFDNUMsU0FBb0IsRUFDcEIsZUFBdUIsRUFDdkIsK0JBQTBEO1FBRTFELElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQyxNQUFNLENBQUM7UUFDOUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7UUFFL0Qsc0JBQUksZUFBZSxFQUFLLENBQUMsR0FBRSxDQUFDO1lBQ3hCLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxHQUFHLDBCQUEwQixDQUFDO1lBQ3hELElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLEdBQUcsK0JBQStCLENBQUM7UUFDdEUsQ0FBQztRQUVELHNCQUFJLGVBQWUsRUFBSyxDQUFDLEdBQUUsQ0FBQztZQUN4QixJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssR0FBRyxhQUFhLEVBQUUsZUFBZSxDQUFDO1lBQzVELElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLEdBQUcsYUFBYSxFQUFFLG9CQUFvQixDQUFDO1FBQzFFLENBQUM7SUFDTCxDQUFDO0lBRUQsNkNBQTZDO0lBQzdDLEtBQUssQ0FBQyxnQkFBZ0IsQ0FDbEIsYUFBcUMsRUFDckMsa0JBQStDLEVBQy9DLGVBQXVCLEVBQ3ZCLFVBQWtCLEVBQ2xCLGVBQXVCO1FBRXZCLGlEQUFpRDtRQUNqRCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUNoQyxJQUFJLENBQUMsdUJBQXVCLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUN2QyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUVuQywrQkFBK0I7UUFDL0Isc0JBQUksZUFBZSxFQUFLLENBQUMsR0FBRSxDQUFDO1lBQ3hCLDBDQUEwQztZQUMxQyxzQkFBSSxlQUFlLEVBQUssQ0FBQyxHQUFFLENBQUM7Z0JBQ3hCLElBQUksQ0FBQztvQkFDRCxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssR0FBRyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDO2dCQUNoRSxDQUFDO2dCQUFDLE9BQU8sS0FBSyxFQUFFLENBQUM7b0JBQ2IsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEdBQUcsVUFBVSxDQUFDO2dCQUN0QyxDQUFDO2dCQUNELE1BQU0sSUFBSSxDQUFDLGFBQWEsQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDckUsQ0FBQztZQUVELHNCQUFJLGVBQWUsRUFBSyxDQUFDLEdBQUUsQ0FBQztnQkFDeEIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEdBQUcsVUFBVSxDQUFDO2dCQUNsQyxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssR0FBRyxlQUFlLENBQUM7Z0JBQ3RDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO2dCQUNqQyxJQUFJLENBQUMsd0JBQXdCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUN4RCxDQUFDO1lBRUQsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDO1lBQ3hCLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztZQUM3QixJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUM7WUFDNUQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO1lBQ3hELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO1lBQ2pDLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxHQUFHLGVBQWUsQ0FBQztRQUMxQyxDQUFDO1FBRUQsK0JBQStCO1FBQy9CLHNCQUFJLGVBQWUsRUFBSyxDQUFDLEdBQUUsQ0FBQztZQUN4QixNQUFNLFNBQVMsR0FBRyxNQUFNLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQztZQUMxQyxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQztZQUN2RCxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQztZQUN4QyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssR0FBRyxhQUFhLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztZQUN4RCxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssR0FBRyxhQUFhLENBQUMsT0FBTyxDQUFDO1lBQzNDLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxHQUFHLGFBQWEsQ0FBQyxTQUFTLENBQUM7WUFDL0MsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEdBQUcsYUFBYSxDQUFDLFFBQVEsQ0FBQztZQUM3QyxNQUFNLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO1lBQ2xDLE1BQU0sSUFBSSxDQUFDLGFBQWEsQ0FBQyxhQUFhLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDaEUsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQ3pCLENBQUM7UUFFRCxJQUFJLENBQUMsd0JBQXdCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN4RCxDQUFDO0lBRUQscUVBQXFFO0lBQ3JFLEtBQUssQ0FBQyx3QkFBd0IsQ0FBQyxTQUFpQjtRQUM1QyxNQUFNLHFCQUFxQixHQUFHLE1BQU0seURBQTJCLEVBQUMsSUFBSSxFQUFFLFNBQVMsQ0FBQyxDQUFDO1FBQ2pGLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEdBQUcscUJBQXFCLENBQUM7UUFDckQsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssR0FBRyxxQkFBcUIsQ0FBQztJQUN4RCxDQUFDO0lBRUQ7NkRBQ3lEO0lBQ3pELEtBQUssQ0FBQyxvQkFBb0I7UUFDdEIsTUFBTSxLQUFLLEdBQXVCLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1FBQzFELE1BQU0sRUFBRSxhQUFhLEVBQUUsR0FBOEIsSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUM7UUFDN0UsTUFBTSxzQkFBc0IsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBQ2hGLE1BQU0sd0JBQXdCLGdCQUMxQixDQUFDLGFBQWEsRUFBRSxnQkFBZ0IsSUFBSSxDQUFDLENBQUMsRUFBRyxDQUFDLGFBQWEsRUFBRSxpQkFBaUIsSUFBSSxDQUFDLENBQUMsRUFBQztRQUNyRixJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxnQkFBRyx3QkFBd0IsRUFBRyxzQkFBc0IsRUFBQztRQUVqRixnQkFBSSxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFHLENBQUMsR0FBRSxDQUFDO1lBQ25DLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO1FBQ3JDLENBQUM7SUFDTCxDQUFDO0lBRUQsWUFBWTtRQUNSLElBQUksQ0FBQztZQUNELE9BQU8sSUFBSSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLDRCQUE0QixDQUFXLENBQUM7UUFDdEUsQ0FBQztRQUFDLE9BQU8sR0FBRyxFQUFFLENBQUM7WUFDWCxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FDWixFQUFFLENBQUMsUUFBUSxDQUNQLDRFQUE0RSxFQUM1RSwrQkFBK0IsQ0FDbEMsRUFDRCxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxDQUNuQyxDQUFDO1lBQ0YsT0FBTyxFQUFFLENBQUM7UUFDZCxDQUFDO0lBQ0wsQ0FBQztJQUVELGdCQUFnQjtRQUNaLElBQUksQ0FBQztZQUNELE1BQU0sYUFBYSxHQUFHLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQVEsQ0FBQztZQUNqRSxPQUFPLGFBQWEsQ0FBQztRQUN6QixDQUFDO1FBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztZQUNYLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1lBQ3hCLE9BQU8sU0FBUyxDQUFDO1FBQ3JCLENBQUM7SUFDTCxDQUFDO0lBRUQsZ0JBQWdCO1FBQ1osSUFBSSxDQUFDO1lBQ0QsTUFBTSxFQUFFLFlBQVksRUFBRSxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxJQUFJLEVBQUUsQ0FBQztZQUN2RCxPQUFPLFlBQVksQ0FBQywrQkFBK0IsQ0FBQztRQUN4RCxDQUFDO1FBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztZQUNYLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1lBQ3hCLE9BQU87UUFDWCxDQUFDO0lBQ0wsQ0FBQztJQUVELGdCQUFnQjtRQUNaLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUNaLEVBQUUsQ0FBQyxRQUFRLENBQ1AsOEZBQThGLEVBQzlGLHlCQUF5QixDQUM1QixFQUNELEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLENBQ25DLENBQUM7UUFDRixJQUFJLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsZ0RBQWdELENBQUMsQ0FBQztJQUN6RSxDQUFDO0lBRUQsaUJBQWlCLENBQUMsYUFBa0I7UUFDaEMsTUFBTSxFQUFFLFVBQVUsRUFBRSxXQUFXLEVBQUUsWUFBWSxFQUFFLFlBQVksRUFBRSxrQkFBa0IsRUFBRSxHQUFHLGFBQWEsQ0FBQztRQUNsRyxNQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7UUFFdEMsTUFBTSxZQUFZLEdBQUcsWUFBWSxDQUFDLCtCQUErQixDQUFDO1FBQ2xFLElBQUksUUFBUSxHQUFXLENBQUMsQ0FBQztRQUN6QixJQUFJLFdBQVcsR0FBVyxDQUFDLENBQUM7UUFDNUIsSUFBSSxpQkFBaUIsR0FBVyxDQUFDLENBQUM7UUFDbEMsSUFBSSxLQUFLLEdBQVcsQ0FBQyxDQUFDO1FBQ3RCLHNCQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFLLElBQUksR0FBRSxDQUFDO1lBQzVCLEtBQUssR0FBRyxDQUFDLENBQUM7UUFDZCxDQUFDO1FBRUQsTUFBTSxZQUFZLEdBQUcsQ0FBQyxJQUFZLEVBQVUsRUFBRTtZQUMxQyxNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztZQUM5QixNQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztZQUMvQixNQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztZQUM5QixPQUFPLEdBQUcsSUFBSSxJQUFJLEtBQUssSUFBSSxHQUFHLEVBQUUsQ0FBQztRQUNyQyxDQUFDLENBQUM7UUFFRiw4QkFBWSxDQUFDLE1BQU0sRUFBSyxDQUFDLEtBQUksQ0FBQyxXQUFXLEdBQUcsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBRWpFLHNCQUFJLFVBQVUsRUFBSyxJQUFJLEdBQUUsQ0FBQztZQUN0QixRQUFRLEdBQUcsVUFBVSxDQUFDLE1BQU0sQ0FBQztRQUNqQyxDQUFDO1FBRUQsc0JBQUksa0JBQWtCLEVBQUssSUFBSSxHQUFFLENBQUM7WUFDOUIsaUJBQWlCLEdBQUcsa0JBQWtCLENBQUMsSUFBSSxDQUFDO1FBQ2hELENBQUM7UUFFRCxZQUFZLENBQUMsV0FBVyxDQUFDLEdBQUc7WUFDeEIsR0FBRyxZQUFZLENBQUMsV0FBVyxDQUFDO1lBQzVCLGNBQWMsRUFBRSxTQUFTO1lBQ3pCLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUs7WUFDM0MsT0FBTyxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSztZQUNuQyxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLO1lBQ25DLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUs7WUFDM0MsV0FBVyxFQUFFLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLO1lBQzVDLFdBQVcsRUFBRSxZQUFZLENBQUMsWUFBWSxDQUFDO1lBQ3ZDLFdBQVcsRUFBRSxXQUFXO1lBQ3hCLFVBQVUsRUFBRSxRQUFRO1lBQ3BCLGFBQWEsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUs7WUFDbkMsbUJBQW1CLEVBQUUsQ0FBQztZQUN0QixnQkFBZ0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDLElBQUk7WUFDcEQsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUs7WUFDcEQsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUs7WUFDbkQsZUFBZSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSztZQUNyQyxhQUFhLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLO1lBQ2pDLE9BQU8sRUFBRSxLQUFLO1lBQ2QsVUFBVSxFQUFFLEVBQUU7WUFDZCxHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLO1lBQ25CLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUs7WUFDM0IsY0FBYyxFQUFFLENBQUM7WUFDakIsZ0JBQWdCLEVBQUUsQ0FBQztZQUNuQixPQUFPLEVBQUUsRUFBRTtZQUNYLGlCQUFpQixFQUFFLGlCQUFpQjtZQUNwQyxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLO1NBQ1YsQ0FBQztRQUV4QixPQUFPLFlBQVksQ0FBQztJQUN4QixDQUFDO0lBRUQsZ0JBQWdCLENBQUMsYUFBd0M7UUFDckQsTUFBTSxFQUFFLFlBQVksRUFBRSxHQUFHLGFBQWEsQ0FBQztRQUN2QyxZQUFZLENBQUMsK0JBQStCLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ3JGLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxlQUFlLEVBQUUsYUFBb0IsQ0FBQyxDQUFDO0lBQzlELENBQUM7SUFFRCxLQUFLLENBQUMsWUFBWSxDQUFDLFVBQW1CO1FBQ2xDLE1BQU0sYUFBYSxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1FBQzlDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUNyQyxzQkFBSSxVQUFVLEVBQUssSUFBSSxHQUFFLENBQUM7WUFDdEIsSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQ1osRUFBRSxDQUFDLFFBQVEsQ0FDUCxrRkFBa0YsRUFDbEYsaUJBQWlCLENBQ3BCLEVBQ0QsRUFBRSxJQUFJLEVBQUUsU0FBUyxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsQ0FDckMsQ0FBQztRQUNOLENBQUM7UUFDRCxJQUFJLENBQUMsQ0FBQyxDQUFDLFlBQVksRUFBRSxDQUFDO0lBQzFCLENBQUM7SUFFRDs7T0FFRztJQUNILEtBQUssQ0FBQyxnQkFBZ0I7UUFDbEIsbUNBQUksSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssRUFBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxHQUFLLENBQUMsR0FBRSxDQUFDO1lBQzFFLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztZQUN2QixPQUFPLElBQUksQ0FBQztRQUNoQixDQUFDO1FBRUQsSUFBSSxDQUFDO1lBQ0Qsc0JBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUssT0FBTyxHQUFFLENBQUM7Z0JBQ2xDLE1BQU0sSUFBSSxHQUFHLFNBQUssS0FBSyxjQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLEVBQUcsRUFBRSxFQUFDLENBQUM7Z0JBQzdELElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxnQkFBRyxjQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUcsSUFBSSxFQUFDLEVBQUcsRUFBRSxFQUFDO1lBQ3hFLENBQUM7WUFDRCxzQkFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBSyxTQUFTLEdBQUUsQ0FBQztnQkFDcEMsTUFBTSxJQUFJLEdBQUcsU0FBSyxLQUFLLGNBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssRUFBRyxFQUFFLEVBQUMsQ0FBQztnQkFDN0QsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLGdCQUFHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUcsSUFBSSxFQUFDO1lBQ2pFLENBQUM7WUFDRCxPQUFPLElBQUksQ0FBQztRQUNoQixDQUFDO1FBQUMsT0FBTyxLQUFLLEVBQUUsQ0FBQztZQUNiLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUNaLEVBQUUsQ0FBQyxRQUFRLENBQ1AscUZBQXFGLEVBQ3JGLHlDQUF5QyxDQUM1QyxFQUNELEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLENBQ25DLENBQUM7WUFDRixPQUFPLEtBQUssQ0FBQztRQUNqQixDQUFDO0lBQ0wsQ0FBQztJQUVEOztPQUVHO0lBQ0gsS0FBSyxDQUFDLGtCQUFrQjtRQUNwQixtQ0FBSSxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFHLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxLQUFLLEdBQUssQ0FBQyxHQUFFLENBQUM7WUFDOUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO1lBQ3pCLE9BQU8sSUFBSSxDQUFDO1FBQ2hCLENBQUM7UUFDRCxJQUFJLENBQUM7WUFDRCxzQkFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBSyxPQUFPLEdBQUUsQ0FBQztnQkFDbEMsTUFBTSxJQUFJLEdBQUcsU0FBSyxLQUFLLGNBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBRyxFQUFFLEVBQUMsQ0FBQztnQkFDL0QsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLGdCQUFHLGNBQUMsSUFBSSxDQUFDLHVCQUF1QixDQUFDLEtBQUssRUFBRyxJQUFJLEVBQUMsRUFBRyxFQUFFLEVBQUM7WUFDNUUsQ0FBQztZQUNELHNCQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFLLFNBQVMsR0FBRSxDQUFDO2dCQUNwQyxNQUFNLElBQUksR0FBRyxTQUFLLEtBQUssY0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFHLEVBQUUsRUFBQyxDQUFDO2dCQUMvRCxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssZ0JBQUcsSUFBSSxDQUFDLHVCQUF1QixDQUFDLEtBQUssRUFBRyxJQUFJLEVBQUM7WUFDckUsQ0FBQztZQUNELE9BQU8sSUFBSSxDQUFDO1FBQ2hCLENBQUM7UUFBQyxPQUFPLEtBQUssRUFBRSxDQUFDO1lBQ2IsSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQ1osRUFBRSxDQUFDLFFBQVEsQ0FDUCx5RkFBeUYsRUFDekYsMkNBQTJDLENBQzlDLEVBQ0QsRUFBRSxJQUFJLEVBQUUsT0FBTyxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsQ0FDbkMsQ0FBQztZQUNGLE9BQU8sS0FBSyxDQUFDO1FBQ2pCLENBQUM7SUFDTCxDQUFDO0lBRUQsS0FBSyxDQUFDLGFBQWEsQ0FBQyxVQUFrQjtRQUNsQyxJQUFJLENBQUM7WUFDRCxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxHQUFHLCtCQUFZLEVBQ3hDLE1BQU0sSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLO2lCQUNiLElBQUksQ0FBQyx3Q0FBd0MsQ0FBQztpQkFDOUMsS0FBSyxDQUNGLEVBQUUsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUN2QjtnQkFDSSxJQUFJLEVBQUUsSUFBSTthQUNiLEVBQ0Q7Z0JBQ0ksTUFBTSxFQUFFO29CQUNKLElBQUksRUFBRSxVQUFVO2lCQUNuQjthQUNKLENBQ0osQ0FDSjtpQkFDQSxPQUFPLEVBQUUsQ0FDakIsQ0FBQztZQUNGLElBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUNoQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDLElBQUksR0FBRyxVQUFVLENBQUM7WUFDcEQsQ0FBQztpQkFBTSxDQUFDO2dCQUNKLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsSUFBSSxHQUFHLEVBQUUsQ0FBQztZQUM1QyxDQUFDO1FBQ0wsQ0FBQztRQUFDLE9BQU8sS0FBSyxFQUFFLENBQUM7WUFDYixJQUFJLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQ2pCLE9BQU8sRUFDUCxFQUFFLENBQUMsUUFBUSxDQUNQLDZGQUE2RixFQUM3Riw0QkFBNEIsQ0FDL0IsRUFDRCxNQUFNLENBQUMsS0FBSyxDQUFDLENBQ2hCLENBQUM7UUFDTixDQUFDO0lBQ0wsQ0FBQztJQUVELHlGQUF5RjtJQUN6RixLQUFLLENBQUMsc0JBQXNCO1FBQ3hCLElBQUksTUFBTSxHQUFZLElBQUksQ0FBQztRQUMzQixNQUFNLFNBQVMsZ0JBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUM7UUFDNUQsTUFBTSxhQUFhLGdCQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssRUFBQztRQUVqRixnQkFBSSxhQUFhLEVBQUcsQ0FBQyxHQUFFLENBQUM7WUFDcEIsSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQ1osRUFBRSxDQUFDLFFBQVEsQ0FDUCxpRkFBaUYsRUFDakYsb0RBQW9ELENBQ3ZELEVBQ0QsRUFBRSxJQUFJLEVBQUUsT0FBTyxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsQ0FDbkMsQ0FBQztZQUNGLE1BQU0sR0FBRyxLQUFLLENBQUM7UUFDbkIsQ0FBQztRQUVELG1DQUFJLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUcsU0FBUyxHQUFLLENBQUMsR0FBRSxDQUFDO1lBQ2pELElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUNaLEVBQUUsQ0FBQyxRQUFRLENBQ1Asc0dBQXNHLEVBQ3RHLHlDQUF5QyxDQUM1QyxFQUNELEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLENBQ25DLENBQUM7WUFDRixNQUFNLEdBQUcsS0FBSyxDQUFDO1FBQ25CLENBQUM7UUFFRCxJQUFJLDJCQUFTLEVBQUssQ0FBQyxpQkFBSSxhQUFhLEVBQUcsQ0FBQyxHQUFFLENBQUM7WUFDdkMsSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQ1osRUFBRSxDQUFDLFFBQVEsQ0FDUCx5RkFBeUYsRUFDekYsa0JBQWtCLENBQ3JCLEVBQ0QsRUFBRSxJQUFJLEVBQUUsU0FBUyxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsQ0FDckMsQ0FBQztZQUNGLE1BQU0sR0FBRyxJQUFJLENBQUM7UUFDbEIsQ0FBQztRQUVELE9BQU8sTUFBTSxDQUFDO0lBQ2xCLENBQUM7SUFFRCxtRkFBbUY7SUFDbkYsS0FBSyxDQUFDLGFBQWE7UUFDZixNQUFNLEtBQUssR0FBdUIsSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUM7UUFDMUQsTUFBTSxFQUFFLGFBQWEsRUFBRSxHQUE4QixJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztRQUM3RSxJQUFJLDBCQUEwQixHQUFZLEdBQUcsQ0FBQztRQUM5QyxJQUFJLDJCQUEyQixHQUFZLENBQUMsQ0FBQztRQUU3QyxzRkFBc0Y7UUFDdEYsTUFBTSxhQUFhLDZCQUNmLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUUsYUFBYSxDQUFDLEVBQ2hELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEdBQzVCLGFBQWEsQ0FBQyxpQkFBaUIsRUFBQztRQUVwQyxJQUFJLHlCQUFhLEVBQUcsQ0FBQyxpQkFBSSxhQUFhLENBQUMsZ0JBQWdCLEVBQUcsQ0FBQyxHQUFFLENBQUM7WUFDMUQsMkJBQTJCLGdCQUFHLGNBQUMsYUFBYSxFQUFHLGFBQWEsQ0FBQyxnQkFBZ0IsRUFBQyxFQUFHLEdBQUcsRUFBQztRQUN6RixDQUFDO1FBQ0QsMEJBQTBCLEdBQUcsTUFBTSxJQUFJLENBQUMsMEJBQTBCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUV2RyxnQkFBSSwwQkFBMEIsRUFBSSxDQUFDLEdBQUUsQ0FBQztZQUNsQyxpQkFBSSwyQkFBMkIsRUFBSSwwQkFBMEIsR0FBRSxDQUFDO2dCQUM1RCxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUM7WUFDNUIsQ0FBQztpQkFBTSxDQUFDO2dCQUNKLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztZQUM3QixDQUFDO1FBQ0wsQ0FBQzthQUFNLENBQUM7WUFDSixJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDN0IsQ0FBQztJQUNMLENBQUM7SUFFRDtxRUFDaUU7SUFDakUsc0JBQXNCO1FBQ2xCLE1BQU0sS0FBSyxHQUF1QixJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztRQUMxRCxNQUFNLEVBQUUsYUFBYSxFQUFFLEdBQThCLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1FBQzdFLE1BQU0sc0JBQXNCLEdBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBRSxhQUFhLENBQUMsQ0FBQztRQUNoRixNQUFNLHdCQUF3QixnQkFBRyxhQUFhLENBQUMsZ0JBQWdCLEVBQUcsYUFBYSxDQUFDLGlCQUFpQixFQUFDO1FBQ2xHLE1BQU0sWUFBWSxnQkFBVyx3QkFBd0IsRUFBRyxzQkFBc0IsRUFBQztRQUMvRSxJQUFJLFlBQVksRUFBRSxDQUFDO1lBQ2YsT0FBTyxZQUFZLENBQUM7UUFDeEIsQ0FBQztRQUNELE9BQU8sQ0FBQyxDQUFDO0lBQ2IsQ0FBQztJQUVEOzs7OztPQUtHO0lBQ0gscUJBQXFCLENBQUMsS0FBeUIsRUFBRSxhQUFxQztRQUNsRixNQUFNLEVBQUUsU0FBUyxFQUFFLGVBQWUsRUFBRSxHQUEyQixhQUFhLENBQUM7UUFDN0UsTUFBTSxnQkFBZ0IsR0FBdUIsS0FBSyxDQUFDLE1BQU0sQ0FDckQsQ0FBQyxJQUFzQixFQUFFLEVBQUUsQ0FDdkIsc0JBQUksQ0FBQyxlQUFlLEVBQUssU0FBUyxFQUFFLE1BQU0sdUJBQUksSUFBSSxDQUFDLGVBQWUsRUFBSyxlQUFlLEVBQzdGLENBQUM7UUFFRixNQUFNLGlCQUFpQixHQUFXLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQVcsRUFBRSxTQUFjLEVBQUUsRUFBRTtZQUN0RixvQkFBTyxHQUFHLEVBQUcsU0FBUyxDQUFDLHNCQUFzQixFQUFDO1FBQ2xELENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztRQUNOLE9BQU8saUJBQWlCLENBQUM7SUFDN0IsQ0FBQztJQUVEOzs7O09BSUc7SUFDSCxLQUFLLENBQUMsMEJBQTBCLENBQUMsVUFBa0I7UUFDL0MsSUFBSSxDQUFDO1lBQ0QsTUFBTSxNQUFNLEdBQUcsK0JBQVksRUFDdkIsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUs7aUJBQ2IsSUFBSSxDQUFDLHdDQUF3QyxDQUFDO2lCQUM5QyxLQUFLLENBQ0YsRUFBRSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQ3ZCO2dCQUNJLDBCQUEwQixFQUFFLElBQUk7YUFDbkMsRUFDRDtnQkFDSSxNQUFNLEVBQUU7b0JBQ0osSUFBSSxFQUFFLFVBQVU7b0JBQ2hCLGlCQUFpQixFQUFFLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxZQUFZLEVBQUUsRUFBRTtpQkFDbkQ7YUFDSixDQUNKLENBQ0o7aUJBQ0EsT0FBTyxFQUFFLENBQ2pCLENBQUM7WUFDRixPQUFPLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsMEJBQTBCLENBQUMsQ0FBQztRQUM1RCxDQUFDO1FBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztZQUNYLE9BQU8sQ0FBQyxDQUFDO1FBQ2IsQ0FBQztJQUNMLENBQUM7SUFFRDs7O09BR0c7SUFDSCxLQUFLLENBQUMsVUFBVTtRQUNaLElBQUksQ0FBQztZQUNELE1BQU0sTUFBTSxHQUFHLCtCQUFZLEVBQ3ZCLE1BQU0sSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLO2lCQUNiLElBQUksQ0FBQyw2Q0FBNkMsQ0FBQztpQkFDbkQsS0FBSyxDQUNGLEVBQUUsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUN2QjtnQkFDSSxPQUFPLEVBQUU7b0JBQ0wsSUFBSSxFQUFFLElBQUk7aUJBQ2I7Z0JBQ0QsT0FBTyxFQUFFO29CQUNMLElBQUksRUFBRSxJQUFJO2lCQUNiO2FBQ0osRUFDRDtnQkFDSSxNQUFNLEVBQUU7b0JBQ0osU0FBUyxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSztpQkFDeEM7YUFDSixDQUNKLENBQ0o7aUJBRUEsT0FBTyxFQUFFLENBQ2pCLENBQUM7WUFDRixPQUFPLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNyQixDQUFDO1FBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztZQUNYLElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FDakIsT0FBTyxFQUNQLEVBQUUsQ0FBQyxRQUFRLENBQ1AsdUZBQXVGLEVBQ3ZGLHdCQUF3QixDQUMzQixFQUNELE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FDZCxDQUFDO1lBQ0YsT0FBTztRQUNYLENBQUM7SUFDTCxDQUFDO0lBRUQ7O09BRUc7SUFDSCxLQUFLLENBQUMseUJBQXlCO1FBQzNCLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFRDs7T0FFRztJQUNILEtBQUssQ0FBQyxzQkFBc0I7UUFDeEIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUN2QixJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUNuQyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsdUJBQXVCLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUN2QyxNQUFNLEVBQUUsZUFBZSxFQUFFLEdBQThCLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1FBQy9FLHNCQUFJLGVBQWUsRUFBSyxDQUFDLEdBQUUsQ0FBQztZQUN4QixJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUNyQyxDQUFDO0lBQ0wsQ0FBQztDQUNKO0FBeDRCWSw4REFBeUI7QUFJbEM7SUFIQyxFQUFFLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBNEI7UUFDOUMsYUFBYSxFQUFFLElBQUk7S0FDdEIsQ0FBQzswREFDNkI7QUFRL0I7SUFOQyxFQUFFLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBNEI7UUFDNUMsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztRQUN4QixDQUFDO1FBQ0QsYUFBYSxFQUFFLElBQUk7S0FDdEIsQ0FBQzt3REFDeUI7QUEyQzNCO0lBekNDLEVBQUUsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUF3QztRQUNqRSxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO1FBQ3RCLENBQUM7UUFDRCxLQUFLLDhIQUFzQjtRQUMzQixVQUFVLEVBQUUsTUFBTTtRQUNsQixJQUFJLEVBQUUsd0NBQXdDO1FBQzlDLGdCQUFnQixFQUFFLEtBQUs7UUFDdkIsV0FBVyxFQUFFLEtBQUs7UUFDbEIsV0FBVyxtSUFBcUI7UUFDaEMsbUJBQW1CLEVBQUUsSUFBSTtRQUN6QixXQUFXLEVBQUUsSUFBSTtRQUNqQixNQUFNO1lBQ0YsT0FBTztnQkFDSCxpQkFBaUIsRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsWUFBWSxFQUFFLEVBQUU7Z0JBQ2hELElBQUksRUFBRSxFQUFFLEdBQUcsRUFBRSxDQUFDLEVBQUU7YUFDbkIsQ0FBQztRQUNOLENBQUM7UUFDRCxRQUFRO1lBQ0osSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ25DLENBQUM7UUFDRCxPQUFPLEVBQUU7WUFDTCxFQUFFLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQztnQkFDakIsSUFBSSxFQUFFLE1BQU07Z0JBQ1osVUFBVSxFQUFFLElBQUk7YUFDbkIsQ0FBQztZQUNGLEVBQUUsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDO2dCQUNqQixJQUFJLEVBQUUsYUFBYTtnQkFDbkIsVUFBVSxFQUFFLElBQUk7YUFDbkIsQ0FBQztZQUNGLEVBQUUsQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDO2dCQUN0QixJQUFJLEVBQUUsd0NBQXdDO2dCQUM5QyxJQUFJLEVBQUUsaUJBQWlCO2dCQUN2QixVQUFVLEVBQUUsTUFBTTthQUNyQixDQUFDO1lBQ0YsRUFBRSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUM7Z0JBQ2pCLElBQUksRUFBRSxNQUFNO2dCQUNaLFVBQVUsRUFBRSxJQUFJO2FBQ25CLENBQUM7U0FDTDtLQUNKLENBQUM7cUVBQ3NDO0FBT3hDO0lBTEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQTRCO1FBQ3JELE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7UUFDdEIsQ0FBQztLQUNKLENBQUM7d0RBQ3lCO0FBUzNCO0lBUEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQTRCO1FBQ2hELE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7UUFDdEIsQ0FBQztRQUNELEtBQUssMkdBQWE7UUFDbEIsVUFBVSxFQUFFLElBQUk7S0FDbkIsQ0FBQzsyREFDdUI7QUFTekI7SUFQQyxFQUFFLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBNEI7UUFDaEQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztRQUN0QixDQUFDO1FBQ0QsS0FBSyx1R0FBUTtRQUNiLFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7NERBQ3dCO0FBOEIxQjtJQTVCQyxFQUFFLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBNEI7UUFDbkQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztRQUN0QixDQUFDO1FBQ0QsS0FBSyxtSEFBWTtRQUNqQixXQUFXLEVBQUUsSUFBSTtRQUNqQixVQUFVLEVBQUUsbUNBQW1DO1FBQy9DLFFBQVE7WUFDSixJQUFJLHNCQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFLLFNBQVMsdUJBQUksSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBSyxJQUFJLEdBQUUsQ0FBQztnQkFDdEYsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssR0FBRyxDQUFDLENBQUM7Z0JBQ2pDLG9DQUFtQixFQUFDLElBQUksQ0FBQyxDQUFDO1lBQzlCLENBQUM7WUFFRCxNQUFNLEVBQUUsZUFBZSxFQUFFLEdBQThCLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1lBQy9FLHNCQUFJLGVBQWUsRUFBSyxDQUFDLEdBQUUsQ0FBQztnQkFDeEIsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO2dCQUNyQixnQkFBSSxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFHLElBQUksQ0FBQyxzQkFBc0IsRUFBRSxHQUFFLENBQUM7b0JBQy9ELElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUNaLEVBQUUsQ0FBQyxRQUFRLENBQ1Asa0dBQWtHLEVBQ2xHLHVDQUF1QyxDQUMxQyxFQUNELEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLENBQ3JDLENBQUM7Z0JBQ04sQ0FBQztZQUNMLENBQUM7UUFDTCxDQUFDO0tBQ0osQ0FBQztvRUFDbUM7QUE0QnJDO0lBMUJDLEVBQUUsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUE0QjtRQUNuRCxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO1FBQ3RCLENBQUM7UUFDRCxLQUFLLHVIQUFpQjtRQUN0QixVQUFVLEVBQUUsbUNBQW1DO1FBQy9DLFFBQVE7WUFDSixvRUFBb0U7WUFDcEUsSUFBSSxzQkFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssRUFBSyxTQUFTLHVCQUFJLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxLQUFLLEVBQUssSUFBSSxHQUFFLENBQUM7Z0JBQ3BGLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO2dCQUNoQyxvQ0FBbUIsRUFBQyxJQUFJLENBQUMsQ0FBQztZQUM5QixDQUFDO1lBQ0QsSUFBSSxzQkFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBSyxTQUFTLHVCQUFJLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUssSUFBSSxHQUFFLENBQUM7Z0JBQ3RGLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO1lBQ3JDLENBQUM7WUFDRCxnQkFBSSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxFQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEdBQUUsQ0FBQztnQkFDN0QsSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQ1osRUFBRSxDQUFDLFFBQVEsQ0FDUCxpRkFBaUYsRUFDakYsb0RBQW9ELENBQ3ZELEVBQ0QsRUFBRSxJQUFJLEVBQUUsT0FBTyxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsQ0FDbkMsQ0FBQztZQUNOLENBQUM7UUFDTCxDQUFDO0tBQ0osQ0FBQzttRUFDa0M7QUFXcEM7SUFUQyxFQUFFLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBNEI7UUFDbkQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztRQUN0QixDQUFDO1FBQ0QsS0FBSyxvSEFBcUI7UUFDMUIsUUFBUSxFQUFFLElBQUk7UUFDZCxVQUFVLEVBQUUsSUFBSTtRQUNoQixLQUFLLEVBQUUsQ0FBQztLQUNYLENBQUM7NERBQzJCO0FBVzdCO0lBVEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQTRCO1FBQ25ELE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7UUFDdEIsQ0FBQztRQUNELEtBQUssZ0hBQW1CO1FBQ3hCLFFBQVEsRUFBRSxJQUFJO1FBQ2QsVUFBVSxFQUFFLElBQUk7UUFDaEIsS0FBSyxFQUFFLENBQUM7S0FDWCxDQUFDOzBEQUN5QjtBQWlCM0I7SUFmQyxFQUFFLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBNEI7UUFDbkQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztRQUN0QixDQUFDO1FBQ0QsS0FBSywrSEFBb0I7UUFDekIsS0FBSyxFQUFFLENBQUM7UUFDUixVQUFVLEVBQUUsbUNBQW1DO1FBQy9DLFFBQVE7WUFDSixvRUFBb0U7WUFDcEUsSUFBSSxzQkFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBSyxTQUFTLHVCQUFJLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUssSUFBSSxHQUFFLENBQUM7Z0JBQzlGLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO2dCQUNyQyxvQ0FBbUIsRUFBQyxJQUFJLENBQUMsQ0FBQztZQUM5QixDQUFDO1FBQ0wsQ0FBQztLQUNKLENBQUM7d0VBQ3VDO0FBMEJ6QztJQXhCQyxFQUFFLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBNEI7UUFDbkQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztRQUN0QixDQUFDO1FBQ0QsS0FBSyxtSUFBc0I7UUFDM0IsS0FBSyxFQUFFLENBQUM7UUFDUixVQUFVLEVBQUUsbUNBQW1DO1FBQy9DLFFBQVE7WUFDSixJQUFJLHNCQUFJLENBQUMsdUJBQXVCLENBQUMsS0FBSyxFQUFLLFNBQVMsdUJBQUksSUFBSSxDQUFDLHVCQUF1QixDQUFDLEtBQUssRUFBSyxJQUFJLEdBQUUsQ0FBQztnQkFDbEcsSUFBSSxDQUFDLHVCQUF1QixDQUFDLEtBQUssR0FBRyxDQUFDLENBQUM7Z0JBQ3ZDLG9DQUFtQixFQUFDLElBQUksQ0FBQyxDQUFDO1lBQzlCLENBQUM7WUFFRCxpQkFBSSxJQUFJLENBQUMsdUJBQXVCLENBQUMsS0FBSyxFQUFJLEVBQUUsR0FBRSxDQUFDO2dCQUMzQyxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FDWixFQUFFLENBQUMsUUFBUSxDQUNQLHdGQUF3RixFQUN4RiwwQ0FBMEMsQ0FDN0MsRUFDRCxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxDQUNyQyxDQUFDO1lBQ04sQ0FBQztRQUNMLENBQUM7S0FDSixDQUFDOzBFQUN5QztBQWdCM0M7SUFkQyxFQUFFLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBNEI7UUFDbkQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztRQUN0QixDQUFDO1FBQ0QsS0FBSywySEFBa0I7UUFDdkIsS0FBSyxFQUFFLENBQUM7UUFDUixVQUFVLEVBQUUsbUNBQW1DO1FBQy9DLFFBQVE7WUFDSixJQUFJLHNCQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxFQUFLLFNBQVMsdUJBQUksSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssRUFBSyxJQUFJLEdBQUUsQ0FBQztnQkFDMUYsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssR0FBRyxDQUFDLENBQUM7Z0JBQ25DLG9DQUFtQixFQUFDLElBQUksQ0FBQyxDQUFDO1lBQzlCLENBQUM7UUFDTCxDQUFDO0tBQ0osQ0FBQztzRUFDcUM7QUEyQnZDO0lBekJDLEVBQUUsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUE0QjtRQUNuRCxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO1FBQ3RCLENBQUM7UUFDRCxLQUFLLCtIQUFvQjtRQUN6QixXQUFXLEVBQUUsS0FBSztRQUNsQixVQUFVLEVBQUUsbUNBQW1DO1FBQy9DLEtBQUssRUFBRSxDQUFDO1FBQ1IsUUFBUTtZQUNKLElBQUksc0JBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUssU0FBUyx1QkFBSSxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFLLElBQUksR0FBRSxDQUFDO2dCQUM5RixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztnQkFDckMsb0NBQW1CLEVBQUMsSUFBSSxDQUFDLENBQUM7WUFDOUIsQ0FBQztZQUVELGlCQUFJLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUksRUFBRSxHQUFFLENBQUM7Z0JBQ3pDLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUNaLEVBQUUsQ0FBQyxRQUFRLENBQ1Asd0ZBQXdGLEVBQ3hGLDBDQUEwQyxDQUM3QyxFQUNELEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLENBQ3JDLENBQUM7WUFDTixDQUFDO1FBQ0wsQ0FBQztLQUNKLENBQUM7d0VBQ3VDO0FBYXpDO0lBWEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQTRCO1FBQ3BELE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7UUFDdEIsQ0FBQztRQUNELEtBQUssb0dBQVM7UUFDZCxRQUFRO1lBQ0osSUFBSSxzQkFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUssSUFBSSx1QkFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBSyxTQUFTLEdBQUUsQ0FBQztnQkFDOUQsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1lBQ3pCLENBQUM7UUFDTCxDQUFDO0tBQ0osQ0FBQzt3REFDd0I7QUF5QjFCO0lBdkJDLEVBQUUsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUE0QjtRQUNqRCxLQUFLLGlIQUFnQjtRQUNyQixVQUFVLEVBQUUsV0FBVztRQUN2QixRQUFRLEVBQUUsQ0FBQyxJQUFJLENBQUM7UUFDaEIsS0FBSyxDQUFDLE9BQU87WUFDVCxJQUFJLENBQUMsQ0FBQyxNQUFNLG9DQUFtQixFQUFDLElBQUksQ0FBQyxDQUFDO2dCQUFFLE9BQU87WUFDL0MsTUFBTSxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztZQUM5QixNQUFNLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1lBQ2hDLHNCQUFJLENBQUMsTUFBTSxJQUFJLENBQUMsc0JBQXNCLEVBQUUsQ0FBQyxFQUFLLEtBQUssR0FBRSxDQUFDO2dCQUNsRCxPQUFPO1lBQ1gsQ0FBQztpQkFBTSxDQUFDO2dCQUNKLE1BQU0sSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFDOUIsTUFBTSxFQUFFLGVBQWUsRUFBRSxHQUE4QixJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztnQkFDL0UsZ0dBQWdHO2dCQUNoRyxzQkFBSSxlQUFlLEVBQUssQ0FBQyxHQUFFLENBQUM7b0JBQ3hCLE1BQU0sSUFBSSxDQUFDLG9CQUFvQixFQUFFLENBQUM7Z0JBQ3RDLENBQUM7Z0JBQ0QsTUFBTSxJQUFJLENBQUMsc0JBQXNCLEVBQUUsQ0FBQztnQkFDcEMsTUFBTSxJQUFJLENBQUMseUJBQXlCLEVBQUUsQ0FBQztnQkFDdkMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssRUFBRSxDQUFDO1lBQ3BDLENBQUM7UUFDTCxDQUFDO0tBQ0osQ0FBQzs4REFDeUI7QUFvQjNCO0lBbEJDLEVBQUUsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUE0QjtRQUNqRCxLQUFLLHNHQUFRO1FBQ2IsVUFBVSxFQUFFLFNBQVM7UUFDckIsUUFBUSxFQUFFLENBQUMsSUFBSSxDQUFDO1FBQ2hCLEtBQUssQ0FBQyxPQUFPO1lBQ1QsSUFBSSxDQUFDLENBQUMsTUFBTSxvQ0FBbUIsRUFBQyxJQUFJLENBQUMsQ0FBQztnQkFBRSxPQUFPO1lBQy9DLE1BQU0sSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUM7WUFDOUIsTUFBTSxJQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztZQUNoQyxzQkFBSSxDQUFDLE1BQU0sSUFBSSxDQUFDLHNCQUFzQixFQUFFLENBQUMsRUFBSyxLQUFLLEdBQUUsQ0FBQztnQkFDbEQsT0FBTztZQUNYLENBQUM7aUJBQU0sQ0FBQztnQkFDSixNQUFNLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLENBQUM7Z0JBQy9CLElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQywyQ0FBMkMsRUFBRTtvQkFDNUQsUUFBUSxFQUFFLE1BQU07aUJBQ25CLENBQUMsQ0FBQztZQUNQLENBQUM7UUFDTCxDQUFDO0tBQ0osQ0FBQzsyREFDc0I7QUFPeEI7SUFKQyxFQUFFLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBNEI7UUFDaEQsVUFBVSxFQUFFLElBQUk7UUFDaEIsV0FBVyxFQUFFLElBQUk7S0FDcEIsQ0FBQztrRUFDOEI7QUFNaEM7SUFKQyxFQUFFLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBNEI7UUFDaEQsVUFBVSxFQUFFLElBQUk7UUFDaEIsUUFBUSxFQUFFLElBQUk7S0FDakIsQ0FBQztrRUFDOEI7QUFLaEM7SUFIQyxFQUFFLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBNEI7UUFDaEQsVUFBVSxFQUFFLElBQUk7S0FDbkIsQ0FBQzs4REFDMEI7QUFLNUI7SUFIQyxFQUFFLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBNEI7UUFDbkQsVUFBVSxFQUFFLElBQUk7S0FDbkIsQ0FBQztrRUFDaUM7QUFNbkM7SUFKQyxFQUFFLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBNEI7UUFDaEQsVUFBVSxFQUFFLElBQUk7UUFDaEIsV0FBVyxFQUFFLElBQUk7S0FDcEIsQ0FBQzt1RUFDbUM7QUFNckM7SUFKQyxFQUFFLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBNEI7UUFDaEQsVUFBVSxFQUFFLElBQUk7UUFDaEIsUUFBUSxFQUFFLElBQUk7S0FDakIsQ0FBQztzREFDa0I7QUFLcEI7SUFIQyxFQUFFLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBNEI7UUFDaEQsVUFBVSxFQUFFLElBQUk7S0FDbkIsQ0FBQzswREFDc0I7b0NBeFZmLHlCQUF5QjtJQXJCckMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQTRCO1FBQzNDLEtBQUssNkdBQXlCO1FBQzlCLFdBQVcsRUFBRSxLQUFLO1FBQ2xCLGFBQWEsRUFBRSxJQUFJO1FBQ25CLE1BQU0sRUFBRSxrQkFBa0I7UUFDMUIsSUFBSSxFQUFFLFNBQVM7UUFDZixVQUFVO1lBQ04sT0FBTztnQkFDSCxLQUFLLEVBQUUsSUFBSSxDQUFDLGVBQWU7Z0JBQzNCLEtBQUssRUFBRSxJQUFJLENBQUMsV0FBVztnQkFDdkIsVUFBVSxFQUFFLElBQUksQ0FBQyxlQUFlO2dCQUNoQyxVQUFVLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjthQUN4QyxDQUFDO1FBQ04sQ0FBQztRQUNELGVBQWU7WUFDWCxPQUFPLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDN0MsQ0FBQztRQUNELEtBQUssQ0FBQyxNQUFNO1lBQ1IsTUFBTSxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDMUIsQ0FBQztLQUNKLENBQUM7R0FDVyx5QkFBeUIsQ0F3NEJyQyIsInNvdXJjZXMiOlsid2VicGFjazovL3h0cmVtQXJ0aWZhY3QvLi9saWIvcGFnZXMvbW9iaWxlLXRpbWUtdHJhY2tpbmctZGV0YWlscy50cz8xZjJjIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFdvcmtPcmRlciB9IGZyb20gJ0BzYWdlL3gzLW1hbnVmYWN0dXJpbmctYXBpJztcbmltcG9ydCB7IFN0YW5kYXJkT3BlcmF0aW9ucywgV29ya09yZGVyUHJvZHVjdExpbmUgfSBmcm9tICdAc2FnZS94My1tYW51ZmFjdHVyaW5nLWFwaS1wYXJ0aWFsJztcbmltcG9ydCB7IFdvcmtDZW50ZXIgfSBmcm9tICdAc2FnZS94My1tYW51ZmFjdHVyaW5nLWRhdGEtYXBpJztcbmltcG9ydCB7IGRlY2ltYWwsIGV4dHJhY3RFZGdlcyB9IGZyb20gJ0BzYWdlL3h0cmVtLWNsaWVudCc7XG5pbXBvcnQgKiBhcyB1aSBmcm9tICdAc2FnZS94dHJlbS11aSc7XG5pbXBvcnQgeyBHZXRVT01OdW1iZXJPZkRlY2ltYWxQbGFjZXMgfSBmcm9tICcuLi9jbGllbnQtZnVuY3Rpb25zL2dldC11bml0LWRlY2ltYWwtcGxhY2VzJztcbmltcG9ydCB7IHZhbGlkYXRlV2l0aERldGFpbHMgfSBmcm9tICcuLi9jbGllbnQtZnVuY3Rpb25zL3ZhbGlkYXRpb24nO1xuaW1wb3J0IHsgT3BlcmF0aW9uTGluZSwgVGltZVRyYWNraW5nTGluZSwgVGltZVRyYWNraW5nU3RvcmFnZU9iamVjdCB9IGZyb20gJy4vdXRpbHMvdHlwZXMnO1xuXG5AdWkuZGVjb3JhdG9ycy5wYWdlPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICB0aXRsZTogJ1RpbWUgdHJhY2tpbmcgZGV0YWlscycsXG4gICAgaXNUcmFuc2llbnQ6IGZhbHNlLFxuICAgIGlzVGl0bGVIaWRkZW46IHRydWUsXG4gICAgbW9kdWxlOiAneDMtbWFudWZhY3R1cmluZycsXG4gICAgbW9kZTogJ2RlZmF1bHQnLFxuICAgIGhlYWRlckNhcmQoKSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICB0aXRsZTogdGhpcy53b3JrT3JkZXJOdW1iZXIsXG4gICAgICAgICAgICBsaW5lMjogdGhpcy5yb3V0aW5nQ29kZSxcbiAgICAgICAgICAgIHRpdGxlUmlnaHQ6IHRoaXMub3BlcmF0aW9uTnVtYmVyLFxuICAgICAgICAgICAgbGluZTJSaWdodDogdGhpcy5vcGVyYXRpb25EZXNjcmlwdGlvbixcbiAgICAgICAgfTtcbiAgICB9LFxuICAgIGJ1c2luZXNzQWN0aW9ucygpIHtcbiAgICAgICAgcmV0dXJuIFt0aGlzLmFkZFF1YW50aXR5LCB0aGlzLm5leHRQYWdlXTtcbiAgICB9LFxuICAgIGFzeW5jIG9uTG9hZCgpIHtcbiAgICAgICAgYXdhaXQgdGhpcy5pbml0UGFnZSgpO1xuICAgIH0sXG59KVxuZXhwb3J0IGNsYXNzIE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHMgZXh0ZW5kcyB1aS5QYWdlIHtcbiAgICBAdWkuZGVjb3JhdG9ycy5zZWN0aW9uPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgaXNUaXRsZUhpZGRlbjogdHJ1ZSxcbiAgICB9KVxuICAgIHNlY3Rpb246IHVpLmNvbnRhaW5lcnMuU2VjdGlvbjtcblxuICAgIEB1aS5kZWNvcmF0b3JzLmJsb2NrPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuc2VjdGlvbjtcbiAgICAgICAgfSxcbiAgICAgICAgaXNUaXRsZUhpZGRlbjogdHJ1ZSxcbiAgICB9KVxuICAgIGJsb2NrOiB1aS5jb250YWluZXJzLkJsb2NrO1xuXG4gICAgQHVpLmRlY29yYXRvcnMucmVmZXJlbmNlRmllbGQ8TW9iaWxlVGltZVRyYWNraW5nRGV0YWlscywgV29ya0NlbnRlcj4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5ibG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdBY3R1YWwgd29yayBjZW50ZXInLFxuICAgICAgICB2YWx1ZUZpZWxkOiAnY29kZScsXG4gICAgICAgIG5vZGU6ICdAc2FnZS94My1tYW51ZmFjdHVyaW5nLWRhdGEvV29ya0NlbnRlcicsXG4gICAgICAgIGlzVHJhbnNpZW50SW5wdXQ6IGZhbHNlLFxuICAgICAgICBpc1RyYW5zaWVudDogZmFsc2UsXG4gICAgICAgIHBsYWNlaG9sZGVyOiAnU2NhbiBvciBzZWxlY3QuLi4nLFxuICAgICAgICBpc0F1dG9TZWxlY3RFbmFibGVkOiB0cnVlLFxuICAgICAgICBpc01hbmRhdG9yeTogdHJ1ZSxcbiAgICAgICAgZmlsdGVyKCkge1xuICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICBtYW51ZmFjdHVyaW5nU2l0ZTogeyBjb2RlOiB0aGlzLmdldFN0b2NrU2l0ZSgpIH0sXG4gICAgICAgICAgICAgICAgdHlwZTogeyBfbmU6IDMgfSxcbiAgICAgICAgICAgIH07XG4gICAgICAgIH0sXG4gICAgICAgIG9uQ2hhbmdlKCkge1xuICAgICAgICAgICAgdGhpcy5yZW1haW5pbmdRdWFudGl0eS5mb2N1cygpO1xuICAgICAgICB9LFxuICAgICAgICBjb2x1bW5zOiBbXG4gICAgICAgICAgICB1aS5uZXN0ZWRGaWVsZHMudGV4dCh7XG4gICAgICAgICAgICAgICAgYmluZDogJ2NvZGUnLFxuICAgICAgICAgICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy50ZXh0KHtcbiAgICAgICAgICAgICAgICBiaW5kOiAnZGVzY3JpcHRpb24nLFxuICAgICAgICAgICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy5yZWZlcmVuY2Uoe1xuICAgICAgICAgICAgICAgIG5vZGU6ICdAc2FnZS94My1tYW51ZmFjdHVyaW5nL1dvcmtDZW50ZXJHcm91cCcsXG4gICAgICAgICAgICAgICAgYmluZDogJ3dvcmtDZW50ZXJHcm91cCcsXG4gICAgICAgICAgICAgICAgdmFsdWVGaWVsZDogJ2NvZGUnLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICB1aS5uZXN0ZWRGaWVsZHMudGV4dCh7XG4gICAgICAgICAgICAgICAgYmluZDogJ3R5cGUnLFxuICAgICAgICAgICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgXSxcbiAgICB9KVxuICAgIGV4cGVjdGVkV29ya0NlbnRlcjogdWkuZmllbGRzLlJlZmVyZW5jZTtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnNlcGFyYXRvckZpZWxkPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuYmxvY2s7XG4gICAgICAgIH0sXG4gICAgfSlcbiAgICBibGFuazogdWkuZmllbGRzLlNlcGFyYXRvcjtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVUaW1lVHJhY2tpbmdEZXRhaWxzPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLmJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ1RpbWUgdW5pdCcsXG4gICAgICAgIGlzRGlzYWJsZWQ6IHRydWUsXG4gICAgfSlcbiAgICB0aW1lVW5pdDogdWkuZmllbGRzLlRleHQ7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy50ZXh0RmllbGQ8TW9iaWxlVGltZVRyYWNraW5nRGV0YWlscz4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5ibG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdVbml0JyxcbiAgICAgICAgaXNEaXNhYmxlZDogdHJ1ZSxcbiAgICB9KVxuICAgIHN0b2NrVW5pdDogdWkuZmllbGRzLlRleHQ7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5udW1lcmljRmllbGQ8TW9iaWxlVGltZVRyYWNraW5nRGV0YWlscz4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5ibG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdRdWFudGl0eScsXG4gICAgICAgIGlzTWFuZGF0b3J5OiB0cnVlLFxuICAgICAgICB2YWxpZGF0aW9uOiAvXlxcZCpbMC05XSh8LlxcZCpbMC05XXwsXFxkKlswLTldKT8kLyxcbiAgICAgICAgb25DaGFuZ2UoKSB7XG4gICAgICAgICAgICBpZiAodGhpcy5yZW1haW5pbmdRdWFudGl0eS52YWx1ZSA9PT0gdW5kZWZpbmVkIHx8IHRoaXMucmVtYWluaW5nUXVhbnRpdHkudmFsdWUgPT09IG51bGwpIHtcbiAgICAgICAgICAgICAgICB0aGlzLnJlbWFpbmluZ1F1YW50aXR5LnZhbHVlID0gMDtcbiAgICAgICAgICAgICAgICB2YWxpZGF0ZVdpdGhEZXRhaWxzKHRoaXMpO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBjb25zdCB7IG9wZXJhdGlvbk1ldGhvZCB9OiBUaW1lVHJhY2tpbmdTdG9yYWdlT2JqZWN0ID0gdGhpcy5nZXRTdG9yYWdlT2JqZWN0KCk7XG4gICAgICAgICAgICBpZiAob3BlcmF0aW9uTWV0aG9kID09PSAwKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5zZXRDbG9zZUZpZWxkKCk7XG4gICAgICAgICAgICAgICAgaWYgKHRoaXMucmVtYWluaW5nUXVhbnRpdHkudmFsdWUgPiB0aGlzLmdldFF0eUF2YWlsYWJsZVRvVHJhY2soKSkge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLiQuc2hvd1RvYXN0KFxuICAgICAgICAgICAgICAgICAgICAgICAgdWkubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLW1hbnVmYWN0dXJpbmcvcGFnZXNfX21vYmlsZV90aW1lX3RyYWNraW5nX2RldGFpbHNfX19xdWFudGl0eV9fbGFyZ2VyX19leHBlY3RlZF9fd2FybmluZycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgJ1RoZSBxdWFudGl0eSBpcyBsYXJnZXIgdGhhbiBleHBlY3RlZC4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHsgdHlwZTogJ3dhcm5pbmcnLCB0aW1lb3V0OiA1MDAwIH0sXG4gICAgICAgICAgICAgICAgICAgICk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9LFxuICAgIH0pXG4gICAgcmVtYWluaW5nUXVhbnRpdHk6IHVpLmZpZWxkcy5OdW1lcmljO1xuXG4gICAgQHVpLmRlY29yYXRvcnMubnVtZXJpY0ZpZWxkPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuYmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnUmVqZWN0ZWQgcXR5LicsXG4gICAgICAgIHZhbGlkYXRpb246IC9eXFxkKlswLTldKHwuXFxkKlswLTldfCxcXGQqWzAtOV0pPyQvLFxuICAgICAgICBvbkNoYW5nZSgpIHtcbiAgICAgICAgICAgIC8vIGlmIHVzZXIgYmxhbmtzIG91dCB2YWx1ZSBzZXQgdG8gemVybyBhbmQgcmUtcnVuIHNjcmVlbiB2YWxpZGF0aW9uXG4gICAgICAgICAgICBpZiAodGhpcy5yZWplY3RlZFF1YW50aXR5LnZhbHVlID09PSB1bmRlZmluZWQgfHwgdGhpcy5yZWplY3RlZFF1YW50aXR5LnZhbHVlID09PSBudWxsKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5yZWplY3RlZFF1YW50aXR5LnZhbHVlID0gMDtcbiAgICAgICAgICAgICAgICB2YWxpZGF0ZVdpdGhEZXRhaWxzKHRoaXMpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMucmVtYWluaW5nUXVhbnRpdHkudmFsdWUgPT09IHVuZGVmaW5lZCB8fCB0aGlzLnJlbWFpbmluZ1F1YW50aXR5LnZhbHVlID09PSBudWxsKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5yZW1haW5pbmdRdWFudGl0eS52YWx1ZSA9IDA7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAodGhpcy5yZWplY3RlZFF1YW50aXR5LnZhbHVlID4gdGhpcy5yZW1haW5pbmdRdWFudGl0eS52YWx1ZSkge1xuICAgICAgICAgICAgICAgIHRoaXMuJC5zaG93VG9hc3QoXG4gICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLW1hbnVmYWN0dXJpbmcvcGFnZXNfX21vYmlsZV90aW1lX3RyYWNraW5nX2RldGFpbHNfX19yZWplY3RlZF9xdHlfZXJyb3InLFxuICAgICAgICAgICAgICAgICAgICAgICAgJ1JlamVjdGVkIHF1YW50aXR5IGdyZWF0ZXIgdGhhbiB0aGUgcXVhbnRpdHkgdmFsdWUuJyxcbiAgICAgICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICAgICAgeyB0eXBlOiAnZXJyb3InLCB0aW1lb3V0OiA1MDAwIH0sXG4gICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICB9KVxuICAgIHJlamVjdGVkUXVhbnRpdHk6IHVpLmZpZWxkcy5OdW1lcmljO1xuXG4gICAgQHVpLmRlY29yYXRvcnMubnVtZXJpY0ZpZWxkPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuYmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnQWN0dWFsIHNldHVwIHRpbWUnLFxuICAgICAgICBpc0hpZGRlbjogdHJ1ZSxcbiAgICAgICAgaXNEaXNhYmxlZDogdHJ1ZSxcbiAgICAgICAgc2NhbGU6IDQsXG4gICAgfSlcbiAgICBzZXR1cFRpbWU6IHVpLmZpZWxkcy5OdW1lcmljO1xuXG4gICAgQHVpLmRlY29yYXRvcnMubnVtZXJpY0ZpZWxkPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuYmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnQWN0dWFsIHJ1biB0aW1lJyxcbiAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgICAgIGlzRGlzYWJsZWQ6IHRydWUsXG4gICAgICAgIHNjYWxlOiA0LFxuICAgIH0pXG4gICAgcnVuVGltZTogdWkuZmllbGRzLk51bWVyaWM7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5udW1lcmljRmllbGQ8TW9iaWxlVGltZVRyYWNraW5nRGV0YWlscz4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5ibG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdTZXR1cCB0aW1lIGhvdXJzJyxcbiAgICAgICAgc2NhbGU6IDQsXG4gICAgICAgIHZhbGlkYXRpb246IC9eXFxkKlswLTldKHwuXFxkKlswLTldfCxcXGQqWzAtOV0pPyQvLFxuICAgICAgICBvbkNoYW5nZSgpIHtcbiAgICAgICAgICAgIC8vIGlmIHVzZXIgYmxhbmtzIG91dCB2YWx1ZSBzZXQgdG8gemVybyBhbmQgcmUtcnVuIHNjcmVlbiB2YWxpZGF0aW9uXG4gICAgICAgICAgICBpZiAodGhpcy5lbnRlcmVkU2V0dXBUaW1lSG91cnMudmFsdWUgPT09IHVuZGVmaW5lZCB8fCB0aGlzLmVudGVyZWRTZXR1cFRpbWVIb3Vycy52YWx1ZSA9PT0gbnVsbCkge1xuICAgICAgICAgICAgICAgIHRoaXMuZW50ZXJlZFNldHVwVGltZUhvdXJzLnZhbHVlID0gMDtcbiAgICAgICAgICAgICAgICB2YWxpZGF0ZVdpdGhEZXRhaWxzKHRoaXMpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9LFxuICAgIH0pXG4gICAgZW50ZXJlZFNldHVwVGltZUhvdXJzOiB1aS5maWVsZHMuTnVtZXJpYztcblxuICAgIEB1aS5kZWNvcmF0b3JzLm51bWVyaWNGaWVsZDxNb2JpbGVUaW1lVHJhY2tpbmdEZXRhaWxzPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLmJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ1NldHVwIHRpbWUgbWludXRlcycsXG4gICAgICAgIHNjYWxlOiAwLFxuICAgICAgICB2YWxpZGF0aW9uOiAvXlxcZCpbMC05XSh8LlxcZCpbMC05XXwsXFxkKlswLTldKT8kLyxcbiAgICAgICAgb25DaGFuZ2UoKSB7XG4gICAgICAgICAgICBpZiAodGhpcy5lbnRlcmVkU2V0dXBUaW1lTWludXRlcy52YWx1ZSA9PT0gdW5kZWZpbmVkIHx8IHRoaXMuZW50ZXJlZFNldHVwVGltZU1pbnV0ZXMudmFsdWUgPT09IG51bGwpIHtcbiAgICAgICAgICAgICAgICB0aGlzLmVudGVyZWRTZXR1cFRpbWVNaW51dGVzLnZhbHVlID0gMDtcbiAgICAgICAgICAgICAgICB2YWxpZGF0ZVdpdGhEZXRhaWxzKHRoaXMpO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBpZiAodGhpcy5lbnRlcmVkU2V0dXBUaW1lTWludXRlcy52YWx1ZSA+PSA2MCkge1xuICAgICAgICAgICAgICAgIHRoaXMuJC5zaG93VG9hc3QoXG4gICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLW1hbnVmYWN0dXJpbmcvcGFnZXNfX21vYmlsZV90aW1lX3RyYWNraW5nX2RldGFpbHNfX19taW51dGVzX19lbnRlcmVkX193YXJuaW5nJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICdNaW51dGVzIGFyZSBlcXVhbCB0byBvciBncmVhdGVyIHRoYW4gNjAuJyxcbiAgICAgICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICAgICAgeyB0eXBlOiAnd2FybmluZycsIHRpbWVvdXQ6IDUwMDAgfSxcbiAgICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgfVxuICAgICAgICB9LFxuICAgIH0pXG4gICAgZW50ZXJlZFNldHVwVGltZU1pbnV0ZXM6IHVpLmZpZWxkcy5OdW1lcmljO1xuXG4gICAgQHVpLmRlY29yYXRvcnMubnVtZXJpY0ZpZWxkPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuYmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnUnVuIHRpbWUgaG91cnMnLFxuICAgICAgICBzY2FsZTogNCxcbiAgICAgICAgdmFsaWRhdGlvbjogL15cXGQqWzAtOV0ofC5cXGQqWzAtOV18LFxcZCpbMC05XSk/JC8sXG4gICAgICAgIG9uQ2hhbmdlKCkge1xuICAgICAgICAgICAgaWYgKHRoaXMuZW50ZXJlZFJ1blRpbWVIb3Vycy52YWx1ZSA9PT0gdW5kZWZpbmVkIHx8IHRoaXMuZW50ZXJlZFJ1blRpbWVIb3Vycy52YWx1ZSA9PT0gbnVsbCkge1xuICAgICAgICAgICAgICAgIHRoaXMuZW50ZXJlZFJ1blRpbWVIb3Vycy52YWx1ZSA9IDA7XG4gICAgICAgICAgICAgICAgdmFsaWRhdGVXaXRoRGV0YWlscyh0aGlzKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICB9KVxuICAgIGVudGVyZWRSdW5UaW1lSG91cnM6IHVpLmZpZWxkcy5OdW1lcmljO1xuXG4gICAgQHVpLmRlY29yYXRvcnMubnVtZXJpY0ZpZWxkPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuYmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnUnVuIHRpbWUgbWludXRlcycsXG4gICAgICAgIGlzTWFuZGF0b3J5OiBmYWxzZSxcbiAgICAgICAgdmFsaWRhdGlvbjogL15cXGQqWzAtOV0ofC5cXGQqWzAtOV18LFxcZCpbMC05XSk/JC8sXG4gICAgICAgIHNjYWxlOiAwLFxuICAgICAgICBvbkNoYW5nZSgpIHtcbiAgICAgICAgICAgIGlmICh0aGlzLmVudGVyZWRSdW5UaW1lTWludXRlcy52YWx1ZSA9PT0gdW5kZWZpbmVkIHx8IHRoaXMuZW50ZXJlZFJ1blRpbWVNaW51dGVzLnZhbHVlID09PSBudWxsKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5lbnRlcmVkUnVuVGltZU1pbnV0ZXMudmFsdWUgPSAwO1xuICAgICAgICAgICAgICAgIHZhbGlkYXRlV2l0aERldGFpbHModGhpcyk7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGlmICh0aGlzLmVudGVyZWRSdW5UaW1lTWludXRlcy52YWx1ZSA+PSA2MCkge1xuICAgICAgICAgICAgICAgIHRoaXMuJC5zaG93VG9hc3QoXG4gICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLW1hbnVmYWN0dXJpbmcvcGFnZXNfX21vYmlsZV90aW1lX3RyYWNraW5nX2RldGFpbHNfX19taW51dGVzX19lbnRlcmVkX193YXJuaW5nJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICdNaW51dGVzIGFyZSBlcXVhbCB0byBvciBncmVhdGVyIHRoYW4gNjAuJyxcbiAgICAgICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICAgICAgeyB0eXBlOiAnd2FybmluZycsIHRpbWVvdXQ6IDUwMDAgfSxcbiAgICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgfVxuICAgICAgICB9LFxuICAgIH0pXG4gICAgZW50ZXJlZFJ1blRpbWVNaW51dGVzOiB1aS5maWVsZHMuTnVtZXJpYztcblxuICAgIEB1aS5kZWNvcmF0b3JzLmNoZWNrYm94RmllbGQ8TW9iaWxlVGltZVRyYWNraW5nRGV0YWlscz4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5ibG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdDbG9zZScsXG4gICAgICAgIG9uQ2hhbmdlKCkge1xuICAgICAgICAgICAgaWYgKHRoaXMuY2xvc2UudmFsdWUgPT09IG51bGwgfHwgdGhpcy5jbG9zZS52YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5zZXRDbG9zZUZpZWxkKCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgfSlcbiAgICBjbG9zZTogdWkuZmllbGRzLkNoZWNrYm94O1xuXG4gICAgQHVpLmRlY29yYXRvcnMucGFnZUFjdGlvbjxNb2JpbGVUaW1lVHJhY2tpbmdEZXRhaWxzPih7XG4gICAgICAgIHRpdGxlOiAnQWRkIHF1YW50aXR5JyxcbiAgICAgICAgYnV0dG9uVHlwZTogJ3NlY29uZGFyeScsXG4gICAgICAgIHNob3J0Y3V0OiBbJ2YyJ10sXG4gICAgICAgIGFzeW5jIG9uQ2xpY2soKSB7XG4gICAgICAgICAgICBpZiAoIShhd2FpdCB2YWxpZGF0ZVdpdGhEZXRhaWxzKHRoaXMpKSkgcmV0dXJuO1xuICAgICAgICAgICAgYXdhaXQgdGhpcy5zZXRBY3R1YWxSdW5UaW1lKCk7XG4gICAgICAgICAgICBhd2FpdCB0aGlzLnNldEFjdHVhbFNldHVwVGltZSgpO1xuICAgICAgICAgICAgaWYgKChhd2FpdCB0aGlzLmlzVGltZUFuZFF1YW50aXR5VmFsaWQoKSkgPT09IGZhbHNlKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBhd2FpdCB0aGlzLmJ1dHRvbnNMb2dpYyh0cnVlKTtcbiAgICAgICAgICAgICAgICBjb25zdCB7IG9wZXJhdGlvbk1ldGhvZCB9OiBUaW1lVHJhY2tpbmdTdG9yYWdlT2JqZWN0ID0gdGhpcy5nZXRTdG9yYWdlT2JqZWN0KCk7XG4gICAgICAgICAgICAgICAgLy9jb25zdCB7IG9wZXJhdGlvbk1ldGhvZCwgb3BlcmF0aW9uTGluZSB9OiBUaW1lVHJhY2tpbmdTdG9yYWdlT2JqZWN0ID0gdGhpcy5nZXRTdG9yYWdlT2JqZWN0KCk7XG4gICAgICAgICAgICAgICAgaWYgKG9wZXJhdGlvbk1ldGhvZCA9PT0gMCkge1xuICAgICAgICAgICAgICAgICAgICBhd2FpdCB0aGlzLnNldFJlbWFpbmluZ1F1YW50aXR5KCk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGF3YWl0IHRoaXMuU2V0QWxsVGltZUZpZWxkc1RvWmVybygpO1xuICAgICAgICAgICAgICAgIGF3YWl0IHRoaXMuc2V0UmVqZWN0ZWRRdWFudGl0eVRvWmVybygpO1xuICAgICAgICAgICAgICAgIHRoaXMuZXhwZWN0ZWRXb3JrQ2VudGVyLmZvY3VzKCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgfSlcbiAgICBhZGRRdWFudGl0eTogdWkuUGFnZUFjdGlvbjtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnBhZ2VBY3Rpb248TW9iaWxlVGltZVRyYWNraW5nRGV0YWlscz4oe1xuICAgICAgICB0aXRsZTogJ05leHQnLFxuICAgICAgICBidXR0b25UeXBlOiAncHJpbWFyeScsXG4gICAgICAgIHNob3J0Y3V0OiBbJ2YzJ10sXG4gICAgICAgIGFzeW5jIG9uQ2xpY2soKSB7XG4gICAgICAgICAgICBpZiAoIShhd2FpdCB2YWxpZGF0ZVdpdGhEZXRhaWxzKHRoaXMpKSkgcmV0dXJuO1xuICAgICAgICAgICAgYXdhaXQgdGhpcy5zZXRBY3R1YWxSdW5UaW1lKCk7XG4gICAgICAgICAgICBhd2FpdCB0aGlzLnNldEFjdHVhbFNldHVwVGltZSgpO1xuICAgICAgICAgICAgaWYgKChhd2FpdCB0aGlzLmlzVGltZUFuZFF1YW50aXR5VmFsaWQoKSkgPT09IGZhbHNlKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBhd2FpdCB0aGlzLmJ1dHRvbnNMb2dpYyhmYWxzZSk7XG4gICAgICAgICAgICAgICAgdGhpcy4kLnJvdXRlci5nb1RvKCdAc2FnZS94My1tYW51ZmFjdHVyaW5nL01vYmlsZVRpbWVUcmFja2luZycsIHtcbiAgICAgICAgICAgICAgICAgICAgZ290TGluZXM6ICd0cnVlJyxcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICB9KVxuICAgIG5leHRQYWdlOiB1aS5QYWdlQWN0aW9uO1xuXG4gICAgLyoqICBIZWFkZXIgRmllbGRzICovXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgaXNEaXNhYmxlZDogdHJ1ZSxcbiAgICAgICAgaXNUcmFuc2llbnQ6IHRydWUsXG4gICAgfSlcbiAgICB3b3JrT3JkZXJOdW1iZXI6IHVpLmZpZWxkcy5UZXh0O1xuXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgaXNEaXNhYmxlZDogdHJ1ZSxcbiAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgfSlcbiAgICByZWxlYXNlZFJvdXRpbmc6IHVpLmZpZWxkcy5UZXh0O1xuXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgaXNEaXNhYmxlZDogdHJ1ZSxcbiAgICB9KVxuICAgIHJvdXRpbmdDb2RlOiB1aS5maWVsZHMuVGV4dDtcblxuICAgIEB1aS5kZWNvcmF0b3JzLm51bWVyaWNGaWVsZDxNb2JpbGVUaW1lVHJhY2tpbmdEZXRhaWxzPih7XG4gICAgICAgIGlzRGlzYWJsZWQ6IHRydWUsXG4gICAgfSlcbiAgICBvcGVyYXRpb25OdW1iZXI6IHVpLmZpZWxkcy5OdW1lcmljO1xuXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVRpbWVUcmFja2luZ0RldGFpbHM+KHtcbiAgICAgICAgaXNEaXNhYmxlZDogdHJ1ZSxcbiAgICAgICAgaXNUcmFuc2llbnQ6IHRydWUsXG4gICAgfSlcbiAgICBvcGVyYXRpb25EZXNjcmlwdGlvbjogdWkuZmllbGRzLlRleHQ7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy50ZXh0RmllbGQ8TW9iaWxlVGltZVRyYWNraW5nRGV0YWlscz4oe1xuICAgICAgICBpc0Rpc2FibGVkOiB0cnVlLFxuICAgICAgICBpc0hpZGRlbjogdHJ1ZSxcbiAgICB9KVxuICAgIGJvbTogdWkuZmllbGRzLlRleHQ7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy50ZXh0RmllbGQ8TW9iaWxlVGltZVRyYWNraW5nRGV0YWlscz4oe1xuICAgICAgICBpc0Rpc2FibGVkOiB0cnVlLFxuICAgIH0pXG4gICAgYm9tQ29kZTogdWkuZmllbGRzLlRleHQ7XG4gICAgLy8gLSBGb3IgSW5mb3JtYXRpb24gb25seSB0aGUgU2VsZWN0ZWRPcGVyYXRpb25NZXRob2QgYXJlXG4gICAgLy8gICBSb3V0ZXJPcGVyYXRpb24gaXMgMFxuICAgIC8vICAgU3RhbmRhcmRPcGVyYXRpb25XaXRoRGF0YSBpcyAxXG4gICAgLy8gICBTdGFuZGFyZE9wZXJhdGlvbk5vRGF0YSBpcyAyXG4gICAgLy8gICBVc2VyRGVmaW5lZE9wZXJhdGlvbiBpcyAzXG5cbiAgICBhc3luYyBpbml0UGFnZSgpIHtcbiAgICAgICAgLy9jb25zdCBzdG9ja1NpdGU6IHN0cmluZyA9IHRoaXMuZ2V0U3RvY2tTaXRlKCk7XG4gICAgICAgIGNvbnN0IHtcbiAgICAgICAgICAgIHVzZXJEZWZpbmVkT3BlcmF0aW9uTnVtYmVyLFxuICAgICAgICAgICAgdXNlckRlZmluZWRPcGVyYXRpb25EZXNjcmlwdGlvbixcbiAgICAgICAgICAgIG9wZXJhdGlvbk1ldGhvZCxcbiAgICAgICAgICAgIHN0YW5kYXJkT3BlcmF0aW9ucyxcbiAgICAgICAgICAgIG9wZXJhdGlvbkxpbmUsXG4gICAgICAgICAgICB3b3JrT3JkZXJOdW1iZXIsXG4gICAgICAgICAgICByZWxlYXNlVGltZVVuaXQsXG4gICAgICAgICAgICByZWxlYXNlVU9NLFxuICAgICAgICB9OiBUaW1lVHJhY2tpbmdTdG9yYWdlT2JqZWN0ID0gdGhpcy5nZXRTdG9yYWdlT2JqZWN0KCk7XG4gICAgICAgIHRoaXMuc2V0SGVhZGVyRmllbGRzKFxuICAgICAgICAgICAgdXNlckRlZmluZWRPcGVyYXRpb25OdW1iZXIsXG4gICAgICAgICAgICBvcGVyYXRpb25MaW5lLFxuICAgICAgICAgICAgd29ya09yZGVyTnVtYmVyLFxuICAgICAgICAgICAgb3BlcmF0aW9uTWV0aG9kLFxuICAgICAgICAgICAgdXNlckRlZmluZWRPcGVyYXRpb25EZXNjcmlwdGlvbixcbiAgICAgICAgKTtcbiAgICAgICAgdGhpcy5zZXREZWZhdWx0VmFsdWVzKG9wZXJhdGlvbkxpbmUsIHN0YW5kYXJkT3BlcmF0aW9ucywgb3BlcmF0aW9uTWV0aG9kLCByZWxlYXNlVU9NLCByZWxlYXNlVGltZVVuaXQpO1xuICAgICAgICB0aGlzLndvcmtPcmRlck51bWJlci52YWx1ZSA9IHdvcmtPcmRlck51bWJlci5udW1iZXI7XG4gICAgICAgIHRoaXMucmVsZWFzZWRSb3V0aW5nLnZhbHVlID0gd29ya09yZGVyTnVtYmVyLnJlbGVhc2VkUm91dGluZy5yb3V0aW5nLmNvZGU7XG4gICAgfVxuXG4gICAgLy8gU2V0IGhlYWRlciBmaWVsZCB2YWx1ZXNcbiAgICBzZXRIZWFkZXJGaWVsZHMoXG4gICAgICAgIHVzZXJEZWZpbmVkT3BlcmF0aW9uTnVtYmVyOiBudW1iZXIgfCBudWxsLFxuICAgICAgICBvcGVyYXRpb25MaW5lOiBQYXJ0aWFsPE9wZXJhdGlvbkxpbmU+IHwgbnVsbCxcbiAgICAgICAgd29ya09yZGVyOiBXb3JrT3JkZXIsXG4gICAgICAgIG9wZXJhdGlvbk1ldGhvZDogbnVtYmVyLFxuICAgICAgICB1c2VyRGVmaW5lZE9wZXJhdGlvbkRlc2NyaXB0aW9uOiBzdHJpbmcgfCBudWxsIHwgdW5kZWZpbmVkLFxuICAgICkge1xuICAgICAgICB0aGlzLndvcmtPcmRlck51bWJlci52YWx1ZSA9IHdvcmtPcmRlci5udW1iZXI7XG4gICAgICAgIHRoaXMucm91dGluZ0NvZGUudmFsdWUgPSB3b3JrT3JkZXIucm91dGluZ0NvZGUuY29kZS50b1N0cmluZygpO1xuXG4gICAgICAgIGlmIChvcGVyYXRpb25NZXRob2QgIT09IDApIHtcbiAgICAgICAgICAgIHRoaXMub3BlcmF0aW9uTnVtYmVyLnZhbHVlID0gdXNlckRlZmluZWRPcGVyYXRpb25OdW1iZXI7XG4gICAgICAgICAgICB0aGlzLm9wZXJhdGlvbkRlc2NyaXB0aW9uLnZhbHVlID0gdXNlckRlZmluZWRPcGVyYXRpb25EZXNjcmlwdGlvbjtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmIChvcGVyYXRpb25NZXRob2QgPT09IDApIHtcbiAgICAgICAgICAgIHRoaXMub3BlcmF0aW9uTnVtYmVyLnZhbHVlID0gb3BlcmF0aW9uTGluZT8ub3BlcmF0aW9uTnVtYmVyO1xuICAgICAgICAgICAgdGhpcy5vcGVyYXRpb25EZXNjcmlwdGlvbi52YWx1ZSA9IG9wZXJhdGlvbkxpbmU/Lm9wZXJhdGlvbkRlc2NyaXB0aW9uO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgLyoqIGZ1bmN0aW9uIFNldCBpbml0aWFsIHBhZ2UgZmllbGQgdmFsdWVzICovXG4gICAgYXN5bmMgc2V0RGVmYXVsdFZhbHVlcyhcbiAgICAgICAgb3BlcmF0aW9uTGluZTogUGFydGlhbDxPcGVyYXRpb25MaW5lPixcbiAgICAgICAgc3RhbmRhcmRPcGVyYXRpb25zOiBQYXJ0aWFsPFN0YW5kYXJkT3BlcmF0aW9ucz4sXG4gICAgICAgIG9wZXJhdGlvbk1ldGhvZDogbnVtYmVyLFxuICAgICAgICByZWxlYXNlVU9NOiBzdHJpbmcsXG4gICAgICAgIHJlbGVhc2VUaW1lVW5pdDogc3RyaW5nLFxuICAgICkge1xuICAgICAgICAvLyBpdGVtIGluZGVwZW5kYW50IG9mIG9wZXJhdGlvbiBtZXRob2QgLSBnZW5lcmljXG4gICAgICAgIHRoaXMucmVqZWN0ZWRRdWFudGl0eS52YWx1ZSA9IDA7XG4gICAgICAgIHRoaXMuZW50ZXJlZFNldHVwVGltZU1pbnV0ZXMudmFsdWUgPSAwO1xuICAgICAgICB0aGlzLmVudGVyZWRTZXR1cFRpbWVIb3Vycy52YWx1ZSA9IDA7XG4gICAgICAgIHRoaXMuZW50ZXJlZFJ1blRpbWVNaW51dGVzLnZhbHVlID0gMDtcbiAgICAgICAgdGhpcy5lbnRlcmVkUnVuVGltZUhvdXJzLnZhbHVlID0gMDtcblxuICAgICAgICAvLyAwID0gUm91dGluZyBPcGVyYXRpb24gTWV0aG9kXG4gICAgICAgIGlmIChvcGVyYXRpb25NZXRob2QgIT09IDApIHtcbiAgICAgICAgICAgIC8vIDEgPSBTdGFuZGFyZCBPcGVyYXRpb24gd2l0aCBkYXRhIE1ldGhvZFxuICAgICAgICAgICAgaWYgKG9wZXJhdGlvbk1ldGhvZCA9PT0gMSkge1xuICAgICAgICAgICAgICAgIHRyeSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuc3RvY2tVbml0LnZhbHVlID0gc3RhbmRhcmRPcGVyYXRpb25zLm9wZXJhdGlvblVvbS5jb2RlO1xuICAgICAgICAgICAgICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuc3RvY2tVbml0LnZhbHVlID0gcmVsZWFzZVVPTTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgYXdhaXQgdGhpcy5zZXRXb3JrQ2VudGVyKHN0YW5kYXJkT3BlcmF0aW9ucy5tYWluV29ya0NlbnRlci5jb2RlKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKG9wZXJhdGlvbk1ldGhvZCA9PT0gMikge1xuICAgICAgICAgICAgICAgIHRoaXMuc3RvY2tVbml0LnZhbHVlID0gcmVsZWFzZVVPTTtcbiAgICAgICAgICAgICAgICB0aGlzLnRpbWVVbml0LnZhbHVlID0gcmVsZWFzZVRpbWVVbml0O1xuICAgICAgICAgICAgICAgIHRoaXMucmVtYWluaW5nUXVhbnRpdHkudmFsdWUgPSAxO1xuICAgICAgICAgICAgICAgIHRoaXMuc2V0U2NhbGVGb3JOdW1lcmljRmllbGRzKHRoaXMuc3RvY2tVbml0LnZhbHVlKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgdGhpcy5jbG9zZS52YWx1ZSA9IHRydWU7XG4gICAgICAgICAgICB0aGlzLmNsb3NlLmlzRGlzYWJsZWQgPSB0cnVlO1xuICAgICAgICAgICAgdGhpcy5zZXR1cFRpbWUudmFsdWUgPSBOdW1iZXIoc3RhbmRhcmRPcGVyYXRpb25zLnNldHVwVGltZSk7XG4gICAgICAgICAgICB0aGlzLnJ1blRpbWUudmFsdWUgPSBOdW1iZXIoc3RhbmRhcmRPcGVyYXRpb25zLnJ1blRpbWUpO1xuICAgICAgICAgICAgdGhpcy5yZW1haW5pbmdRdWFudGl0eS52YWx1ZSA9IDE7XG4gICAgICAgICAgICB0aGlzLnRpbWVVbml0LnZhbHVlID0gcmVsZWFzZVRpbWVVbml0O1xuICAgICAgICB9XG5cbiAgICAgICAgLy8gMCA9IFJvdXRpbmcgT3BlcmF0aW9uIE1ldGhvZFxuICAgICAgICBpZiAob3BlcmF0aW9uTWV0aG9kID09PSAwKSB7XG4gICAgICAgICAgICBjb25zdCBib21WYWx1ZXMgPSBhd2FpdCB0aGlzLmdldEJvbUNvZGUoKTtcbiAgICAgICAgICAgIHRoaXMuYm9tQ29kZS52YWx1ZSA9IGJvbVZhbHVlcy5ib21Db2RlLmNvZGUudG9TdHJpbmcoKTtcbiAgICAgICAgICAgIHRoaXMuYm9tLnZhbHVlID0gYm9tVmFsdWVzLnByb2R1Y3QuY29kZTtcbiAgICAgICAgICAgIHRoaXMuc3RvY2tVbml0LnZhbHVlID0gb3BlcmF0aW9uTGluZS5vcGVyYXRpb25Vbml0LmNvZGU7XG4gICAgICAgICAgICB0aGlzLnJ1blRpbWUudmFsdWUgPSBvcGVyYXRpb25MaW5lLnJ1blRpbWU7XG4gICAgICAgICAgICB0aGlzLnNldHVwVGltZS52YWx1ZSA9IG9wZXJhdGlvbkxpbmUuc2V0dXBUaW1lO1xuICAgICAgICAgICAgdGhpcy50aW1lVW5pdC52YWx1ZSA9IG9wZXJhdGlvbkxpbmUudGltZVVuaXQ7XG4gICAgICAgICAgICBhd2FpdCB0aGlzLnNldFJlbWFpbmluZ1F1YW50aXR5KCk7XG4gICAgICAgICAgICBhd2FpdCB0aGlzLnNldFdvcmtDZW50ZXIob3BlcmF0aW9uTGluZS5leHBlY3RlZFdvcmtDZW50ZXIuY29kZSk7XG4gICAgICAgICAgICB0aGlzLnNldENsb3NlRmllbGQoKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHRoaXMuc2V0U2NhbGVGb3JOdW1lcmljRmllbGRzKHRoaXMuc3RvY2tVbml0LnZhbHVlKTtcbiAgICB9XG5cbiAgICAvKiogU2V0IHRoZSBzY2FsZSBmb3IgbnVtZXJpYyBmaWVsZCBiYXNlZCBvbiB0aGVpciB1bml0IG9mIG1lYXN1cmUgKi9cbiAgICBhc3luYyBzZXRTY2FsZUZvck51bWVyaWNGaWVsZHMoc3RvY2tVbml0OiBzdHJpbmcpIHtcbiAgICAgICAgY29uc3QgbnVtYmVyT2ZEZWNpbWFsUGxhY2VzID0gYXdhaXQgR2V0VU9NTnVtYmVyT2ZEZWNpbWFsUGxhY2VzKHRoaXMsIHN0b2NrVW5pdCk7XG4gICAgICAgIHRoaXMucmVtYWluaW5nUXVhbnRpdHkuc2NhbGUgPSBudW1iZXJPZkRlY2ltYWxQbGFjZXM7XG4gICAgICAgIHRoaXMucmVqZWN0ZWRRdWFudGl0eS5zY2FsZSA9IG51bWJlck9mRGVjaW1hbFBsYWNlcztcbiAgICB9XG5cbiAgICAvKiogc2V0IHRoZSByZW1haW5pbmcgcXVhbnRpdHkgdmFsdWUuIEV4cGVjdGVkIHF0eSBtaW51cyB0aGUgY29tcGxldGVkIHF0eVxuICAgICAqICBpZiBjb21wbGV0ZWQgZXhjZWVkcyBleHBlY3RlZCB0aGVuIHNldCBxdHkgdG8gemVybyAqL1xuICAgIGFzeW5jIHNldFJlbWFpbmluZ1F1YW50aXR5KCkge1xuICAgICAgICBjb25zdCBsaW5lczogVGltZVRyYWNraW5nTGluZVtdID0gdGhpcy5nZXRUcmFja2luZ0xpbmVzKCk7XG4gICAgICAgIGNvbnN0IHsgb3BlcmF0aW9uTGluZSB9OiBUaW1lVHJhY2tpbmdTdG9yYWdlT2JqZWN0ID0gdGhpcy5nZXRTdG9yYWdlT2JqZWN0KCk7XG4gICAgICAgIGNvbnN0IHF0eVRyYWNrZWRPbkRldmljZU9ubHkgPSB0aGlzLmNhbGN1bGF0ZUxpbmVRdWFudGl0eShsaW5lcywgb3BlcmF0aW9uTGluZSk7XG4gICAgICAgIGNvbnN0IHJlbWFpbmluZ1F0eUluWDNEYXRhYmFzZSA9XG4gICAgICAgICAgICAob3BlcmF0aW9uTGluZT8uZXhwZWN0ZWRRdWFudGl0eSA/PyAwKSAtIChvcGVyYXRpb25MaW5lPy5jb21wbGV0ZWRRdWFudGl0eSA/PyAwKTtcbiAgICAgICAgdGhpcy5yZW1haW5pbmdRdWFudGl0eS52YWx1ZSA9IHJlbWFpbmluZ1F0eUluWDNEYXRhYmFzZSAtIHF0eVRyYWNrZWRPbkRldmljZU9ubHk7XG5cbiAgICAgICAgaWYgKHRoaXMucmVtYWluaW5nUXVhbnRpdHkudmFsdWUgPCAwKSB7XG4gICAgICAgICAgICB0aGlzLnJlbWFpbmluZ1F1YW50aXR5LnZhbHVlID0gMDtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIGdldFN0b2NrU2l0ZSgpIHtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLiQuc3RvcmFnZS5nZXQoJ21vYmlsZS1zZWxlY3RlZC1zdG9jay1zaXRlJykgYXMgc3RyaW5nO1xuICAgICAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgICAgICAgIHRoaXMuJC5zaG93VG9hc3QoXG4gICAgICAgICAgICAgICAgdWkubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICdAc2FnZS94My1tYW51ZmFjdHVyaW5nL3BhZ2VzX19tb2JpbGVfY29tcGxldGVkX3F1YW50aXR5X19fc3RvY2tfc2l0ZV9lcnJvcicsXG4gICAgICAgICAgICAgICAgICAgICdUaGUgc3RvY2sgc2l0ZSBpcyBub3QgZGVmaW5lZCcsXG4gICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICB7IHR5cGU6ICdlcnJvcicsIHRpbWVvdXQ6IDUwMDAgfSxcbiAgICAgICAgICAgICk7XG4gICAgICAgICAgICByZXR1cm4gJyc7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBnZXRTdG9yYWdlT2JqZWN0KCk6IFRpbWVUcmFja2luZ1N0b3JhZ2VPYmplY3QgfCB1bmRlZmluZWQge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgY29uc3Qgc3RvcmFnZU9iamVjdCA9IHRoaXMuJC5zdG9yYWdlLmdldCgndGltZV90cmFja2luZycpIGFzIGFueTtcbiAgICAgICAgICAgIHJldHVybiBzdG9yYWdlT2JqZWN0O1xuICAgICAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgICAgICAgIHRoaXMuc2hvd1N0b3JhZ2VFcnJvcigpO1xuICAgICAgICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIGdldFRyYWNraW5nTGluZXMoKTogVGltZVRyYWNraW5nTGluZVtdIHtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgIGNvbnN0IHsgdGltZVRyYWNraW5nIH0gPSB0aGlzLmdldFN0b3JhZ2VPYmplY3QoKSB8fCB7fTtcbiAgICAgICAgICAgIHJldHVybiB0aW1lVHJhY2tpbmcud29ya09yZGVyT3BlcmF0aW9uVHJhY2tpbmdMaW5lcztcbiAgICAgICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICAgICAgICB0aGlzLnNob3dTdG9yYWdlRXJyb3IoKTtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIHNob3dTdG9yYWdlRXJyb3IoKTogdm9pZCB7XG4gICAgICAgIHRoaXMuJC5zaG93VG9hc3QoXG4gICAgICAgICAgICB1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAnQHNhZ2UveDMtbWFudWZhY3R1cmluZy9wYWdlc19fbW9iaWxlX2NvbXBsZXRlZF9xdWFudGl0eV9kZXRhaWxzX19fZW1wdHlfc3RvcmFnZV9vYmplY3RfZXJyb3InLFxuICAgICAgICAgICAgICAgICdTdG9yYWdlIG9iamVjdCBpcyBlbXB0eScsXG4gICAgICAgICAgICApLFxuICAgICAgICAgICAgeyB0eXBlOiAnZXJyb3InLCB0aW1lb3V0OiA1MDAwIH0sXG4gICAgICAgICk7XG4gICAgICAgIHRoaXMuJC5yb3V0ZXIuZ29UbygnQHNhZ2UveDMtbWFudWZhY3R1cmluZy9Nb2JpbGVDb21wbGV0ZWRRdWFudGl0eScpO1xuICAgIH1cblxuICAgIGluaXRUcmFja2luZ0xpbmVzKHN0b3JhZ2VPYmplY3Q6IGFueSk6IFRpbWVUcmFja2luZ0xpbmVbXSB7XG4gICAgICAgIGNvbnN0IHsgZW1wbG95ZWVJZCwgdHJhbnNhY3Rpb24sIHRyYWNraW5nRGF0ZSwgdGltZVRyYWNraW5nLCBzdGFuZGFyZE9wZXJhdGlvbnMgfSA9IHN0b3JhZ2VPYmplY3Q7XG4gICAgICAgIGNvbnN0IHN0b2NrU2l0ZSA9IHRoaXMuZ2V0U3RvY2tTaXRlKCk7XG5cbiAgICAgICAgY29uc3QgdHJhY2tpbmdMaW5lID0gdGltZVRyYWNraW5nLndvcmtPcmRlck9wZXJhdGlvblRyYWNraW5nTGluZXM7XG4gICAgICAgIGxldCBlbXBsb3llZTogbnVtYmVyID0gMDtcbiAgICAgICAgbGV0IGxpbmVDb3VudGVyOiBudW1iZXIgPSAwO1xuICAgICAgICBsZXQgc3RhbmRhcmRPcGVyYXRpb246IG51bWJlciA9IDA7XG4gICAgICAgIGxldCBjbG9zZTogbnVtYmVyID0gMTtcbiAgICAgICAgaWYgKHRoaXMuY2xvc2UudmFsdWUgPT09IHRydWUpIHtcbiAgICAgICAgICAgIGNsb3NlID0gMjtcbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IFlZWVlNTUREZGF0ZSA9IChkYXRlOiBzdHJpbmcpOiBzdHJpbmcgPT4ge1xuICAgICAgICAgICAgY29uc3QgeWVhciA9IGRhdGUuc2xpY2UoMCwgNCk7XG4gICAgICAgICAgICBjb25zdCBtb250aCA9IGRhdGUuc2xpY2UoNSwgNyk7XG4gICAgICAgICAgICBjb25zdCBkYXkgPSBkYXRlLnNsaWNlKDgsIDEwKTtcbiAgICAgICAgICAgIHJldHVybiBgJHt5ZWFyfS0ke21vbnRofS0ke2RheX1gO1xuICAgICAgICB9O1xuXG4gICAgICAgIHRyYWNraW5nTGluZS5sZW5ndGggIT09IDAgJiYgKGxpbmVDb3VudGVyID0gdHJhY2tpbmdMaW5lLmxlbmd0aCk7XG5cbiAgICAgICAgaWYgKGVtcGxveWVlSWQgIT09IG51bGwpIHtcbiAgICAgICAgICAgIGVtcGxveWVlID0gZW1wbG95ZWVJZC50ZWFtSWQ7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoc3RhbmRhcmRPcGVyYXRpb25zICE9PSBudWxsKSB7XG4gICAgICAgICAgICBzdGFuZGFyZE9wZXJhdGlvbiA9IHN0YW5kYXJkT3BlcmF0aW9ucy5jb2RlO1xuICAgICAgICB9XG5cbiAgICAgICAgdHJhY2tpbmdMaW5lW2xpbmVDb3VudGVyXSA9IHtcbiAgICAgICAgICAgIC4uLnRyYWNraW5nTGluZVtsaW5lQ291bnRlcl0sXG4gICAgICAgICAgICBwcm9kdWN0aW9uU2l0ZTogc3RvY2tTaXRlLFxuICAgICAgICAgICAgd29ya09yZGVyTnVtYmVyOiB0aGlzLndvcmtPcmRlck51bWJlci52YWx1ZSxcbiAgICAgICAgICAgIHJvdXRpbmc6IHRoaXMucmVsZWFzZWRSb3V0aW5nLnZhbHVlLFxuICAgICAgICAgICAgcm91dGluZ0NvZGU6IHRoaXMucm91dGluZ0NvZGUudmFsdWUsXG4gICAgICAgICAgICBvcGVyYXRpb25OdW1iZXI6IHRoaXMub3BlcmF0aW9uTnVtYmVyLnZhbHVlLFxuICAgICAgICAgICAgZGVzY3JpcHRpb246IHRoaXMub3BlcmF0aW9uRGVzY3JpcHRpb24udmFsdWUsXG4gICAgICAgICAgICBwb3N0aW5nRGF0ZTogWVlZWU1NRERkYXRlKHRyYWNraW5nRGF0ZSksXG4gICAgICAgICAgICB0cmFuc2FjdGlvbjogdHJhbnNhY3Rpb24sXG4gICAgICAgICAgICBlbXBsb3llZUlkOiBlbXBsb3llZSxcbiAgICAgICAgICAgIG9wZXJhdGlvblVuaXQ6IHRoaXMuc3RvY2tVbml0LnZhbHVlLFxuICAgICAgICAgICAgb3BlcmF0aW9uQ29udmVyc2lvbjogMSxcbiAgICAgICAgICAgIGFjdHVhbFdvcmtDZW50ZXI6IHRoaXMuZXhwZWN0ZWRXb3JrQ2VudGVyLnZhbHVlLmNvZGUsXG4gICAgICAgICAgICB0b3RhbENvbXBsZXRlZFF1YW50aXR5OiB0aGlzLnJlbWFpbmluZ1F1YW50aXR5LnZhbHVlLFxuICAgICAgICAgICAgYWN0dWFsUmVqZWN0ZWRRdWFudGl0eTogdGhpcy5yZWplY3RlZFF1YW50aXR5LnZhbHVlLFxuICAgICAgICAgICAgYWN0dWFsU2V0dXBUaW1lOiB0aGlzLnNldHVwVGltZS52YWx1ZSxcbiAgICAgICAgICAgIGFjdHVhbFJ1blRpbWU6IHRoaXMucnVuVGltZS52YWx1ZSxcbiAgICAgICAgICAgIGJhbGFuY2U6IGNsb3NlLFxuICAgICAgICAgICAgcmVqZWN0aW9uczogW10sXG4gICAgICAgICAgICBib206IHRoaXMuYm9tLnZhbHVlLFxuICAgICAgICAgICAgYm9tQ29kZTogdGhpcy5ib21Db2RlLnZhbHVlLFxuICAgICAgICAgICAgb3BlcmF0aW9uU3BsaXQ6IDAsXG4gICAgICAgICAgICBhbHRlcm5hdGl2ZUluZGV4OiAwLFxuICAgICAgICAgICAgcHJvamVjdDogJycsXG4gICAgICAgICAgICBzdGFuZGFyZE9wZXJhdGlvbjogc3RhbmRhcmRPcGVyYXRpb24sXG4gICAgICAgICAgICB0aW1lVW5pdDogdGhpcy50aW1lVW5pdC52YWx1ZSxcbiAgICAgICAgfSBhcyBUaW1lVHJhY2tpbmdMaW5lW107XG5cbiAgICAgICAgcmV0dXJuIHRyYWNraW5nTGluZTtcbiAgICB9XG5cbiAgICBzYXZlVGltZVRyYWNraW5nKHN0b3JhZ2VPYmplY3Q6IFRpbWVUcmFja2luZ1N0b3JhZ2VPYmplY3QpIHtcbiAgICAgICAgY29uc3QgeyB0aW1lVHJhY2tpbmcgfSA9IHN0b3JhZ2VPYmplY3Q7XG4gICAgICAgIHRpbWVUcmFja2luZy53b3JrT3JkZXJPcGVyYXRpb25UcmFja2luZ0xpbmVzID0gdGhpcy5pbml0VHJhY2tpbmdMaW5lcyhzdG9yYWdlT2JqZWN0KTtcbiAgICAgICAgdGhpcy4kLnN0b3JhZ2Uuc2V0KCd0aW1lX3RyYWNraW5nJywgc3RvcmFnZU9iamVjdCBhcyBhbnkpO1xuICAgIH1cblxuICAgIGFzeW5jIGJ1dHRvbnNMb2dpYyhkaXNwbGF5TXNnOiBib29sZWFuKSB7XG4gICAgICAgIGNvbnN0IHN0b3JhZ2VPYmplY3QgPSB0aGlzLmdldFN0b3JhZ2VPYmplY3QoKTtcbiAgICAgICAgdGhpcy5zYXZlVGltZVRyYWNraW5nKHN0b3JhZ2VPYmplY3QpO1xuICAgICAgICBpZiAoZGlzcGxheU1zZyA9PT0gdHJ1ZSkge1xuICAgICAgICAgICAgdGhpcy4kLnNob3dUb2FzdChcbiAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLW1hbnVmYWN0dXJpbmcvcGFnZXNfX21vYmlsZV9jb21wbGV0ZWRfcXVhbnRpdHlfZGV0YWlsc19fX3F1YW50aXR5X2FkZGVkJyxcbiAgICAgICAgICAgICAgICAgICAgJ1F1YW50aXR5IGFkZGVkLicsXG4gICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICB7IHR5cGU6ICdzdWNjZXNzJywgdGltZW91dDogMzAwMCB9LFxuICAgICAgICAgICAgKTtcbiAgICAgICAgfVxuICAgICAgICB0aGlzLiQuc2V0UGFnZUNsZWFuKCk7XG4gICAgfVxuXG4gICAgLyoqIEZ1bmN0aW9uIGNvdmVydHMgdGhlIHNldHVwIHRpbWUgZW50ZXJlZCBieSB0aGUgdXNlciB0byBvcGVyYXRpb24gdGltZSB1bml0XG4gICAgICogIHVwZGF0ZXMgcnVudGltZSBwYWdlIGZpZWxkIHdpdGggbmV3IHZhbHVlIHJldHVybjogdHJ1ZSB8IGZhbHNlIHdhcyBjYWxjdWxhdGlvbiBzdWNjZXNzZnVsbHlcbiAgICAgKi9cbiAgICBhc3luYyBzZXRBY3R1YWxSdW5UaW1lKCk6IFByb21pc2U8Ym9vbGVhbj4ge1xuICAgICAgICBpZiAodGhpcy5lbnRlcmVkUnVuVGltZUhvdXJzLnZhbHVlICsgdGhpcy5lbnRlcmVkUnVuVGltZU1pbnV0ZXMudmFsdWUgPT09IDApIHtcbiAgICAgICAgICAgIHRoaXMucnVuVGltZS52YWx1ZSA9IDA7XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfVxuXG4gICAgICAgIHRyeSB7XG4gICAgICAgICAgICBpZiAodGhpcy50aW1lVW5pdC52YWx1ZSA9PT0gJ2hvdXJzJykge1xuICAgICAgICAgICAgICAgIGNvbnN0IHRpbWUgPSBNYXRoLmZsb29yKHRoaXMuZW50ZXJlZFJ1blRpbWVIb3Vycy52YWx1ZSAqIDYwKTtcbiAgICAgICAgICAgICAgICB0aGlzLnJ1blRpbWUudmFsdWUgPSAodGhpcy5lbnRlcmVkUnVuVGltZU1pbnV0ZXMudmFsdWUgKyB0aW1lKSAvIDYwO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMudGltZVVuaXQudmFsdWUgPT09ICdtaW51dGVzJykge1xuICAgICAgICAgICAgICAgIGNvbnN0IHRpbWUgPSBNYXRoLmZsb29yKHRoaXMuZW50ZXJlZFJ1blRpbWVIb3Vycy52YWx1ZSAqIDYwKTtcbiAgICAgICAgICAgICAgICB0aGlzLnJ1blRpbWUudmFsdWUgPSB0aGlzLmVudGVyZWRSdW5UaW1lTWludXRlcy52YWx1ZSArIHRpbWU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgICAgIHRoaXMuJC5zaG93VG9hc3QoXG4gICAgICAgICAgICAgICAgdWkubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICdAc2FnZS94My1tYW51ZmFjdHVyaW5nL3BhZ2VzX19tb2JpbGVfdGltZV90cmFja2luZ19kZXRhaWxzX19fdXBkYXRlX19ydW50aW1lX19lcnJvcicsXG4gICAgICAgICAgICAgICAgICAgICdUaGUgYWN0dWFsIHJ1biB0aW1lIGNhbGN1bGF0aW9uIGZhaWxlZC4nLFxuICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgeyB0eXBlOiAnZXJyb3InLCB0aW1lb3V0OiA1MDAwIH0sXG4gICAgICAgICAgICApO1xuICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgLyoqIEZ1bmN0aW9uIGNvdmVydHMgdGhlIHNldHVwIHRpbWUgZW50ZXJlZCBieSB0aGUgdXNlciB0byBvcGVyYXRpb24gdGltZSB1bml0XG4gICAgICogIHVwZGF0ZXMgc2V0dXB0aW1lIHBhZ2UgZmllbGQgd2l0aCBuZXcgdmFsdWUgcmV0dXJuOiB0cnVlIHwgZmFsZXMgd2FzIGNhbGN1bGF0aW9uIHN1Y2NlZnVsbHlcbiAgICAgKi9cbiAgICBhc3luYyBzZXRBY3R1YWxTZXR1cFRpbWUoKTogUHJvbWlzZTxib29sZWFuPiB7XG4gICAgICAgIGlmICh0aGlzLmVudGVyZWRTZXR1cFRpbWVIb3Vycy52YWx1ZSArIHRoaXMuZW50ZXJlZFNldHVwVGltZU1pbnV0ZXMudmFsdWUgPT09IDApIHtcbiAgICAgICAgICAgIHRoaXMuc2V0dXBUaW1lLnZhbHVlID0gMDtcbiAgICAgICAgICAgIHJldHVybiB0cnVlO1xuICAgICAgICB9XG4gICAgICAgIHRyeSB7XG4gICAgICAgICAgICBpZiAodGhpcy50aW1lVW5pdC52YWx1ZSA9PT0gJ2hvdXJzJykge1xuICAgICAgICAgICAgICAgIGNvbnN0IHRpbWUgPSBNYXRoLmZsb29yKHRoaXMuZW50ZXJlZFNldHVwVGltZUhvdXJzLnZhbHVlICogNjApO1xuICAgICAgICAgICAgICAgIHRoaXMuc2V0dXBUaW1lLnZhbHVlID0gKHRoaXMuZW50ZXJlZFNldHVwVGltZU1pbnV0ZXMudmFsdWUgKyB0aW1lKSAvIDYwO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMudGltZVVuaXQudmFsdWUgPT09ICdtaW51dGVzJykge1xuICAgICAgICAgICAgICAgIGNvbnN0IHRpbWUgPSBNYXRoLmZsb29yKHRoaXMuZW50ZXJlZFNldHVwVGltZUhvdXJzLnZhbHVlICogNjApO1xuICAgICAgICAgICAgICAgIHRoaXMuc2V0dXBUaW1lLnZhbHVlID0gdGhpcy5lbnRlcmVkU2V0dXBUaW1lTWludXRlcy52YWx1ZSArIHRpbWU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgICAgIHRoaXMuJC5zaG93VG9hc3QoXG4gICAgICAgICAgICAgICAgdWkubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICdAc2FnZS94My1tYW51ZmFjdHVyaW5nL3BhZ2VzX19tb2JpbGVfdGltZV90cmFja2luZ19kZXRhaWxzX19fdXBkYXRlX19zZXR1cF9fdGltZV9fZXJyb3InLFxuICAgICAgICAgICAgICAgICAgICAnVGhlIGFjdHVhbCBzZXR1cCB0aW1lIGNhbGN1bGF0aW9uIGZhaWxlZC4nLFxuICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgeyB0eXBlOiAnZXJyb3InLCB0aW1lb3V0OiA1MDAwIH0sXG4gICAgICAgICAgICApO1xuICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgYXN5bmMgc2V0V29ya0NlbnRlcih3b3JrQ2VudGVyOiBzdHJpbmcpIHtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgIHRoaXMuZXhwZWN0ZWRXb3JrQ2VudGVyLnZhbHVlID0gZXh0cmFjdEVkZ2VzPFdvcmtDZW50ZXI+KFxuICAgICAgICAgICAgICAgIGF3YWl0IHRoaXMuJC5ncmFwaFxuICAgICAgICAgICAgICAgICAgICAubm9kZSgnQHNhZ2UveDMtbWFudWZhY3R1cmluZy1kYXRhL1dvcmtDZW50ZXInKVxuICAgICAgICAgICAgICAgICAgICAucXVlcnkoXG4gICAgICAgICAgICAgICAgICAgICAgICB1aS5xdWVyeVV0aWxzLmVkZ2VzU2VsZWN0b3IoXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBmaWx0ZXI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvZGU6IHdvcmtDZW50ZXIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgICAgIClcbiAgICAgICAgICAgICAgICAgICAgLmV4ZWN1dGUoKSxcbiAgICAgICAgICAgICk7XG4gICAgICAgICAgICBpZiAodGhpcy5leHBlY3RlZFdvcmtDZW50ZXIudmFsdWUpIHtcbiAgICAgICAgICAgICAgICB0aGlzLmV4cGVjdGVkV29ya0NlbnRlci52YWx1ZS5jb2RlID0gd29ya0NlbnRlcjtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgdGhpcy5leHBlY3RlZFdvcmtDZW50ZXIudmFsdWUuY29kZSA9ICcnO1xuICAgICAgICAgICAgfVxuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgdGhpcy4kLmRpYWxvZy5tZXNzYWdlKFxuICAgICAgICAgICAgICAgICdlcnJvcicsXG4gICAgICAgICAgICAgICAgdWkubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICdAc2FnZS94My1tYW51ZmFjdHVyaW5nL3BhZ2VzX19tb2JpbGVfY29tcGxldGVkX3F1YW50aXR5X2RldGFpbHNfX19sb2FkaW5nX3dvcmtfY2VudHJlX2Vycm9yJyxcbiAgICAgICAgICAgICAgICAgICAgJ0Vycm9yIGxvYWRpbmcgd29yayBjZW50ZXIuJyxcbiAgICAgICAgICAgICAgICApLFxuICAgICAgICAgICAgICAgIFN0cmluZyhlcnJvciksXG4gICAgICAgICAgICApO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgLyoqIGZ1bmN0aW9uIHZlcmlmeSBpZiB0aGUgdGltZSBhbmQgcXVhbnRpdHkgdmFsdWVzIGVudGVyIGFyZSBwZXJtaXR0ZWQgLSBUcnVlIHwgRmFsc2UgKi9cbiAgICBhc3luYyBpc1RpbWVBbmRRdWFudGl0eVZhbGlkKCk6IFByb21pc2U8Ym9vbGVhbj4ge1xuICAgICAgICBsZXQgcmVzdWx0OiBib29sZWFuID0gdHJ1ZTtcbiAgICAgICAgY29uc3QgdG90YWx0aW1lID0gdGhpcy5ydW5UaW1lLnZhbHVlICsgdGhpcy5zZXR1cFRpbWUudmFsdWU7XG4gICAgICAgIGNvbnN0IHRvdGFsUXVhbnRpdHkgPSB0aGlzLnJlbWFpbmluZ1F1YW50aXR5LnZhbHVlIC0gdGhpcy5yZWplY3RlZFF1YW50aXR5LnZhbHVlO1xuXG4gICAgICAgIGlmICh0b3RhbFF1YW50aXR5IDwgMCkge1xuICAgICAgICAgICAgdGhpcy4kLnNob3dUb2FzdChcbiAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLW1hbnVmYWN0dXJpbmcvcGFnZXNfX21vYmlsZV90aW1lX3RyYWNraW5nX2RldGFpbHNfX19yZWplY3RlZF9xdHlfZXJyb3InLFxuICAgICAgICAgICAgICAgICAgICAnUmVqZWN0ZWQgcXVhbnRpdHkgZ3JlYXRlciB0aGFuIHRoZSBxdWFudGl0eSB2YWx1ZS4nLFxuICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgeyB0eXBlOiAnZXJyb3InLCB0aW1lb3V0OiA1MDAwIH0sXG4gICAgICAgICAgICApO1xuICAgICAgICAgICAgcmVzdWx0ID0gZmFsc2U7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAodGhpcy5yZW1haW5pbmdRdWFudGl0eS52YWx1ZSArIHRvdGFsdGltZSA9PT0gMCkge1xuICAgICAgICAgICAgdGhpcy4kLnNob3dUb2FzdChcbiAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLW1hbnVmYWN0dXJpbmcvcGFnZXNfX21vYmlsZV90aW1lX3RyYWNraW5nX2RldGFpbHNfX19pbnZhbGlkX19xdWFudGl0eV9fdGltZV9fX3ZhbHVlc19fZXJyb3InLFxuICAgICAgICAgICAgICAgICAgICAnQ2hlY2sgeW91ciBlbnRyeSBmb3IgcXVhbnRpdHkgYW5kIHRpbWUuJyxcbiAgICAgICAgICAgICAgICApLFxuICAgICAgICAgICAgICAgIHsgdHlwZTogJ2Vycm9yJywgdGltZW91dDogNTAwMCB9LFxuICAgICAgICAgICAgKTtcbiAgICAgICAgICAgIHJlc3VsdCA9IGZhbHNlO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKHRvdGFsdGltZSA9PT0gMCAmJiB0b3RhbFF1YW50aXR5ID4gMCkge1xuICAgICAgICAgICAgdGhpcy4kLnNob3dUb2FzdChcbiAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLW1hbnVmYWN0dXJpbmcvcGFnZXNfX21vYmlsZV90aW1lX3RyYWNraW5nX2RldGFpbHNfX19ub19fdGltZV9fZW50ZXJlZF9fd2FybmluZycsXG4gICAgICAgICAgICAgICAgICAgICdObyB0aW1lIGVudGVyZWQuJyxcbiAgICAgICAgICAgICAgICApLFxuICAgICAgICAgICAgICAgIHsgdHlwZTogJ3dhcm5pbmcnLCB0aW1lb3V0OiA1MDAwIH0sXG4gICAgICAgICAgICApO1xuICAgICAgICAgICAgcmVzdWx0ID0gdHJ1ZTtcbiAgICAgICAgfVxuXG4gICAgICAgIHJldHVybiByZXN1bHQ7XG4gICAgfVxuXG4gICAgLyoqIGZ1bmN0aW9uIHRvIHNldCB0aGUgQ2xvc2UgZmllbGQgLSB5ZXMvbm8gYmFzZWQgb24gdGhlIHF1YW50aXR5IGJlaW5nIHRyYWNrZWQgKi9cbiAgICBhc3luYyBzZXRDbG9zZUZpZWxkKCkge1xuICAgICAgICBjb25zdCBsaW5lczogVGltZVRyYWNraW5nTGluZVtdID0gdGhpcy5nZXRUcmFja2luZ0xpbmVzKCk7XG4gICAgICAgIGNvbnN0IHsgb3BlcmF0aW9uTGluZSB9OiBUaW1lVHJhY2tpbmdTdG9yYWdlT2JqZWN0ID0gdGhpcy5nZXRTdG9yYWdlT2JqZWN0KCk7XG4gICAgICAgIGxldCBhdXRvbWF0aWNDbG9zaW5nUGVyY2VudGFnZTogZGVjaW1hbCA9IDEwMDtcbiAgICAgICAgbGV0IGNvbXBsZXRlZFF1YW50aXR5UGVyY2VudGFnZTogZGVjaW1hbCA9IDA7XG5cbiAgICAgICAgLy8gVG90YWwgcXVhbnRpdHkgPSBxdWFudGl0eSBvZiB0cmFja2VkIGxpbmVzICsgcXVhbnRpdHkgdG8gdHJhY2sgKyBjb21wbGV0ZWQgcXVhbnRpdHlcbiAgICAgICAgY29uc3QgdG90YWxRdWFudGl0eSA9XG4gICAgICAgICAgICB0aGlzLmNhbGN1bGF0ZUxpbmVRdWFudGl0eShsaW5lcywgb3BlcmF0aW9uTGluZSkgK1xuICAgICAgICAgICAgdGhpcy5yZW1haW5pbmdRdWFudGl0eS52YWx1ZSArXG4gICAgICAgICAgICBvcGVyYXRpb25MaW5lLmNvbXBsZXRlZFF1YW50aXR5O1xuXG4gICAgICAgIGlmICh0b3RhbFF1YW50aXR5ID4gMCAmJiBvcGVyYXRpb25MaW5lLmV4cGVjdGVkUXVhbnRpdHkgPiAwKSB7XG4gICAgICAgICAgICBjb21wbGV0ZWRRdWFudGl0eVBlcmNlbnRhZ2UgPSAodG90YWxRdWFudGl0eSAvIG9wZXJhdGlvbkxpbmUuZXhwZWN0ZWRRdWFudGl0eSkgKiAxMDA7XG4gICAgICAgIH1cbiAgICAgICAgYXV0b21hdGljQ2xvc2luZ1BlcmNlbnRhZ2UgPSBhd2FpdCB0aGlzLmdldEF1dG9tYXRpY0Nsb3NpbmdQZXJjZW50KHRoaXMuZXhwZWN0ZWRXb3JrQ2VudGVyLnZhbHVlLmNvZGUpO1xuXG4gICAgICAgIGlmIChhdXRvbWF0aWNDbG9zaW5nUGVyY2VudGFnZSAhPSAwKSB7XG4gICAgICAgICAgICBpZiAoY29tcGxldGVkUXVhbnRpdHlQZXJjZW50YWdlID49IGF1dG9tYXRpY0Nsb3NpbmdQZXJjZW50YWdlKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5jbG9zZS52YWx1ZSA9IHRydWU7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIHRoaXMuY2xvc2UudmFsdWUgPSBmYWxzZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHRoaXMuY2xvc2UudmFsdWUgPSBmYWxzZTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIC8qKiBmb3IgdGhlIGN1cnJlbnQgd29yayBvcmRlciBhbmQgb3BlcmF0aW9uIHNldCB0aGUgdG90YWwgdHJhY2tlZCBxdWFudGl0eVxuICAgICAqICByZXR1cm4gPSBxdHkgYWxyZWFkeSB0cmFja2VkIGluIFgzICsgcXR5IHRyYWNrZWQgb24gZGV2aWNlICovXG4gICAgZ2V0UXR5QXZhaWxhYmxlVG9UcmFjaygpOiBudW1iZXIge1xuICAgICAgICBjb25zdCBsaW5lczogVGltZVRyYWNraW5nTGluZVtdID0gdGhpcy5nZXRUcmFja2luZ0xpbmVzKCk7XG4gICAgICAgIGNvbnN0IHsgb3BlcmF0aW9uTGluZSB9OiBUaW1lVHJhY2tpbmdTdG9yYWdlT2JqZWN0ID0gdGhpcy5nZXRTdG9yYWdlT2JqZWN0KCk7XG4gICAgICAgIGNvbnN0IHF0eVRyYWNrZWRPbkRldmljZU9ubHkgPSB0aGlzLmNhbGN1bGF0ZUxpbmVRdWFudGl0eShsaW5lcywgb3BlcmF0aW9uTGluZSk7XG4gICAgICAgIGNvbnN0IHJlbWFpbmluZ1F0eUluWDNEYXRhYmFzZSA9IG9wZXJhdGlvbkxpbmUuZXhwZWN0ZWRRdWFudGl0eSAtIG9wZXJhdGlvbkxpbmUuY29tcGxldGVkUXVhbnRpdHk7XG4gICAgICAgIGNvbnN0IHJlbWFpbmluZ1F0eTogbnVtYmVyID0gcmVtYWluaW5nUXR5SW5YM0RhdGFiYXNlIC0gcXR5VHJhY2tlZE9uRGV2aWNlT25seTtcbiAgICAgICAgaWYgKHJlbWFpbmluZ1F0eSkge1xuICAgICAgICAgICAgcmV0dXJuIHJlbWFpbmluZ1F0eTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gMDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBDYWxjdWxhdGUgdGhlIHRvdGFsIHF1YW50aXR5IC0gbGluZXMgdHJhY2tlZCBmb3IgYSBnaXZlbiB3b3JrIG9yZGVyIGFuZCBvcGVyYXRpb25cbiAgICAgKiBAcGFyYW0gbGluZXNcbiAgICAgKiBAcGFyYW0gb3BlcmF0aW9uTGluZVxuICAgICAqIEByZXR1cm5zXG4gICAgICovXG4gICAgY2FsY3VsYXRlTGluZVF1YW50aXR5KGxpbmVzOiBUaW1lVHJhY2tpbmdMaW5lW10sIG9wZXJhdGlvbkxpbmU6IFBhcnRpYWw8T3BlcmF0aW9uTGluZT4pOiBudW1iZXIge1xuICAgICAgICBjb25zdCB7IHdvcmtPcmRlciwgb3BlcmF0aW9uTnVtYmVyIH06IFBhcnRpYWw8T3BlcmF0aW9uTGluZT4gPSBvcGVyYXRpb25MaW5lO1xuICAgICAgICBjb25zdCBjdXJyZW50T3BlcmF0aW9uOiBUaW1lVHJhY2tpbmdMaW5lW10gPSBsaW5lcy5maWx0ZXIoXG4gICAgICAgICAgICAobGluZTogVGltZVRyYWNraW5nTGluZSkgPT5cbiAgICAgICAgICAgICAgICBsaW5lLndvcmtPcmRlck51bWJlciA9PT0gd29ya09yZGVyPy5udW1iZXIgJiYgbGluZS5vcGVyYXRpb25OdW1iZXIgPT09IG9wZXJhdGlvbk51bWJlcixcbiAgICAgICAgKTtcblxuICAgICAgICBjb25zdCB0b3RhbExpbmVRdWFudGl0eTogbnVtYmVyID0gY3VycmVudE9wZXJhdGlvbi5yZWR1Y2UoKHN1bTogbnVtYmVyLCBvcGVyYXRpb246IGFueSkgPT4ge1xuICAgICAgICAgICAgcmV0dXJuIHN1bSArIG9wZXJhdGlvbi50b3RhbENvbXBsZXRlZFF1YW50aXR5O1xuICAgICAgICB9LCAwKTtcbiAgICAgICAgcmV0dXJuIHRvdGFsTGluZVF1YW50aXR5O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEF1dG9tYXRpYyBjbG9zaW5nIHBlcmNlbnRhZ2UgZm9yIGV4cGVjdGVkIHdvcmsgY2VudGVyICYgc2l0ZVxuICAgICAqIEBwYXJhbSB3b3JrQ2VudGVyXG4gICAgICogQHJldHVybnNcbiAgICAgKi9cbiAgICBhc3luYyBnZXRBdXRvbWF0aWNDbG9zaW5nUGVyY2VudCh3b3JrQ2VudGVyOiBzdHJpbmcpOiBQcm9taXNlPGRlY2ltYWw+IHtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgIGNvbnN0IHJlc3VsdCA9IGV4dHJhY3RFZGdlczxXb3JrQ2VudGVyPihcbiAgICAgICAgICAgICAgICBhd2FpdCB0aGlzLiQuZ3JhcGhcbiAgICAgICAgICAgICAgICAgICAgLm5vZGUoJ0BzYWdlL3gzLW1hbnVmYWN0dXJpbmctZGF0YS9Xb3JrQ2VudGVyJylcbiAgICAgICAgICAgICAgICAgICAgLnF1ZXJ5KFxuICAgICAgICAgICAgICAgICAgICAgICAgdWkucXVlcnlVdGlscy5lZGdlc1NlbGVjdG9yKFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYXV0b21hdGljQ2xvc2luZ1BlcmNlbnRhZ2U6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZpbHRlcjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY29kZTogd29ya0NlbnRlcixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG1hbnVmYWN0dXJpbmdTaXRlOiB7IGNvZGU6IHRoaXMuZ2V0U3RvY2tTaXRlKCkgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICAgICAgKVxuICAgICAgICAgICAgICAgICAgICAuZXhlY3V0ZSgpLFxuICAgICAgICAgICAgKTtcbiAgICAgICAgICAgIHJldHVybiBwYXJzZUZsb2F0KHJlc3VsdFswXS5hdXRvbWF0aWNDbG9zaW5nUGVyY2VudGFnZSk7XG4gICAgICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgICAgICAgcmV0dXJuIDA7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBnZXQgQk9NIGNvZGUgcmVxdWlyZWQgZm9yIG9wZXJhdGlvbiB0cmFja2luZy9jcmVhdGlvbiBvZiBsaW5lc1xuICAgICAqIEByZXR1cm5zXG4gICAgICovXG4gICAgYXN5bmMgZ2V0Qm9tQ29kZSgpOiBQcm9taXNlPGFueT4ge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgY29uc3QgcmVzdWx0ID0gZXh0cmFjdEVkZ2VzPFdvcmtPcmRlclByb2R1Y3RMaW5lPihcbiAgICAgICAgICAgICAgICBhd2FpdCB0aGlzLiQuZ3JhcGhcbiAgICAgICAgICAgICAgICAgICAgLm5vZGUoJ0BzYWdlL3gzLW1hbnVmYWN0dXJpbmcvV29ya09yZGVyUHJvZHVjdExpbmUnKVxuICAgICAgICAgICAgICAgICAgICAucXVlcnkoXG4gICAgICAgICAgICAgICAgICAgICAgICB1aS5xdWVyeVV0aWxzLmVkZ2VzU2VsZWN0b3IoXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBib21Db2RlOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBwcm9kdWN0OiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBmaWx0ZXI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHdvcmtPcmRlcjogdGhpcy53b3JrT3JkZXJOdW1iZXIudmFsdWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgICAgIClcblxuICAgICAgICAgICAgICAgICAgICAuZXhlY3V0ZSgpLFxuICAgICAgICAgICAgKTtcbiAgICAgICAgICAgIHJldHVybiByZXN1bHRbMF07XG4gICAgICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgICAgICAgdGhpcy4kLmRpYWxvZy5tZXNzYWdlKFxuICAgICAgICAgICAgICAgICdlcnJvcicsXG4gICAgICAgICAgICAgICAgdWkubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICdAc2FnZS94My1tYW51ZmFjdHVyaW5nL3BhZ2VzX19tb2JpbGVfY29tcGxldGVkX3RpbWVfdHJhY2tpbmdfX19sb2FkaW5nX0JPTV9jb2RlX2Vycm9yJyxcbiAgICAgICAgICAgICAgICAgICAgJ0Vycm9yIGxvYWRpbmcgQk9NIGNvZGUnLFxuICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgU3RyaW5nKGVyciksXG4gICAgICAgICAgICApO1xuICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogU2V0IHRoZSByZWplY3RlZCBxbmF0aXR5IGZpZWxkIHRvIHplcm9cbiAgICAgKi9cbiAgICBhc3luYyBzZXRSZWplY3RlZFF1YW50aXR5VG9aZXJvKCkge1xuICAgICAgICB0aGlzLnJlamVjdGVkUXVhbnRpdHkudmFsdWUgPSAwO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFNldCBhbGwgcnVudGltZSBhbmQgc2V0dXAgdGltZSBmaWVsZHMgdG8gemVyb1xuICAgICAqL1xuICAgIGFzeW5jIFNldEFsbFRpbWVGaWVsZHNUb1plcm8oKSB7XG4gICAgICAgIHRoaXMuc2V0dXBUaW1lLnZhbHVlID0gMDtcbiAgICAgICAgdGhpcy5ydW5UaW1lLnZhbHVlID0gMDtcbiAgICAgICAgdGhpcy5lbnRlcmVkUnVuVGltZUhvdXJzLnZhbHVlID0gMDtcbiAgICAgICAgdGhpcy5lbnRlcmVkUnVuVGltZU1pbnV0ZXMudmFsdWUgPSAwO1xuICAgICAgICB0aGlzLmVudGVyZWRTZXR1cFRpbWVIb3Vycy52YWx1ZSA9IDA7XG4gICAgICAgIHRoaXMuZW50ZXJlZFNldHVwVGltZU1pbnV0ZXMudmFsdWUgPSAwO1xuICAgICAgICBjb25zdCB7IG9wZXJhdGlvbk1ldGhvZCB9OiBUaW1lVHJhY2tpbmdTdG9yYWdlT2JqZWN0ID0gdGhpcy5nZXRTdG9yYWdlT2JqZWN0KCk7XG4gICAgICAgIGlmIChvcGVyYXRpb25NZXRob2QgIT09IDApIHtcbiAgICAgICAgICAgIHRoaXMucmVtYWluaW5nUXVhbnRpdHkudmFsdWUgPSAxO1xuICAgICAgICB9XG4gICAgfVxufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./lib/pages/mobile-time-tracking-details.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-time-tracking-details.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;