import { Container, ProductSite } from '@sage/x3-master-data-api';
import { Location } from '@sage/x3-stock-data-api';
import * as ui from '@sage/xtrem-ui';
import { Product, ProductLine, StorageObject, TrackingLine } from './utils/types';
type StockLocation = {
    code: string;
    type: string;
};
export declare class MobileProductionReportingDetails extends ui.Page {
    private productSite;
    private packingUnits;
    private productUnitOfMeasure;
    product: ui.fields.Text;
    localizedDescription: ui.fields.Text;
    site: ui.fields.Text;
    workOrderNumber: ui.fields.Text;
    section: ui.containers.Section;
    block: ui.containers.Block;
    image: ui.fields.Image;
    stockUnit: ui.fields.DropdownList<string, MobileProductionReportingDetails>;
    remainingQuantity: ui.fields.Numeric;
    conversionFactor: ui.fields.Numeric<MobileProductionReportingDetails>;
    stockStatus: ui.fields.Select;
    suggestedLocation: ui.fields.Reference;
    location: ui.fields.Reference;
    lot: ui.fields.Reference;
    lotText: ui.fields.Text;
    sublot: ui.fields.Text;
    expirationDate: ui.fields.Date;
    serialNumber: ui.fields.Text;
    container: ui.fields.Reference;
    licensePlateNumber: ui.fields.Reference;
    close: ui.fields.Checkbox;
    lotManaged: ui.fields.Numeric;
    sublotManaged: ui.fields.Numeric;
    addQuantity: ui.PageAction;
    nextPage: ui.PageAction;
    initPage(): Promise<void>;
    private getProductSite;
    /**
     * Get stock site from this.$.storage
     * @returns string -  site code
     */
    getStockSite(): string;
    getStorageObject(): StorageObject | undefined;
    getProductLine(): Partial<ProductLine>;
    getTrackingLines(): TrackingLine[];
    showStorageError(): void;
    initTrackingLines(storageObject: any): TrackingLine[];
    saveQuantityTracking(storageObject: StorageObject): void;
    buttonsLogic(displayMsg: boolean): Promise<void>;
    /** Fields Methods */
    calculateQuantity(lines: TrackingLine[], productLine: Partial<ProductLine>): number;
    toggleManageBySerialNumberField(serialNumberManagementMode: string): boolean;
    toggleManageByLocationFields(locationManagementMode: any): void;
    private lotManagement;
    expirationManagement(lotManagement: string, product: string): Promise<void>;
    containerFieldLogic(containerValue: Partial<Container>, locationValue: Partial<Location>): void;
    /**
     * Populate header card
     * @param {Partial<Product>} { code, localizedDescription1 }
     * @param {string} site
     * @memberof MobileProductionReportingDetails
     */
    setHeaderFields({ code, localizedDescription1 }: Partial<Product>, site: string): Promise<void>;
    getStockStatuses(): Promise<string[]>;
    /**
     * Get the locations for the stock site
     * @param site
     * @returns StockLocation[]
     */
    getLocations(site: string): Promise<StockLocation[]>;
    getLocationManagementRules(product: string, stockSite: string): Promise<import("@sage/xtrem-client").ExtractEdges<ProductSite>>;
    getLotManagementMode(): Promise<string>;
    getCategoryLotManagementMode(productCategory: string): Promise<string>;
    private lotExists;
    /**
     * findSerialNumber - search table STOSER for a selected product serial number
     * @param product
     * @param serialNumber
     * @returns boolean
     */
    findSerialNumber(product: any, serialNumber: string): Promise<boolean>;
    getExpirationManagementMode(product: string): Promise<any>;
    /** Get the LOT sequence for a product */
    getLotSequence(): Promise<string>;
    /**
     *  Set the isHidden and isMandatory values for UI
     *  properties affected by a products lot management mode
     *
     * @private
     * @param {string} mode
     * @memberof MobileProductionReportingDetails
     */
    private setLotFieldBehaviour;
    /**
     * Test that the required lot values have been entered as
     * required by the products lot management rules
     * @param {*} mode
     * @return {*}  {Promise<boolean>}
     * @memberof MobileProductionReportingDetails
     */
    lotValuesAreValid(mode: string): Promise<boolean>;
    /**
     * Determines all the packing units of the product site and sets them to the packingUnits array.
     * Fills the stock unit options with the stock unit and packing units.
     */
    initPackingUnitFields(): void;
    /**
     * Determines for the stock unit the conversion factor and enables or disables the conversion factor due to the packing unit array.
     * Sets the number of decimals (scale) for the remaining quantity field.
     */
    initPackingUnitToStockUnitConversionFactor(): Promise<void>;
    /**
     * Converts a quantity from a given unit of measure (UOM) to the stock unit.
     * @param page The current page instance.
     * @param productCode The product code for which the conversion is done.
     * @param stockSite The stock site code where the product is located.
     * @param quantity The quantity to convert.
     * @param uom The unit of measure code of the quantity.
     * @param stockUnitUom The stock unit of measure code.
     * @param conversionFactor The conversion factor to apply if different to the definition entered.
     * @returns The converted quantity in stock unit.
     */
    convertUnitToStockUnit(page: MobileProductionReportingDetails, productCode: string, stockSite: string, quantity: number, uom: string, stockUnitUom: string, conversionFactor: number): number;
}
export {};
//# sourceMappingURL=mobile-production-reporting-details.d.ts.map