"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkOrder = void 0;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Manufacturing = require("..");
const joins = {
    referenceJoins: {
        planningSite: {
            code: 'planningSite',
        },
        productionSite: {
            code: 'productionSite',
        },
        releasedRouting: {
            routing: 'releasedRouting',
            routingCode: 'routingCode',
            site: 'productionSite',
        },
        routingCode: {
            code: 'routingCode',
        },
    },
    collectionJoins: {
        workOrderProductLines: {
            workOrder: 'number',
        },
        workOrderOperationLines: {
            workOrder: 'number',
        },
        workOrderOperationSchedulingLines: {
            workOrder: 'number',
        },
        workOrderMaterialLines: {
            number: 'number',
        },
    },
};
let WorkOrder = class WorkOrder extends xtrem_core_1.Node {
    static workOrderOptimization(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'WorkOrder', 'workOrderOptimization', parameters);
    }
};
exports.WorkOrder = WorkOrder;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrder.prototype, "number", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MFGSTA',
        dataType: () => sageX3ManufacturingData.enums.statusInProgressDatatype,
    })
], WorkOrder.prototype, "orderStatus", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PLNFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], WorkOrder.prototype, "planningSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], WorkOrder.prototype, "productionSite", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MFGMOD',
        dataType: () => sageX3ManufacturingData.enums.releaseModeDatatype,
    })
], WorkOrder.prototype, "releaseMode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TYPMOD',
        dataType: () => sageX3ManufacturingData.enums.modeTypeDatatype,
    })
], WorkOrder.prototype, "modeType", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], WorkOrder.prototype, "startDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], WorkOrder.prototype, "endDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCDMOD',
        dataType: () => sageX3ManufacturingData.enums.schedulingModeDatatype,
    })
], WorkOrder.prototype, "scheduleMode", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LTIREDCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrder.prototype, "percLTReduction", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrder.prototype, "plannedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OBJDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], WorkOrder.prototype, "initialObjective", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ROUNUM',
        columnType: 'string',
        node: () => sageX3Manufacturing.nodes.RoutingHeader,
    })
], WorkOrder.prototype, "releasedRouting", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ROUALT',
        columnType: 'integer',
        node: () => sageX3MasterData.nodes.BomRouting,
    })
], WorkOrder.prototype, "routingCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MFGPIO',
        dataType: () => sageX3ManufacturingData.enums.priorityDatatype,
    })
], WorkOrder.prototype, "priority", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCDFLG',
        dataType: () => sageX3ManufacturingData.enums.schedulingStatusDatatype,
    })
], WorkOrder.prototype, "schedulingStatus", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MATLINNBR',
    })
], WorkOrder.prototype, "numberOfMaterials", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLSTA',
        dataType: () => sageX3ManufacturingData.enums.workOrderAllocationStatusDatatype,
    })
], WorkOrder.prototype, "allocationStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MFGTRKFLG',
        dataType: () => sageX3ManufacturingData.enums.workOrderSituationDatatype,
    })
], WorkOrder.prototype, "trackingFlag", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPTFLG',
    })
], WorkOrder.prototype, "workOrderOptimized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SUSFLG',
    })
], WorkOrder.prototype, "workOrderSuspendedFlag", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Manufacturing.nodes.WorkOrderProductLine,
        isMutable: true,
        dependsOn: ['number'],
    })
], WorkOrder.prototype, "workOrderProductLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Manufacturing.nodes.WorkOrderOperationLine,
        isMutable: true,
        dependsOn: ['number'],
    })
], WorkOrder.prototype, "workOrderOperationLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Manufacturing.nodes.WorkOrderOperationScheduling,
        isMutable: true,
        dependsOn: ['number'],
    })
], WorkOrder.prototype, "workOrderOperationSchedulingLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Manufacturing.nodes.WorkOrderMaterialLine,
        isMutable: true,
        dependsOn: ['number'],
    })
], WorkOrder.prototype, "workOrderMaterialLines", void 0);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: WorkOrderOptimization */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    productionSite: {
                        isMandatory: true,
                        type: 'string',
                    },
                    number: {
                        isMandatory: true,
                        type: 'string',
                    },
                    product: {
                        isMandatory: true,
                        type: 'string',
                    },
                    operationNumber: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'integer',
                        },
                    },
                    operationSplit: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'integer',
                        },
                    },
                    operationStartDateTime: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    operationEndDateTime: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    operationRunStartDateTime: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    operationRunEndDateTime: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    forcedStartDateTime: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    expectedWorkCenter: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    setupTimeSeconds: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'integer',
                        },
                    },
                    sequenceOrder: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'integer',
                        },
                    },
                    forcedPlacement: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'integer',
                        },
                    },
                    status: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    message: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                status: {
                    isMandatory: true,
                    type: 'integer',
                },
                message: {
                    isMandatory: true,
                    type: 'string',
                },
            },
        },
    })
], WorkOrder, "workOrderOptimization", null);
exports.WorkOrder = WorkOrder = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'MFGHEAD',
        keyPropertyNames: ['number'],
        indexes: [
            {
                orderBy: {
                    number: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], WorkOrder);
//# sourceMappingURL=work-order.js.map