import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, decimal, integer, Collection, Context } from '@sage/xtrem-core';
import * as sageX3Manufacturing from '..';
export declare class WorkOrder extends Node {
    readonly number: Promise<string>;
    readonly orderStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
    readonly planningSite: Reference<sageX3System.nodes.Site>;
    readonly productionSite: Reference<sageX3System.nodes.Site>;
    readonly releaseMode: Promise<sageX3ManufacturingData.enums.ReleaseMode | null>;
    readonly modeType: Promise<sageX3ManufacturingData.enums.ModeType | null>;
    readonly startDate: Promise<date | null>;
    readonly endDate: Promise<date | null>;
    readonly scheduleMode: Promise<sageX3ManufacturingData.enums.SchedulingMode | null>;
    readonly percLTReduction: Promise<decimal | null>;
    readonly plannedQuantity: Promise<decimal | null>;
    readonly initialObjective: Promise<date | null>;
    readonly releasedRouting: Reference<sageX3Manufacturing.nodes.RoutingHeader | null>;
    readonly routingCode: Reference<sageX3MasterData.nodes.BomRouting | null>;
    readonly priority: Promise<sageX3ManufacturingData.enums.Priority | null>;
    readonly schedulingStatus: Promise<sageX3ManufacturingData.enums.SchedulingStatus | null>;
    readonly numberOfMaterials: Promise<integer | null>;
    readonly allocationStatus: Promise<sageX3ManufacturingData.enums.WorkOrderAllocationStatus | null>;
    readonly trackingFlag: Promise<sageX3ManufacturingData.enums.WorkOrderSituation | null>;
    readonly workOrderOptimized: Promise<boolean>;
    readonly workOrderSuspendedFlag: Promise<boolean>;
    readonly workOrderProductLines: Collection<sageX3Manufacturing.nodes.WorkOrderProductLine>;
    readonly workOrderOperationLines: Collection<sageX3Manufacturing.nodes.WorkOrderOperationLine>;
    readonly workOrderOperationSchedulingLines: Collection<sageX3Manufacturing.nodes.WorkOrderOperationScheduling>;
    readonly workOrderMaterialLines: Collection<sageX3Manufacturing.nodes.WorkOrderMaterialLine>;
    static workOrderOptimization(context: Context, parameters: {
        productionSite: string;
        number: string;
        product: string;
        operationNumber: number[];
        operationSplit: number[];
        operationStartDateTime: string[];
        operationEndDateTime: string[];
        operationRunStartDateTime: string[];
        operationRunEndDateTime: string[];
        forcedStartDateTime: string[];
        expectedWorkCenter: string[];
        setupTimeSeconds: number[];
        sequenceOrder: number[];
        forcedPlacement: number[];
        status: number;
        message: string;
    }): Promise<{
        status: number;
        message: string;
    }>;
}
//# sourceMappingURL=work-order.d.ts.map