import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3System from '@sage/x3-system';
import { Node, integer, Reference, date, decimal } from '@sage/xtrem-core';
export declare class WorkOrderSuggestionLine extends Node {
    readonly code: Promise<string>;
    readonly operationNumber: Promise<integer | null>;
    readonly operationSplit: Promise<integer | null>;
    readonly operationKey: Promise<string>;
    readonly manufacturingSite: Reference<sageX3System.nodes.Site>;
    readonly startDate: Promise<date | null>;
    readonly endDate: Promise<date | null>;
    readonly operationStatus: Promise<sageX3ManufacturingData.enums.OperationStatus | null>;
    readonly expectedWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly actualWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly operationUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly stockOperationConversion: Promise<decimal | null>;
    readonly expectedQuantity: Promise<decimal | null>;
    readonly completedQuantity: Promise<decimal | null>;
    readonly rejectQuantity: Promise<decimal | null>;
    readonly routingOperationTimeCode: Promise<sageX3ManufacturingData.enums.RunTimeType | null>;
    readonly timeUnit: Promise<sageX3ManufacturingData.enums.TimeUnitCode | null>;
    readonly preparationTime: Promise<decimal | null>;
    readonly setupTime: Promise<decimal | null>;
    readonly completedSetupTime: Promise<decimal | null>;
    readonly runTime: Promise<decimal | null>;
    readonly completedOperationTime: Promise<decimal | null>;
    readonly waitingTime: Promise<decimal | null>;
    readonly postRunTime: Promise<decimal | null>;
    readonly laborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly actualLaborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly numberOfResources: Promise<integer | null>;
}
//# sourceMappingURL=work-order-suggestion-line.d.ts.map