import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3Manufacturing from '..';
export declare class WorkOrderProductLine extends Node {
    readonly workOrder: Reference<sageX3Manufacturing.nodes.WorkOrder | null>;
    readonly lineNumber: Promise<integer | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly productType: Promise<sageX3Manufacturing.enums.ManufacturingProductType | null>;
    readonly productionSite: Reference<sageX3System.nodes.Site>;
    readonly productCategory: Reference<sageX3MasterData.nodes.ProductCategory>;
    readonly projectTaskNumber: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly customer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly releaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly releaseQuantity: Promise<decimal | null>;
    readonly releaseStkConversion: Promise<decimal | null>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly expectedQuantity: Promise<decimal | null>;
    readonly remainingQuantity: Promise<decimal | null>;
    readonly lot: Promise<string>;
    readonly bomCode: Reference<sageX3MasterData.nodes.BomCodes | null>;
    readonly originalDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly salesOrder: Promise<string>;
    readonly lineStatus: Promise<sageX3ManufacturingData.enums.ProductionStatus | null>;
    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorProductVersion: Promise<string>;
    readonly productSiteAttribute: Collection<sageX3Manufacturing.nodes.ProductSiteAttribute>;
    readonly productAnalysis: Collection<sageX3Manufacturing.nodes.WorkOrderProductLineProductAnalysis>;
}
//# sourceMappingURL=work-order-product-line.d.ts.map