import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3System from '@sage/x3-system';
import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3Manufacturing from '..';
export declare class WorkOrderOperationTrackingLine extends Node {
    readonly trackingNumber: Promise<string>;
    readonly line: Promise<integer | null>;
    readonly workOrderNumber: Promise<string>;
    readonly operationNumber: Promise<integer | null>;
    readonly operationSplit: Promise<integer | null>;
    readonly productionSite: Reference<sageX3System.nodes.Site>;
    readonly routing: Reference<sageX3MasterData.nodes.Product | null>;
    readonly routingCode: Reference<sageX3Manufacturing.nodes.RoutingHeader | null>;
    readonly operationUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly operationConversion: Promise<decimal | null>;
    readonly totalCompletedQuantity: Promise<decimal | null>;
    readonly actualRejectedQuantity: Promise<decimal | null>;
    readonly actualWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly actualSetupTime: Promise<decimal | null>;
    readonly actualRunTime: Promise<decimal | null>;
    readonly employeeId: Promise<integer | null>;
    readonly message: Promise<integer | null>;
    readonly timeUnit: Promise<sageX3ManufacturingData.enums.TimeUnitCode | null>;
    readonly alternativeIndex: Promise<integer | null>;
    readonly standardOperation: Reference<sageX3Manufacturing.nodes.StandardOperations | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly workOrderOperationTracking: Reference<sageX3Manufacturing.nodes.WorkOrderOperationTracking>;
    readonly balance: Promise<decimal | null>;
    readonly bom: Promise<string>;
    readonly bomCode: Promise<string>;
    readonly postingDate: Promise<string>;
    readonly transaction: Promise<string>;
    readonly rejections: Collection<sageX3Manufacturing.nodes.WorkOrderOperationTrackingLineRejections>;
}
//# sourceMappingURL=work-order-operation-tracking-line.d.ts.map