"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkOrderOperationScheduling = void 0;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        productionSite: {
            code: 'productionSite',
        },
    },
};
let WorkOrderOperationScheduling = class WorkOrderOperationScheduling extends xtrem_core_1.Node {
};
exports.WorkOrderOperationScheduling = WorkOrderOperationScheduling;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderOperationScheduling.prototype, "workOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPENUM',
    })
], WorkOrderOperationScheduling.prototype, "operationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPESPLNUM',
    })
], WorkOrderOperationScheduling.prototype, "operationSplit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], WorkOrderOperationScheduling.prototype, "productionSite", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NEXOPENUM',
    })
], WorkOrderOperationScheduling.prototype, "downstreamOperationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCDCOD',
        dataType: () => sageX3ManufacturingData.enums.schedulingCodeDatatype,
    })
], WorkOrderOperationScheduling.prototype, "scheduleCode", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCDTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationScheduling.prototype, "overlappingTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCDQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationScheduling.prototype, "overlappingQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCDLOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationScheduling.prototype, "lotQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationScheduling.prototype, "numberOfLots", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DACMST',
        dataType: () => sageX3ManufacturingData.enums.scheduleTypeDatatype,
    })
], WorkOrderOperationScheduling.prototype, "milestone", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isNullable: true,
        dataType: () => sageX3ManufacturingData.enums.timeUnitCodeDatatype,
        getValue() {
            return 'hours';
        },
    })
], WorkOrderOperationScheduling.prototype, "timeUnit", void 0);
exports.WorkOrderOperationScheduling = WorkOrderOperationScheduling = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SCHEDULING',
        keyPropertyNames: ['workOrder', 'operationNumber', 'operationSplit'],
        indexes: [
            {
                orderBy: {
                    workOrder: 1,
                    operationNumber: 1,
                    operationSplit: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['workOrder', 'operationNumber', 'operationSplit'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], WorkOrderOperationScheduling);
//# sourceMappingURL=work-order-operation-scheduling.js.map