"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkOrderOperationLine = void 0;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Manufacturing = require("..");
const joins = {
    referenceJoins: {
        workOrder: {
            number: 'workOrder',
        },
        manufacturingSite: {
            code: 'manufacturingSite',
        },
        expectedWorkCenter: {
            code: 'expectedWorkCenter',
            manufacturingSite: 'manufacturingSite',
        },
        actualWorkCenter: {
            code: 'actualWorkCenter',
            manufacturingSite: 'manufacturingSite',
        },
        laborWorkCenter: {
            code: 'laborWorkCenter',
            manufacturingSite: 'manufacturingSite',
        },
        actualLaborWorkCenter: {
            code: 'actualLaborWorkCenter',
            manufacturingSite: 'manufacturingSite',
        },
        operationUnit: {
            code: 'operationUnit',
        },
        tool: {
            code: 'tool',
        },
        subcontractWorkCenter: {
            code: 'subcontractWorkCenter',
            manufacturingSite: 'manufacturingSite',
        },
    },
    collectionJoins: {
        workOrderScheduling: {
            workOrder: 'workOrder',
            operationNumber: 'operationNumber',
            operationSplit: 'operationSplit',
        },
    },
};
let WorkOrderOperationLine = class WorkOrderOperationLine extends xtrem_core_1.Node {
};
exports.WorkOrderOperationLine = WorkOrderOperationLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MFGNUM',
        columnType: 'string',
        node: () => sageX3Manufacturing.nodes.WorkOrder,
    })
], WorkOrderOperationLine.prototype, "workOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPENUM',
    })
], WorkOrderOperationLine.prototype, "operationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPESPLNUM',
    })
], WorkOrderOperationLine.prototype, "operationSplit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], WorkOrderOperationLine.prototype, "manufacturingSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EXTWST',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], WorkOrderOperationLine.prototype, "expectedWorkCenter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPLWST',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], WorkOrderOperationLine.prototype, "actualWorkCenter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTLAB',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], WorkOrderOperationLine.prototype, "laborWorkCenter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPLLAB',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], WorkOrderOperationLine.prototype, "actualLaborWorkCenter", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPESTA',
        dataType: () => sageX3ManufacturingData.enums.operationStatusDatatype,
    })
], WorkOrderOperationLine.prototype, "operationStatus", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPESTR',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], WorkOrderOperationLine.prototype, "startDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPEEND',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], WorkOrderOperationLine.prototype, "endDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FRCSTRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], WorkOrderOperationLine.prototype, "forcedStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FRCSTRHOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderOperationLine.prototype, "forcedStartTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ROODES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderOperationLine.prototype, "operationDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPEUOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], WorkOrderOperationLine.prototype, "operationUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPESTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "stockOperationConversion", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TIMUOMCOD',
        dataType: () => sageX3ManufacturingData.enums.timeUnitCodeDatatype,
    })
], WorkOrderOperationLine.prototype, "timeUnit", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ROOTIMCOD',
        dataType: () => sageX3ManufacturingData.enums.runTimeTypeDatatype,
    })
], WorkOrderOperationLine.prototype, "routingOperationTimeCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPEPLNNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderOperationLine.prototype, "operationPlanNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TECCRD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderOperationLine.prototype, "technicalSheet", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EQUNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], WorkOrderOperationLine.prototype, "tool", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FXGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderOperationLine.prototype, "fixture", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderOperationLine.prototype, "program", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTWSTNBR',
    })
], WorkOrderOperationLine.prototype, "numberOfResources", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRPTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "preparationTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTSETTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "setupTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPLSETTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "completedSetupTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTUNTTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "unitTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPLUNTTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "completedUnitaryTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTOPETIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "runTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPLOPETIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "completedOperationTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WAITIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "waitingTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PSPTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "postRunTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "expectedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPLQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "completedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REJCPLQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "rejectQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCOCOD',
        dataType: () => sageX3ManufacturingData.enums.subcontractingDatatype,
    })
], WorkOrderOperationLine.prototype, "subcontract", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCOWST',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], WorkOrderOperationLine.prototype, "subcontractWorkCenter", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCOLTI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderOperationLine.prototype, "subcontractLeadTimeDays", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SCHGRP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderOperationLine.prototype, "groupingCriterion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SCHSBB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderOperationLine.prototype, "distinctionCriteria", void 0);
__decorate([
    xtrem_core_1.decorators.datetimeProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FDMA',
    })
], WorkOrderOperationLine.prototype, "firstAvailability", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Manufacturing.nodes.WorkOrderScheduling,
        isMutable: true,
        dependsOn: ['workOrder', 'operationNumber', 'operationSplit'],
    })
], WorkOrderOperationLine.prototype, "workOrderScheduling", void 0);
exports.WorkOrderOperationLine = WorkOrderOperationLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'MFGOPE',
        keyPropertyNames: ['workOrder', 'operationNumber', 'operationSplit'],
        indexes: [
            {
                orderBy: {
                    workOrder: 1,
                    operationNumber: 1,
                    operationSplit: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['workOrder', 'operationNumber', 'operationSplit'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], WorkOrderOperationLine);
//# sourceMappingURL=work-order-operation-line.js.map