"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkOrderMaterialTrackingLine = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Manufacturing = require("..");
const joins = {
    referenceJoins: {
        bomNumber: {
            code: 'bomNumber',
        },
        bomAlternative: {
            bomType() {
                return 'manufacturing';
            },
            code: 'bomAlternative',
        },
        product: {
            product: 'product',
            stockSite: 'productionSite',
        },
        productionSite: {
            code: 'productionSite',
        },
        project: {
            id: 'project',
        },
        workOrderMaterialTracking: {
            trackingNumber: 'mfgTrackingNumber',
        },
    },
    collectionJoins: {
        stockJournal: {
            stockSite: 'productionSite',
            documentType() {
                return 'productionTracking';
            },
            documentId: 'mfgTrackingNumber',
            documentLine: 'materialTrackingLine',
        },
    },
};
let WorkOrderMaterialTrackingLine = class WorkOrderMaterialTrackingLine extends xtrem_core_1.Node {
};
exports.WorkOrderMaterialTrackingLine = WorkOrderMaterialTrackingLine;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGTRKNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderMaterialTrackingLine.prototype, "mfgTrackingNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MATTRKLIN',
    })
], WorkOrderMaterialTrackingLine.prototype, "materialTrackingLine", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderMaterialTrackingLine.prototype, "workOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MFGLIN',
    })
], WorkOrderMaterialTrackingLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], WorkOrderMaterialTrackingLine.prototype, "bomNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMALT',
        columnType: 'integer',
        filters: {
            lookup: {
                bomType: 'manufacturing',
            },
            control: {
                bomType: 'manufacturing',
            },
        },
        node: () => sageX3MasterData.nodes.BomCodes,
    })
], WorkOrderMaterialTrackingLine.prototype, "bomAlternative", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ProductSite,
    })
], WorkOrderMaterialTrackingLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], WorkOrderMaterialTrackingLine.prototype, "productionSite", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USEQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderMaterialTrackingLine.prototype, "consumedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMSEQ',
    })
], WorkOrderMaterialTrackingLine.prototype, "bomSequence", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOTPREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderMaterialTrackingLine.prototype, "preferredLot", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], WorkOrderMaterialTrackingLine.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3StockData.nodes.StockJournal,
        isMutable: true,
        dependsOn: ['productionSite', 'mfgTrackingNumber', 'materialTrackingLine'],
    })
], WorkOrderMaterialTrackingLine.prototype, "stockJournal", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageX3Manufacturing.nodes.WorkOrderMaterialTracking,
    })
], WorkOrderMaterialTrackingLine.prototype, "workOrderMaterialTracking", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isTransientInput: true,
        isNullable: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderMaterialTrackingLine.prototype, "balance", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isTransientInput: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderMaterialTrackingLine.prototype, "postingDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isTransientInput: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderMaterialTrackingLine.prototype, "transaction", void 0);
exports.WorkOrderMaterialTrackingLine = WorkOrderMaterialTrackingLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'MFGMATTRK',
        keyPropertyNames: ['mfgTrackingNumber', 'materialTrackingLine'],
        indexes: [
            {
                orderBy: {
                    mfgTrackingNumber: 1,
                    materialTrackingLine: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['mfgTrackingNumber', 'materialTrackingLine'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        authorizationCode: 'GESMKM',
    })
], WorkOrderMaterialTrackingLine);
//# sourceMappingURL=work-order-material-tracking-line.js.map