import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3Manufacturing from '..';
export declare class WorkOrderMaterialTrackingLine extends Node {
    readonly mfgTrackingNumber: Promise<string>;
    readonly materialTrackingLine: Promise<integer | null>;
    readonly workOrder: Promise<string>;
    readonly lineNumber: Promise<integer | null>;
    readonly bomNumber: Reference<sageX3MasterData.nodes.Product | null>;
    readonly bomAlternative: Reference<sageX3MasterData.nodes.BomCodes | null>;
    readonly product: Reference<sageX3MasterData.nodes.ProductSite>;
    readonly productionSite: Reference<sageX3System.nodes.Site>;
    readonly consumedQuantity: Promise<decimal | null>;
    readonly bomSequence: Promise<integer | null>;
    readonly preferredLot: Promise<string>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly stockJournal: Collection<sageX3StockData.nodes.StockJournal>;
    readonly workOrderMaterialTracking: Reference<sageX3Manufacturing.nodes.WorkOrderMaterialTracking>;
    readonly balance: Promise<decimal | null>;
    readonly postingDate: Promise<string>;
    readonly transaction: Promise<string>;
}
//# sourceMappingURL=work-order-material-tracking-line.d.ts.map