"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkOrderMaterialLine = void 0;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Manufacturing = require("..");
const joins = {
    referenceJoins: {
        number: {
            number: 'number',
        },
        lineNumber: {
            workOrder: 'number',
            lineNumber: 'lineNumber',
        },
        product: {
            code: 'product',
        },
        productionSite: {
            code: 'productionSite',
        },
        bomUnit: {
            code: 'bomUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        location: {
            stockSite: 'productionSite',
            code: 'location',
        },
        majorProductVersion: {
            product: 'product',
            code: 'majorProductVersion',
        },
    },
};
let WorkOrderMaterialLine = class WorkOrderMaterialLine extends xtrem_core_1.Node {
};
exports.WorkOrderMaterialLine = WorkOrderMaterialLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MFGNUM',
        columnType: 'string',
        node: () => sageX3Manufacturing.nodes.WorkOrder,
    })
], WorkOrderMaterialLine.prototype, "number", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MFGLIN',
        columnType: 'integer',
        node: () => sageX3Manufacturing.nodes.WorkOrderProductLine,
    })
], WorkOrderMaterialLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMSEQ',
    })
], WorkOrderMaterialLine.prototype, "bomSequence", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], WorkOrderMaterialLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], WorkOrderMaterialLine.prototype, "productionSite", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RETDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], WorkOrderMaterialLine.prototype, "requirementDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMOPE',
    })
], WorkOrderMaterialLine.prototype, "bomOperationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUMFXDQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderMaterialLine.prototype, "cumulTotalQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMUOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], WorkOrderMaterialLine.prototype, "bomUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], WorkOrderMaterialLine.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderMaterialLine.prototype, "bomUnitStockFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RETQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderMaterialLine.prototype, "requiredQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USEQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderMaterialLine.prototype, "consumedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderMaterialLine.prototype, "allocatedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderMaterialLine.prototype, "shortageQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOC',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Location,
    })
], WorkOrderMaterialLine.prototype, "location", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MATSTA',
        dataType: () => sageX3ManufacturingData.enums.productionStatusDatatype,
    })
], WorkOrderMaterialLine.prototype, "materialStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPNTYP',
        dataType: () => sageX3MasterData.enums.componentTypeDatatype,
    })
], WorkOrderMaterialLine.prototype, "componentType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMAJ',
        columnType: 'string',
        node: () => sageX3StockData.nodes.MajorVersionStatus,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], WorkOrderMaterialLine.prototype, "majorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCVALMIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], WorkOrderMaterialLine.prototype, "minorProductVersion", void 0);
exports.WorkOrderMaterialLine = WorkOrderMaterialLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'MFGMAT',
        keyPropertyNames: ['number', 'lineNumber', 'bomSequence', 'product'],
        indexes: [
            {
                orderBy: {
                    number: 1,
                    lineNumber: 1,
                    bomSequence: 1,
                    product: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['number', 'lineNumber', 'bomSequence', 'product'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], WorkOrderMaterialLine);
//# sourceMappingURL=work-order-material-line.js.map