"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkCenterReplacement = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Manufacturing = require("..");
const joins = {
    referenceJoins: {
        manufacturingSite: {
            code: 'manufacturingSite',
        },
    },
};
let WorkCenterReplacement = class WorkCenterReplacement extends xtrem_core_1.Node {
};
exports.WorkCenterReplacement = WorkCenterReplacement;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkCenterReplacement.prototype, "workCenter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WCRFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], WorkCenterReplacement.prototype, "manufacturingSite", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Manufacturing.nodes.WorkCenterReplacementWorkCenterReplacementLines,
    })
], WorkCenterReplacement.prototype, "workCenterReplacementLines", void 0);
exports.WorkCenterReplacement = WorkCenterReplacement = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'RPLWST',
        keyPropertyNames: ['workCenter', 'manufacturingSite'],
        indexes: [
            {
                orderBy: {
                    workCenter: 1,
                    manufacturingSite: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['workCenter'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], WorkCenterReplacement);
//# sourceMappingURL=work-center-replacement.js.map